#include	"mch.c"
#include	"mch1.c"

main (argc,argv)
char *argv [];
{
	yyinit (argc,argv);
	yyparse ();
	if (!errorn)
		codegenerator();
	cexit ();
}

yyerror(ms)
{
	mcerror(ms);
}

yyinit(argc, argv)
char **argv;
{
	register char *pp;
	register i;
	register struct key *p;
	for (p=keywds; p->k_val; p++) {
		pp = p->k_nam;
		i = 0;
		while(*pp)
			i =+ *pp++;
		symtab[i%TABLEN].s_flag = KEYW;
	}
	nextch = -1;
	nxtlab++;
	symbuf	= talloc(SYMLEN+2);
	iargc = argc;
	*(iargv = argv) = 0;
}


yylex()
{
	register c;
	register char *p, *sl;
	char ccbuf[4];
	if ((c=nextch) == -1)
		c = getch();
	if (c == SP || (c == LF ? ++yyline : 0) || c == HT)
		do
		  nextch = -1; 
			while ((c = getch()) == SP);
	if (alpha(c)) {
		sl = p = symbuf;
		sl =+ SYMLEN;
		while (alpha(c) || digit(c)) {
			if (p < sl)
				*p++ = c;
			c = cgetc(cin);
		}
		while (p <= sl)
			*p++ = '\0';
		nextch = c;
		return(lookup());
	}

	if (digit(c) || c == '$')
		return(getnum(c));

	if (c == EOF)
		return(c);
	nextch = -1;
	switch(c) {
		case '\'' :
			return(getasci());
		case '"' :
			return(getstr());
		case '/'  :
			if ((nextch=getch()) != '*')
				return(c);
			nextch = -1;
			while ((c=getch()) != EOF) {
				nextch = -1;
				if (c == '*' && getch() == '/') {
					nextch = -1;
					return(yylex());
				}
			}
	}

	*(p=ccbuf) = c;
	if ((c=getch()) != SP) {
		*++p = c;
		*++p = '\0';
		if (c=keylook(ccbuf,optable)) {
			if (c == EQLSH || c == EQRSH) {
				*p = cgetc(cin);
				if ( (c == EQLSH && *p != '<') ||
					(c == EQRSH && *p != '>') ) {
						ungetc(*p, cin);
						return('=');
				}
			}
			nextch = -1;
			return(c);
		}
	}
	return(ccbuf[0]);
}


getasci()
{
	register c, c1;
	register char *p;
	char *q;
	yylval = 0;
	p = &yylval;
	q = p+2;
	while ((c = cgetc(cin)) != '\'') {
		if (endchk(c))
			break;
		if (c == '\\')
			switch(c1 = cgetc(cin)) {
				case 'n' : c = '\n';
					break;
				case 't' : c = '\t';
					break;
				case 'r' : c = '\r';
					break;
				case '0' : c = '\0';
					break;
				default :
					if (p < q)
						*p++ = c;
					c = c1;
			}
		if (p < q)
			*p++ = c;
	}
	if (p>q)
		mcerror("Character constant syntax");
	return(ASCII);
}


getstr()
{
	register c, c1;
	register char *p;
	char *q;
	p = strbuf;
	q = p+STRLEN;
	while ((c=cgetc(cin)) != '"') {
		if (endchk(c))
			break;

		if (c == '\\') {
			if ((c1 = cgetc(cin)) != '"' && p < q)
				*p++ = c;
			c = c1;
		}
		if (p<q)
			*p++ = c;
	}
	*p++ = '\0';
	yylval = p;
	return(STRING);
}


endchk(c)
{
	if (c != LF && c != EOF)
		return(0);
	mcerror("Missing quotes");
	nextch = c;
	return(1);
}

getnum(ch)
{
	register n, base, c;
	if (ch == '$') {
		n = 0;
		while(hexdig(c = cgetc(cin))) {
			if (c >= 'A' && c <= 'F')
				c =| 040;
			n =<< 4;
			n =| (digit(c) ? (c-'0') : (c-'a'+10));
		}
	} else {
		n = ch - '0';
		base = (n ? 10 : 8);
		while(digit(c=cgetc(cin)))
			n = n*base + c - '0';
	}
	nextch = c;
	yylval = n;
	return(NUM);
}

hexdig(ch)
char ch;
{
	return(digit(ch) || ((ch =| 040) >= 'a' && ch <= 'f'));
}

alpha(ch)
char ch;
{
	return(ch=='_' || (ch=| 040) >= 'a' && ch <= 'z');
}

digit(ch)
char ch;
{
	return(ch >= '0' && ch <= '9');
}

keylook(word, kstruct)
char *word;
{
	register struct key *p;
	register char *wp;
	wp = word;
	for (p=kstruct; p->k_val; p++)
		if (cmpstr(wp, p->k_nam))
			break;
	return(p->k_val);
}



lookup()
{
	register struct symtab *p;
	register int i;
	register char *pp;
	i = 0;
	pp = symbuf;
	while (pp < symbuf+SYMLEN)
		i =+ *pp++;
	p = &symtab[i%TABLEN];
	if (p->s_flag & KEYW && (i=keylook(symbuf, keywds)))
			return(i);
	i = 0;
	while (*p->s_name) {
		if (cmpstr(p->s_name, symbuf)) {
			i++;
			break;
		}
		if (++p >= &symtab[TABLEN])
			p = symtab;
	}
	if (i == 0) {
		if (++symcntr >= TABLEN)
			finmsg("Symbol table overflow");
		p->s_flag =& KEYW;
		p->s_class = 0;
		p->s_link = p->s_value = p->s_type = p->s_dsiz = 0;
		scopy(p->s_name, symbuf);
	}
	symptr = yylval = p;
	return(ID);
}


scopy(s1,s2)
char *s1, *s2;
{
	while(*s1++ = *s2++);
}

cmpstr(s1,s2)
char *s1,*s2;
{
	while ( *s1++ == *s2 )
		if ( *s2++ == '\0' )
			return(1);
	return(0);
}
