/*
 *	lpkill.c
 *	Peter Collinson March 77
 *	If any arguments are specified deletes the spooler file
 *	containing the file name from the queue
 *	If that file is being printed kills the process
 *	If no arguments specified - kill the running print process
 *	Checks if the file being printed is owned by the invoker
 *	Must be run using setuser id format.
 *	Gets its information from the /usr/lpd/lock file
 *	which is updated by the lpd deamon.
 *	In this file
 *	bytes 0,1	current lpdexec process id
 *	bytes 2-18	Name of current spooler file
 */

char lock[]	"/usr/lpd/lock";
char lpd[]	"/usr/lpd";

struct info
{	int spoolno;
	char spoolfile[16];
};

int buf[18];
int iobuf[259];

struct 
{	int	inode;
	char 	fname[14];
} dir;
struct
{	int	majmin;
	int	inumber;
	int	flags;
	char	links;
	char	uid;
	char	gid;
	char	s0;
	int	fill[13];
} statb;

struct
{	char	user[24];	/* Name of creator of file */
	char	path[512];	/* Pathname of file */
	char	swit;		/* switches set on file */
	char	file[128];	/* The file name itself */
} fdata;

char useruid;
char usergid;


main(argc, argv)
int argc; char **argv;
{
	useruid = getuid()&0377;
	usergid = getgid() & 0377;
	if(chdir(lpd) < 0)
	{	printf("Cannot open spool directory\n");
		exit();
	}

	if(argc == 1) killrunning(); 
	while(--argc)
		killfile(*++argv);
}

killrunning()
{	register int spoolno;

	if(spoolno = getinfo())
	{	
		if(useruid == 0 || (useruid == statb.uid && usergid == statb.gid))
		{	/* unlink spooler file just in case */
				unlink(&buf[1]);
				kill(spoolno, 2);
				exit();
		}
	}
	printf("Permission denied\n");
	exit();
}


int getinfo()
{	register int ret, fd;
	register struct info *info;
	info = buf;
	ret = 0;

	if((fd = open(lock, 0)) >= 0)
	{	if((read(fd, &buf, 2) > 0) && (info->spoolno != 0) && (read(fd, &buf[1], 16) > 0) &&
			(stat(info->spoolfile, &statb) >= 0))
			ret = info->spoolno;
	}
	close(fd);
	return(ret);
}

killfile(file)
char *file;
{	register int fd, lpfnd, spoolno;
	int onedel;
	int all;

	lpfnd = 0;
	onedel = 0;
	all = 0;

	if(file[0] == '-' && file[1] == 'a') all++;
	if((fd = open(lpd, 0)) < 0)
	{	printf("Cannot open /usr/lpd\n");
		exit();
	}

	seek(fd, 32, 0);		/* Avoid . and .. entries */
	while(read(fd, &dir, 16) > 0)
	{	if(dir.inode != 0 && dir.fname[0] == 'l' && dir.fname[1] == 'p')
		{	lpfnd++;
			if((stat(dir.fname, &statb) >= 0) &&
			   (useruid == 0 || (useruid == statb.uid && usergid == statb.gid)) &&
			   (readcontents(dir.fname)) &&
			   (all || compstr(fdata.file, file)))
			{
				if((spoolno = getinfo()) && compstr(dir.fname, &buf[1]))
					{	/* Remove spool file just in case */
						unlink(&buf[1]);
						kill(spoolno, 2);
						printf("File: %s is currently being printed - process killed\n", fdata.file);
					}
				else
				{	if(unlink(dir.fname) < 0)
						printf("Cannot delete spooler file: %s\n", dir.fname);
					else
					printf("Deleted spooler file for: %s\n",  fdata.file);
				}
				onedel++;
			}
		}
	}
	if(onedel == 0)
	{
		if(lpfnd == 0) { printf("Line printer queue empty\n"); exit(); }
		else printf("Cannot find spooler file%s%s\n", (all?"":" for: "), file);
	}
	close(fd);
}

int readcontents(spoolerfile)
char *spoolerfile;
{	register int ret;
	ret = 1;
	if(fopen(spoolerfile, &iobuf) < 0)
	{	printf("Cannot open spoolerfile: %s\n", spoolerfile);
		exit();
	}

	if(readline(fdata.user) ||
	   readline(fdata.path) ||
	   ((fdata.swit = getc(&iobuf)) < 0) ||
	   (getc(&iobuf) != '\n') ||
	   readline(fdata.file)) ret = 0;
	close(iobuf[0]);
	return(ret);
}

int compstr(s, d)
char *s, *d;
{	register char *i, *j;
	i = s; j = d;

	while(*i)
	{	if((*j == '\0') ||
		   (*i++ != *j++)) return(0);
	}
	if(*j) return(0);
	return(1);
}


int readline(dest)
char *dest;
{	register char *p, c; register int ret;
	p = dest; ret = 0;

	while((c = getc(iobuf)) != '\n')
	{	if(c < 0) { ret++; *dest == '0'; break;	}
		*p++ = c;
	}
	*p = '\0';
	return(ret);
}
