.de FO
'bp
..
.de HD
'sp 2
'sp
.ns
.wh 0 HD
.wh -7 FO
.nr p 10
.de PG
.sp
.ne 2
.ti +\\np
..
.de ST
.sp 2
\\$1
.br
..
.nr tl -10
.de TL
.ti \\n(tl
\\$1	\c
..
.pl 51
.ta 11,21,31,41,51,61,71,81,91,100   
.de TI
.ti +10
..
.ce
Improve your floating point on the 11/40
.ce
R.P.A. Collinson UKC November 1977

.PG
This package consists of a series of alterations to
the UNIX libraries which allow the 'ucsd_fort' version of fptrap to
be used with C programs.
.PG
The ucsd_fort software on the First Chicago mailing provided
two things:
	1)	An entry to fptrap (called fpsim) which can be called with a jsr
and not through the standard trap mechanism.
	2)	It uses the 11/40 floating point hardware (which
we do not have).

	It seemed logical to use the direct calling mechanism for fptrap
to eliminate the extremely inefficient and slow 'trap' system.
However, the version of fp.s sent in the Chicago mailing did not have
the look-ahead feature (Unix News 6 - vol 1). So my version combines the two
(see s3/fp.s).
.PG
Preliminary results with the new floating system seem to
indicate that programs run between two and four times the
original speed, they are increased in size by a very small fraction - so
it does appear to be worth doing.

To install the software:
.sp
1)	compile fp.s and put it into /lib/liba.a. Note this must be done before
anything else.
.sp
2)	compile fpsim.c (in s1) and install it in /lib as 'fpsim'. This program is a pre-processor
for 'as' programs. It goes through the code replacing all sequences of
floating point instructions by
	jsr pc,fpsim
	instruction sequence
.br
It does not look to see if it has been done before. So be careful.
.sp
3)	Compile the new version of cc.c (in ../mods), this calls /lib/fpsim on the working 'as'
file (after the code optimiser), it is only called when -f is specified to cc.
.sp
4)	Now look in the directory called commands.
	The shell file
	change.liba	gives details of how to run fpsim on certain selected
files in liba.a (source in s3). Please note that this shell file has been run and is
only included for demonstration purposes.
The shell files: new.liba and new.libc are runnable and will convert the
two libraries to the new calling system. They both assume
	a)	Your working directory is 'commands' and  its parent contains
the directories s3, s4 and s5.
	b)	The commands directory contains a copy of liba.a and libc.a

5)	The portable C library is a problem. It tends to be
sprinkled liberally with floating point
references (more specifically in printf, ftoa and scanf).
There doesn't seem to be any really adequate way of making it only
load fptrap etc when it needs it. So: cc now looks to see whether
the portable C lib is requested (looks for -lp switch) and loads the old version
of the run-time start-off code (floating point only) -
cc expects the code to be in /lib/trap.fcrt0.o.
In essence, the portable C library treats floating point the way it used
to.

6)	When you have done all this, you can
alter the file (fcrt0.o) in /lib which is included at the start of every C program.
The source of the new version is in s5.
I found that when the profiler was used, it requires a new header file (which wasn't
present on the distributed UNIX system). cc now includes a
file called fmcrt0.o when the profiling switch is set. (See s4 for source).

7)	For manual pages for fpsim (fpsim.1) and a new fptrap.3 see ../man/man[13].
.sp3
If any-one knows how to alter the C compiler to generate the correct
instruction sequence please let me know. It will then be possible to get
rid of fpsim.


.ce
Fortran
.PG
The directory 'fort' contains all the altered files required to
recompile the Unix fortran compiler and run-time system.
I have not bothered to include run files (You can find the correct file on your
version of the Unix Source).
