#

/*
 * lpdaemon -  line printer spooler, started up by lp
 */


#define	OVERPRINTS	4
#define	PRINTER		"/dev/lp"

#include		"lpdaemon.h"
#define	ILLEGALDATA	"File is not a character file"
#define	HEADERTOOLONG	"Header will not fit in specified page width"
#define	SMALLPAGE	"Specified page size too small"
#define	CANCELLED	"Cancelled during printing"
#define	NOTFOUND	"Cannot open specified file for reading"

#define	VT		'\13'
#define	FF		'\14'
#define	BS		'\10'
#define	true		0177777
#define	false		0
#define	INITIAL		1
#define	FINAL		0
#define	IGNORE		1
#define	PARITY		0200

int	lpfd;		/* file descriptor for the printer */
int	filefd;		/* file descriptor for a file to be printed */
int	qfd;		/* file descriptor for lpq name file */
int	semfd;		/* file descriptor for the queue lock */

int	line_ctr;	/* current line on logical page */
int	line_no;	/* total number of lines processed */
int	page_no;	/* number of pages printed */
int	p_length;	/* virtual page length in printing */
int	p_width;	/*    ditto  width */
char	*line_start;	/* beginning of the virtual line */

int	killed;		/* set true by a signal 14 */
char	*error;		/* points to appropriate error message */
int	endfile;	/* has endfile been reached for a file */
int	throwpage;	/* page throw at the end of each page */
int	bufcount;	/* number of characters in input buffer */

char	lpbuffer[512];	/* intermediate buffer for the printer */
char	filebuf[513];	/* input buffer for file being printed */
char	headerbuf[PAGEWIDTH+2];	/* formatting buffer for page header */
char	linebuf[PAGEWIDTH+2];	/* formatting buffer for line to be printed */
char	*lpptr	lpbuffer;	/* current pointer into lpbuffer */
char	*iptr	filebuf;	/* file input pointer */
int	col[OVERPRINTS];
char	overprints[OVERPRINTS][PAGEWIDTH+2];

char	*formfeed	"\14";
char	*forms	"\14\14\14\14\14";
char	*space	" ";
char	*stars
	"************************************************************************\n";
char	*box
	"**                                                                    **\n";
char	*overbox {
	"**                                                                    **\r";





main( argc , argv )
int	argc;
char	**argv;
	{
	register int	i, j;
	char		*arg;
	int		pid;
	int		reset[2];
	extern int	kill_request(), set_killed();

	/*  14 - Finish file now printing, then die */
	signal( 14, set_killed );

	close(0);    close(1);

	argc--;    argv++;
	if ( argc < 2 )
		exit( -1 );
	arg = *argv++;
	qfd = *arg++;
	semfd = *arg;
	arg = *argv;

	for ( i=0; i< OVERPRINTS; i++ )  {
		col[i] = -1;
		for ( j=0; j< PAGEWIDTH+3; j++ )
			overprint[i][j] = ' ';
		}

	while( (lpfd = open( PRINTER, 1 )) < 0 )
		sleep(10);

	while ( !killed )  {

		/* 15 - Abandon the request currently printing */
		signal( 15, kill_request );

		/* Get next entry and mark it as printing */
		lock( semfd );
		if ( read( qfd, &lpq, LPQLNG ) < LPQLNG )  {
			unlock( semfd );
			break;
			}
		if ( lpq.num_copies <= 0 )  {
			unlock( semfd );
			continue;
			}
		lpq.printing = true;
		seek( qfd, -LPQLNG, 1 );
		write( qfd, &lpq, LPQLNG );
		unlock( semfd );

		/* Print the file */
		burst_page();
		while ( lpq.num_copies >0 )  {
			print_file();
			if ( lpq.num_copies ) 
				lpq.num_copies--;
			lock( semfd );
			seek( qfd, -LPQLNG, 1 );
			write( qfd, &lpq, LPQLNG );
			unlock( semfd );
			}
		if ( error )
			error_message();
		clear_lpbuf();
		if ( lpq.lpdfile )
			unlink( lpq.filename );
		}

	/* Mark "no daemon active" in queue file => zero bytes 2-3
	 * If not killed, then truncate the queue */
	lock( semfd );
	seek( qfd, 0 , 0 );
	read( qfd, reset, 2 );
	reset[1] = 0;
	if ( !killed )  {
		close( qfd );
		qfd = creat( arg, 0600 );
		}
	seek( qfd, 0, 0);
	write( qfd, reset, 4 );
	unlock( semfd );
	}



char	*line_ptr, *burst_save, *pageno_ptr, *line_text;
int	any_dregs, newline, tvec[2];



print_file()
	{

	endfile = false;
	error = page_no = line_ctr = 0;
	line_no = 1;
	set_sizes();
	filefd =  open( lpq.filename, 0 );
	if ( filefd < 0 )
		error = NOTFOUND;
	iptr = filebuf;    bufcount = 0;
	page_head();
	newline = true;
	while ( !endfile  &&  !error )
		print_line();
	close( filefd );
	/* line_ctr == pagelength =>  have just completed a page */
	if ( lpq.bottom_margin  ||  line_ctr < p_length )
		lpstring( formfeed );
	}




print_line()
	{
	register char	c;
	register int	col_no;
	int		i;
	char		*p;

	if ( lpq.numbers  &&  newline )
		 itoa( line_no, line_start );
	any_dregs = newline = false;
	col_no = 0;
	line_ptr = line_text;
	for (;;)  {

		if ( iptr >= &filebuf[bufcount] )  {
			iptr = filebuf;
			bufcount =  read( filefd, filebuf, 512 );
			if ( bufcount <= 0 )  {
				endfile = true;
				/* If we have a non-terminated line at
				 * eof, then print it */
				if ( line_ptr > line_text )  {
					line_ctr++;
					put_line( true );
					}
				return;
				}
			}

		if ( (c= *iptr++) &PARITY )  {
			error = ILLEGALDATA;
			return;
			}

		if ( c< '\10'  ||  ('\15'< c  &&  c< '\40')  ||  '\176'< c )
			continue;

		switch ( c )  {
		case   VT:
			if ( lpq.vtabsize <= 0 ) continue;
		case '\n':
			*line_ptr = '\n';
			line_no++;
			line_ctr++;
			newline = true;
			put_line( true );
			if ( c=='\n' || (i=lpq.vtabsize-1) <= 0 )
				return;
			line_ctr =+ i;
			lines(i);
			return;
		case '\r':
			*line_ptr = '\r';
			put_line( true );
			return;
		case FF:
			*line_ptr = FF;
			line_no++;
			line_ctr++;
			newline = true;
			put_line( true );
			line_ctr = 1;
			page_head();
			return;
		case BS:
			col_no--;
			if ( col_no < 0 ) col_no = 0;
			continue;
		case '\t':
			col_no =+ lpq.htabsize;
			col_no =- col_no %lpq.htabsize;
			while ( line_ptr -line_text < col_no )
				*line_ptr++ = ' ';
			continue;
			}

		if ( line_ptr - line_start >= p_width
			&&  line_ptr - line_text == col_no )  {
			*line_ptr++ = '\n';
			put_line( true );
			line_ctr++;
			if ( lpq.numbers )  {
				p = "cont";
				for ( i=0; *p!= '\0'; line_start[i++] = *p++ );
				}
			line_ptr = line_text;
			col_no = 0;
			}

		/* So its an ordinary char.  If we are at the righmost column
		 * so far then stash it */
		if ( line_ptr -line_text == col_no )  {
			col_no++;
			*line_ptr++ = c;
			continue;
			}

		/* Otherwise its an overprint.  Fit the char into the
		 * first overprint buffer that has a spcae in this column */
		any_dregs = true;
		for ( i= 0; i< OVERPRINTS;  i++ )  {
			p = &overprints[i][col_no];
			if ( *p == ' ' )  {
				*p = c;
				/* Mark rightmost extent of char in this buf */
				if ( col[i] < col_no )
					col[i] = col_no;
				break;
				}
			}

		/* No room.  In desperation dump the overprint buffers to
		 * the lineprinter and start again with them all clear.
		 * We do not print the normal buffer here */
		if ( i == OVERPRINTS )  {
			put_line( false );
			overprint[0][col_no] = c;
			col[0] = col_no;
			}
		col_no++;
		}
	}




put_line( print_buf )
int	print_buf;
	{
	register int	i, c;
	register char	*p;


	/* New page ? */
	if (  (throwpage  &&  line_ctr > p_length) )  {
		lpstring( formfeed );
		page_head();
		}
	if ( line_ctr > p_length )
		line_ctr = 1;

	if ( any_dregs )  {
		any_dregs = false;
		/* Print the overprint buffers that have been used */
		for ( i= 0; i< OVERPRINTS; i++ )  {
			if ( (c= col[i]) < 0 )
				break;
			for ( p= linebuf;  p< line_text;  p++ )
				lpstring( space );
			p =  &overprint[i][++c];
			*p++ = '\r';
			*p = '\0';
			lpstring( &overprint[i]);
			/* clear the buffer */
			for ( p= overprint[i];  p< overprint[i+1]; )
				*p++ = ' ';
			col[i] = -1;
			}
		}
	if ( !print_buf )
		return;
	/* Print the normal buffer */
	*++line_ptr = '\0';
	lpstring( linebuf );
	for ( p= line_start;  p< line_text; )
		*p++ = ' ';
	}




page_head()
	{
	register char	*p;

	page_no++;
	lines( lpq.top_margin );
	if ( lpq.header )  {
		*(p = itoa( page_no, pageno_ptr ))  = '\0';
		lpstring( headerbuf );
		lines( BLANKSUNDERHEADER +1 );
		}
	}




set_sizes()
	{
	register char	*p, *q;
	register int	i;
	int		title_lng, header_wdt, spaces, right_limit;

	throwpage =  lpq.top_margin| lpq.bottom_margin| lpq.header;
	/* In this routine we set up line_start and line_text.
	 * line_start is the leftmost edge of printing in linebuf.
	 * line_text is the leftmost edge of the text from
	 * file being printed.  The line numbers are put in the gap */
	p_length = PAGELNG;
	if ( i = lpq.page_lng )
		p_length = i;
	p_length =- (lpq.top_margin + lpq.bottom_margin);
	if ( lpq.header )
		p_length =- (BLANKSUNDERHEADER + 1);
	p_width = PAGEWIDTH;
	if ( i = lpq.page_wdt )
		p_width = i;
	p_width =- lpq.margin;
	if ( p_length < 20  ||  p_width < 20 )  {
		error = SMALLPAGE;
		return;
		}

	line_start =  &linebuf[ lpq.margin];
	line_text = line_start +  ( lpq.numbers? 12: 0 );
	for ( p= linebuf;  p< line_text; )
		*p++ = ' ';

	if ( lpq.header )  {

		/* Set up the header buffer, marking the end of it by
		 * pageno_ptr, for later reference */
		for ( q= lpq.title;  *q;  q++ );
		title_lng =  q - lpq.title;
		for ( p= headerbuf;  p< &headerbuf[lpq.margin+2]; )
			*p++ = ' ';
		/* 2(spaces) + time + 2 + title + 2 + page no */
		header_wdt =  2 + 24 + 2 + title_lng + 2 + 7;
		if ( header_wdt > p_width )  {
			error = HEADERTOOLONG;
			return;
			}
		if ( lpq.lpdfile )
			q =  ctime( lpq.date );
		else	{
			time( tvec );
			q =  ctime( tvec );
			}
		while ( *q != '\n' )
			*p++ = *q++;
		right_limit =  (3* p_width)/4;
		spaces = 2;
		if ( header_wdt < right_limit )
			spaces =  2 + (right_limit - header_wdt)/2;
		for ( i= 0;  i <spaces;  i++ )
			*p++ = ' ';
		for ( q= lpq.title;  *q; )
			*p++ = *q++;
		for ( i= 0;  i <spaces;  i++ )
			*p++ = ' ';
		for ( q= "page ";  *q!= '\0'; )
			*p++ = *q++;
		pageno_ptr = p;
		}
	}




burst_page()
	{
	register int	i;
	register char	*p;

	for ( i=0; i< 6; i++ )
		lpstring( stars );
	lpstring( stars );
	lpstring( box );

	box_line("Title:         ", lpq.title, 1 );
	box_line("From:          ", lpq.from, 1 );
	box_line("To:            ", lpq.to, 1 );
	box_line("Filename:      ", lpq.filename, 1 );
	linebuf[0] = '#';
	*(p= itoa( lpq.serial, &linebuf[1] ))  = '\0';
	box_line("Serial number: ", linebuf, 1 );
	time( tvec );
	box_line("Time printed:  ", ctime( tvec), 0 );
	box_line("Time queued:   ", ctime( lpq.date), 0 );
	box_line("Last modified: ", ctime( lpq.mdate), 0 );

	lpstring( stars );
	lpstring( stars );

	/* Save the end of the burst page output.  On error
	 * other output is scrapped by returning to burst_save */
	burst_save = lpptr;
	lpstring( formfeed );
	}




error_message()
	{
	register	i;

	lpptr = burst_save;
	lines( 10 );
	lpstring( stars );
	lpstring( stars );
	lpstring( box );
	box_line("Filename:     ", lpq.filename, 1 );
	box_line("Request cancelled :-", "", 1 );
	box_line( "      ",  error, 1 );
	lpstring( stars );
	lpstring( stars );
	lpstring( formfeed );
	}




box_line( str1, str2, nl )
char	*str1, *str2;
int	nl;
	{

	lpstring( overbox );
	lpstring("      ");
	lpstring( str1 );
	lpstring( str2 );
	if ( nl )
		lpstring("\n");
	lpstring( box );
	}




lpstring( str )
char	*str;
	{
	register char	*p, *optr;

	p = str;
	optr = lpptr;
	while ( (*optr++ = *p++) != '\0' )  {
		if ( optr >= &lpbuffer[512] )  {
			write( lpfd, lpbuffer, 512 );
			burst_save = optr = lpbuffer;
			}
		}
	lpptr = optr -1;
	}




clear_lpbuf()
	{
	register int	residual;

	if ( residual = lpptr -lpbuffer )  {
		write( lpfd, lpbuffer, residual );
		lpptr = lpbuffer;
		}
	}




lines( num )
int	num;
	{
	register int	n;
	char		send[3];

/*
	n = num;
	send[0] = VT;
	send[2] = '\0';
	if ( n > 63 )  {
		n =- 63;
		send[1] = 63;
		lpstring( send );
		}
	send[1] = n -11;
	lpstring( send );
*/
	for ( n=0; n<num; n++ )
		lpstring("\n");
	}





itoa( num, ptr )
int	num ;
char	*ptr;
	{
	register int	power;

	for ( power= 10;  num/power != 0;  power =* 10 );
	power =/ 10;
	for (; power > 0;  power =/ 10 )  {
		*ptr++ = num/power + '0';
		num =% power;
		}
	return( ptr );
	}




set_killed()
	{
	killed = true;
	}




kill_request()
	{
	lpq.num_copies = 0;
	error = CANCELLED;
	}
