#
/*
 *	Collection of routines used by shutdown and fastdown
 */


#include	"../sys/param.h"
#include	"../sys/proc.h"

struct	{
	char	name[8];
	int	type;
	char	*value;
	}  nl[1];

int	abort;
char	*warning;




/*
 *	Killprocs kills all processes in decreasing priority,
 *	except itself.  Since sleepy swapped out processes
 *	will not die, and can't do anything, only try 5 times
 */

killprocs( unix )
char	unix[];
	{
	struct proc	*procno, *p;
	int		count, maxpri, mem, ownpid, iteration_count;
	int		i, time_now[2];
	char		*nm, *dest;

	time( time_now );
	printf("\n%s", ctime( time_now ));
	dest = &nl[0];
	nm = "_proc";
	while ( *dest++ = *nm++ );
	nlist( unix, nl);
	if ( nl[0].type == 0)  {
		printf("No name list\n");
		exit();
		};
	if ( (mem=open("/dev/kmem", 0)) <0 )  {
		printf("No mem\n");
		exit();
		};
	sync();
	count = 0;
	iteration_count = -1;
	ownpid = getpid();
	printf("\nProcesses killed :-\n");
	for ( i=0;  i< 5  &&  iteration_count;  i++ )  {
		seek( mem, nl[0].value, 0);
		nice(-220);
		read( mem, proc, sizeof proc);
		iteration_count = 0;
		for (;;)  {
			maxpri = 0;
			procno = 0;
			for ( p= &proc[1]; p< &proc[NPROC]; p++)  {
				if ( p->p_stat !=0 &&
				     p->p_pid  !=ownpid &&
				     p->p_pri  > maxpri )  {
					maxpri = p->p_pri;
					procno = p;
					};
				};
			if ( procno == 0 )
				break;
			printf("%6d", procno->p_pid);
			iteration_count++;
			if ( ++count %10 == 0 )
				putchar('\n');
			kill( procno->p_pid, 9);
			procno->p_stat = 0;
			};
		};
	if ( count == 0 )
		printf("  None\n");
	else	if ( count %10 != 0 )
			putchar('\n');
	nice(0);
	}


wall( text, anywall )
char	*text;
int	*anywall;
	{
	int	tmpfile, count, pid, newpid;
	char	*letter, *tmp;

	*anywall = 1 ;
	tmp = "/tmp/shutdownmesg";
	pid = getpid();
	tmpfile = creat( tmp, 0600 );
	letter = text;
	count = 0;
	while ( *letter++ != '\0' )
		count++;
	write( tmpfile, text, count );
	close( tmpfile );
	newpid = fork();
	if (pid!=getpid())  {
		nointerrupts();
		execl("/etc/wall", "", "/tmp/shutdownmesg");
		};
	while ( newpid != wait() );
	unlink( tmp );
	}




nointerrupts()
	{
	abort = 0;
	signal( SIGHUP, 1 );
	signal( SIGQIT, 1 );
	signal( SIGINT, 1 );
	}



interrupt()  {
	abort = 1;
	signal( SIGINT, 1);
	}



copy( namein, nameout )
char	*namein, *nameout;
	{
	int	filein, fileout, size, buf[256];

	/* if namein doesnt exist make sure nameout doesnt, else copy across */
	if ( (filein= open(namein, 0)) <0)
		unlink( nameout);
	else	{
		fileout = creat( nameout, 0644);
		while ( (size=read( filein, buf, 512)) > 0 )
			write( fileout, buf, size);
		close( filein);
		close( fileout);
		}
	}


setwarning( nameout )
char	*nameout;
	{
	int	fileout, count;
	char	*letter;

	fileout = creat( nameout, 0644 );
	letter = warning;
	count = 0;
	while ( *letter++ != '\0' )
		count++;
	write( fileout, warning, count );
	close( fileout );
	}


terminate( anywall )
int	anywall;
	{
	/* restore message of the day */
	copy( "/etc/motd.b", "/etc/motd" );
	unlink("/etc/motd.b");
	if ( anywall > 0 )
		wall("shutdown cancelled, t/s continues\n");
	exit(0);
	}


delay( seconds )
int	seconds;
	{
	int	i;

	if ( abort == 1 )
		terminate();
	for ( i=0; i<seconds; i=i+3 )  {
		sleep(3);
		if ( abort == 1 )
			terminate();
		}
	}
