#

/*
 * Register proding routines for the SI disks,
 * to be used in conjunction with disk.c
 */


#include	"../param.h"
#include	"../buf.h"
#include	"../conf.h"
#include	"../user.h"
#include	"../disk.h"
#include	"si.h"

/* Control register bits */
#define	GO		01
#define	WRITE		02
#define	READ		04
#define VERIFY		010
#define	IENABLE		0100
#define	DONE		0200
#define	STROBENORMAL	0
#define	STROBELATE	04000
#define	STROBEARLY	010000
#define	OFFSETNORMAL	0
#define	OFFSETMINUS	020000
#define	OFFSETPLUS	040000
/* Error register bits */
#define	BADSECTOR	01000
#define	DRIVEFAULT	04000
#define	SELECTERROR	010000
#define	RWERRORS	077770
/* Seek status error register bits */
#define	DONEPORT0	016

struct	{
	int	si_cr;		/* control register */
	int	si_wcr;		/* word count register */
	int	si_pcar;	/* port cylinder address register */
	int	si_hsar;	/* head sector address register */
	int	si_mar;		/* memory address register */
	int	si_er;		/* error register */
	int	si_ssr;		/* seek status register */
	int	si_sar;		/* seek address register */
	};

int	SIADDR		0176700;


struct devtab	sitab;
struct buf	rsibuf;
int		si_init		1;

int	sirecovery[]  {
		OFFSETNORMAL | STROBENORMAL,
		OFFSETMINUS  | STROBENORMAL,
		OFFSETPLUS   | STROBENORMAL,
		OFFSETNORMAL | STROBELATE,
		OFFSETMINUS  | STROBELATE,
		OFFSETPLUS   | STROBELATE,
		OFFSETNORMAL | STROBEARLY,
		OFFSETMINUS  | STROBEARLY,
		OFFSETPLUS   | STROBEARLY
		};


/* Synonyms for the pdisk address fields */
#define	pcar	p_addr1
#define	hsar	p_addr2
/* Masks for decoding the minor device no */
#define	PORT		03
#define	LDISK		0174

/* Clock ticks allowed before software interrupt forced */
#define	SITIMEOUT	25
/* Limit of retry's on a transfer */
#define	ERRLIM		5*9


sistrategy( abp)
struct	buf	*abp;
	{
	register struct buf	*bp;
	register struct pdisk	*pdp;
	register int		drive;
	int			ldisk;

	bp = abp;
	/* Check that the minor dev no is ok */
	drive = bp->b_dev &PORT;
	ldisk = (bp->b_dev &LDISK) >>2;
	pdp = &si_disks[drive];
	if ( drive>= NSIDEV  ||  ldisk>= pdp->p_nldisks )
		bp->b_flags =| B_ERROR;
	diskstrategy( pdp, &(pdp->p_ldisks)[ldisk], bp);
	}



sistart( apdp)
struct pdisk	*apdp;
	{
	register struct pdisk	*pdp;
	register int		sps;
	extern			sisoftintr();

	pdp = apdp;
	diskflip( pdp, 160 );
	pdp->pcar =  (pdp->p_buf->b_dev &PORT)<<10 | pdp->p_addr1;

	/* Arrange to do a LMC at startup */
	if ( si_init )  {
		si_init = 0;
		SIADDR->si_cr = 0;
		/* Enable interrupts */
		SIADDR->si_cr =  IENABLE| READ;
		sitab.d_actl = &sitab;
		}
/* Pretend we've done an overlapped seek  */
	sitab.d_actl->d_actf = pdp;
	sitab.d_actl = pdp;
	pdp->d_actf = 0;
	sps = PS->integ;
	spl5();
	sirwstart();
	PS->integ = sps;
/* All of which is replaced by :
	pdp->p_flags =| P_SEEKING;
	SIADDR->si_sar = pdp->pcar;
	timeout( sisoftintr, 0, HZ/2 );
*/
	}



sirwstart()
	{
	register struct pdisk	*pdp;
	register struct buf	*bp;
	extern			sisoftintr();

	if ( sitab.d_active )
		return;
	/* Any disks in the r/w queue ? */
	if ( (pdp= sitab.d_actf) == 0 )
		return;
	sitab.d_active++;
	bp = pdp->p_buf;
	SIADDR->si_mar = bp->b_addr;
	SIADDR->si_hsar = pdp->hsar;
	SIADDR->si_pcar = pdp->pcar;
	SIADDR->si_wcr  = -bp->b_wcount;
	SIADDR->si_cr  =  GO| IENABLE| (bp->b_xmem&03)<<4 |
				( bp->b_flags&B_READ? READ: WRITE )|
				sirecovery[ pdp->p_errcnt %9 ];
	timeout( sisoftintr, 0, HZ/2 );
	}




siintr()
	{
	register struct pdisk	*pdp;
	register int		stat, n;
	int			wds;
	extern			sisoftintr();


	/* Re-enable interrupts */
	SIADDR->si_cr =  IENABLE |READ;
	wds =  -~SIADDR->si_wcr;
	stat =   SIADDR->si_ssr;
	killtimeouts( sisoftintr, 0 );

	/* Detect completed seeks */
	n = DONEPORT0;
	for ( pdp= si_disks; pdp< &si_disks[NSIDEV]; pdp++ )  {
		if ( pdp->p_flags&P_SEEKING  &&  n&stat )  {
			/* Put him in the r/w queue */
			sitab.d_actl->d_actf = pdp;
			sitab.d_actl = pdp;
			pdp->d_actf = 0;
			pdp->p_flags =& ~P_SEEKING;
			}
		n =<< 4;
		}

	if ( sitab.d_active )  {
		/* Get the r/w error bits of the error register */
		n =  SIADDR->si_er &RWERRORS;
		pdp = sitab.d_actf;
		sitab.d_active = 0;
		stat = 0;
		if ( n | sitab.d_errcnt )  {
			if ( n &(BADSECTOR|SELECTERROR|DRIVEFAULT) )
				stat = ENXIO;
			else  if ( diskfail( pdp, n, wds) < ERRLIM )  {
				/* Try again */
				sirwstart();
				return;
				}
			else	stat = EIO;
			}
		diskfinish( &sitab, stat, wds );
		}
	sirwstart();
	}



/*
 *  Software interrupt, only happens when hardware error results
 *  in no interrupt from the controller.
 */

sisoftintr( arg )
int	arg;
	{

	/* Reset the controller, then do an interrupt */
	SIADDR->si_cr = 0;
	sitab.d_errcnt++;
	siintr();
	sitab.d_errcnt = 0;
	}



siread( dev )
int	dev;
	{
	physio( sistrategy, &rsibuf, dev, B_READ );
	}




siwrite( dev )
int	dev;
	{
	physio( sistrategy, &rsibuf, dev, B_WRITE );
	}
