/*
 * Each logical disk is defined by an ldisk structure.
 * This defines the address of the disk, and holds the head
 * and tail of the doubly linked I/O queue for the disk.
 */

struct	ldisk	{
	char		l_flags;	/* see defines below */
	char		l_prio;		/* priority level of ldisk */
	int		l_locyl;	/* starting cylinder address */
	char		*l_nblk;	/* length in blocks */
	struct buf	*av_forw;	/* head of I/O queue */
	struct buf	*av_back;	/* tail " */
	};

/* l_flags bits */
#define	L_FLIPCYL	01


/*
 * Each logical disk has a priority level.  The scheduling of requests
 * at each priority level is controlled by the prilev structure for
 * that priority level.  The scheduling chooses a logical disk for service
 * and then works forwards or backwards through the requests on that disk
 * according to the head direction.  The logical disk is chosen as the
 * next in *s_order with requests pending.
 */

struct	prilev  {
	int		s_reqcount;	/* no. requests waiting */
	char		s_ordptr;	/* current postion in schedule list */
	char		s_headdir;	/* head direction */
	char		*s_order;	/* servicing order */
	struct ldisk	*s_curldisk;	/* ldisk of current request */
	struct buf	*s_nextbp;	/* scheduled for service next */
	};


/*
 * Each physical disk is described by a pdisk structure.
 * This contains all the status information for the disk
 * while I/O is in progress on the disk.
 */

struct	pdisk  {
	/* The following refer to the request currently being serviced */
	struct buf	*p_buf;		/* request's buf */
	struct ldisk	*p_ldp;		/* its ldisk */
	char		p_errcnt;	/* errors so far on request */
	char		p_errsprtd;	/* errors reported so far */
	struct buf	*d_actf;	/* linkage for q of disks to r/w */
	int		p_addr1;	/* physical address 1 */
	int		p_addr2;	/*    "  2 */
	int		p_error;	/* copy of error register at last error */
	int		p_resid;	/* words remaining after I/O error */
	/* Information about the disk */
	char		p_flags;	/* see defines below */
	char		p_nldisks;	/* no of logical disks on pdisk */
	struct ldisk	*p_ldisks;	/* the logical disks on pdisk */
	int		(*p_start)();	/* the overlapped start routine */
	struct prilev	*p_schedule;	/* head of list of priority levels */
	};

/* p_flags bits */
#define	P_BUSY		01
#define	P_SEEKING	02
