# include "../h/param.h"
# include "../h/uba.h"
# include "../h/map.h"
# include "../h/buf.h"
# include "../h/dir.h"
# include "../h/user.h"
# include "../h/proc.h"

extern int dv_debug;  /*%%%*/
 
/*
*  Allocate as many contiguous UBA mapping registers
*  as are necessary to do transfer of 'bcnt' bytes
*  to/from location 'baddr'.
*  Wait for enough map registers.
*  'bdpflg' is non-zero if a "buffered data path" (BDP) is
*  to be used, else 0 -> use direct data path (DDP) .
*  Return
*
*    |31 - - 28|27 - - 18|17 - - - 9|8 - - 0|
*    |         |         |          |       |
*    |  BDP    |   no.   |  start   | byte  |
*    |   no.   | mapping |   map    | offset|
*    |         |  reg's  | reg. no. |       |
*    |         |         |          |       |
*
*/

ubasetup(bp, bdpflg)
register struct buf *bp;
{
	register int *io;
	register int bdp;
	register int i, nmreg;
	register int pf, *pt;
	int ipl;
	int ubinfo;
	extern int Ubamap[], ubautl[];

	/* compute useful stuff: virtual page frame, click count */
	pf = ((int) bp->b_un.b_addr >> 9) & 0x7fffff;
	nmreg = ((((int) bp->b_un.b_addr + bp->b_bcount - 1) >> 9) & 0x7fffff) - pf + 2;
	if (dv_debug) printf("pf%x nmreg%d\n", pf, nmreg); /*%%%*/

	/* get user page table if we must map to user space */
	ipl = spl6();
	if ((bp->b_flags & B_PHYS) != 0)
		ptaccess(bp->b_proc, Ubamap, ubautl);
	
	/* get unibus mapping registers */
	while ((i = malloc(ubamap, nmreg) - 1) < 0)
	{
		umrwant++;
		sleep(ubamap, PSWP);
	}
	if (bdpflg)
	{
		while ((bdp = malloc(bdpmap, 1)) == NULL)
		{
			bdpwant++;
			sleep(bdpmap, PSWP);
		}
	}
	else
		bdp = 0;
	splx(ipl);

	/* compute return value */
	ubinfo = (bdp << 28) | (nmreg << 18) | (i << 9) | ((int) bp->b_un.b_addr & 0x1ff);

	/* get pointer into unibus mapping registers */
	io = &((int) ((struct uba_regs *) UBA0)->uba_map[i]);

	/* 'bdp' now becomes the fixed template for the mapping regs */
	bdp = (bdp << 21) | MRV;
	if (bdp != MRV && ((int)bp->b_un.b_addr & 01) != 0)
		bdp |= BO;

	/* map u-area if needed */
	if ((bp->b_flags & B_UAREA) != 0)
	{
		for (i = 0; i < UPAGES; i++)
		{
			if ((*io++ = (bp->b_proc->p_addr[i] & 0x1fffff) | bdp) == bdp)
				panic("uba: zero upage");
		}
		nmreg -= UPAGES;
	}

	/* we do different mapping for physical vs buffered I/O */
	if ((bp->b_flags & B_PHYS) == 0)
	{
		/* buffered I/O */
		pf = (pf & 0x1fffff) | bdp;
		while (--nmreg > 0)
			*io++ = pf++;
	}
	else
	{
		/* physical I/O */
		/* adjust for possible I/O to stack segment */
		if ((pf & 0x200000) != 0)
		{
			i = ((struct user *) ubautl)->u_pcb.pcb_szpt;
			pf = i * 128 + pf - 0x400000;
		}

		/* copy page map into uba mapping registers */
		pt = ubautl + UPAGES * 128 + pf;
		while (--nmreg > 0)
			if ((*io++ = (*pt++ & 0x1fffff) | bdp) == bdp)
				panic("uba: zero entry");
	}

	/* invalidate last entry */
	*io++ = 0;

	/* return unibus information */
	return (ubinfo);
}

/*
**  UBALLOC -- allocate unibus
**
**	Non-buffer interface.  Sets up a buffer and calls ubasetup.
*/

struct buf ubabuf;

int uballoc(baddr, bcnt, bdpflg)
char bdpflg;
char *baddr;
unsigned short bcnt;
{
	register int ipl, ubinfo;

	ipl = spl6();
	while (ubabuf.b_flags & B_BUSY)
	{
		ubabuf.b_flags |= B_WANTED;
		sleep((caddr_t) &ubabuf, PRIUBA);
	}

	/* fill in unibus buffer */
	ubabuf.b_un.b_addr = baddr;
	ubabuf.b_flags = B_BUSY;
	ubabuf.b_bcount = bcnt;
	splx(ipl);

	/* allocate the unibus map */
	ubinfo = ubasetup(&ubabuf, bdpflg);

	/* free up the unibus buffer */
	ubabuf.b_flags &= ~B_BUSY;
	if (ubabuf.b_flags & B_WANTED)
		wakeup((caddr_t) &ubabuf);
	return (ubinfo);
}
 


ubafree(mr)
int mr;
{
/*
*  Free UBA memory mapping reg's and a BDP no..
*
*	'mr' is as returned by ubasetup.
*/
 
	register bdp , nmreg , regnum ;
	register int sipl;
 
	sipl = spl6();
	bdp = (mr>>28) & 0x0f ;  /* BDP no. */
	if (bdp)
	{
		((struct uba_regs *)UBA0)->uba_dpr[bdp] |= BNE ; /* purge */
		mfree(bdpmap, 1, bdp);
		if (bdpwant) {
			bdpwant = 0;
			wakeup(bdpmap);
		}
	}

	nmreg = (mr>>18) & 0x3ff ; /* no. of mapping reg's */
	regnum = (mr>>9) & 0x1ff ; /* 1st map reg. no. */
 
	/* free mapping reg's */
	mfree(ubamap,nmreg,regnum+1) ;
	if (umrwant) {
		umrwant = 0;
		wakeup(ubamap);
	}
	splx(sipl);
}

ubainit()
{
	mfree(ubamap, 496, 1);
	mfree(bdpmap, 15, 1);
}
