#define	LOC	0
#define	FOR	1
#define	FORP	2
#define	NUL	3
#define	FORQ	4
#define	FORI	5
#define	FORH	6
#define	FORK	7

#define	IGNOR	0
#define	CAT	1
#define	END	2
#define	NAME	3
#define	IN	4
#define	OUT	5
#define	PIPE	6
#define	EXLAM	7

struct	pa
{
	char	flag;
	char	type;
	char	*ptr;
} pa[30];
char	cmd[256];
char	exb[256];
char	*exp;
int	flb[10];
int	*flp;
char	cat[]	{ "/bin/cat -u" };
char	slave[]	{ "/usr/ken/mpx/ss" };

int	cpid, lpid, fpid;
int	ssfp;
int	pass;
int	hupsub();
int	qitsub();
int	intsub();

main()
{
	register i, m;

	/*
	 * have daemon create slave shell
	 */

	ssfp = mpxfile();
	if(ssfp < 0) {
		prs("no open channels\n");
		exit();
	}
	i = mpxcon(ssfp, 0);
	if(i < 0) {
		prs("no daemon\n");
		exit();
	}
	alarm(5);
	mpxatt(ssfp, ssfp);
	alarm(0);
	write(ssfp, slave, length(slave)+1);

	/*
	 * have input side of channel to slave
	 * permanently connect to cat for
	 * printing of std out and diag out
	 */
	if((cpid=fork()) == 0) {
		for(i=1; i<4; i++)
			signal(i, 1);
		close(0);
		dup(ssfp);
		close(2);
		close(ssfp);
		exec(cat);
	}

	signal(1, hupsub);
	signal(2, intsub);
	signal(3, qitsub);

loop:
	setexit();
	prs("> ");
	for(i=0; i<250; i++) {
		m = getchar();
		if(m <= 0)
			goto out;
		if(m == '\n')
			break;
		if(spcl(m))
			cmd[i++] = ' ';
		cmd[i] = m;
	}
	cmd[i++] = ' ';
	cmd[i] = 0;
	parse();
	if(syntax())
		goto loop;
	fpid = 0;
	pass = 1;
	norm();
	*flp = -1;
	pass = 2;
	norm();
	closefp(0);
	while((i=wait(cmd)) >= 0) {
		if(i == lpid)
			break;
		if(i == cpid)
			goto out;
	}
	if(fpid)
		kill(fpid, 9);
	goto loop;

out:
	putss(FORK);
	kill(cpid, 9);
	prs("\n\n");
	exit();
}

parse()
{
	register struct pa *p;
	register char *cp;
	register t;

	cp = cmd;
	p = pa;

loop:
	while(*cp == ' ')
		cp++;
	p->flag = 0;
	t = spcl(*cp);
	if(t) {
		p->type = t;
		cp++;
		p++;
		if(t == END)
			return;
		goto loop;
	}
	p->type = NAME;
	p->ptr = cp;
	while(*cp != ' ')
		cp++;
	*cp++ = '\0';
	p++;
	goto loop;
}

spcl(c)
{

	switch(c) {

	case '<':
		return(IN);

	case '>':
		return(OUT);

	case '^':
	case '|':
		return(PIPE);

	case '!':
		return(EXLAM);

	case '\0':
		return(END);

	}
	return(0);
}

syntax()
{
	register struct pa *p;
	int outf, inf, pipf, namf;

	inf = 0;
	outf = 0;
	pipf = 0;
	namf = 0;
	for(p=pa;;p++)
	switch(p->type) {

	case END:
		if(namf)
			return(0);
		if(pipf || inf || outf)
			goto err;
		return(1);

	case EXLAM:
		if(namf)
			goto err;
		if((p+1)->type != NAME)
			goto err;
		p->type = IGNOR;
		(p+1)->flag++;
		break;

	case IN:
		if(inf || pipf)
			goto err;
		inf++;
		goto file;

	case OUT:
		if(outf)
			goto err;
		outf++;
		if((p+1)->type == OUT) {
			p->type = IGNOR;
			p++;
			p->type = CAT;
		}

	file:
		if((p+1)->type == EXLAM) {
			(p+1)->type = p->type;
			p->type = IGNOR;
			p++;
			(p+1)->flag++;
		}
		if((p+1)->type != NAME)
			goto err;
		(p+1)->type = p->type;
		p->type = IGNOR;
		p++;
		break;

	case PIPE:
		if(!namf || outf)
			goto err;
		namf = 0;
		pipf++;
		break;

	case NAME:
		namf++;
	}
err:
	prs("syntax error\n");
	return(1);
}

norm()
{
	register struct pa *p, *q;
	register char *cp;
	int flag;

	flp = flb;
	*flp++ = -1;
	exp = exb;
	for(p=pa; p->type!=NAME; p++)
		;
	for(q=pa; q->type!=IN; q++)
		if(q->type == END) {
			if(p->flag) {
				spread(cat);
				exline(LOC);
			}
			goto l1;
		}
	if(q->flag)
		exline(NUL);
	spread("<%s ", q->ptr);
	if(p->flag == q->flag)
		goto l1;
	spread(cat);
	if(q->flag)
		exline(FOR); else
		exline(LOC);
l1:
	flag = LOC;
	if(p->flag)
		flag = FOR;
	q = p;
l2:
	while(p->type != PIPE) {
		if(p->type == END)
			goto l3;
		if(p->type == NAME)
			spread("%s ", p->ptr);
		p++;
	}
	while(p->type != NAME)
		p++;
	if(p->flag != q->flag) {
		exline(flag);
		goto l1;
	}
	spread("| ");
	goto l2;
l3:
	for(p=pa; p->type!=OUT && p->type!=CAT; p++)
		if(p->type == END) {
			if(flag == FOR) {
				exline(FORP);
				spread(cat);
				flag = LOC;
			}
			exline(flag);
			goto l4;
		}
	if(p->flag != q->flag) {
		exline(flag);
		spread("%s ", cat);
		flag = LOC;
		if(p->flag)
			flag = FOR;
	}
	if(p->type == CAT)
		spread(">");
	spread(">%s", p->ptr);
	if(p->flag) {
		exline(FORP);
		spread(cat);
		flag = LOC;
	}
	exline(flag);
l4:
	return;
}

spread(s, p)
char *s, *p;
{
	register char *cp, *pp;

	cp = exp;
loop:
	if(*s != '%') {
		if(*cp++ = *s++)
			goto loop;
		cp--;
		exp = cp;
		return;
	}
	pp = p;
	s =+ 2;
	while(*cp++ = *pp++)
		;
	cp--;
	goto loop;
}

exline(type)
{
	register f, g;

	switch(type)
	{

	case NUL:
		if(pass == 2)
			flp =+ 2;
		break;

	case LOC:
		if(pass == 1)
			break;
		lpid = fork();
		if(fpid == 0)
			fpid = lpid;
		if(lpid == 0) {
			if(flp[-1] >= 0) {
				close(0);
				dup(flp[-1]);
			}
			if(*flp >= 0) {
				close(1);
				dup(*flp);
			}
			closefp(0);
			exec(exb);
		}
		flp =+ 2;
		break;

	case FOR:
	case FORP:
		if(pass == 2)
			break;
		putss(type);
		f = mpxchan(ssfp);
		alarm(5);
		mpxwait(f);
		alarm(0);
		g = mpxchan(f);
		alarm(5);
		mpxwait(g);
		alarm(0);
		write(f, exb, length(exb)+1);
		*flp++ = f;
		*flp++ = g;
	}
	exp = exb;
	*exp = 0;
}

closefp(f)
{
	register *p;

	for(p = flb+1; *p >= 0;) {
		if(f)
			mpxdis(*p);
		close(*p++);
	}
}

putss(c)
{

	write(ssfp, &c, 1);
}

qitsub()
{
	xxxsub(FORQ);
}
hupsub()
{
	xxxsub(FORH);
}
intsub()
{
	xxxsub(FORI);
}
xxxsub(c)
{

	signal(1, hupsub);
	signal(2, intsub);
	signal(3, qitsub);
	putss(c);
	prs("\n\n");
	reset();
}
