/*
 *  Simulate C/A/T on scope
 */

int	x;
int	y;
int	rail;
int	mag;
int	font;
int	vtf;
int	esc;
int	escf;
int	leadf;
int	code;
int	dflag;

char widtab[] {
	0,
	4,
	3,
	1,
	1,
	1,
	1,
	2,
	2,
	2,
	1,
	1,
	3,
	1,
	3,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	3,
	2,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	3,
	1,
	2,
	2,
	0,
	2,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	3,
	2,
	1,
	3,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	1,
	2,
	4,
	3,
	2,
	1 };

int	size;
char	sizetab[] {
/*	7, 8, 10, 11, 12, 14, 18, 9, 6, 16, 20, 22, 24, 28, 36; */
	3, 3,  4,  4,  5,  6,  7, 4, 2,  6,  8,  9, 10, 14, 16 };
char	single[] {
	1, 1,  1,  1,  1,  1,  1, 1, 1,  0,  0,  0,  0,  0,  0 };

char fontab[] {
	0000,	/* space */
	0145,	/* ! */
	0000,	/* " */
	0153,	/* # */
	0155,	/* $ */
	0053,	/* % */
	0050,	/* & */
	0150,	/* ' */
	0132,	/* ( */
	0133,	/* ) */
	0122,	/* * */
	0143,	/* + */
	0047,	/* , */
	0123,	/* - */
	0044,	/* . */
	0043,	/* / */
	0110,	/* 0 */
	0111,	/* 1 */
	0112,	/* 2 */
	0113,	/* 3 */
	0114,	/* 4 */
	0115,	/* 5 */
	0116,	/* 6 */
	0117,	/* 7 */
	0120,	/* 8 */
	0121,	/* 9 */
	0142,	/* : */
	0023,	/* ; */
	0000,	/* < */
	0140,	/* = */
	0000,	/* > */
	0147,	/* ? */
	0131,	/* @ */
	0103,	/* A */
	0075,	/* B */
	0070,	/* C */
	0074,	/* D */
	0072,	/* E */
	0101,	/* F */
	0065,	/* G */
	0060,	/* H */
	0066,	/* I */
	0105,	/* J */
	0107,	/* K */
	0063,	/* L */
	0062,	/* M */
	0061,	/* N */
	0057,	/* O */
	0067,	/* P */
	0055,	/* Q */
	0064,	/* R */
	0076,	/* S */
	0056,	/* T */
	0106,	/* U */
	0071,	/* V */
	0104,	/* W */
	0102,	/* X */
	0077,	/* Y */
	0073,	/* Z */
	0134,	/* [ */
	0000,	/* \ */
	0135,	/* ] */
	0000,	/* ^ */
	0000,	/* _ */
	0000,	/* ` */
	0025,	/* a */
	0012,	/* b */
	0027,	/* c */
	0011,	/* d */
	0031,	/* e */
	0014,	/* f */
	0045,	/* g */
	0001,	/* h */
	0006,	/* i */
	0015,	/* j */
	0017,	/* k */
	0005,	/* l */
	0004,	/* m */
	0003,	/* n */
	0033,	/* o */
	0021,	/* p */
	0042,	/* q */
	0035,	/* r */
	0010,	/* s */
	0002,	/* t */
	0016,	/* u */
	0037,	/* v */
	0041,	/* w */
	0013,	/* x */
	0051,	/* y */
	0007,	/* z */
	0000,	/* { */
	0151,	/* | */
	0000,	/* } */
	0000,	/* ~ */
	0000};	/* del */


main()
{

	if ((vtf=open("/dev/vt0", 1)) < 0) {
		error("No VT");
		return;
	}
	erase();
loop:
	code = getchar();
	if (code==0)
		exit();
	switch(code>>5) {

	/* escape code */
	case 04:
	case 05:
	case 06:
	case 07:
		esc = ~code & 0177;
		if (escf) {
			x =+ esc;
			if (x>3383)
				error("Off right edge");
		} else {
			x =- esc;
			if (x<=0)
				error("Off left edge");
		}
		goto loop;

	/* lead code */
	case 03:
		esc = ~code & 037;
		if (leadf) {
			y =- esc;
			if (y<0)  {
				erase();
				y = 1300;
			}
		} else {
			y =+ esc;
			if (y>1300)
				error("Off top");
		}
		goto loop;

	/* control, size change */
	case 02:
		if ((code&020) != 0) {	/* size */
			esc = code & 017;
			if (esc==15)
				error("Bad size");
			size = sizetab[esc];
			wvt(3, 1, 4, size);
			if (dflag & single[esc])
				x =+ 55;
			if (!dflag & !single[esc])
				x =- 55;
			dflag = !single[esc];
			goto loop;
		}
		switch(code&017) {		/* control */

		/* upper rail */
		case 002:
			rail = 1;
			goto loop;

		/* lower rail */
		case 001:
			rail = 0;
			goto loop;

		/* upper mag */
		case 003:
			mag = 1;
			goto loop;

		/* lower mag */
		case 004:
			mag = 0;
			goto loop;

		/* upper font */
		case 006:
			font = 1;
			goto loop;

		/* lower font */
		case 005:
			font = 0;
			goto loop;

		/* escape forward */
		case 007:
			escf = 1;
			goto loop;

		/* escape backward */
		case 010:
			escf = 0;
			goto loop;

		/* stop */
		case 011:
			error("done");
			exit ();

		/* lead forward */
		case 012:
			leadf = 1;
			goto loop;

		/* lead backward */
		case 014:
			leadf = 0;
			goto loop;

		/* initialize */
		case 000:
			escf = 1;
			leadf = 1;
			rail = 0;
			mag = 0;
			font = 0;
			x = 0;
			y = 1300;
			goto loop;

		default:
			error("Bad control");
			exit();
		}

	/* flash code */
	case 00:
	case 01:
		code =& 077;
		if (code==0)
			exit();
		flash(code);
		goto loop;
	}
	error("Eh?");
}

erase()
{
	wvt(2, 01, 01);
}

flash(c)
{
	char *cp;
	int sx, sy;

	if (font)
		c =| 0100;
	sx = x-2048;
	sy = y*3 - 2048;
	for (cp = fontab; cp<fontab+0137 & *cp!=c; cp++);
	c = cp-fontab;
	sx = sx - size*widtab[c];
	wvt(9, 9, sx, sx>>8, sy, sy>>8, 1, 3, c+040, 0);
}

wvt(n, args)
{
	int *ap, c;

	ap = &args;
	while (--n>=0) {
		c = *ap++ & 0377;
		write(vtf, &c, 1);
	}
}

error(s)
char *s;
{
	while (*s)
		putchar(*s++);
	putchar('\n');
	exit();
}
