/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Clear.c	1.2 85/08/10
*/

/*
**	Clear various fields from entry tables.
*/

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"node.h"


static States	State;
static Entry **	Table;

static void	CLRstate();
static void	CTroute();



/*
**	Clear out routing information;
*/

void
ClearRoute(table)
	Entry **		table;
{
	register Entry **	epp;
	register Entry **	end;

	for ( epp = table, end = &epp[HASH_SIZE] ; epp < end ; epp++ )
		if ( *epp != (Entry *)0 )
			CTroute(*epp);
}


static void
CTroute(ep)
	register Entry *	ep;
{
	if ( ep->e_great != (Entry *)0 )
		CTroute(ep->e_great);

	if ( ep->e_less != (Entry *)0 )
		CTroute(ep->e_less);

	ep->e_route = (Entry *)0;
}



/*
**	Clear out specific state flags from nodes and links.
*/

void
ClearState(states, table)
	States			states;
	Entry **		table;
{
	register Entry **	epp;
	register Entry **	end;

	State = states;
	Table = table;

	for ( epp = table, end = &epp[HASH_SIZE] ; epp < end ; epp++ )
		if ( *epp != (Entry *)0 )
			CLRstate(*epp);
}


static void
CLRstate(ep)
	register Entry *	ep;
{
	register Link *	lp;

	if ( ep->e_great != (Entry *)0 )
		CLRstate(ep->e_great);

	if ( ep->e_less != (Entry *)0 )
		CLRstate(ep->e_less);

	ep->e_states &= ~State;

	if ( Table != NodeHash )
		return;

	for ( lp = ep->e_node->n_l_first ; lp != (Link *)0 ; lp = lp->l_next )
		lp->l_data->d_states &= ~State;
}
