/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Pprintstats.c	1.2 84/08/30
*/

/*
**	Print out protocol statistics
*/

#define	STDIO

#include	"global.h"

#include	"Pstats.h"

#define	Fprintf	(void)fprintf



void
Pprintstats(fd)
	FILE *	fd;
{
	register int	i;
	register int	first = 1;

#	if	PSTATISTICS == 1
	for ( i = 0 ; i < PS_NSTATS ; i++ )
	{
		if ( Pstats[i].ss_count )
		{
			if ( first )
			{
				first = 0;
				Fprintf(fd, "Protocol statistics:\n");
			}

#			if	PSTATSDESC == 1
			Fprintf(fd, "%9ld %s\n", Pstats[i].ss_count, Pstats[i].ss_descp);
#			else	PSTATSDESC
			Fprintf(fd, "%9ld [%d]\n", Pstats[i].ss_count, i);
#			endif	PSTATSDESC
		}
	}
#	else	PSTATISTICS
#	ifdef	lint
	i = (int)fd; first = i; i = first;
#	endif	lint
#	endif	PSTATISTICS
}
