/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)GetUser.c	1.4 85/08/07
*/

/*
**	Given a uid, find user name and
**	fill a structure with details from the 'passwd' file.
*/

#define	PASSWD_USED

#include	"global.h"

#include	"Passwd.h"



bool
GetUser(pp, uid)
	register Passwd *pp;
	int		uid;
{
#	if	AUSAS == 1
	char		namebuf[SSIZ];
	struct pwent	pe;

	pp->P_uid = uid;
	pe.pw_uid = uid;

	errno = 0;	/* Clear old error */

	while ( getpwlog(&pe, namebuf, sizeof namebuf) == PWERROR )
	{
		if ( errno != 0 )
		{
			Syserror("Can't access passwd file");
			errno = 0;
		}
		else
		{
			pwclose();
			pp->P_error = "no such user";
			return false;
		}
	}

	pwclose();

	pp->P_name = newstr(pe.pw_strings[LNAME]);

	pp->P_flags = ((pe.pw_xflags&USENET)?P_CANSEND:0)
			| ((pe.pw_xflags&USECON)?P_CANCON:0)
			| P_EXPLICIT | P_MULTICAST;

	pp->P_gid = pe.pw_gid;

	if
	(
		uid == 0
		||
		uid == ACSNETUID
#		ifdef	NETPRIV
		||
		(pe.pw_xflags & NETPRIV)
#		endif	NETPRIV
	)
		pp->P_flags |= P_SU|P_BROADCAST|P_OTHERHANDLERS|P_CANCON|P_CANSEND;

#	else	AUSAS == 1

	register struct passwd *pw;
	extern struct passwd *	getpwuid();

	pp->P_uid = uid;

	errno = 0;

	while ( (pw = getpwuid(uid)) == (struct passwd *)0 )
	{
#		if	SYSTEM != 5
		if ( errno != 0 )
		{
			Syserror("Can't access passwd file");
			errno = 0;
		}
		else
#		endif	SYSTEM != 5
		{
			endpwent();
			pp->P_error = "no such user";
			return false;
		}
	}

	endpwent();

	pp->P_name = newstr(pw->pw_name);
	pp->P_gid = pw->pw_gid;

#	if	MUSH == 1

	pp->P_flags = 0;

#	if	BSD4 > 1
	if ( sprivs(P_HAVEPRIVS) ) {
#	endif
		if ( testupriv(pw->pw_uid, USE_UUCP) )
			pp->P_flags |= P_CANSEND;
		if ( testupriv(pw->pw_uid, USE_REMOTE) )
			pp->P_flags |= P_CANCON;
		pp->P_flags |= P_MULTICAST;
#	if BSD4 > 1
		/* caution: 4.1z does not have NET_SU - delete these 3 lines */
		if ( testupriv(pw->pw_uid, NET_SU) )
			pp->P_flags |=
			    P_BROADCAST|P_OTHERHANDLERS|P_SU;
	} else
		pp->P_flags = P_CANSEND|P_CANCON|P_EXPLICIT|P_MULTICAST;
#	endif

#	else	MUSH == 1

	pp->P_flags = P_CANSEND|P_CANCON|P_EXPLICIT|P_MULTICAST;

#	endif	MUSH == 1

	if ( uid == 0 || uid == ACSNETUID )
		pp->P_flags |= P_BROADCAST|P_OTHERHANDLERS|P_SU;

#	endif	AUSAS == 1

	return true;
}
