/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ExPipeO.c	1.8 85/07/20
*/

/*
**	pipe(), fork(), execve() sequence with stdout selected.
*/

#define	FILE_CONTROL
#define	RECOVER
#define	STDIO

#include	"global.h"

#include	"debug.h"

#include	<signal.h>

#define	TOCHILD		1
#define	CHILD0		0


static int	EPO_fd;
static VarArgs *EPO_cmd;
static int	EPO_pid;
static int	(*EPO_sig)();

extern void	MakeErrFile();


FILE *
ExPipeO(args, ofd)
	register VarArgs *args;
	int		ofd;
{
	register int	i;
	int		p[2];

	DODEBUG(if(NARGS(args)>MAXVARARGS)Fatal("MAXVARARGS"));

	ARG(args, NARGS(args)) = NULLSTR;

	while ( pipe(p) == SYSERROR )
		Syserror("Can't pipe");

	MakeErrFile(&EPO_fd);

	for ( ;; )
	{
		switch ( EPO_pid = fork() )
		{
		case SYSERROR:
			Syserror("Can't fork");
			continue;

		case 0:
			Recover(ert_finish);

			DODEBUG(EchoArgs(NARGS(args), &ARG(args, 0)));

			if ( p[CHILD0] != 0 )
			{
				if ( ofd == 0 )
					ofd = dup(ofd);
				(void)close(0);
				if ( dup(p[CHILD0]) != 0 )
					exit(100);
			}

			if ( ofd != 1 )
			{
				(void)close(1);
				if ( dup(ofd) != 1 )
					exit(101);
			}

			if ( EPO_fd != 2 )
			{
				(void)close(2);
				if ( dup(EPO_fd) != 2 )
					exit(102);
			}

			for ( i = 3 ; close(i) != SYSERROR ; i++ );

			for ( ;; )
			{
				(void)execve(ARG(args, 0), &ARG(args, 0), StripEnv());
				Syserror("Cannot execve \"%s\"", ARG(args, 0));
			}
		}

		(void)close(p[CHILD0]);

		EPO_sig = signal(SIGPIPE, SIG_IGN);
		EPO_cmd = args;

		return fdopen(p[TOCHILD], "w");
	}
}



char *
ExOPipeClose(fd)
	FILE *		fd;
{
	register int	i;
	int		status;
#	if	DEBUG >= 1
	char *		errfile;
#	endif	DEBUG >= 1

	(void)fclose(fd);
	(void)signal(SIGPIPE, EPO_sig);

	while ( (i = wait(&status)) != EPO_pid )
		if ( i == SYSERROR )
		{
			Syserror("Lost child");
			return NULLSTR;
		}

	if ( ErrorTty((int *)0) )
		return NULLSTR;

	if ( status )
		return GetErrFile(EPO_cmd, status, EPO_fd);

#	if	DEBUG >= 1
	if
	(
		Traceflag > 0
		&&
		(errfile = GetErrFile(EPO_cmd, 0, EPO_fd)) != NULLSTR
	)
	{
		Trace(1, errfile);
		free(errfile);
	}
	else
#	endif	DEBUG >= 1

	(void)close(EPO_fd);

	return NULLSTR;
}
