/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)Passwd.h	1.1 84/06/12
*/

/*
**	Network validation flags from "passwd" file.
*/

enum
{
	Pf_broadcast, Pf_multicast, Pf_explicit,	/* Addressing allowed */
	Pf_otherhandlers,				/* Unusual handler requests allowed */
	Pf_cancon, Pf_cansend,				/* Protocols allowed */
	Pf_su						/* Network super-user */
};

#define	P_BROADCAST	(1<<(int)Pf_broadcast)
#define	P_MULTICAST	(1<<(int)Pf_multicast)
#define	P_EXPLICIT	(1<<(int)Pf_explicit)
#define	P_OTHERHANDLERS	(1<<(int)Pf_otherhandlers)
#define	P_CANCON	(1<<(int)Pf_cancon)
#define	P_CANSEND	(1<<(int)Pf_cansend)
#define	P_SU		(1<<(int)Pf_su)

typedef int	Pflg_t;

/*
**	Structure returned by "passwd" file accessing routines.
*/

typedef struct
{
	char *	P_name;	/* User name */
	Pflg_t	P_flags;/* Validation bits */
	int	P_uid;	/* System uid */
	int	P_gid;	/* System gid */
}
			Passwd;

#define	P_error		P_name
#define	P_user		P_name

/*
**	"passwd" file accessing routines
*/

extern bool		GetUid();
extern bool		GetUser();
