/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)InRoute.c	1.2 85/02/20
*/

/*
**	Return number of occurences of "nodename" in "HdrRoute".
*/

#include	"global.h"
#include	"debug.h"
#include	"header.h"



int
InRoute(nodename)
	char *		nodename;
{
	register char *	p;
	register char *	e;
	register int	count;

	Trace3(1, "InRoute(%s), HdrRoute=\"%s\"", nodename, HdrRoute);

	if ( (p = HdrRoute) == NULLSTR )
		return 0;

	for
	(
		count = 0 ;
		*p++ == HC_ROUTE ;
	)
	{
		if ( (e = strchr(p, HC_TIME)) == NULLSTR )
		{
			Error("missing time field in message header route: \"%s\"", HdrRoute);
			break;
		}
		else
			*e = '\0';

		if ( strccmp(nodename, p) == STREQUAL )
			count++;

		*e = HC_TIME;

		if ( (p = strchr(p, HC_ROUTE)) == NULLSTR )
			break;
	}

	Trace2(1, "InRoute found %d", count);

	return count;
}
