/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)GetFthFiles.c	1.2 84/06/29
*/

/*
**	Extract files info to FthFiles from FthFdescs list.
**
**	Returns "fth_ok" if successful, otherwise a failure reason.
*/

#include	"global.h"
#include	"ftheader.h"

extern char	FthFdRestricted[];
extern void	UnQuoteChars();



FthReason
GetFthFiles()
{
	register char *		cp = FthFdescs;
	register int		i;
	register FthFD_p	flp;
	register FthFD_p *	endflp = &FthFiles;
	register char *		ep;
	char *			p[4];

	NFthFiles = 0;

	do
	{
		if ( (ep = strchr(cp, FTH_FSEP)) != NULLSTR )
			*ep++ = '\0';
		
		p[0] = cp;

		for ( i = 1 ; i < 4 ; i++ )
			if ( (cp = strchr(cp, FTH_FDSEP)) != NULLSTR )
			{
				*cp++ = '\0';
				p[i] = cp;
			}
			else
				return fth_files;
		
		NFthFiles++;

		flp = Talloc(FthFDesc);
		*endflp = flp;
		endflp = &flp->f_next;

		flp->f_next = (FthFD_p)0;
		flp->f_name = newstr(p[0]);
		UnQuoteChars(flp->f_name, FthFdRestricted);
		flp->f_length = atol(p[1]);
		flp->f_time = atol(p[2]);
		flp->f_mode = atoo(p[3]);
	}
	while
		( (cp = ep) != NULLSTR );

	return fth_ok;
}
