/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID %W% %E%
*/

/*
**	Debugging routines
*/

#define	STDIO

#include	"global.h"

#include	"Pconfig.h"
#include	"Packet.h"
#include	"Debug.h"


Time_t			Debug_ticks;
int			Ptraceflag;
FILE *			PtraceFd	= stderr;

typedef struct 
{
	char	lp_pkt[PKTLOGLEN];
	char	lp_ident;
}
			LogPkt;

typedef struct
{
	LogPkt	lg_pkt;
	Timo_t	lg_ticks;
}
			Pktlog;

typedef Pktlog *	Log_p;

#define	lg_ident	lg_pkt.lp_ident

static Pktlog		log[PKTHIST];
static Log_p		inlog		= log;
static Log_p		outlog		= log;
static short		logflag;

#define			Fprintf		(void)fprintf

#define	TYPE		((pktp->pkt_hdr[PKTHDR]>>PKTTYP_S)&PKTTYP_M)
#define	CHANNEL		((pktp->pkt_hdr[PKTHDR]>>PKTCHN_S)&PKTCHN_M)
#define	SEQUENCE	((pktp->pkt_hdr[PKTHDR]>>PKTSEQ_S)&PKTSEQ_M)


void
Ptracepkt(pktp, ident, t)
	Pkt_p		pktp;
	char		ident;
	Timo_t		t;
{
	register char * cp;
	register int	size;
	register char *	type;

	switch ( TYPE )
	{
	case PKTDATATYP:	type = "   ";	break;
	case PKTACKTYP:		type = "ack";	break;
	case PKTNAKTYP:		type = "nak";	break;
	case PKTCNTLTYP:	type = "ctl";	break;
	}

	size = BYTE(pktp->pkt_hdr[PKTSIZE0]);
	size |= BYTE(pktp->pkt_hdr[PKTSIZE1]) << 8;

	Fprintf
	(
		 PtraceFd
		,"%4d %s N:%d,Q:%d,T:%s,Z:%-3d ["
		,t
		,ident==PLOGIN?"RECV":ident==PLOGOUT?"xque":"xmit"
		,CHANNEL
		,SEQUENCE
		,type
		,size
	);

	size += PKTHDRZ;

	if ( size > PKTLOGLEN )
		size = PKTLOGLEN;

	for ( cp = (char *)pktp ; --size >= 0 ; )
		Fprintf(PtraceFd, " %03o", BYTE(*cp++));

	Fprintf(PtraceFd, " ]\n");

	(void)fflush(PtraceFd);
}




void
Plogpkt(pktp, ident)
	Pkt_p		pktp;
	char		ident;
{
	register Time_t	ticksnow;

	ticksnow = ticks();
	inlog->lg_ticks = ticksnow - Debug_ticks;
	Debug_ticks = ticksnow;

	if ( Ptraceflag >= 2 )
	{
		Ptracepkt(pktp, ident, inlog->lg_ticks);
		return;
	}

	inlog->lg_pkt = *(LogPkt *)pktp;

	inlog->lg_ident = ident;

	if ( ++inlog >= &log[PKTHIST] )
		inlog = log;
	if ( logflag )
		outlog = inlog;
	else
	if ( inlog == outlog )
		logflag++;
}



void
Pdumphist(s)
	char *	s;
{
	register int	first = 1;

	while ( outlog != inlog || logflag )
	{
		if ( first )
		{
			first = 0;
			Fprintf(PtraceFd, "%s - last %d packets\n", s, PKTHIST);
		}
		logflag = 0;
		Ptracepkt((Pkt_p)outlog, outlog->lg_ident, outlog->lg_ticks);
		if ( ++outlog >= &log[PKTHIST] )
			outlog = log;
	}

	if ( first && Ptraceflag >= 2 )
		Fprintf(PtraceFd, "%s\n", s);

	(void)fflush(PtraceFd);
}



void
Ptracehdrs(badhdrs)
	int	badhdrs;
{
	Fprintf(PtraceFd, "%d bad header bytes\n", badhdrs);
}
