/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ReadRoute.c	1.6 87/05/21
*/

/*
**	Read route table into memory.
*/

#define	FILE_CONTROL
#define	STAT_CALL
#define	LOCKING

#include	"global.h"
#include	"debug.h"

#undef	Extern
#define	Extern
#include	"state.h"
#include	"route.h"

static Time_t	RouteRead;	/* Time routefile last read */




bool
ReadRoute()
{
	register int	fd;
	struct stat	statb;
	static char *	format = "Can't %s \"%s\"";

	if ( RouteFile == NULLSTR )
		RouteFile = ROUTEFILE;

	if ( (fd = open(RouteFile, O_READ)) == SYSERROR )
	{
		Syserror(format, "open", RouteFile);
		return false;
	}

#	if	AUTO_LOCKING != 1
	if ( Lock(RouteFile, fd, for_reading) == SYSERROR )
	{
		Syserror(format, "lock", RouteFile);
		(void)close(fd);
		return false;
	}
#	endif	AUTO_LOCKING

	if ( fstat(fd, &statb) == SYSERROR )
	{
		Syserror(format, "stat", RouteFile);
		UnLock(fd);
		(void)close(fd);
		return false;
	}

	if ( (int)statb.st_size != statb.st_size )
	{
		Fatal("size of \"%s\" too big", RouteFile);
		UnLock(fd);
		(void)close(fd);
		return false;
	}

	if ( statb.st_size == 0 )
	{
		UnLock(fd);
		(void)close(fd);
		return false;
	}

	RouteRead = statb.st_mtime;	/* Remember modify time */

	if ( RouteBase != NULLSTR )
		free(RouteBase);

	RouteBase = Malloc((int)statb.st_size);

	if ( read(fd, RouteBase, (int)statb.st_size) != statb.st_size )
	{
		Syserror(format, "read", RouteFile);
		UnLock(fd);
		(void)close(fd);
		return false;
	}

	UnLock(fd);
	(void)close(fd);

	NodeCount = NODE_COUNT;
	LinkCount = LINK_COUNT;
	AliasCount = ALIAS_COUNT;
	DomainCount = DOMAIN_COUNT;
	LevelCount = LEVEL_COUNT;
	HomeFlags = HOME_FLAGS;

	LinkTable = LINK_TABLE_ADDR;
	NodeTable = NODE_TABLE_ADDR;
	AliasTable = ALIAS_TABLE_ADDR;
	DomainTable = DOMAIN_TABLE_ADDR;
	LevelTable = LEVEL_TABLE_ADDR;
	ForwTable = FORW_TABLE_ADDR;
	MemberTable = MEMBER_TABLE_ADDR;
	DomForwTable = DOMFORW_TABLE_ADDR;
	Strings = STRINGS_ADDR;

	return true;
}



void
SetRoute(newfile)
	char *	newfile;
{
	RouteFile = newfile;
}



void
CheckRoute()
{
	struct stat	statb;

	if ( RouteBase == NULLSTR )
		return;

	if ( stat(RouteFile, &statb) == SYSERROR || statb.st_mtime > RouteRead )
		ReadRoute();
}
