/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)AdjustSource.c	1.17 86/06/13
*/

/*
**	If `to' is not a member of `from's from_primary domain,
**	and last domain in `source' is not already
**	the highest domain in local hierarchy,
**	remove all local domains from `source',
**	and concatenate `from's from_primary domain with the source address.
**
**	If `from's from_primary domain is in the local hierarchy,
**	also concatenate any higher domains in hierarchy
**	below `to's from_primary domain.
*/

#include	"global.h"
#include	"address.h"
#include	"debug.h"
#include	"header.h"
#include	"state.h"

#include	"route.h"



char *
AdjustSource(source, ap, from, to)
	char *			source;
	Address *		ap;
	int			from;
	int			to;
{
	register int		i;
	register char *		cp;
	register char **	cpp;
	register int		to_prim;
	register int		from_prim;
	register int		j;
	char *			newsource;
	NodeLink		nl;

	Trace4
	(
		1,
		"AdjustSource \"%s\" for message from \"%s\" to \"%s\"",
		source,
		RT_NODE(from)->ne_name,
		RT_NODE(to)->ne_name
	);

	if ( (from_prim = RT_NODE(from)->ne_primary) == LINK_N_A )
		return NULLSTR;

	if ( (i = ap->ad_domains) > 0 )
		for ( cpp = &ap->ad_strings[i] ; i > 0 ; i-- )
		{
			if ( !FindDomain(*cpp--, &nl) )
				break;

			if ( RT_DOMAIN(nl.nl_domind)->de_hierarchy == (LevelCount-1) )
				return NULLSTR;

			if ( nl.nl_domind == from_prim )
			{
				i--;
				break;
			}

			if ( nl.nl_link != (NodeCount-1) )
				break;	/* Foreign domain */
		}

	if
	(
		i == 0
		&&
		FindNode(ap->ad_node, pt_msg, &nl)
		&&
		nl.nl_domind != LINK_N_A
	)
		from_prim = nl.nl_domind;

	Trace3
	(
		2,
		"AdjustSource: from primary \"%s\", to primary \"%s\"",
		RT_DOMAIN(from_prim)->de_name,
		(to_prim = RT_NODE(to)->ne_primary) == LINK_N_A?"N/A":RT_DOMAIN(to_prim)->de_name
	);

	if
	(
		(to_prim = RT_NODE(to)->ne_primary) != LINK_N_A
		&&
		(
			to_prim == from_prim
			||
			((j = to*DomainCount + from_prim), (MemberTable[j/8] & (1<<(j%8))))
		)
	)
		return NULLSTR;

	newsource = cp = Malloc((NODE_NAME_SIZE+1)*(LevelCount+1) + strlen(source) + 1);

	for ( cpp = ap->ad_strings ; i-- >= 0 ; )
	{
		cp = strcpyend(cp, *cpp++);
		*cp++ = DOMAIN_SEP;
	}

	cp = strcpyend(cp, RT_DOMAIN(from_prim)->de_name);

	if ( (i = RT_DOMAIN(from_prim)->de_hierarchy) != LINK_N_A )
		for ( to *= DomainCount ; ++i < LevelCount ; )
		{
			from_prim = *RT_LEVEL(i);

			if ( from_prim == to_prim )
				break;

			*cp++ = DOMAIN_SEP;
			cp = strcpyend(cp, RT_DOMAIN(from_prim)->de_name);
		}

	Trace2(1, "AdjustSource returns \"%s\"", newsource);

	return newsource;
}
