/*
**	Written by Doug Kingston, Centrum voor Wiskunde en Informatica, NL
*/

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>

#include <stdio.h>
#include <netdb.h>

struct	sockaddr_in sin;

main(argc, argv)
	int argc;
	char *argv[];
{
	int s;
	register len;
	register char *p;
	char *host;
	register struct hostent *hp;
	struct servent *sp;

	if (argc < 4) {
		fprintf(stderr, "tcpconnect host daemonprog daemonargs\n");
		exit(4);
	}
	argv++, argc--;
	host = *argv;
	argv++, argc--;

	hp = gethostbyname(host);
	if (hp == NULL) {
		fprintf(stderr, "gettable: %s: host unknown\n", host);
		exit(2);
	}
/****	host = hp->h_name; ****/
	sin.sin_family = hp->h_addrtype;
	s = socket(hp->h_addrtype, SOCK_STREAM, 0, 0);
	if (s < 0) {
		perror("gettable: socket");
		exit(4);
	}
	sp = getservbyname("acsnet", "tcp");
	if (sp == NULL) {
		fprintf(stderr, "gettable: acsnet/tcp: unknown service\n");
		exit(3);
	}
	bcopy(hp->h_addr, &sin.sin_addr, hp->h_length);
	sin.sin_port = sp->s_port;
	if (connect(s, &sin, sizeof (sin), 0) < 0) {
		perror("gettable: connect");
		exit(6);
	}
	fprintf(stderr, "Connection to %s complete.\n", host);

	dup2 (s, 0);
	dup2 (s, 1);
	close (s);
	execv (argv[0], argv);
	perror(argv[0]);
}
