/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	@(#)DecodeName.c	1.2 85/06/26
*/

/*
**	Extract parts from last element of a path name produced by EncodeName.
*/

#include	"global.h"
#include	"messagename.h"
#include	"debug.h"



ulong
DecodeName(name, parts)
	char *		name;
	register Parts *parts;
{
	register char *	p;

	/*
	**	Find last element of path name
	*/

	if ( (p = strrchr(name, '/')) == NULLSTR )
		p = name;
	else
		p++;

	DODEBUG
	(
		if ( strlen(p) < PNAMELEN )
			Fatal("DecodeName last component too short: \"%s\"", name);
	);

	parts->p_flag1 = (char)DecodNum(&p[PFLAG1], PFLAG1LEN);
	parts->p_flag2 = (char)DecodNum(&p[PFLAG2], PFLAG2LEN);
	parts->p_time = DecodNum(&p[PTIME], PTIMLEN);

	return DecodNum(&p[PNUM], PNUMLEN);
}
