/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID 88/07/24 @(#)MakeEnv.c	1.3
*/


/*
**	Concatenate strings into header environment.
**	Variable number of argument pairs terminated by a NULLSTR.
*/

#include	"global.h"
#include	"header.h"


char		EnvRestricted[]	= { ENV_RS, ENV_SEP, '\0' };

extern void	QuoteChars();



#if VARARGS
char *
MakeEnv(va_alist)
	va_dcl
{
	register char *	cp;
	register char *	np;
	register char *	vp;
	register int	size;
	char *		string;
	va_list		va;

	va_start(va);
	for (size = 0; (np = va_arg(va, char *)) != NULLSTR; )
	{
		size += strlen(np) + 1;

		if ( (vp = va_arg(va, char *)) != NULLSTR )
			size += strlen(vp) + 1;
	}
	va_end(va);
	
	string = cp = Malloc(size+1);

	va_start(va);
	while ((np = va_arg(va, char *)) != NULLSTR)
	{
		register char *	ocp;

		*cp++ = ENV_RS;
		cp = strcpyend(cp, np);

		if ( (vp = va_arg(va, char *)) != NULLSTR )
		{
			*cp++ = ENV_SEP;
			ocp = cp;
			cp = strcpyend(cp, vp);
			QuoteChars(ocp, EnvRestricted);
		}
	}
	va_end(va);

	return string;
}
#else
/*VARARGS2*/
char *
MakeEnv(name, value, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10)
	char *		name;
	char *		value;
	char *		a1;
	char *		a2;
	char *		a3;
	char *		a4;
	char *		a5;
	char *		a6;
	char *		a7;
	char *		a8;
	char *		a9;
	char *		a10;
{
	char **		cpp;
	register char *	cp;
	register char *	np;
	register char *	vp;
	register int	size;
	char *		string;

	for
	(
		size = 0, cpp = &name ;
		(np = ARGS_OFF_STACK(cpp)) != NULLSTR ;
	)
	{
		size += strlen(np) + 1;

		if ( (vp = ARGS_OFF_STACK(cpp)) != NULLSTR )
			size += strlen(vp) + 1;
	}
	
	string = cp = Malloc(size+1);

	for
	(
		cpp = &name ;
		(np = ARGS_OFF_STACK(cpp)) != NULLSTR ;
	)
	{
		register char *	ocp;

		*cp++ = ENV_RS;
		cp = strcpyend(cp, np);

		if ( (vp = ARGS_OFF_STACK(cpp)) != NULLSTR )
		{
			*cp++ = ENV_SEP;
			ocp = cp;
			cp = strcpyend(cp, vp);
			QuoteChars(ocp, EnvRestricted);
		}
	}

	return string;
}
#endif
