/* Ver 1.00 21-Apr-88 WB Initial Version
 * Ver 1.01 24-May-88 WB If sendfile dies, run OLDCOLONMAILER
 *
 * This program is a quick-and-dirty to replace SCO's "mail.cln".
 * It simply maps whatever it is given into being an invocation of
 * the SUNIII "sendfile" program
 *
 * This program gets installed in /usr/lib/mail as "mail.cln" and
 * must be setuid root.
 *
 * This program was written by Bill Baker at Blue Sky Industries
 * (billb@bsi386.bluesky). Permission is granted for Licensed Users of
 * SCO Xenix V to copy this program as is needed for their own purposes.
 * No Warranty or Support of any kind is offered. You use this program
 * at your own risk.
 */

/* The arguments we receive are as follows:
 *	argv[0] = "my name", as is expected
 *	argv[1] = "-h", which we ignore
 *	argv[2] = "0", which we ignore
 *	argv[3] = name of addressee
 *	argv[4] = name of sender
 *	argv[5] = name of target machine
 *
 *
 * These get mapped into the following invocation of sendfile:
 *	argv[0] = sendfile's name, as is required by it
 *	argv[1] = "-amailer", so that the mail handler is invoked
 *	argv[2] = "-nMail"
 *	argv[3] = "-ssender", so that the sender appears correctly
 *	argv[4] = "user@machine", so that it gets there!
 *	argv[5] = "-", so that std input gets sent to through the net
 *
 * Note that use of the "-a", "-n" & "-s" options to sendfile all can only
 * be done by root. Hence this program must be setuid root.
 */

#include <errno.h>

/* This define is where you keep your sendfile. Ours is in /usr/bin."*/
#define SENDFILE	"/usr/bin/sendfile"
/* This define is waht you have chosen to call the old mail.cln program that
 * you have lying around. If ACSnet can't cope with the mail address, maybe it
 * can
 */
#define OLDCOLONMAILER	"/usr/lib/mail/OLDmail.cln"

main(argc, argv)
int argc;
char *argv[];
{
	char *newargv[7];
	char *sender;
	char *addressee;
	extern char *malloc();
	int childpid;
	int childstat;	/* what did my child think of it all? */

	newargv[0]=SENDFILE;

	newargv[1]="-amailer";

	newargv[2]="-nmail";

	sender=malloc(strlen(argv[4])+3);
	sprintf(sender, "-s%s", argv[4]);
	newargv[3]=sender;

	addressee=malloc(strlen(argv[3])+strlen(argv[5])+2);
	sprintf(addressee, "%s@%s", argv[3], argv[5]);
	newargv[4]=addressee;

	newargv[5]="-";

	newargv[6]=(char *)0;

	if((childpid=fork())<0)
	{
		perror(argv[0]);
		exit(EAGAIN);
	}
	else if(childpid==0)
	{
		/* we're the child process, so exec SENDFILE */
		execv(SENDFILE, newargv);
	}
	else
	{
		/* wait for our child process to finish */
		while (wait (&childstat) == -1)
			;

		if(childstat!=0)	/* ACSnet didn't like it! */
			execv(OLDCOLONMAILER, argv);
	}
	exit(0);
}
