
; EEPROM Validation Bytes
  DB      055H, 0AAH              ; EEPROM Validation Bytes: CS4232

  DB      000H                    ; EEPROM data length upper byte
  DB      0ECH                    ; lower byte, Listed Size = 240

; Hardware Mapping Data
  DB      008H                    ; 00=4/08=8 peripheral port size, XCTL0/XA2
  DB      048H                    ; RESERVED
  DB      075H                    ; IRQ selection A & B - B= 7,  A=5
  DB      0B9H                    ; IRQ selection C & D - D=11,  C=9
  DB      0FCH                    ; IRQ selection E & F - F=15,  E=12
  DB      010H                    ; DMA selection A & B - B= 1,  A=0
  DB      003H                    ; DMA selection C     -        C=3

; PnP Resource Header - Starts with Crystal PnP ID for CS4232 IC
  DB      00EH, 063H, 076H, 032H, 0FFH,0FFH,0FFH,0FFH,071H  ; CSC7632 FFFFFFFF
  DB      00AH, 010H, 001H        ; PnP version 1.0, Vender version 0.1
  DB      082H, 00CH, 000H, 'Tropez Plus', 000H ; ANSI ID

; LOGICAL DEVICE 0 (Windows Sound System & OPL3 & SBPro)
  DB      015H, 00EH, 063H, 000H, 000H, 000H ; EISA ID: CSC0000

  DB      082H, 004H, 000H, 'WSS', 000H ; ANSI ID
  DB      031H, 000H              ; DF Best Choice
  DB      02AH, 002H, 028H        ; DMA: 1  - WSS & SBPro
  DB      02AH, 009H, 028H        ; DMA: 0,3  - WSS & SBPro capture
  DB      022H, 020H, 000H        ; IRQ: 5  Interrupt Select 0
  DB      047H, 000H, 034H, 005H, 034H, 005H, 004H, 004H ; 10b WSSbase: 534
  DB      04BH, 088H, 003H, 004H  ; 10b SYNbase: 388
  DB      04BH, 020H, 002H, 010H  ; 10b SBbase: 220

  DB      031H, 001H              ; DF Acceptable Choice 1
  DB      02AH, 00BH, 028H        ; DMA: 0,1,3  - WSS & SBPro
  DB      02AH, 00BH, 028H        ; DMA: 0,1,3  - WSS & SBPro capture
  DB      022H, 0A0H, 00AH        ; IRQ: 5,7,9,11  Interrupt Select 0
  DB      047H, 000H, 000H, 001H, 0FCH, 00FH, 004H, 004H ; 10b WSSbase: 100-FFC
  DB      047H, 000H, 088H, 003H, 0F8H, 003H, 008H, 004H ; 10b SYNbase: 388-3F8
  DB      047H, 000H, 020H, 002H, 040H, 002H, 020H, 010H ; 10b SBbase: 220-240

  DB      038H                    ; End of DF for Logical Device 0


; LOGICAL DEVICE 1 (Game Port)
  DB      015H, 041H, 0D0H, 0B0H, 02FH, 000H ; EISA ID: PNPB02F

  DB      082H, 005H, 000H, 'GAME', 000H ; ANSI ID
  DB      031H,000H               ; DF Best Choice
  DB      04BH,000H,002H,008H    ; 8b GAMEbase: 200
  
  DB      031H,001H              ; DF Acceptable Choice 1
  DB      04BH,001H,002H,001H     ; 1b GAMEbase: 201


  DB      038H                    ; End of DF for Logical Device 1


; LOGICAL DEVICE 2 (Control)
;  DB      015H, 00EH, 063H, 000H, 002H, 000H ; EISA ID: CSC0002
  DB      015H, 00EH, 063H, 000H, 010H, 000H ; EISA ID: CSC0010


  DB      082H, 005H, 000H, 'CTRL', 000H ; ANSI ID
  DB      047H, 000H, 000H, 001H, 0F8H, 00FH, 008H, 008H ; 10b CTRLbase: 100-FF8

; LOGICAL DEVICE 3 (MPU-401)
  DB      015H, 041H, 0D0H, 0B0H, 006H, 000H ; EISA ID: PNPB006

  DB      082H, 004H, 000H, 'MPU', 000H ; ANSI ID
  
  DB      031H, 000H              ; DF Best Choice 
  DB      047H, 000H, 050H, 003H, 0F8H, 003H, 008H, 002H ; 10b MPUbase: 350-3F8 
  
  DB      031H, 001H              ; DF Acceptable Choice 1
  DB      022H, 0A0H, 098H        ; IRQ: 5,7,11,12,15  Interrupt Select 0
  DB      047H, 000H, 050H, 003H, 0F8H, 003H, 008H, 002H ; 10b MPUbase: 350-3F8

  DB      038H                    ; End of DF for Logical Device 3


; LOGICAL DEVICE 4 (Synth)
  DB      015H, 00EH, 063H, 000H, 004H, 000H ; EISA ID: CSC0004

  DB      082H, 006H, 000H, 'Synth', 000H ; ANSI ID
  DB      031H, 000H              ; DF Best Choice
  DB      022H, 000H, 002H        ; IRQ: 9  Interrupt Select 0
  DB      04BH, 030H, 003H, 010H  ; 10b SYNTbase: 330

  DB      031H, 001H              ; DF Acceptable Choice 1
  DB      022H, 0A0H, 09AH        ; IRQ: 5,7,9,11,12,15  Interrupt Select 0
  DB      047H, 000H, 050H, 002H, 0F0H, 003H, 010H, 010H ; 10b SYNTbase: 250-3F0

  DB      038H                    ; End of DF for Logical Device 4


  DB      079H, 0BAH              ; End of Resource Data, Checksum
