// Filename: twittercharactercounter.js


    

// Prints Character and Word length on textarea input
function callFunction(){
    
    let characters = getCharLength();
    
    //document.getElementById("typed").innerHTML =  characters;
    //document.getElementById("div5").innerHTML = getRemaining();
    
    document.getElementById("description").innerHTML =  characters;
    document.getElementById("bio").innerHTML =  characters;
    document.getElementById("comment").innerHTML =  characters;
    document.getElementById("title").innerHTML =  characters;
    //document.getElementById("hashtag").innerHTML =  getHashtagCount();
    document.getElementById("truncation").innerHTML =  characters;



    
    if (characters <= 10000){
    
        document.getElementById("comment").style.color = "black";
    }
    else if (characters > 10000){
        document.getElementById("comment").style.color = "red";
    }
    
    if (characters <= 1000){
    
        document.getElementById("bio").style.color = "black";
    }
    else if (characters > 1000){
        document.getElementById("bio").style.color = "red";
    }
    if (characters <= 5000){
    
        document.getElementById("description").style.color = "black";
    }
    else if (characters > 5000){
        document.getElementById("description").style.color = "red";
    }
    

    if (characters <= 70){
        document.getElementById("truncation").style.color = "black";
    }
    else if (characters > 70){
        document.getElementById("truncation").style.color = "red";
    }
    
    if (characters <= 100){
        document.getElementById("title").style.color = "black";
    }
    else if (characters > 100){
        document.getElementById("title").style.color = "red";
    }
    
    
    
    
    
    


    
    
}



// Get user input from textarea
function getUserInput(){
    
    // Assign user input to variable
    var userInput = document.getElementById("userWord").value;
    console.log("test" + userInput)
    return userInput;
}

// Get length of characters in textarea
function getCharLength() {
    if (getUserInput().length <= 2200){
        //document.getElementById("typed").style.color = "black";
        //document.getElementById("div5").style.color = "black";
        return getUserInput().length;
    }
    else {
       // document.getElementById("typed").style.color = "red";
       // document.getElementById("div5").style.color = "red";
        return getUserInput().length;
    }
    
    
    
    
}

// Get remaining characters (number of characters until 280 is reached)
function getRemaining(){
    return 2200 - getCharLength();
}





// Copy text in textarea with button click
function copy() {
    

      if (getUserInput().length > 0){
    
          var copyText = document.getElementById("userWord");
          copyText.select();
          copyText.setSelectionRange(0, 99999)
          document.execCommand("copy");
          
          var x = document.getElementById("snackbar");
          x.className = "show";
          setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
      }
      else{
          var x = document.getElementById("snackbarFail");
          x.className = "show";
          setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
      }
      
}
    
// Clear text in textarea with button click
function clearContent() {
    document.getElementById("userWord").value='';
    callFunction();
}







// Grab elements
const selectElement = (selector) => {
    const element = document.querySelector(selector);
    if(element) return element;
    throw new Error(`Something went wrong! Make sure that ${selector} exists/is typed correctly.`);  
};

//Nav styles on scroll
const scrollHeader = () =>{
    const navbarElement = selectElement('#header');
    if(this.scrollY >= 15) {
        navbarElement.classList.add('activated');
    } else {
        navbarElement.classList.remove('activated');
    }
}

window.addEventListener('scroll', scrollHeader);

// Open menu & search pop-up
const menuToggleIcon = selectElement('#menu-toggle-icon');
const formOpenBtn = selectElement('#search-icon');
const formCloseBtn = selectElement('#form-close-btn');
const searchContainer = selectElement('#search-form-container');

const toggleMenu = () =>{
    const mobileMenu = selectElement('#menu');
    mobileMenu.classList.toggle('activated');
    menuToggleIcon.classList.toggle('activated');
}

menuToggleIcon.addEventListener('click', toggleMenu);

// Open/Close search form popup
formOpenBtn.addEventListener('click', () => searchContainer.classList.add('activated'));
formCloseBtn.addEventListener('click', () => searchContainer.classList.remove('activated'));
// -- Close the search form popup on ESC keypress
window.addEventListener('keyup', (event) => {
    if(event.key === 'Escape') searchContainer.classList.remove('activated');
});

// Switch theme/add to local storage
const body = document.body;
const themeToggleBtn = selectElement('#theme-toggle-btn');
const currentTheme = localStorage.getItem('currentTheme');

// Check to see if there is a theme preference in local Storage, if so add the ligt theme to the body
if (currentTheme) {
    body.classList.add('light-theme');
}

themeToggleBtn.addEventListener('click', function () {
    // Add light theme on click
    body.classList.toggle('light-theme');

    // If the body has the class of light theme then add it to local Storage, if not remove it
    if (body.classList.contains('light-theme')) {
        localStorage.setItem('currentTheme', 'themeActive');
    } else {
        localStorage.removeItem('currentTheme');
    }
});















