document.addEventListener('DOMContentLoaded', function() {
    const textInput = document.getElementById('vc-textInput');
    const vowelCountElement = document.getElementById('vc-vowelCount');
    const consonantCountElement = document.getElementById('vc-consonantCount');
    const letterCountElement = document.getElementById('vc-letterCount');
    const wordCountElement = document.getElementById('vc-wordCount'); // Assuming you've added this for word count
    // Assuming IDs for individual vowel counts if they exist
    const vowelACountElement = document.getElementById('vc-vowelA');
    const vowelECountElement = document.getElementById('vc-vowelE');
    const vowelICountElement = document.getElementById('vc-vowelI');
    const vowelOCountElement = document.getElementById('vc-vowelO');
    const vowelUCountElement = document.getElementById('vc-vowelU');
    const copyButton = document.getElementById('vc-copyButton');
    const maxCharacters = 1000000; // Set your maximum character limit here

    function updateCounts() {
        const text = textInput.value.toLowerCase();
        const textLength = text.length;

        if (textLength > maxCharacters) {
            // Display warning in all relevant count elements
            const message = '1,000,000 character limit';
            vowelCountElement.textContent = message;
            consonantCountElement.textContent = message;
            letterCountElement.textContent = message;
            wordCountElement.textContent = message;
            // Update individual vowel counts if needed
            if(vowelACountElement) vowelACountElement.textContent = message;
            if(vowelECountElement) vowelECountElement.textContent = message;
            if(vowelICountElement) vowelICountElement.textContent = message;
            if(vowelOCountElement) vowelOCountElement.textContent = message;
            if(vowelUCountElement) vowelUCountElement.textContent = message;
            return; // Exit the function to prevent further counting
        }

        // Continue with normal counting if within the character limit
        const vowels = text.match(/[aeiou]/gi) || [];
        const consonants = text.match(/[bcdfghjklmnpqrstvwxyz]/gi) || [];
        const words = text.match(/\S+/g) || []; // Matches sequences of non-whitespace characters
        const letters = text.match(/[a-z]/gi) || [];

        // Update the HTML with the counts
        vowelCountElement.textContent = vowels.length;
        consonantCountElement.textContent = consonants.length;
        letterCountElement.textContent = letters.length;
        wordCountElement.textContent = words.length;
        // Update individual vowel counts
        if(vowelACountElement) vowelACountElement.textContent = (text.match(/a/gi) || []).length;
        if(vowelECountElement) vowelECountElement.textContent = (text.match(/e/gi) || []).length;
        if(vowelICountElement) vowelICountElement.textContent = (text.match(/i/gi) || []).length;
        if(vowelOCountElement) vowelOCountElement.textContent = (text.match(/o/gi) || []).length;
        if(vowelUCountElement) vowelUCountElement.textContent = (text.match(/u/gi) || []).length;
    }

    textInput.addEventListener('input', updateCounts);

    copyButton.addEventListener('click', async () => {
        if (navigator.clipboard) {
            try {
                await navigator.clipboard.writeText(textInput.value);
                copyButton.textContent = 'Copied!';
                setTimeout(() => {
                    copyButton.textContent = 'Copy Text';
                }, 2000);
            } catch (err) {
                console.error('Failed to copy:', err);
            }
        } else {
            textInput.select();
            document.execCommand('copy');
            copyButton.textContent = 'Copied!';
            setTimeout(() => {
                copyButton.textContent = 'Copy Text';
            }, 2000);
        }
    });

    // Initialize counts on page load
    updateCounts();
});






// Grab elements
const selectElement = (selector) => {
    const element = document.querySelector(selector);
    if(element) return element;
    throw new Error(`Something went wrong! Make sure that ${selector} exists/is typed correctly.`);  
};

//Nav styles on scroll
const scrollHeader = () =>{
    const navbarElement = selectElement('#header');
    if(this.scrollY >= 15) {
        navbarElement.classList.add('activated');
    } else {
        navbarElement.classList.remove('activated');
    }
}

window.addEventListener('scroll', scrollHeader);

// Open menu & search pop-up
const menuToggleIcon = selectElement('#menu-toggle-icon');
//const formOpenBtn = selectElement('#search-icon');
const formCloseBtn = selectElement('#form-close-btn');
const searchContainer = selectElement('#search-form-container');

const toggleMenu = () =>{
    const mobileMenu = selectElement('#menu');
    mobileMenu.classList.toggle('activated');
    menuToggleIcon.classList.toggle('activated');
}

menuToggleIcon.addEventListener('click', toggleMenu);

// Open/Close search form popup
//formOpenBtn.addEventListener('click', () => searchContainer.classList.add('activated'));
formCloseBtn.addEventListener('click', () => searchContainer.classList.remove('activated'));
// -- Close the search form popup on ESC keypress
window.addEventListener('keyup', (event) => {
    if(event.key === 'Escape') searchContainer.classList.remove('activated');
});









