// Filename: ucas.js


    

// Prints Character and Word length on textarea input

let characters;
let originalInput;
let lineCount;



function callFunction(){
    
    characters = getUserInput().trim().length;
    originalInput = getUserInput();
    lineCount = getLineCount(originalInput);
    
    
    
    if (characters <= 4000){
        document.getElementById("typed").style.color = "black";
    }
    else {
        document.getElementById("typed").style.color = "red";
    }
    
    if (lineCount <= 47){
        document.getElementById("lines").style.color = "black";
    }
    else {
        document.getElementById("lines").style.color = "red";
    }
    
    
    
    
    
    document.getElementById("typed").innerHTML =  characters;
    
    
    document.getElementById("lines").innerHTML = lineCount;
    
    


}






// Get user input from textarea
const getUserInput = function(){
    
    // Assign user input to variable
    let userInput = document.getElementById("userWord").value;
    
    return userInput;
}

// Get length of characters in textarea
function getCharLength() {
    if (getUserInput().length <= 4000){
        document.getElementById("item1").style.color = "black";
        //document.getElementById("item2").style.color = "black";
        return getUserInput().length;
    }
    else {
        document.getElementById("item1").style.color = "red";
        //document.getElementById("item2").style.color = "red";
        return getUserInput().length;
    }
}




// Get line count

/*
function getLineCount(){

    let newLines = originalInput.split(/\n/);
    let count = 0;
    
    for (let i = 0; i < newLines.length; i++){
        
        if (newLines[i].length > 94){
            count += Math.ceil(newLines[i].length / 94);
        }
        console.log("Line: " + i + " " + newLines[i])
        
    }
    
    
    if (count > 0){
        count--;
    }
    
    
    if (characters === 0){
        return 0;
    }
   // console.log("Output: " + newLines)
  
    return count + newLines.length;

}

*/

function getLineCount(text) {
    
	let lines = 0;
	
	if (characters <= 0) {
        return 0;
    }

	// Split on end of lines.
    text.split(/\r?\n/).forEach((line) => {
        // If it is an empty line just increase the number of lines by 1
        // and print an empty line.
        if (line === "") {
            console.log();
            lines++;
        } else {
            // 94 = max length
            // We are matching two groups here, but we only care to the groups
            // with the text.
            line.split(/(.{1,94})(?:\s|$)/g).forEach((wrappedLine) => {
                // Skip the empty lines (the groups we don't care).
                if (wrappedLine === "") return;
    
                console.log(wrappedLine);
                lines++;
            });
        }
    });

    return lines;
}











// Copy text in textarea with button click
function copy() {
    

      if (characters > 0){
    
          var copyText = document.getElementById("userWord");
          copyText.select();
          copyText.setSelectionRange(0, 99999)
          document.execCommand("copy");
          
          var x = document.getElementById("snackbar");
          x.className = "show";
          setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
      }
      else{
          var x = document.getElementById("snackbarFail");
          x.className = "show";
          setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
      }
      
}
    
// Clear text in textarea with button click
function clearContent() {
    document.getElementById("userWord").value='';
    callFunction();
}









// Grab elements
const selectElement = (selector) => {
    const element = document.querySelector(selector);
    if(element) return element;
    throw new Error(`Something went wrong! Make sure that ${selector} exists/is typed correctly.`);  
};

//Nav styles on scroll
const scrollHeader = () =>{
    const navbarElement = selectElement('#header');
    if(this.scrollY >= 15) {
        navbarElement.classList.add('activated');
    } else {
        navbarElement.classList.remove('activated');
    }
}

window.addEventListener('scroll', scrollHeader);

// Open menu & search pop-up
const menuToggleIcon = selectElement('#menu-toggle-icon');
const formOpenBtn = selectElement('#search-icon');
const formCloseBtn = selectElement('#form-close-btn');
const searchContainer = selectElement('#search-form-container');

const toggleMenu = () =>{
    const mobileMenu = selectElement('#menu');
    mobileMenu.classList.toggle('activated');
    menuToggleIcon.classList.toggle('activated');
}

menuToggleIcon.addEventListener('click', toggleMenu);

// Open/Close search form popup
formOpenBtn.addEventListener('click', () => searchContainer.classList.add('activated'));
formCloseBtn.addEventListener('click', () => searchContainer.classList.remove('activated'));
// -- Close the search form popup on ESC keypress
window.addEventListener('keyup', (event) => {
    if(event.key === 'Escape') searchContainer.classList.remove('activated');
});

// Switch theme/add to local storage
const body = document.body;
const themeToggleBtn = selectElement('#theme-toggle-btn');
const currentTheme = localStorage.getItem('currentTheme');

// Check to see if there is a theme preference in local Storage, if so add the ligt theme to the body
if (currentTheme) {
    body.classList.add('light-theme');
}

themeToggleBtn.addEventListener('click', function () {
    // Add light theme on click
    body.classList.toggle('light-theme');

    // If the body has the class of light theme then add it to local Storage, if not remove it
    if (body.classList.contains('light-theme')) {
        localStorage.setItem('currentTheme', 'themeActive');
    } else {
        localStorage.removeItem('currentTheme');
    }
});


















