// Filename: pinterest.js


// Global variables
let userInput;

let postColor;
let dmColor;
let bioColor;
let usernameColor;
let hashtagColor;
let captionColor;


// Prints Character and Word length on textarea input
function callFunction(){
    
    userInput = getUserInput();
    
    let characters = userInput.length;
    
    document.getElementById("typed").innerHTML =  characters;
    document.getElementById("div5").innerHTML = getRemaining();
    
    document.getElementById("pin-title").innerHTML =  characters;
    document.getElementById("bio").innerHTML =  characters;
    document.getElementById("username").innerHTML =  characters;
    document.getElementById("profile-name").innerHTML =  characters;
    document.getElementById("hashtag").innerHTML =  getHashtagCount();
    document.getElementById("board-description").innerHTML =  characters;


    // Username color and Profile name color
    
    if (characters <= 30 && usernameColor !== "black"){
    
        document.getElementById("username").style.color = "black";
        document.getElementById("profile-name").style.color = "black";
        usernameColor = "black";
    }
    else if (characters > 30 && usernameColor !== "red"){
        document.getElementById("username").style.color = "red";
        document.getElementById("profile-name").style.color = "red";
        usernameColor = "red";
    }
    
    // Bio color
    
    if (characters <= 160 && bioColor !== "black"){
        document.getElementById("bio").style.color = "black";
        bioColor = "black";
    }
    else if (characters > 160 && bioColor !== "red"){
        document.getElementById("bio").style.color = "red";
        bioColor = "red";
    }
    
    // DM color
    
    if (characters <= 100 && dmColor !== "black"){
        document.getElementById("pin-title").style.color = "black";
        dmColor = "black";
    }
    else if (characters > 100 && dmColor !== "red"){
        document.getElementById("pin-title").style.color = "red";
        dmColor = "black";
    }
    
    // Caption truncation color

    if (characters <= 500 && captionColor !== "black"){
        document.getElementById("board-description").style.color = "black";
        captionColor = "black";
    }
    else if (characters > 500 && captionColor !== "red"){
        document.getElementById("board-description").style.color = "red";
        captionColor = "red";
    }
    
    
    
    let hashtagCount = getHashtagCount();
    if (hashtagCount <= 20 && hashtagColor !== "black"){
        document.getElementById("hashtag").style.color = "black";
        hashtagColor = "black";
    }
    else if (hashtagCount > 20 && hashtagColor !== "red"){
        document.getElementById("hashtag").style.color = "red";
        hashtagColor = "red";
    }
    
    
    
    
    


    
    
}

// Get hashtag count

function getHashtagCount() {
  let string = userInput; 
  let result = string.match(/#/g);
  
  if (result === null){
      return "0";
  }
  return result.length;
}

// Get user input from textarea
function getUserInput(){
    
    // Assign user input to variable
    let userInput = document.getElementById("userWord").value;
    return userInput;
}

// Get length of characters in textarea
function getCharLength() {
    if (userInput.length <= 500){
        document.getElementById("typed").style.color = "black";
        document.getElementById("div5").style.color = "black";
        return userInput.length;
    }
    else {
        document.getElementById("typed").style.color = "red";
        document.getElementById("div5").style.color = "red";
        return userInput.length;
    }
    
    
    
    
}

// Get remaining characters (number of characters until 500 is reached)
function getRemaining(){
    return 500 - getCharLength();
}





// Copy text in textarea with button click
function copy() {
    

      if (userInput.length > 0){
    
          var copyText = document.getElementById("userWord");
          copyText.select();
          copyText.setSelectionRange(0, 99999)
          document.execCommand("copy");
          
          var x = document.getElementById("snackbar");
          x.className = "show";
          setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
      }
      else{
          var x = document.getElementById("snackbarFail");
          x.className = "show";
          setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
      }
      
}
    
// Clear text in textarea with button click
function clearContent() {
    document.getElementById("userWord").value='';
    callFunction();
}







// Grab elements
const selectElement = (selector) => {
    const element = document.querySelector(selector);
    if(element) return element;
    throw new Error(`Something went wrong! Make sure that ${selector} exists/is typed correctly.`);  
};

//Nav styles on scroll
const scrollHeader = () =>{
    const navbarElement = selectElement('#header');
    if(this.scrollY >= 15) {
        navbarElement.classList.add('activated');
    } else {
        navbarElement.classList.remove('activated');
    }
}

window.addEventListener('scroll', scrollHeader);

// Open menu & search pop-up
const menuToggleIcon = selectElement('#menu-toggle-icon');
const formOpenBtn = selectElement('#search-icon');
const formCloseBtn = selectElement('#form-close-btn');
const searchContainer = selectElement('#search-form-container');

const toggleMenu = () =>{
    const mobileMenu = selectElement('#menu');
    mobileMenu.classList.toggle('activated');
    menuToggleIcon.classList.toggle('activated');
}

menuToggleIcon.addEventListener('click', toggleMenu);

// Open/Close search form popup
formOpenBtn.addEventListener('click', () => searchContainer.classList.add('activated'));
formCloseBtn.addEventListener('click', () => searchContainer.classList.remove('activated'));
// -- Close the search form popup on ESC keypress
window.addEventListener('keyup', (event) => {
    if(event.key === 'Escape') searchContainer.classList.remove('activated');
});

// Switch theme/add to local storage
const body = document.body;
const themeToggleBtn = selectElement('#theme-toggle-btn');
const currentTheme = localStorage.getItem('currentTheme');

// Check to see if there is a theme preference in local Storage, if so add the ligt theme to the body
if (currentTheme) {
    body.classList.add('light-theme');
}

themeToggleBtn.addEventListener('click', function () {
    // Add light theme on click
    body.classList.toggle('light-theme');

    // If the body has the class of light theme then add it to local Storage, if not remove it
    if (body.classList.contains('light-theme')) {
        localStorage.setItem('currentTheme', 'themeActive');
    } else {
        localStorage.removeItem('currentTheme');
    }
});

















