// Prints Character and Word length on textarea input

let characters;
let userInput;
let paragraphCount;
let wordCount;




function callFunction(){
    
    characters = getUserInput().length;
    userInput = getUserInput();
    paragraphCount = getParagraphCount();
    wordCount = getWordCount();

    
    
  
    if (wordCount <= 0) {
        document.getElementById("div5").innerHTML =  0;
    }
    else {
        document.getElementById("div5").innerHTML =  wordCount / paragraphCount;
    }
    
    
    
    
    
    document.getElementById("div3").innerHTML = paragraphCount;
    document.getElementById("div7").innerHTML = wordCount;

    


}






// Get user input from textarea
const getUserInput = function(){
    
    // Assign user input to variable
    let userInput = document.getElementById("userWord").value;
    
    return userInput;
}

// Get length of characters in textarea
function getCharLength() {
        return getUserInput().length;
}

// Get count of paragraphs
function getParagraphCount(){
    let count = 0;
    let wsRegex = /^\s+|\s+$/g;
    let result = userInput.replace(wsRegex, "");
    
    // If there are no NewLine characters and no non-whitespace
    // characters then return 0

    if (!result.match(/\n+/g) && !result.match(/\S/gi)){
        return 0;
    }
    
    // If there are no NewLine characters but there is a non-whitespace
    // character then return 1
    
    else if (!result.match(/\n+/g) && result.match(/\S/gi)){
        
        return 1;
    }
    
    // If there is a NewLine character followed by a space and a non-space
    // character or NewLine character followed by a non-space character
    // then return number of NewLine characters + 1
    
    else{
        return result.match(/\n+(\s+\S|\S)/g).length + 1;
    }
}

// Get count of words in textarea
function getWordCount(){
    if(!userInput.match(/\S+/g)){
        return 0;
    }
    else {
        return userInput.match(/\S+/g).length;
    }
}






// Copy text in textarea with button click
function copy() {
    

      if (characters > 0){
    
          var copyText = document.getElementById("userWord");
          copyText.select();
          copyText.setSelectionRange(0, 99999)
          document.execCommand("copy");
          
          var x = document.getElementById("snackbar");
          x.className = "show";
          setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
      }
      else{
          var x = document.getElementById("snackbarFail");
          x.className = "show";
          setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
      }
      
}
    
// Clear text in textarea with button click
function clearContent() {
    document.getElementById("userWord").value='';
    callFunction();
}







// Grab elements
const selectElement = (selector) => {
    const element = document.querySelector(selector);
    if(element) return element;
    throw new Error(`Something went wrong! Make sure that ${selector} exists/is typed correctly.`);  
};

//Nav styles on scroll
const scrollHeader = () =>{
    const navbarElement = selectElement('#header');
    if(this.scrollY >= 15) {
        navbarElement.classList.add('activated');
    } else {
        navbarElement.classList.remove('activated');
    }
}

window.addEventListener('scroll', scrollHeader);

// Open menu & search pop-up
const menuToggleIcon = selectElement('#menu-toggle-icon');
const formOpenBtn = selectElement('#search-icon');
const formCloseBtn = selectElement('#form-close-btn');
const searchContainer = selectElement('#search-form-container');

const toggleMenu = () =>{
    const mobileMenu = selectElement('#menu');
    mobileMenu.classList.toggle('activated');
    menuToggleIcon.classList.toggle('activated');
}

menuToggleIcon.addEventListener('click', toggleMenu);

// Open/Close search form popup
formOpenBtn.addEventListener('click', () => searchContainer.classList.add('activated'));
formCloseBtn.addEventListener('click', () => searchContainer.classList.remove('activated'));
// -- Close the search form popup on ESC keypress
window.addEventListener('keyup', (event) => {
    if(event.key === 'Escape') searchContainer.classList.remove('activated');
});

// Switch theme/add to local storage
const body = document.body;
const themeToggleBtn = selectElement('#theme-toggle-btn');
const currentTheme = localStorage.getItem('currentTheme');

// Check to see if there is a theme preference in local Storage, if so add the ligt theme to the body
if (currentTheme) {
    body.classList.add('light-theme');
}

themeToggleBtn.addEventListener('click', function () {
    // Add light theme on click
    body.classList.toggle('light-theme');

    // If the body has the class of light theme then add it to local Storage, if not remove it
    if (body.classList.contains('light-theme')) {
        localStorage.setItem('currentTheme', 'themeActive');
    } else {
        localStorage.removeItem('currentTheme');
    }
});




