document.addEventListener('DOMContentLoaded', () => {
    const textArea = document.getElementById('vc-textInput');
    const lineCountDiv = document.getElementById('vc-vowelCount');
    const tableBody = document.getElementById('vc-frequencyTable').getElementsByTagName('tbody')[0];
    const copyButton = document.getElementById('vc-copyButton');
    const downloadButton = document.getElementById('vc-downloadCsv');
    const excludeBlanksCheckbox = document.getElementById('includeBlanks');

    let debounceTimer;

    textArea.addEventListener('input', () => {
        updateCountsAndTable();
    });

    copyButton.addEventListener('click', () => {
        textArea.select();
        document.execCommand('copy');
        copyButton.textContent = "Copied";
        setTimeout(() => {
            copyButton.textContent = "Copy Text";
        }, 2000); // Reset button text after 2 seconds
    });

    excludeBlanksCheckbox.addEventListener('change', () => {
        updateCountsAndTable();
    });

    downloadButton.addEventListener('click', () => {
        downloadButton.textContent = "Preparing...";
        setTimeout(() => {
            downloadAsCSV();
            downloadButton.textContent = "Download as CSV";
        }, 1000);
    });

    function updateCountsAndTable() {
        const text = textArea.value;
        const lines = text.split(/\r*\n/);
        const filteredLines = text.trim() === "" ? [] : (excludeBlanksCheckbox.checked ? lines.filter(line => line.trim() !== '') : lines);

        lineCountDiv.textContent = filteredLines.length; // Updated to count lines as per checkbox

        clearTimeout(debounceTimer);
        debounceTimer = setTimeout(() => {
            updateFrequencyTable(filteredLines);
        }, 300);
    }

    function updateFrequencyTable(lines) {
        tableBody.innerHTML = ''; // Clear existing content
        lines.forEach((line, index) => {
            const row = tableBody.insertRow();
            const cellLineNumber = row.insertCell(0);
            const cellLineContent = row.insertCell(1);
            cellLineNumber.textContent = index + 1;
            cellLineNumber.className = 'line-number'; // Add class to line number cell
            cellLineContent.textContent = line;
            cellLineContent.className = 'content-header'; // Add class to content cell
        });
    }

    function downloadAsCSV() {
        const text = textArea.value;
        const lines = text.split(/\r*\n/);
        const filteredLines = excludeBlanksCheckbox.checked ? lines.filter(line => line.trim() !== '') : lines;
        let csvContent = "data:text/csv;charset=utf-8,Line Number,Content\n";
        
        filteredLines.forEach((line, index) => {
            csvContent += `${index + 1},"${line.replace(/"/g, '""')}"\n`; // Escape double quotes
        });

        const encodedUri = encodeURI(csvContent);
        const link = document.createElement("a");
        link.setAttribute("href", encodedUri);
        link.setAttribute("download", "lines.csv");
        document.body.appendChild(link); // Required for FF

        link.click(); // Trigger the download
        document.body.removeChild(link); // Clean up
    }
});




























// Grab elements
const selectElement = (selector) => {
    const element = document.querySelector(selector);
    if(element) return element;
    throw new Error(`Something went wrong! Make sure that ${selector} exists/is typed correctly.`);  
};

//Nav styles on scroll
const scrollHeader = () => {
    const navbarElement = selectElement('#header'); // Ensure this ID matches your HTML
    if (window.scrollY >= 15) {
        navbarElement.classList.add('activated');
    } else {
        navbarElement.classList.remove('activated');
    }
}

window.addEventListener('scroll', scrollHeader);

// Open menu & search pop-up
const menuToggleIcon = selectElement('#menu-toggle-icon');
//const formOpenBtn = selectElement('#search-icon');
const formCloseBtn = selectElement('#form-close-btn');
const searchContainer = selectElement('#search-form-container');

const toggleMenu = () =>{
    const mobileMenu = selectElement('#menu');
    mobileMenu.classList.toggle('activated');
    menuToggleIcon.classList.toggle('activated');
}

menuToggleIcon.addEventListener('click', toggleMenu);

// Open/Close search form popup
//formOpenBtn.addEventListener('click', () => searchContainer.classList.add('activated'));
formCloseBtn.addEventListener('click', () => searchContainer.classList.remove('activated'));
// -- Close the search form popup on ESC keypress
window.addEventListener('keyup', (event) => {
    if(event.key === 'Escape') searchContainer.classList.remove('activated');
});




















