document.addEventListener("DOMContentLoaded", function() {
    const textInput = document.getElementById("vc-textInput");
    const japaneseCharacterCount = document.getElementById("vc-vowelCount");
    const estimatedJapaneseWords = document.getElementById("vc-consonantCount");
    const hiraganaCount = document.getElementById("hiragana");
    const katakanaCount = document.getElementById("katakana");
    const kanjiCount = document.getElementById("kanji");
    const englishCharacterCount = document.getElementById("vc-characterCount");
    const copyButton = document.getElementById("vc-copyButton");

    // Debounce function to limit how often a function can fire
    function debounce(func, wait) {
        let timeout;
        return function() {
            const context = this, args = arguments;
            clearTimeout(timeout);
            timeout = setTimeout(() => {
                func.apply(context, args);
            }, wait);
        };
    }

    // Updates counts for Hiragana, Katakana, Kanji, and English characters
    const debouncedUpdate = debounce(function updateOtherCounts() {
        const text = textInput.value;
        hiraganaCount.textContent = (text.match(/[\u3040-\u309F]/g) || []).length;
        katakanaCount.textContent = (text.match(/[\u30A0-\u30FF]/g) || []).length;
        kanjiCount.textContent = (text.match(/[\u4E00-\u9FAF\u3400-\u4DBF]/g) || []).length;
        englishCharacterCount.textContent = (text.match(/[a-zA-Z0-9]/g) || []).length;
    }, 300);

    // Updates counts for Japanese Characters and Estimated Japanese Words
    function updateJapaneseCounts() {
        const text = textInput.value;
        const japaneseCharacters = text.match(/[\u3000-\u303F\u3040-\u309F\u30A0-\u30FF\uFF00-\uFFEF\u4E00-\u9FAF\u3400-\u4DBF]/g) || [];
        japaneseCharacterCount.textContent = japaneseCharacters.length;
        estimatedJapaneseWords.textContent = Math.ceil(japaneseCharacters.length / 5);
    }

    textInput.addEventListener("input", updateJapaneseCounts);
    textInput.addEventListener("input", debouncedUpdate);

    // Functionality for copy button
    copyButton.addEventListener("click", function() {
        textInput.select();
        document.execCommand("copy");
        copyButton.textContent = "Copied!";
        setTimeout(function() {
            copyButton.textContent = "Copy Text";
        }, 2000);
    });
});








































// Grab elements
const selectElement = (selector) => {
    const element = document.querySelector(selector);
    if(element) return element;
    throw new Error(`Something went wrong! Make sure that ${selector} exists/is typed correctly.`);  
};

//Nav styles on scroll
const scrollHeader = () =>{
    const navbarElement = selectElement('#header');
    if(this.scrollY >= 15) {
        navbarElement.classList.add('activated');
    } else {
        navbarElement.classList.remove('activated');
    }
}

window.addEventListener('scroll', scrollHeader);

// Open menu & search pop-up
const menuToggleIcon = selectElement('#menu-toggle-icon');
//const formOpenBtn = selectElement('#search-icon');
const formCloseBtn = selectElement('#form-close-btn');
const searchContainer = selectElement('#search-form-container');

const toggleMenu = () =>{
    const mobileMenu = selectElement('#menu');
    mobileMenu.classList.toggle('activated');
    menuToggleIcon.classList.toggle('activated');
}

menuToggleIcon.addEventListener('click', toggleMenu);

// Open/Close search form popup
//formOpenBtn.addEventListener('click', () => searchContainer.classList.add('activated'));
formCloseBtn.addEventListener('click', () => searchContainer.classList.remove('activated'));
// -- Close the search form popup on ESC keypress
window.addEventListener('keyup', (event) => {
    if(event.key === 'Escape') searchContainer.classList.remove('activated');
});









