document.addEventListener('DOMContentLoaded', function() {
    const textInput = document.getElementById('vc-textInput');
    const characterCountElement = document.getElementById('vc-characterCount');
    const line1CountElement = document.getElementById('vc-line1Count');
    const line2CountElement = document.getElementById('vc-line2Count');
    const line3CountElement = document.getElementById('vc-line3Count');
    const copyButton = document.getElementById('vc-copyButton');
    const maxCharacters = 1000000; // Set your maximum character limit here

    function updateCounts() {
        const text = textInput.value;
        const textLength = text.length;
        const exceedMessageElement = document.getElementById('vc-exceedMessage');
    
        if (textLength > maxCharacters) {
            // Display warning in all relevant count elements
            const message = '1,000,000 character limit exceeded';
            characterCountElement.innerHTML = `<span style="color: red;">${message}</span>`;
            line1CountElement.innerHTML = '';
            line2CountElement.innerHTML = '';
            line3CountElement.innerHTML = `<span style="color: red;">${message}</span>`;
            exceedMessageElement.style.display = 'none'; // Hide the exceed message
            return; // Exit the function to prevent further counting
        }
    
        // Split the text into lines, filtering out any blank lines
        const lines = text.split(/\r?\n/).filter(line => line.trim() !== '');
    
        // Update syllable counts for the first three non-blank lines regardless
        updateLineSyllableCount(lines[0] || '', line1CountElement, 5);
        updateLineSyllableCount(lines[1] || '', line2CountElement, 7);
        updateLineSyllableCount(lines[2] || '', line3CountElement, 5);
    
        // Show the exceed message if more than 3 lines are entered, but still display line 3's count
        if (lines.length > 3) {
            exceedMessageElement.style.display = 'block'; // Show the exceed message
        } else {
            exceedMessageElement.style.display = 'none'; // Hide the exceed message if within the limit
        }
}



function updateLineSyllableCount(text, element, expectedSyllables) {
    const syllables = calculateSyllables(text);
    let syllableCountText;

    // Apply red color if syllables exceed the expected count, else use the default color
    if (syllables > expectedSyllables) {
        syllableCountText = `<span style="color: red;">${syllables}</span>`;
    } else {
        syllableCountText = `${syllables}`;
    }

    // Adjusting font size for "/ expectedSyllables" as per previous instructions
    element.innerHTML = `${syllableCountText} <span style="color: #888; font-size: 0.8em;">/ ${expectedSyllables}</span>`;
}


    
    function updateLineSyllableCount(text, element, expectedSyllables) {
    const syllables = calculateSyllables(text);
    let syllableCountText;

    // Apply red color if syllables exceed the expected count, else use the default color
    if (syllables > expectedSyllables) {
        syllableCountText = `<span style="color: red;">${syllables}</span>`;
    } else {
        syllableCountText = `${syllables}`;
    }

    // Make the "/ expectedSyllables" part smaller and in gray color
    // You can adjust "0.8em" to the size that works best for your design
    element.innerHTML = `${syllableCountText} <span style="color: #888; font-size: 0.8em;">/ ${expectedSyllables}</span>`;
}




    // List of problematic words and their syllable counts
    const problematicWords = {
    'aa':2,
    'abated':3,
    'abatement':3,
    'abiotic':4,
    'aby':2,
    'achievement':3,
    'acre':2,
    'acreage':3,
    'acuity':4,
    'acutely':3,
    'ado':2,
    'adobe':3,
    'adopted':3,
    'aforementioned':4,
    'aforesaid':3,
    'aga':2,
    'agave':3,
    'aged':2,
    'agee':2,
    'ago':2,
    'agrarian':4,
    'agree':2,
    'agreeable':4,
    'agreeing':3,
    'aha':2,
    'ai':2,
    'ais':2,
    'ala':2,
    'alexia':4,
    'aliases':4,
    'amalgamated':5,
    'amazement':3,
    'ami':2,
    'amiable':4,
    'amie':2,
    'amusement':3,
    'anaemia':4,
    'anemia':4,
    'anemone':4,
    'ani':2,
    'aorta':3,
    'aortic':3,
    'apa':2,
    'apostrophe':4,
    'apr':2,
    'aquarium':4,
    'aquariums':4,
    'aqueous':3,
    'ar':2,
    'aria':3,
    'ataxia':4,
    'atheism':3,
    'atheist':3,
    'atonement':3,
    'atria':3,
    'atrial':3,
    'atrium':3,
    'ava':2,
    'aviation':4,
    'aviator':4,
    'avian':3,
    'avionics':4,
    'avo':2,
    'awa':2,
    'awareness':3,
    'awhile':2,
    'aba':2,
    'abalone':4,
    'abbreviation':5,
    'abbreviated':5,
    'abo':2,
    'absentee':3,
    'absenteeism':4,
    'absolutely':4,
    'abstracted':3,
    'academia':5,
    'accelerated':5,
    'accentuate':4,
    'accepted':3,
    'accommodated':5,
    'accompanying':5,
    'accordion':4,
    'accrual':3,
    'accruing':3,
    'accrue':2,
    'accumulated':5,
    'accurately':4,
    'acknowledgement':4,
    'acme':2,
    'acne':2,
    'acquainted':3,
    'acquitted':3,
    'activated':4,
    'actively':3,
    'actuation':4,
    'actuator':4,
    'actual':3,
    'actuality':5,
    'actually':4,
    'actuarial':5,
    'actuaries':4,
    'actuated':4,
    'actuate':3,
    'addicted':3,
    'addressee':3,
    'adequately':4,
    'adiabatic':5,
    'adios':3,
    'adjudicated':5,
    'administratively':6,
    'admitted':3,
    'advances':3,
    'advancement':3,
    'advertisement':4,
    'adversely':3,
    'advisement':3,
    'advocated':4,
    'aeon':2,
    'aerial':3,
    'affectionately':5,
    'affected':3,
    'affiliation':5,
    'affiliated':5,
    'affiliate':4,
    'affirmatively':5,
    'affluence':3,
    'affluent':3,
    'aggie':2,
    'aggregated':4,
    'aggressively':4,
    'aggressiveness':4,
    'agitated':4,
    'agile':2,
    'agribusiness':4,
    'ageless':2,
    'agric':1,
    'aisle':1,
    'albeit':3,
    'algae':2,
    'algebraic':4,
    'alienated':4,
    'alleviation':5,
    'alleviating':5,
    'alleviate':4,
    'allele':2,
    'alliance':3,
    'allium':3,
    'allocated':4,
    'allotted':3,
    'alluvial':4,
    'alluded':3,
    'alopecia':5,
    'aloe':2,
    'alternatively':5,
    'alternately':4,
    'altruistic':4,
    'altruism':3,
    'aluminium':5,
    'alveolar':4,
    'alfa':1,
    'alias':1,
    'alphanumeric':2,
    'alum':1,
    'ambiance':3,
    'ambience':3,
    'ambient':3,
    'ambiguity':5,
    'ambiguous':4,
    'ammonium':4,
    'amniotic':4,
    'amphitheater':5,
    'amphitheatre':5,
    'amphibian':4,
    'amphibious':4,
    'amplifier':4,
    'amputee':3,
    'ana':2,
    'analgesia':5,
    'andante':3,
    'anesthesiology':7,
    'angled':2,
    'animated':4,
    'anime':3,
    'anion':3,
    'annotated':4,
    'announcement':3,
    'annoyance':3,
    'annoying':3,
    'annual':3,
    'annually':4,
    'annuity':4,
    'anorexia':5,
    'ante':2,
    'anterior':4,
    'antennae':3,
    'antibacterial':6,
    'antibiotic':5,
    'anticoagulant':6,
    'antimicrobial':6,
    'antioxidant':5,
    'antiquarian':5,
    'antiquated':4,
    'anticipated':5,
    'antiqued':2,
    'any':2,
    'anyone':3,
    'anal':1,
    'anat':1,
    'anim':1,
    'anon':1,
    'anxiety':4,
    'apnea':3,
    'apogee':3,
    'appellee':3,
    'appendices':4,
    'appendixes':4,
    'apples':2,
    'appliance':3,
    'applique':3,
    'applying':3,
    'appointed':3,
    'appointee':3,
    'appreciable':5,
    'appreciation':5,
    'appreciated':5,
    'appreciating':5,
    'appreciate':4,
    'apprenticeship':4,
    'appropriation':5,
    'appropriated':5,
    'appropriating':5,
    'appropriate':4,
    'approximated':5,
    'approximately':5,
    'aphrodisiac':5,
    'approx':1,
    'archaic':3,
    'archaeological':6,
    'archaeologist':5,
    'archaeology':5,
    'archeological':6,
    'archeology':5,
    'arduous':3,
    'area':3,
    'areal':3,
    'arguing':3,
    'argue':2,
    'argyle':2,
    'ariel':3,
    'arrangement':3,
    'arrhythmia':4,
    'arroyo':3,
    'artemisia':5,
    'arterial':4,
    'arteriosclerosis':7,
    'articulated':5,
    'archdiocese':4,
    'assassinated':5,
    'assembled':3,
    'assertiveness':4,
    'asserted':3,
    'asses':2,
    'assignee':3,
    'assimilated':5,
    'association':5,
    'associative':5,
    'associated':5,
    'associating':5,
    'associate':4,
    'assorted':3,
    'astrobiology':6,
    'ashes':2,
    'assoc':1,
    'astron':1,
    'atlases':3,
    'attache':3,
    'attaches':3,
    'attenuation':5,
    'attenuator':5,
    'attenuated':5,
    'attested':3,
    'attractively':4,
    'attractiveness':4,
    'attributed':4,
    'athenaeum':4,
    'attrib':1,
    'atty':1,
    'audience':3,
    'audio':3,
    'audiovisual':6,
    'audiology':5,
    'auditorium':5,
    'aureus':3,
    'authenticated':5,
    'authoritarian':6,
    'autobiographical':7,
    'autobiography':6,
    'autoimmune':4,
    'automated':4,
    'automobile':4,
    'augmented':3,
    'auntie':2,
    'auspices':3,
    'auto':1,
    'avenue':3,
    'avoir':1,
    'awesome':2,
    'axes':2,
    'axial':3,
    'axiomatic':5,
    'axiom':3,
    'azo':2,
    'baccalaureate':5,
    'bacteria':4,
    'bacterial':4,
    'bacteriophage':5,
    'bacteriology':6,
    'bacterium':4,
    'bakeware':2,
    'balboa':3,
    'bale':1,
    'banshee':2,
    'banded':2,
    'barbarian':4,
    'barbecue':3,
    'barbeque':3,
    'barium':3,
    'barr':2,
    'barrier':3,
    'baryon':3,
    'bareback':2,
    'barefoot':2,
    'barely':2,
    'bases':2,
    'bastille':2,
    'baseball':2,
    'baseboard':2,
    'baseline':2,
    'baseman':2,
    'basement':2,
    'basses':2,
    'batterie':3,
    'batted':2,
    'battled':2,
    'bayard':2,
    'bayonet':3,
    'bayou':2,
    'beforehand':3,
    'being':2,
    'belated':3,
    'beloved':3,
    'bereavement':3,
    'beryllium':4,
    'betrayal':3,
    'beyond':2,
    'beaded':2,
    'beanie':2,
    'bearded':2,
    'beastie':2,
    'bedded':2,
    'belle':1,
    'belted':2,
    'beneficiaries':6,
    'benefited':4,
    'bestiality':5,
    'bestiary':4,
    'bias':2,
    'biased':2,
    'biathlon':3,
    'bicentennial':5,
    'biennial':4,
    'biennium':4,
    'binomial':4,
    'bioassay':4,
    'biochemical':5,
    'biochemistry':5,
    'biodegradable':6,
    'bioengineering':6,
    'biofeedback':4,
    'biogeography':6,
    'biogenesis':5,
    'biographical':5,
    'biological':5,
    'biologically':6,
    'biologic':4,
    'biomass':3,
    'biomedical':5,
    'biometric':4,
    'biometrics':4,
    'biophysical':5,
    'biophysics':4,
    'biosphere':3,
    'biosynthesis':5,
    'biota':3,
    'biotechnology':6,
    'biotin':3,
    'biographer':4,
    'biography':4,
    'biologist':4,
    'biology':4,
    'bionic':3,
    'biopsy':3,
    'biotic':3,
    'bisexual':4,
    'bibliographic':5,
    'bibliography':5,
    'bienvenue':3,
    'biggie':2,
    'biliary':4,
    'bile':1,
    'birdhouses':3,
    'birdie':2,
    'bitte':2,
    'blas':2,
    'blasted':2,
    'blazes':2,
    'bldg':1,
    'blended':2,
    'blessed':2,
    'bloated':2,
    'blooded':2,
    'bloodshed':2,
    'bluish':2,
    'boa':2,
    'boas':2,
    'bonuses':3,
    'boreal':3,
    'bobsled':2,
    'bonnie':2,
    'bonded':2,
    'boneless':2,
    'boogie':2,
    'bookie':2,
    'boolean':3,
    'booted':2,
    'boredom':2,
    'borehole':2,
    'bossier':3,
    'boulevard':2,
    'bounded':2,
    'bourgeoisie':3,
    'braces':2,
    'bracelet':2,
    'bracelets':2,
    'braided':2,
    'brasserie':3,
    'bravely':2,
    'breeches':2,
    'brian':2,
    'briar':2,
    'brier':2,
    'brio':2,
    'bridegroom':2,
    'bridesmaid':2,
    'brodie':2,
    'bronchial':3,
    'brownie':2,
    'bruin':2,
    'bulimia':4,
    'butadiene':4,
    'buckeye':2,
    'budgeted':3,
    'bulleted':3,
    'bullying':3,
    'bumblebee':3,
    'bungee':2,
    'bunches':2,
    'buoyancy':3,
    'buoyant':2,
    'burial':3,
    'burying':3,
    'buses':2,
    'busiest':3,
    'busses':2,
    'business':2,
    'businessman':3,
    'bustier':3,
    'buyer':2,
    'buying':2,
    'cacao':3,
    'cadastre':3,
    'cadre':2,
    'caf':2,
    'cafe':2,
    'camaraderie':5,
    'canoe':2,
    'canoeing':3,
    'caribe':3,
    'catastrophe':4,
    'caveat':3,
    'cabriolet':4,
    'cadmium':3,
    'cafeteria':5,
    'cakewalk':2,
    'calcareous':4,
    'calcium':3,
    'calculated':4,
    'calibrated':4,
    'calibre':3,
    'calorie':3,
    'cameo':3,
    'cameos':3,
    'camisole':3,
    'campion':3,
    'campuses':3,
    'canciones':3,
    'canzone':3,
    'capsule':2,
    'captivated':4,
    'carbonated':4,
    'cardiac':3,
    'cardiovascular':6,
    'cardiologist':5,
    'cardiology':5,
    'carrier':3,
    'carrion':3,
    'carriageway':3,
    'carrying':3,
    'careful':2,
    'carefully':3,
    'careless':2,
    'carelessly':3,
    'carelessness':3,
    'caretaker':3,
    'carle':1,
    'casserole':3,
    'cassie':2,
    'casual':3,
    'casually':4,
    'casualty':4,
    'casebook':2,
    'caseload':2,
    'casework':2,
    'cated':2,
    'cation':3,
    'cationic':4,
    'caucuses':3,
    'causeway':2,
    'caviar':3,
    'caveman':2,
    'cayenne':2,
    'celiac':3,
    'cereal':3,
    'cesium':3,
    'ceded':2,
    'celebrated':4,
    'censuses':3,
    'centennial':4,
    'centre':2,
    'centurion':4,
    'ceremonial':5,
    'certifying':4,
    'certiorari':5,
    'certificated':5,
    'chameleon':4,
    'chaos':2,
    'chaotic':3,
    'chamomile':3,
    'champion':3,
    'championship':4,
    'chariot':3,
    'charlie':2,
    'charleston':2,
    'chasse':2,
    'chatted':2,
    'chenille':2,
    'cherie':2,
    'cheeseburger':3,
    'cheesecake':2,
    'chianti':3,
    'chimpanzee':3,
    'chippendale':3,
    'chlorinated':4,
    'chorale':2,
    'choreographer':5,
    'choreography':5,
    'choruses':3,
    'chromium':3,
    'chuckled':2,
    'cine':2,
    'circadian':4,
    'circulated':4,
    'cited':2,
    'clarifying':4,
    'clarion':3,
    'classes':2,
    'classifiable':5,
    'classifier':4,
    'classifying':4,
    'cliche':2,
    'client':2,
    'cloisonne':3,
    'clostridium':4,
    'closely':2,
    'closeness':2,
    'clouded':2,
    'coalition':4,
    'coagulation':5,
    'coauthor':3,
    'coaxial':4,
    'coed':2,
    'coefficient':4,
    'coenzyme':3,
    'coercion':3,
    'coercive':3,
    'coerce':2,
    'coerced':2,
    'coexist':3,
    'coexistence':4,
    'coincidental':5,
    'coincidentally':6,
    'coincidence':4,
    'coincident':4,
    'coincided':4,
    'coincide':3,
    'coinsurance':4,
    'coleoptera':5,
    'colonial':4,
    'colonialism':5,
    'comedian':4,
    'comes':2,
    'cooperation':5,
    'cooperative':5,
    'cooperated':5,
    'cooperating':5,
    'cooperate':4,
    'coordination':5,
    'coordinator':5,
    'coordinated':5,
    'coordinating':5,
    'coordinate':4,
    'coordinates':4,
    'copious':3,
    'coquille':2,
    'coriander':4,
    'covariance':4,
    'coarsely':2,
    'coated':2,
    'cochlear':3,
    'coded':2,
    'coffee':2,
    'coliseum':4,
    'collaboratively':6,
    'collaborated':5,
    'collated':3,
    'collectively':4,
    'collected':3,
    'collided':3,
    'collie':2,
    'colloquia':4,
    'colloquial':4,
    'colloquium':4,
    'colosseum':4,
    'cole':1,
    'colonel':2,
    'combinatorial':6,
    'commencement':3,
    'committed':3,
    'committee':3,
    'communicated':5,
    'communique':4,
    'compagnie':3,
    'comparatively':5,
    'compendium':4,
    'compensated':4,
    'competed':3,
    'competitively':5,
    'competitiveness':5,
    'compile':2,
    'complemented':4,
    'completed':3,
    'completely':3,
    'completeness':3,
    'compliance':3,
    'compliant':3,
    'complicated':4,
    'complying':3,
    'comprehensively':5,
    'computed':3,
    'comeback':2,
    'concatenated':5,
    'conceded':3,
    'concentrated':4,
    'conceptual':4,
    'conceptualization':7,
    'conceptually':5,
    'concerted':3,
    'conciliation':5,
    'concisely':3,
    'conclusively':4,
    'concluded':3,
    'condominium':5,
    'confidentiality':7,
    'confinement':3,
    'confiscated':4,
    'confluence':3,
    'confounded':3,
    'congratulated':5,
    'congruence':3,
    'congruent':3,
    'conjugated':4,
    'connected':3,
    'conscientious':4,
    'consecrated':4,
    'consequences':4,
    'consecutively':5,
    'consensual':4,
    'conservatively':5,
    'conservatory':4,
    'consignee':3,
    'consolidated':5,
    'console':2,
    'consortia':4,
    'consortium':4,
    'conspicuous':4,
    'conspicuously':5,
    'constituted':4,
    'constituency':5,
    'constituent':4,
    'constructively':4,
    'contaminated':5,
    'contemplated':4,
    'contemporaneous':6,
    'contented':3,
    'contextual':4,
    'continuity':5,
    'contiguous':4,
    'continua':4,
    'continuation':5,
    'continual':4,
    'continually':5,
    'continuance':4,
    'continuing':4,
    'continuous':4,
    'continuously':5,
    'continuum':4,
    'continue':3,
    'contractual':4,
    'contractually':5,
    'contracted':3,
    'contributed':4,
    'conversely':3,
    'converted':3,
    'conveyancing':4,
    'conveyance':3,
    'conveyor':3,
    'convoluted':4,
    'concurrency':3,
    'conservation':2,
    'cookie':2,
    'copier':3,
    'copying':3,
    'copyrighted':4,
    'cornea':3,
    'corneal':3,
    'cornucopia':5,
    'correlated':4,
    'corrente':3,
    'corrie':2,
    'corroborated':5,
    'corrugated':4,
    'cort':2,
    'corded':2,
    'coulee':2,
    'courier':3,
    'courteous':3,
    'courses':2,
    'coyote':2,
    'crl':2,
    'cranial':3,
    'cranium':3,
    'crappie':2,
    'crayon':2,
    'creatine':3,
    'creation':3,
    'creationism':4,
    'creationist':4,
    'creativity':5,
    'creative':3,
    'creator':3,
    'created':3,
    'creatinine':4,
    'creating':3,
    'create':2,
    'crematorium':5,
    'crested':2,
    'crier':2,
    'criteria':4,
    'criterion':4,
    'crocodile':3,
    'crooked':2,
    'croupier':3,
    'crowded':2,
    'cruces':2,
    'cruel':2,
    'cruelly':3,
    'cruelty':3,
    'crumpled':2,
    'crying':2,
    'cryogenic':4,
    'cures':2,
    'curiae':3,
    'curio':3,
    'curios':3,
    'curiosity':5,
    'curious':3,
    'curiously':4,
    'curie':2,
    'cutaneous':4,
    'culminated':4,
    'cultivated':4,
    'currier':3,
    'currie':2,
    'cursed':2,
    'curses':2,
    'custodial':4,
    'custodian':4,
    'cutie':2,
    'cyanide':3,
    'cyan':2,
    'cyclades':3,
    'cysteine':3,
    'dj':2,
    'dale':1,
    'damages':3,
    'dandelion':4,
    'daphne':2,
    'daredevil':3,
    'dated':2,
    'dateline':2,
    'daybed':2,
    'deactivation':5,
    'deactivated':5,
    'deactivate':4,
    'debated':3,
    'decapitated':5,
    'deceptively':4,
    'decisively':4,
    'decided':3,
    'deciduous':4,
    'decoded':3,
    'decree':2,
    'defensively':4,
    'defenseman':3,
    'defiance':3,
    'defiant':3,
    'defiantly':4,
    'definitively':5,
    'deflated':3,
    'deflected':3,
    'degraded':3,
    'degree':2,
    'dehumidifier':6,
    'dehydrated':4,
    'deity':3,
    'deleted':3,
    'deliberately':5,
    'delighted':3,
    'delineation':5,
    'delineated':5,
    'delineate':4,
    'delirious':4,
    'delirium':4,
    'deluded':3,
    'demented':3,
    'denial':3,
    'denominated':5,
    'denoted':3,
    'denying':3,
    'deodorant':4,
    'departed':3,
    'depleted':3,
    'depreciation':5,
    'depreciated':5,
    'deserted':3,
    'destroyer':3,
    'deterioration':6,
    'deteriorated':6,
    'deteriorating':6,
    'deteriorate':5,
    'devaluation':5,
    'developement':4,
    'deviation':4,
    'deviance':3,
    'deviant':3,
    'deviate':3,
    'devious':3,
    'devoted':3,
    'deadliest':3,
    'decimated':4,
    'decorated':4,
    'dedicated':4,
    'definitely':4,
    'delegated':4,
    'deleterious':5,
    'delicately':4,
    'demonstrated':4,
    'dengue':2,
    'densely':2,
    'deprecated':4,
    'designated':4,
    'designee':3,
    'desperately':4,
    'detonated':4,
    'deuterium':4,
    'devastated':4,
    'devotee':3,
    'diabetes':4,
    'diabetic':4,
    'diabolical':5,
    'diabolic':4,
    'diagram':3,
    'dialectical':5,
    'dialectic':4,
    'dialect':3,
    'dialog':3,
    'dialogic':4,
    'dialogue':3,
    'diamant':4,
    'diaphragm':3,
    'diary':3,
    'diatom':3,
    'diagnosis':4,
    'diagnosing':4,
    'diagnostic':4,
    'diagnostics':4,
    'diagnose':3,
    'diagnosed':3,
    'diagonal':4,
    'diagonally':5,
    'dialer':3,
    'dialing':3,
    'dialling':3,
    'dialysis':4,
    'dialed':2,
    'diameter':4,
    'diarrhea':4,
    'diarrhoea':4,
    'diastolic':4,
    'dichroic':3,
    'dielectric':4,
    'dietary':4,
    'dietetic':4,
    'dietetics':4,
    'dietitian':4,
    'diet':2,
    'dieter':3,
    'dieting':3,
    'dilapidated':5,
    'dilated':3,
    'diluted':3,
    'diocese':3,
    'diorama':4,
    'diocesan':4,
    'diode':2,
    'dioxide':3,
    'dipole':2,
    'directorial':5,
    'directed':3,
    'diuretic':4,
    'diurnal':3,
    'diversifying':5,
    'divided':3,
    'divinely':3,
    'dickie':2,
    'differentiable':6,
    'differentiation':6,
    'differentiated':6,
    'differentiating':6,
    'differentiate':5,
    'difficulties':2,
    'diphtheria':4,
    'disabled':3,
    'disagree':3,
    'disagreeable':5,
    'disagreeing':4,
    'disappointed':4,
    'disbursement':3,
    'disconnected':4,
    'discontinuity':6,
    'discontinuation':6,
    'discontinuance':5,
    'discontinuing':5,
    'discontinuous':5,
    'discontinue':4,
    'discriminated':5,
    'disengagement':4,
    'disgraceful':3,
    'disinterested':5,
    'disjointed':3,
    'dislocated':4,
    'disobedience':5,
    'displacement':3,
    'disproportionately':6,
    'disputed':3,
    'dissected':3,
    'disseminated':5,
    'dissipated':4,
    'dissociation':5,
    'distasteful':3,
    'distinctively':4,
    'distorted':3,
    'distracted':3,
    'distributed':4,
    'dixie':2,
    'dizzying':3,
    'doable':3,
    'doer':2,
    'doing':2,
    'doings':2,
    'domesticated':5,
    'donated':3,
    'dore':2,
    'dogged':2,
    'doggie':2,
    'dolce':2,
    'dole':1,
    'domicile':3,
    'dominated':4,
    'donne':2,
    'dossier':3,
    'dossiers':3,
    'dotted':2,
    'doubletree':3,
    'doubles':2,
    'dovecot':2,
    'dovetail':2,
    'downgraded':3,
    'drier':2,
    'driveway':2,
    'druid':2,
    'drying':2,
    'dual':2,
    'duality':4,
    'dualism':3,
    'dually':3,
    'dubious':3,
    'duce':2,
    'duel':2,
    'dueling':3,
    'duet':2,
    'duo':2,
    'duodenal':4,
    'duplicated':4,
    'ductile':2,
    'dyer':2,
    'dying':2,
    'dyeing':2,
    'dyslexia':4,
    'dystopia':4,
    'ecu':2,
    'egalitarian':6,
    'ego':2,
    'elaborated':5,
    'elated':3,
    'electrifying':5,
    'electrophysiology':8,
    'eliminated':5,
    'elongated':4,
    'emitted':3,
    'enumerated':5,
    'eon':2,
    'ep':2,
    'epitome':4,
    'equatorial':5,
    'equated':3,
    'equestrian':4,
    'equilibria':5,
    'equilibrium':5,
    'era':2,
    'eradicated':5,
    'erectile':3,
    'eroded':3,
    'esophageal':5,
    'eta':2,
    'ethereal':4,
    'etiology':5,
    'evacuation':5,
    'evacuated':5,
    'evacuate':4,
    'evaluation':5,
    'evaluative':5,
    'evaluator':5,
    'evaluated':5,
    'evaluating':5,
    'evaluate':4,
    'evaporated':5,
    'eventual':4,
    'eventually':5,
    'earlier':3,
    'earliest':3,
    'easier':3,
    'easiest':3,
    'easement':2,
    'eavesdropping':3,
    'ecclesiastical':6,
    'echoing':3,
    'ecol':1,
    'econ':1,
    'editorial':5,
    'educated':4,
    'edit':1,
    'educ':1,
    'eerie':2,
    'effectively':4,
    'effectiveness':4,
    'eide':2,
    'eigenvalue':4,
    'elevated':4,
    'elec':1,
    'elect':1,
    'elem':1,
    'elev':1,
    'elsewhere':2,
    'embattled':3,
    'embed':2,
    'embedded':3,
    'embodying':4,
    'embryo':3,
    'embryology':5,
    'embryonic':4,
    'emcee':2,
    'emigrated':4,
    'emplacement':3,
    'employability':6,
    'employee':3,
    'employer':3,
    'emporium':4,
    'emulated':4,
    'emptying':3,
    'encapsulated':5,
    'encoded':3,
    'encouragement':4,
    'encyclopaedia':6,
    'encyclopedia':6,
    'endometrial':5,
    'endometriosis':6,
    'endothelial':5,
    'endothelium':5,
    'endorsement':3,
    'enforcement':3,
    'engagement':3,
    'enhancement':3,
    'enjoyable':4,
    'enlargement':3,
    'enrollee':3,
    'ensuing':3,
    'ensue':2,
    'enthusiastically':7,
    'enthusiastic':5,
    'enthusiasm':4,
    'enthusiast':4,
    'entirely':3,
    'entirety':3,
    'entrepreneurial':6,
    'entree':2,
    'enviable':4,
    'envious':3,
    'endemic':1,
    'engin':1,
    'epidemiological':8,
    'epidemiology':7,
    'epithelial':5,
    'epithelium':5,
    'equiv':1,
    'erroneous':4,
    'erroneously':5,
    'erstwhile':2,
    'escalated':4,
    'espionage':4,
    'esse':2,
    'estimated':4,
    'estradiol':4,
    'estuarine':4,
    'estuaries':4,
    'estuary':4,
    'euchre':2,
    'euphonium':4,
    'euphoria':4,
    'evan':1,
    'evening':2,
    'evenings':2,
    'every':2,
    'everybody':4,
    'everyday':3,
    'everything':3,
    'everywhere':3,
    'exacerbated':5,
    'exaggerated':5,
    'exalted':3,
    'excavated':4,
    'excelsior':4,
    'excessively':4,
    'excited':3,
    'excitement':3,
    'exclusively':4,
    'excluded':3,
    'excreted':3,
    'excruciating':5,
    'executed':4,
    'exfoliating':5,
    'exhale':2,
    'exile':2,
    'expanded':3,
    'expatriate':4,
    'expedient':4,
    'expedited':4,
    'experiential':5,
    'experiencing':5,
    'experience':4,
    'experienced':4,
    'exploded':3,
    'expos':3,
    'expropriation':5,
    'exquisitely':4,
    'exterior':4,
    'extensively':4,
    'extenuating':5,
    'extended':3,
    'extraneous':4,
    'extraterrestrial':6,
    'extrapolated':5,
    'extremely':3,
    'extruded':3,
    'exec':1,
    'eyeglasses':3,
    'eyeing':2,
    'fabled':2,
    'facia':3,
    'facies':3,
    'facilitated':5,
    'faerie':3,
    'faeries':3,
    'faery':3,
    'familiarity':6,
    'famille':2,
    'fatigued':2,
    'fabricated':4,
    'faceted':3,
    'facile':2,
    'factorial':4,
    'factual':3,
    'factually':4,
    'faceless':2,
    'faceplate':2,
    'faded':2,
    'falsehood':2,
    'falsely':2,
    'farewell':2,
    'farmhouses':3,
    'fascia':3,
    'fascinated':4,
    'fated':2,
    'fateful':2,
    'feces':2,
    'female':2,
    'fetuses':3,
    'federated':4,
    'fellatio':4,
    'fermion':3,
    'fertile':2,
    'fescue':2,
    'fiance':3,
    'fiancee':3,
    'fiasco':3,
    'fiat':2,
    'fibre':2,
    'fiduciary':5,
    'fiesta':3,
    'finitely':3,
    'fiercely':2,
    'figuratively':5,
    'filigree':3,
    'file':1,
    'filename':2,
    'finial':3,
    'finance':1,
    'finely':2,
    'fireball':2,
    'firebird':2,
    'firebox':2,
    'firefly':2,
    'firehouse':2,
    'fireman':2,
    'fireplace':2,
    'firepower':3,
    'fireproof':2,
    'fireside':2,
    'firestone':2,
    'firestorm':2,
    'firewood':2,
    'firework':2,
    'fireworks':2,
    'fishes':2,
    'fisheye':2,
    'fitted':2,
    'flagpole':2,
    'flamboyant':3,
    'fleeing':2,
    'flier':2,
    'flores':2,
    'flooded':2,
    'fluency':3,
    'fluent':2,
    'fluently':3,
    'fluid':2,
    'fluidity':4,
    'fluorescein':5,
    'fluorescence':4,
    'fluorescent':4,
    'fluoride':3,
    'fluorine':3,
    'fluor':2,
    'fluctuation':4,
    'fluctuating':4,
    'fluctuate':3,
    'fluted':2,
    'flyer':2,
    'flying':2,
    'focuses':3,
    'foliage':3,
    'foliar':3,
    'folio':3,
    'folios':3,
    'fondue':2,
    'footed':2,
    'forgiveness':3,
    'formatted':3,
    'formulated':4,
    'fortifying':4,
    'fortunately':4,
    'forceful':2,
    'forcefully':3,
    'forecast':2,
    'forecaster':3,
    'forecasting':3,
    'foreclosure':3,
    'foreclosed':2,
    'forefoot':2,
    'forefront':2,
    'forego':2,
    'foregone':2,
    'foreground':2,
    'forehand':2,
    'forehead':2,
    'foreman':2,
    'foremost':2,
    'foreplay':2,
    'forerunner':3,
    'foreseen':2,
    'foreshore':2,
    'foresight':2,
    'foreskin':2,
    'foretold':2,
    'foreword':2,
    'foundation':2,
    'foxes':2,
    'foyer':2,
    'fragile':2,
    'fragmented':3,
    'framework':2,
    'freer':2,
    'freebie':2,
    'freeing':2,
    'freestyle':2,
    'friar':2,
    'friendlier':3,
    'frigid':1,
    'frosted':2,
    'fruition':3,
    'frustrated':3,
    'fryer':2,
    'frying':2,
    'fueling':3,
    'fueled':2,
    'fuelled':2,
    'furious':3,
    'furiously':4,
    'futile':2,
    'fucking':1,
    'funnier':3,
    'funniest':3,
    'gazelle':2,
    'galilee':3,
    'gallium':3,
    'galaxies':2,
    'gale':1,
    'ganglia':3,
    'ganglion':3,
    'gargoyle':2,
    'gaseous':3,
    'gases':2,
    'gastroenteritis':6,
    'gastroenterology':7,
    'gastrointestinal':6,
    'gated':2,
    'gatefold':2,
    'gatekeeper':3,
    'gateway':2,
    'genealogical':6,
    'genealogy':5,
    'genie':2,
    'geochemical':5,
    'geochemistry':5,
    'geodesic':4,
    'geodetic':4,
    'geographical':5,
    'geographically':6,
    'geographic':4,
    'geological':5,
    'geologic':4,
    'geomagnetic':5,
    'geometrical':5,
    'geometrically':6,
    'geometric':4,
    'geomorphology':6,
    'geophysical':5,
    'geophysics':4,
    'geopolitical':6,
    'geopolitics':5,
    'geoscience':4,
    'geothermal':4,
    'geodesy':4,
    'geography':4,
    'geology':4,
    'geometry':4,
    'geranium':4,
    'generated':4,
    'geniuses':3,
    'genoa':3,
    'genre':2,
    'gentile':2,
    'genuine':3,
    'geriatric':4,
    'geriatrics':4,
    'germanium':4,
    'giant':2,
    'gifted':2,
    'gilded':2,
    'gimme':2,
    'girlie':2,
    'glace':2,
    'glacier':3,
    'gladiator':4,
    'glasses':2,
    'glial':2,
    'glioma':3,
    'gloria':3,
    'glorious':3,
    'gloriously':4,
    'gluing':2,
    'gluon':2,
    'glutathione':4,
    'goa':2,
    'going':2,
    'goalie':2,
    'goldeneye':3,
    'gonorrhea':4,
    'gooey':2,
    'goodbye':2,
    'gooseneck':2,
    'gracias':3,
    'gradient':3,
    'gratuitous':4,
    'gratuity':4,
    'graceful':2,
    'gracefully':3,
    'graded':2,
    'graduation':4,
    'gradual':3,
    'gradually':4,
    'graduated':4,
    'graduating':4,
    'graduate':3,
    'grandiose':3,
    'granulated':4,
    'granule':2,
    'grantee':2,
    'grapefruit':2,
    'grapevine':2,
    'grated':2,
    'gratifying':4,
    'grateful':2,
    'gratefully':3,
    'gravely':2,
    'gravestone':2,
    'greenbrier':3,
    'greenhouses':3,
    'grille':1,
    'grosses':2,
    'groupie':2,
    'grueling':3,
    'gubernatorial':6,
    'guarantee':3,
    'guaranteeing':4,
    'guarded':2,
    'guardian':3,
    'guardianship':4,
    'guesthouses':3,
    'guided':2,
    'guidebook':2,
    'guideline':2,
    'guile':1,
    'gutted':2,
    'gymnasium':4,
    'habitual':4,
    'habitually':5,
    'hatred':2,
    'hacienda':4,
    'hairstyle':2,
    'halcyon':3,
    'hale':1,
    'handled':2,
    'handcrafted':3,
    'handed':2,
    'handsomely':3,
    'happier':3,
    'happiest':3,
    'hardie':2,
    'harmonious':4,
    'harrier':3,
    'hated':2,
    'hateful':2,
    'haunted':2,
    'hausfrauen':3,
    'havelock':2,
    'helio':3,
    'helium':3,
    'hemodialysis':6,
    'hemophilia':5,
    'heres':2,
    'heroic':3,
    'headed':2,
    'healthier':3,
    'healthiest':3,
    'hearted':2,
    'heated':2,
    'heavier':3,
    'heaviest':3,
    'hedgehog':2,
    'helices':3,
    'hematopoietic':6,
    'hemoglobin':2,
    'henrietta':4,
    'henceforth':2,
    'herbarium':4,
    'heriot':3,
    'hermes':2,
    'hernia':3,
    'heroin':3,
    'heroine':3,
    'heroism':3,
    'herpes':2,
    'hereby':2,
    'hereto':2,
    'heretofore':3,
    'herewith':2,
    'hesitated':4,
    'hessian':3,
    'heterogeneity':7,
    'heterogeneous':6,
    'heterosexual':6,
    'hiatus':3,
    'hierarchical':5,
    'hierarchy':4,
    'hilarious':4,
    'hideous':3,
    'highlighted':3,
    'hillier':3,
    'hippie':2,
    'historian':4,
    'historiography':6,
    'homeopathic':5,
    'homeostasis':5,
    'homeopathy':5,
    'homogeneity':6,
    'homogeneous':5,
    'homosexual':5,
    'homosexuality':7,
    'hobbyist':3,
    'hole':1,
    'hombre':2,
    'homebound':2,
    'homecoming':3,
    'homeland':2,
    'homeless':2,
    'homelessness':3,
    'homely':2,
    'homemade':2,
    'homemaker':3,
    'homesick':2,
    'homesite':2,
    'homespun':2,
    'homestead':2,
    'hometown':2,
    'homeward':2,
    'homework':2,
    'hooded':2,
    'hoodie':2,
    'hopeful':2,
    'hopefully':3,
    'hopeless':2,
    'hopelessly':3,
    'hopelessness':3,
    'horrifying':4,
    'horses':2,
    'horseback':2,
    'horseman':2,
    'horsepower':3,
    'horseradish':3,
    'horseshoes':2,
    'hoses':2,
    'hostile':2,
    'hottie':2,
    'houses':2,
    'houseboat':2,
    'household':2,
    'householder':3,
    'housekeeper':3,
    'housekeeping':3,
    'housewares':2,
    'housewarming':3,
    'housewife':2,
    'housework':2,
    'hoya':2,
    'humanitarian':6,
    'humidifier':5,
    'humiliation':5,
    'humiliated':5,
    'humiliating':5,
    'hugely':2,
    'hundred':2,
    'hunted':2,
    'hyacinth':3,
    'hydrated':3,
    'hydrochlorothiazide':7,
    'hydroelectric':5,
    'hydrogenated':5,
    'hyena':3,
    'hyperplasia':5,
    'hyphenated':4,
    'hypoglycemia':6,
    'hypothermia':5,
    'hypoxia':4,
    'hysteria':4,
    'icy':2,
    'id':2,
    'idea':3,
    'ideal':3,
    'idealistic':5,
    'idealism':4,
    'idealist':4,
    'idealized':4,
    'ideally':4,
    'ideological':6,
    'ideology':5,
    'identifiable':6,
    'identifier':5,
    'identifying':5,
    'imagines':4,
    'iodide':3,
    'iodine':3,
    'iota':3,
    'ion':2,
    'ionization':5,
    'ionic':3,
    'ionizing':4,
    'ionized':3,
    'ionospheric':5,
    'ionosphere':4,
    'iridium':4,
    'isolated':4,
    'ivy':2,
    'iceberg':2,
    'icebreaker':3,
    'iceman':2,
    'ideograph':4,
    'idiocy':4,
    'idiopathic':5,
    'idiosyncratic':6,
    'idiom':3,
    'idiot':3,
    'idiotic':4,
    'igneous':3,
    'ignited':3,
    'ilia':3,
    'illuminated':5,
    'illustrated':4,
    'illustrious':4,
    'illus':1,
    'imagery':3,
    'imbedded':3,
    'imitated':4,
    'immaterial':5,
    'immediacy':5,
    'immediate':4,
    'immensely':3,
    'immigrated':4,
    'immunoassay':5,
    'impacted':3,
    'impartiality':6,
    'imperial':4,
    'imperialism':5,
    'imperialist':5,
    'imperium':4,
    'impeded':3,
    'impervious':4,
    'implicated':4,
    'implying':3,
    'impressively':4,
    'improvement':3,
    'imputed':3,
    'inactivated':5,
    'inadequately':5,
    'inappropriate':5,
    'inaugurated':5,
    'inbred':2,
    'incapacitated':6,
    'incarcerated':5,
    'incendiary':5,
    'incipient':4,
    'incitement':3,
    'included':3,
    'incompleteness':4,
    'incorporated':5,
    'incubated':4,
    'inde':2,
    'indebted':3,
    'indefinitely':5,
    'indented':3,
    'indexes':3,
    'indicated':4,
    'indices':3,
    'indicia':4,
    'indium':3,
    'individual':5,
    'individuality':7,
    'individualistic':7,
    'individualism':6,
    'individualized':6,
    'individually':6,
    'inducement':3,
    'industrial':4,
    'industrialization':7,
    'industrialised':5,
    'industrialized':5,
    'industrials':4,
    'industrious':4,
    'inexperienced':5,
    'inexpensively':5,
    'infantile':3,
    'infatuation':5,
    'inferior':4,
    'inferiority':6,
    'infertile':3,
    'infinitely':4,
    'infiltrated':4,
    'inflated':3,
    'influential':4,
    'influenza':4,
    'influencing':4,
    'influence':3,
    'influenced':3,
    'infrared':3,
    'infringement':3,
    'ingenuity':5,
    'ingredient':4,
    'inhabited':4,
    'inhale':2,
    'inherited':4,
    'inhomogeneous':6,
    'initiation':5,
    'initiative':5,
    'initiator':5,
    'initiated':5,
    'initiating':5,
    'initiate':4,
    'injurious':4,
    'innocuous':4,
    'innuendo':4,
    'inoculated':5,
    'insanely':3,
    'inserted':3,
    'insidious':4,
    'insignia':4,
    'insole':2,
    'insomnia':4,
    'insomniac':4,
    'instantaneous':5,
    'instantaneously':6,
    'instantiate':4,
    'instigated':4,
    'instituted':4,
    'instinctively':4,
    'insulated':4,
    'integrated':4,
    'interior':4,
    'intellectual':5,
    'intellectually':6,
    'intensifying':5,
    'intensively':4,
    'intended':3,
    'intensely':3,
    'interested':4,
    'intermediation':6,
    'intermediaries':6,
    'intermediary':6,
    'intermediate':5,
    'interpolated':5,
    'interrelated':5,
    'interrogated':5,
    'interrupted':4,
    'interscience':4,
    'interviewee':4,
    'intimately':4,
    'intimidated':5,
    'intoxicated':5,
    'intracranial':5,
    'intrauterine':5,
    'intricately':4,
    'intrigued':2,
    'intuition':4,
    'intuitive':4,
    'intuit':3,
    'inundated':4,
    'invaded':3,
    'invalidated':5,
    'invaluable':5,
    'invariably':5,
    'invariant':4,
    'inversely':3,
    'investigated':5,
    'invited':3,
    'involvement':3,
    'init':1,
    'insurance':2,
    'inter':1,
    'intro':1,
    'irradiation':5,
    'irradiance':4,
    'irradiated':5,
    'irrigated':4,
    'irritated':4,
    'ischemia':4,
    'ischia':3,
    'issuance':3,
    'issuer':3,
    'issuing':3,
    'issue':2,
    'isle':1,
    'iterated':4,
    'ital':1,
    'jaded':2,
    'jagged':2,
    'jamboree':3,
    'janitorial':5,
    'javelin':2,
    'jennie':2,
    'joey':2,
    'johannes':3,
    'jointed':2,
    'joule':1,
    'joyous':2,
    'jubilee':3,
    'judiciary':5,
    'juvenile':3,
    'judgement':2,
    'jukebox':2,
    'junkie':2,
    'justifiable':5,
    'justifiably':5,
    'justifying':4,
    'kamikaze':4,
    'karate':3,
    'kale':1,
    'kayak':2,
    'kea':2,
    'keyhole':2,
    'keying':2,
    'kinesiology':6,
    'kiosk':2,
    'kiddie':2,
    'kilometre':4,
    'kindred':2,
    'knitted':2,
    'knotted':2,
    'koa':2,
    'koala':3,
    'kore':2,
    'krone':2,
    'kylie':2,
    'kyle':1,
    'labia':3,
    'laborious':4,
    'laity':3,
    'lamented':3,
    'lanai':3,
    'lakefront':2,
    'lakeshore':2,
    'laminated':4,
    'landed':2,
    'lariat':3,
    'laryngeal':4,
    'largely':2,
    'lassie':2,
    'lated':2,
    'lately':2,
    'laureate':3,
    'layer':2,
    'layering':3,
    'layette':2,
    'laying':2,
    'layoff':2,
    'layout':2,
    'layup':2,
    'legitimately':5,
    'leis':2,
    'lenient':3,
    'leone':3,
    'leotard':3,
    'leu':2,
    'leviathan':4,
    'learned':2,
    'leasehold':2,
    'legged':2,
    'legislated':4,
    'leisurely':3,
    'leishmania':4,
    'lenses':2,
    'lesbian':3,
    'lesbianism':4,
    'lessee':2,
    'leste':2,
    'leukaemia':4,
    'leukemia':4,
    'levee':2,
    'liabilities':5,
    'liability':5,
    'liable':3,
    'liaison':3,
    'liaise':2,
    'liar':2,
    'librarian':4,
    'librarianship':5,
    'licensee':3,
    'limes':2,
    'linoleum':4,
    'lion':2,
    'lionheart':3,
    'lire':2,
    'litre':2,
    'livre':2,
    'liberated':4,
    'libertarian':5,
    'libertarianism':6,
    'lifeboat':2,
    'lifeguard':2,
    'lifeless':2,
    'lifelike':2,
    'lifeline':2,
    'lifelong':2,
    'lifesaving':3,
    'lifetime':2,
    'lighted':2,
    'lighthouses':3,
    'likelihood':3,
    'likely':2,
    'likeness':2,
    'likewise':2,
    'limited':3,
    'limelight':2,
    'limestone':2,
    'linear':3,
    'linearity':5,
    'linearized':4,
    'linearly':4,
    'lingerie':3,
    'linoleic':4,
    'linebacker':3,
    'lineman':2,
    'liquidated':4,
    'listeria':4,
    'lisle':1,
    'listed':2,
    'lithium':3,
    'litho':1,
    'livelihood':3,
    'lively':2,
    'livestock':2,
    'lizzie':2,
    'locale':2,
    'located':3,
    'loaded':2,
    'lobbying':3,
    'lobbyist':3,
    'loneliness':3,
    'lonely':2,
    'lonesome':2,
    'loophole':2,
    'loosely':2,
    'louie':2,
    'louis':2,
    'louvre':2,
    'loveless':2,
    'lovely':2,
    'lovemaking':3,
    'loyal':2,
    'loyalist':3,
    'loyalty':3,
    'luau':2,
    'lubricated':4,
    'lutein':3,
    'lukewarm':2,
    'lustre':2,
    'luxurious':4,
    'luxuriously':5,
    'lyceum':3,
    'lying':2,
    'ml':2,
    'mro':2,
    'macabre':3,
    'machete':3,
    'madre':2,
    'malaria':4,
    'mania':3,
    'maniac':3,
    'manipulated':5,
    'manoeuvre':3,
    'maria':3,
    'material':4,
    'materiality':6,
    'materialism':5,
    'materialize':5,
    'materialized':5,
    'materially':5,
    'materials':4,
    'materiel':4,
    'matrices':3,
    'maya':2,
    'mayan':2,
    'macadamia':5,
    'macroeconomics':6,
    'mackerel':2,
    'mademoiselle':4,
    'maggie':2,
    'magnesium':4,
    'magnifier':4,
    'magnifying':4,
    'magpie':2,
    'makeshift':2,
    'malleable':4,
    'male':1,
    'mammalian':4,
    'managerial':5,
    'manatee':3,
    'management':3,
    'mandated':3,
    'manhole':2,
    'mantua':3,
    'manual':3,
    'manually':4,
    'manuf':1,
    'marbles':2,
    'mariachi':4,
    'marinated':4,
    'marionette':4,
    'marquee':2,
    'marrying':3,
    'marseille':2,
    'martingale':3,
    'massacre':3,
    'massively':3,
    'masses':2,
    'mated':2,
    'matinee':3,
    'matrimonial':5,
    'matted':2,
    'mausoleum':4,
    'maybe':2,
    'mayonnaise':3,
    'mayoral':3,
    'meander':3,
    'media':3,
    'mediation':4,
    'mediator':4,
    'mediaeval':4,
    'medial':3,
    'median':3,
    'mediated':4,
    'mediating':4,
    'mediate':3,
    'medieval':4,
    'mediocre':4,
    'mediocrity':5,
    'medium':3,
    'mediums':3,
    'melee':2,
    'memorial':4,
    'menagerie':4,
    'meow':2,
    'merengue':3,
    'meridian':4,
    'meteorite':4,
    'meteorological':7,
    'meteorology':6,
    'methionine':4,
    'metre':2,
    'measles':2,
    'meanwhile':2,
    'measurement':3,
    'medicated':4,
    'meiosis':3,
    'memorabilia':6,
    'menstruation':4,
    'menstrual':3,
    'mercantile':3,
    'mercurial':4,
    'meritorious':5,
    'merely':2,
    'merle':1,
    'mesothelioma':6,
    'messianic':4,
    'messier':3,
    'metronidazole':5,
    'metal':1,
    'meteor':1,
    'microbial':4,
    'microbiological':7,
    'microbiology':6,
    'microeconomics':6,
    'microelectronics':6,
    'migrated':3,
    'mis':2,
    'mitochondrial':5,
    'mitre':2,
    'midwifery':3,
    'millennia':4,
    'millennial':4,
    'millennium':4,
    'mile':1,
    'milestone':2,
    'ministerial':5,
    'minnie':2,
    'minded':2,
    'minefield':2,
    'miscellanea':5,
    'miscellaneous':5,
    'misguided':3,
    'misled':2,
    'mismanagement':4,
    'missile':2,
    'mistletoe':3,
    'misses':2,
    'moa':2,
    'mobile':2,
    'molasses':3,
    'moped':2,
    'morale':2,
    'mores':2,
    'mosaic':3,
    'motivated':4,
    'moderately':4,
    'modifier':4,
    'modifying':4,
    'modulated':4,
    'module':2,
    'moiety':3,
    'molecule':3,
    'mole':1,
    'mongolian':4,
    'monolayer':4,
    'mononuclear':5,
    'monte':2,
    'montes':2,
    'mondial':3,
    'moratorium':5,
    'mortuary':4,
    'mortgagee':3,
    'mottled':2,
    'mounted':2,
    'movie':2,
    'movement':2,
    'moxie':2,
    'muon':2,
    'museum':3,
    'mutated':3,
    'mutilated':4,
    'mutual':3,
    'mutually':4,
    'multifaceted':5,
    'multilayer':4,
    'multimedia':5,
    'multiplier':4,
    'multiplying':4,
    'multiracial':3,
    'multithreaded':4,
    'multivariate':5,
    'mule':1,
    'muted':2,
    'mycobacterium':6,
    'myelin':3,
    'myeloma':4,
    'myeloid':3,
    'myocardial':5,
    'myocardium':5,
    'myopia':4,
    'myosin':3,
    'myopic':3,
    'myriad':3,
    'mysterious':4,
    'mysteriously':5,
    'nv':2,
    'naira':3,
    'naive':2,
    'naked':2,
    'namaste':3,
    'napoleon':4,
    'natively':3,
    'nameless':2,
    'namely':2,
    'nameplate':2,
    'namesake':2,
    'narrated':3,
    'nausea':3,
    'necessitated':5,
    'nefarious':4,
    'negotiation':5,
    'negotiator':5,
    'negotiate':4,
    'nene':2,
    'neoclassical':5,
    'neodymium':5,
    'neonatal':4,
    'neoplastic':4,
    'neoplasm':3,
    'neoprene':3,
    'neon':2,
    'necktie':2,
    'negatively':4,
    'neisseria':4,
    'nested':2,
    'netted':2,
    'neurophysiology':7,
    'neurol':1,
    'niacin':3,
    'nitrile':2,
    'nicely':2,
    'nickelodeon':5,
    'nightingale':3,
    'nineteen':2,
    'nineteenth':2,
    'ninety':2,
    'notifiable':5,
    'notifier':4,
    'notifying':4,
    'notorious':4,
    'notoriously':5,
    'nodded':2,
    'nominated':4,
    'nominee':3,
    'noncompliance':4,
    'nonlinear':4,
    'nonlinearity':6,
    'nontrivial':4,
    'nonviolence':4,
    'nonetheless':3,
    'noted':2,
    'notebook':2,
    'noteworthy':3,
    'nuances':3,
    'nuance':2,
    'nucleation':4,
    'nuclear':3,
    'nuclei':3,
    'nucleoside':4,
    'nucleotide':4,
    'nucleon':3,
    'nucleus':3,
    'nutrient':3,
    'nursery':2,
    'oasis':3,
    'obedience':4,
    'obedient':4,
    'obi':2,
    'obituaries':5,
    'obituary':5,
    'oboe':2,
    'oca':2,
    'oceanographic':6,
    'oceanic':4,
    'ochre':2,
    'odious':3,
    'ogre':2,
    'oka':2,
    'ol':2,
    'olympiad':4,
    'omitted':3,
    'oocyte':3,
    'opa':2,
    'opiate':3,
    'opium':3,
    'opinionated':5,
    'ora':2,
    'orientation':5,
    'oriental':4,
    'orientated':5,
    'orient':3,
    'originated':5,
    'ova':2,
    'ovarian':4,
    'overdue':3,
    'overlying':4,
    'overrated':4,
    'overseer':4,
    'oversee':3,
    'overseeing':4,
    'oyez':2,
    'objectively':4,
    'oblivion':4,
    'oblivious':4,
    'obsidian':4,
    'obsoleted':4,
    'obvious':3,
    'obviously':4,
    'obstet':1,
    'occupier':4,
    'oeuvre':2,
    'oeuvres':2,
    'officiating':5,
    'ombre':2,
    'omelet':2,
    'ongoing':3,
    'oneness':2,
    'oneself':2,
    'oracles':3,
    'orchestrated':4,
    'orienteering':5,
    'orig':1,
    'osteoarthritis':6,
    'osteopathic':5,
    'osteoporosis':6,
    'osteopathy':5,
    'outdated':3,
    'outfitted':3,
    'outgoing':3,
    'outlier':3,
    'outlying':3,
    'outsole':2,
    'over':1,
    'oxygenated':5,
    'pt':2,
    'padre':2,
    'paleontology':6,
    'papaya':3,
    'pariah':3,
    'parietal':4,
    'parochial':4,
    'parole':2,
    'paseo':3,
    'patio':3,
    'patios':3,
    'patriarchal':4,
    'patriarchy':4,
    'patriarch':3,
    'patriot':3,
    'patriotic':4,
    'paves':2,
    'pacifier':4,
    'pacemaker':3,
    'paediatrics':4,
    'painted':2,
    'palladium':4,
    'palliative':4,
    'pale':1,
    'panacea':4,
    'pancreatitis':5,
    'pancreas':3,
    'pancreatic':4,
    'pandemonium':5,
    'pantheon':3,
    'pantie':2,
    'paranoia':4,
    'participated':5,
    'partying':3,
    'parted':2,
    'passe':2,
    'passes':2,
    'passionately':4,
    'pasted':2,
    'patriotism':4,
    'patted':2,
    'pathol':1,
    'pavement':2,
    'payable':3,
    'payee':2,
    'payer':2,
    'paying':2,
    'payoff':2,
    'pecuniary':5,
    'pedestrian':4,
    'pediatrician':5,
    'pediatric':4,
    'pediatrics':4,
    'penile':2,
    'peony':3,
    'periodicity':6,
    'period':3,
    'periodical':5,
    'periodically':6,
    'petroleum':4,
    'petunia':4,
    'peaceful':2,
    'peacefully':3,
    'peacemaker':3,
    'peacemaking':3,
    'peacetime':2,
    'pedigree':3,
    'peeing':2,
    'pele':1,
    'peng':2,
    'percentile':3,
    'perceptual':4,
    'percutaneous':5,
    'perdue':2,
    'perennial':4,
    'perforated':4,
    'periodontal':5,
    'periodic':4,
    'permeability':6,
    'permeable':4,
    'permeate':3,
    'perpetrated':4,
    'perpetuity':5,
    'perpetual':4,
    'perpetually':5,
    'perpetuated':5,
    'perpetuating':5,
    'perpetuate':4,
    'persecuted':4,
    'perverted':3,
    'perches':2,
    'petrol':1,
    'phobia':3,
    'photocopier':5,
    'photoelectric':5,
    'photovoltaic':5,
    'phoebe':2,
    'phosphorylated':5,
    'physiological':6,
    'physiologic':5,
    'physiotherapy':6,
    'physiology':5,
    'pianist':3,
    'pianos':3,
    'piazza':3,
    'piety':3,
    'piet':2,
    'pioneer':3,
    'pion':2,
    'pious':2,
    'pituitary':5,
    'picayune':3,
    'pictorial':4,
    'pickled':2,
    'piecemeal':2,
    'piecewise':2,
    'pile':1,
    'pinhole':2,
    'pipeline':2,
    'pistachio':4,
    'pitted':2,
    'pixie':2,
    'pizzeria':4,
    'playa':2,
    'playas':2,
    'placement':2,
    'planetarium':5,
    'plasmodium':4,
    'plated':2,
    'platelet':2,
    'playable':3,
    'player':2,
    'pleaded':2,
    'pliable':3,
    'plier':2,
    'pliers':2,
    'plutonium':4,
    'podiatry':4,
    'podium':3,
    'poem':2,
    'poetic':3,
    'poetics':3,
    'poetry':3,
    'polio':3,
    'policeman':3,
    'politely':3,
    'politeness':3,
    'potassium':4,
    'potentiometer':6,
    'poinsettia':4,
    'pointed':2,
    'polluted':3,
    'polyamide':4,
    'polyester':4,
    'polyethylene':5,
    'polynomial':5,
    'polyurethane':5,
    'polyunsaturated':7,
    'pole':1,
    'pombe':2,
    'pomegranate':3,
    'portrayal':3,
    'porcelain':2,
    'portfolio':4,
    'positively':4,
    'posse':2,
    'posterior':4,
    'postulated':4,
    'postgraduate':4,
    'potted':2,
    'prairie':2,
    'prayer':2,
    'preamble':3,
    'precarious':4,
    'preceded':3,
    'precisely':3,
    'precluded':3,
    'predominately':5,
    'preeminent':4,
    'preemption':3,
    'preemptive':3,
    'preempt':2,
    'prematurely':4,
    'premenstrual':4,
    'premium':3,
    'preoccupation':5,
    'preoccupied':4,
    'preorder':3,
    'presidio':4,
    'pretended':3,
    'previous':3,
    'predicated':4,
    'prelim':1,
    'premiere':3,
    'premises':3,
    'presbyterian':5,
    'president':2,
    'prettier':3,
    'prettiest':3,
    'primordial':4,
    'prion':2,
    'prior':2,
    'priority':4,
    'priory':3,
    'prius':2,
    'privately':3,
    'priceless':2,
    'principe':3,
    'principled':3,
    'procurement':3,
    'productively':4,
    'profile':2,
    'profusely':3,
    'progressively':4,
    'projectile':3,
    'proletariat':5,
    'promiscuous':4,
    'promoted':3,
    'pronunciation':5,
    'propionate':4,
    'proportionately':5,
    'proprietary':5,
    'proprietor':4,
    'proprietorship':5,
    'propriety':4,
    'prorated':3,
    'prospectuses':4,
    'protea':3,
    'protease':3,
    'protege':3,
    'proteolytic':5,
    'protozoa':4,
    'proverbial':4,
    'provided':3,
    'prosecuted':4,
    'prying':2,
    'pseudoephedrine':5,
    'psoriasis':4,
    'psychiatrist':4,
    'psychiatry':4,
    'psychiatric':4,
    'psychoanalysis':6,
    'psychoanalytic':6,
    'puree':2,
    'purifying':4,
    'punctuation':4,
    'punctual':3,
    'punctuality':5,
    'purposeful':3,
    'purposely':3,
    'pursuance':3,
    'pursuant':3,
    'pursuing':3,
    'pursue':2,
    'purely':2,
    'quatre':2,
    'qualifier':4,
    'qualifying':4,
    'qualitatively':5,
    'quantifiable':5,
    'quantifying':4,
    'quantitatively':5,
    'quarrying':3,
    'quartile':2,
    'queuing':2,
    'quiescent':3,
    'quiet':2,
    'quieter':3,
    'quietly':3,
    'quickie':2,
    'quilted':2,
    'quintile':2,
    'quizzes':2,
    'quoted':2,
    'radiation':4,
    'radiative':4,
    'radiator':4,
    'radial':3,
    'radian':3,
    'radiance':3,
    'radiant':3,
    'radiated':4,
    'radiating':4,
    'radiate':3,
    'radii':3,
    'radio':3,
    'radioactivity':7,
    'radioactive':5,
    'radiographic':5,
    'radiological':6,
    'radiologic':5,
    'radionuclide':5,
    'radiotherapy':6,
    'radiography':5,
    'radiologist':5,
    'radiology':5,
    'radiometer':5,
    'radios':3,
    'radium':3,
    'radius':3,
    'raia':2,
    'rapier':3,
    'ratios':3,
    'rationale':3,
    'ravioli':4,
    'raya':2,
    'races':2,
    'racecourse':2,
    'racetrack':2,
    'raceway':2,
    'raffles':2,
    'ragged':2,
    'rainier':3,
    'rallying':3,
    'rallye':2,
    'rangefinder':3,
    'rarely':2,
    'rated':2,
    'rayon':2,
    'reagent':3,
    'realignment':4,
    'reactivation':5,
    'reactivated':5,
    'reactivate':4,
    'reaction':3,
    'reactionary':5,
    'reactive':3,
    'reactor':3,
    'react':2,
    'readmission':4,
    'reaffirm':3,
    'real':2,
    'realestate':4,
    'realisation':5,
    'reality':4,
    'realising':4,
    'realistically':6,
    'realistic':4,
    'realise':3,
    'realised':3,
    'realism':3,
    'realist':3,
    'realizing':4,
    'realize':3,
    'realized':3,
    'reallocation':5,
    'really':3,
    'realtor':3,
    'realty':3,
    'reals':2,
    'reappear':3,
    'reapply':3,
    'reappointment':4,
    'rearranging':4,
    'rearrange':3,
    'rearranged':3,
    'reassess':3,
    'reassessment':4,
    'reassignment':4,
    'reassurance':4,
    'reassure':3,
    'reauthorization':6,
    'recalculated':5,
    'recipient':4,
    'recited':3,
    'recompile':3,
    'reconstituted':5,
    'reconstructed':4,
    'redesignated':5,
    'redistributed':5,
    'reducer':2,
    'reelection':4,
    'reenter':3,
    'reentry':3,
    'refinement':3,
    'reformulated':5,
    'refrigerated':5,
    'refueling':4,
    'refuted':3,
    'regalia':4,
    'regenerated':5,
    'rehabilitated':6,
    'reimburse':3,
    'reimbursed':3,
    'reincarnation':5,
    'reinforce':3,
    'reinstall':3,
    'reinstated':4,
    'reinstate':3,
    'reinsurance':4,
    'reintegration':5,
    'reintroduction':5,
    'reintroduced':4,
    'reinvent':3,
    'reinvestment':4,
    'reissue':3,
    'reissued':3,
    'reiterate':4,
    'related':3,
    'relaying':3,
    'reliable':4,
    'reliance':3,
    'reliant':3,
    'relocated':4,
    'relying':3,
    'remediation':5,
    'remedial':4,
    'remitted':3,
    'remotely':3,
    'renunciation':5,
    'reopen':3,
    'reorder':3,
    'reorganization':6,
    'reorganize':4,
    'reorganized':4,
    'repeated':3,
    'replacement':3,
    'repudiation':5,
    'reputed':3,
    'requirement':3,
    'resale':2,
    'reschedule':3,
    'resided':3,
    'residual':4,
    'resourceful':3,
    'respectively':4,
    'responsiveness':4,
    'restated':3,
    'restatement':3,
    'restricted':3,
    'retaliation':5,
    'retaliate':4,
    'retarded':3,
    'rete':2,
    'retiree':3,
    'retirement':3,
    'retransmitted':4,
    'reunification':6,
    'reunited':4,
    'reunite':3,
    'reunion':3,
    'reusable':4,
    'reusing':3,
    'reuse':2,
    'reused':2,
    'revaluation':5,
    'revue':2,
    'rebbe':2,
    'recipe':3,
    'reconcile':3,
    'recreation':4,
    'recreational':5,
    'recreate':3,
    'rectifier':4,
    'referee':3,
    'refugee':3,
    'refer':1,
    'reggae':2,
    'regulated':4,
    'relegated':4,
    'rencontre':3,
    'renovated':4,
    'replicated':4,
    'reptile':2,
    'requiem':3,
    'rescuing':3,
    'rescue':2,
    'residue':3,
    'retroactive':4,
    'retrospectively':5,
    'revenue':3,
    'reverie':3,
    'rhea':2,
    'rheology':4,
    'rhinestone':2,
    'rhodium':3,
    'ria':2,
    'rial':2,
    'rialto':3,
    'riot':2,
    'riparian':4,
    'riyal':2,
    'riches':2,
    'ridicule':3,
    'ridgeway':2,
    'ritual':3,
    'riveted':3,
    'rodeo':3,
    'ros':2,
    'roselle':2,
    'rotisserie':4,
    'role':1,
    'rookie':2,
    'rooted':2,
    'rosebud':2,
    'rosemary':3,
    'rosewood':2,
    'routinely':3,
    'rounded':2,
    'routed':2,
    'royal':2,
    'royalty':3,
    'rupee':2,
    'rupiah':3,
    'rudely':2,
    'ruffled':2,
    'rugged':2,
    'rule':1,
    'sabre':2,
    'sacred':2,
    'sade':2,
    'salient':3,
    'safeguard':2,
    'safely':2,
    'safety':2,
    'sagebrush':2,
    'salvia':3,
    'sale':1,
    'salesman':2,
    'salespeople':3,
    'salesperson':3,
    'salted':2,
    'sanctuaries':4,
    'sanctuary':4,
    'sanded':2,
    'saturated':4,
    'saute':2,
    'saucepan':2,
    'sayer':2,
    'saying':2,
    'scale':1,
    'scapegoat':2,
    'scariest':3,
    'scarcely':2,
    'scarecrow':2,
    'scenario':4,
    'scenarios':4,
    'sceptre':2,
    'schedule':2,
    'schizophrenia':5,
    'sciatica':4,
    'scientific':4,
    'scientist':3,
    'science':2,
    'scion':2,
    'scoliosis':4,
    'scorpion':3,
    'scoreboard':2,
    'scorecard':2,
    'scoreless':2,
    'scratches':2,
    'scrubbed':2,
    'secluded':3,
    'securely':3,
    'selenium':4,
    'selectively':4,
    'semiotics':4,
    'senile':2,
    'sepia':3,
    'sequoia':3,
    'serial':3,
    'serialization':6,
    'serialize':4,
    'serialized':4,
    'serious':3,
    'seriously':4,
    'seriousness':4,
    'severely':3,
    'secretarial':5,
    'secretariat':5,
    'sectarian':4,
    'seeing':2,
    'segregated':4,
    'seismology':3,
    'semiannual':5,
    'sempre':2,
    'senatorial':5,
    'sensual':3,
    'sensuality':5,
    'sensuous':3,
    'sentient':3,
    'senseless':2,
    'separated':4,
    'separately':4,
    'serrated':3,
    'services':3,
    'sesame':3,
    'sexiest':3,
    'sexual':3,
    'sexuality':5,
    'sharia':3,
    'shaded':2,
    'shakedown':2,
    'shale':1,
    'shambles':2,
    'shameful':2,
    'shameless':2,
    'shamelessly':3,
    'shareholder':3,
    'sharpie':2,
    'shea':2,
    'shingles':2,
    'shoreline':2,
    'shredded':2,
    'sienna':3,
    'sierra':3,
    'siesta':3,
    'simultaneously':6,
    'sinuses':3,
    'sided':2,
    'sidebar':2,
    'sideboard':2,
    'sidekick':2,
    'sideline':2,
    'sidelines':2,
    'sideshow':2,
    'sidestep':2,
    'sidewalk':2,
    'sidewall':2,
    'sideways':2,
    'sidewinder':3,
    'signifying':4,
    'sighted':2,
    'silhouetted':4,
    'silhouette':3,
    'simian':3,
    'simplifying':4,
    'simulated':4,
    'simultaneous':5,
    'sincerely':3,
    'sinfonia':4,
    'singles':2,
    'sited':2,
    'situation':4,
    'situational':5,
    'situated':4,
    'skateboard':2,
    'skatepark':2,
    'skiing':2,
    'slated':2,
    'slaying':2,
    'sleeveless':2,
    'slotted':2,
    'smile':1,
    'smokeless':2,
    'smoothie':2,
    'snowmobile':3,
    'snowshoe':2,
    'snowshoeing':3,
    'sobriety':4,
    'societal':4,
    'society':4,
    'socioeconomic':7,
    'sociological':6,
    'sociologist':5,
    'sociology':5,
    'sodium':3,
    'solarium':4,
    'soloist':3,
    'sophisticated':5,
    'soviet':3,
    'sockeye':2,
    'sole':1,
    'solely':2,
    'sombre':2,
    'somebody':3,
    'someday':2,
    'somehow':2,
    'someplace':2,
    'something':2,
    'sometime':2,
    'sometimes':2,
    'somewhat':2,
    'somewhere':2,
    'sortie':2,
    'sorely':2,
    'soreness':2,
    'soya':2,
    'spacecraft':2,
    'spaceship':2,
    'sparsely':2,
    'speciation':4,
    'speciality':5,
    'specifier':4,
    'specifying':4,
    'spectacles':3,
    'spectre':2,
    'speculated':4,
    'spirited':3,
    'spiritual':4,
    'spirituality':6,
    'spiritualism':5,
    'spokesman':2,
    'spokeswoman':3,
    'spontaneity':5,
    'spontaneous':4,
    'spontaneously':5,
    'spotted':2,
    'sprayer':2,
    'spurious':3,
    'spying':2,
    'squarely':2,
    'stadium':3,
    'stadiums':3,
    'stagecoach':2,
    'stale':1,
    'stalemate':2,
    'stated':2,
    'statue':2,
    'statehood':2,
    'stateless':2,
    'stately':2,
    'statement':2,
    'stateroom':2,
    'stateside':2,
    'statewide':2,
    'statesman':2,
    'staying':2,
    'stereotyping':5,
    'stereotype':4,
    'stereotyped':4,
    'sterile':2,
    'stile':1,
    'stimulated':4,
    'stipulated':4,
    'stoic':2,
    'stockpile':2,
    'stole':1,
    'stonewall':2,
    'stoneware':2,
    'storefront':2,
    'storehouse':2,
    'strangely':2,
    'strangeness':2,
    'strayer':2,
    'strenuous':3,
    'streptomyces':4,
    'strontium':3,
    'studio':3,
    'studying':3,
    'style':1,
    'sucre':2,
    'suicidal':4,
    'suicide':3,
    'suing':2,
    'superior':4,
    'superiority':6,
    'superannuation':6,
    'superfluous':4,
    'superseded':4,
    'supervisory':4,
    'supremely':3,
    'subcutaneous':5,
    'subdivided':4,
    'subdue':2,
    'submitted':3,
    'subordinated':5,
    'subsidiaries':5,
    'subsidiary':5,
    'substantiated':5,
    'substantiate':4,
    'substituted':4,
    'subterranean':5,
    'suburbia':4,
    'successively':4,
    'suited':2,
    'sumptuous':3,
    'sundae':2,
    'sundial':3,
    'sunglasses':3,
    'supplier':3,
    'supplying':3,
    'super':1,
    'surreal':3,
    'surrealism':4,
    'surveying':3,
    'surveyor':3,
    'surely':2,
    'surety':2,
    'sweetie':2,
    'syringes':3,
    'symbiosis':4,
    'symbiotic':4,
    'symposia':4,
    'symposium':4,
    'syndicated':4,
    'synovial':4,
    'tales':2,
    'tabulated':4,
    'tactile':2,
    'tachycardia':5,
    'tadpole':2,
    'takedown':2,
    'talented':3,
    'tale':1,
    'talkie':2,
    'tally':1,
    'tangled':2,
    'tapioca':4,
    'tasted':2,
    'tasteful':2,
    'tastefully':3,
    'tasteless':2,
    'tattooing':3,
    'taxpayer':3,
    'tbsp':1,
    'tedious':3,
    'tele':1,
    'tensile':2,
    'tenuous':3,
    'tented':2,
    'teriyaki':4,
    'terminated':4,
    'terrestrial':4,
    'terrier':3,
    'terrifying':4,
    'territorial':5,
    'testes':2,
    'testifying':4,
    'testimonial':5,
    'textile':2,
    'textual':3,
    'theater':3,
    'theatre':3,
    'theatrical':4,
    'theism':2,
    'theologian':5,
    'theological':5,
    'theophylline':4,
    'theorem':3,
    'theoretical':5,
    'theoretically':6,
    'theoretic':4,
    'theorist':3,
    'theory':3,
    'theocracy':4,
    'theology':4,
    'theosophy':4,
    'thereby':2,
    'therefor':2,
    'therefore':2,
    'therefrom':2,
    'thereto':2,
    'therewith':2,
    'thiamine':3,
    'thorium':3,
    'thoroughbred':3,
    'threonine':3,
    'tiara':3,
    'tilapia':4,
    'tiniest':3,
    'titanium':4,
    'titled':2,
    'titre':2,
    'tibia':3,
    'tibial':3,
    'tidewater':3,
    'tilde':2,
    'tile':1,
    'timbre':2,
    'timekeeping':3,
    'timeless':2,
    'timeliness':3,
    'timely':2,
    'timepiece':2,
    'timetable':3,
    'tireless':2,
    'tirelessly':3,
    'tiresome':2,
    'tissue':2,
    'topiary':4,
    'totalitarian':6,
    'totalitarianism':7,
    'toffee':2,
    'toile':1,
    'toluene':3,
    'tole':1,
    'tongued':1,
    'tongues':1,
    'tootsie':2,
    'touche':2,
    'trachea':3,
    'tracheal':3,
    'trademark':2,
    'tradesman':2,
    'trainee':2,
    'transferee':3,
    'transmitted':3,
    'transported':3,
    'transsexual':4,
    'trattoria':4,
    'trenches':2,
    'triad':2,
    'triage':2,
    'trial':2,
    'triangle':3,
    'triangulation':5,
    'triangular':4,
    'triennial':4,
    'trier':2,
    'trio':2,
    'trios':2,
    'triumphant':3,
    'triumph':2,
    'tritium':3,
    'trivia':3,
    'trivial':3,
    'trivium':3,
    'truancy':3,
    'truer':2,
    'truncated':3,
    'trustee':2,
    'trying':2,
    'tryout':2,
    'tui':2,
    'tuition':3,
    'tumultuous':4,
    'tutorial':4,
    'tufted':2,
    'tulle':1,
    'turion':3,
    'twentieth':3,
    'tying':2,
    'typeface':2,
    'typescript':2,
    'typeset':2,
    'typesetting':3,
    'typewriter':3,
    'typo':1,
    'tyrant':1,
    'ubi':2,
    'udo':2,
    'uni':2,
    'unifying':4,
    'unitarian':5,
    'united':3,
    'uranium':4,
    'urea':3,
    'usual':3,
    'usually':4,
    'uta':2,
    'uti':2,
    'utilitarian':6,
    'utile':2,
    'ultimately':4,
    'ultraviolet':2,
    'unaccounted':4,
    'unadjusted':4,
    'unaffected':4,
    'unaffiliated':6,
    'unambiguous':5,
    'unannotated':5,
    'unanticipated':6,
    'unassisted':4,
    'unattended':4,
    'unaudited':4,
    'unbiased':3,
    'unbonded':3,
    'unbounded':3,
    'unbranded':3,
    'unbridled':3,
    'unbundled':3,
    'uncharted':3,
    'uncirculated':5,
    'uncomplicated':5,
    'unconnected':4,
    'uncontested':4,
    'uncorrelated':5,
    'uncorrected':4,
    'uncover':2,
    'undated':3,
    'undecided':4,
    'undefeated':4,
    'undeniable':5,
    'undeniably':5,
    'undetected':4,
    'undergoing':4,
    'undergraduate':5,
    'underlie':3,
    'underlying':4,
    'understated':4,
    'understatement':4,
    'undivided':4,
    'undifferentiated':7,
    'undisputed':4,
    'undistributed':5,
    'undoing':3,
    'undocumented':5,
    'undue':2,
    'undying':3,
    'unedited':4,
    'uneducated':5,
    'unexpected':4,
    'unfortunately':5,
    'unforeseen':3,
    'unfounded':3,
    'unfunded':3,
    'ungraded':3,
    'ungrateful':3,
    'unincorporated':6,
    'uninhabited':5,
    'uninhibited':5,
    'unintended':4,
    'uninterrupted':5,
    'unleaded':3,
    'unlikely':3,
    'unlimited':4,
    'unlisted':3,
    'unmoderated':5,
    'unmounted':3,
    'unneeded':3,
    'unobstructed':4,
    'unprecedented':5,
    'unprotected':4,
    'unrated':3,
    'unreal':3,
    'unrealistic':5,
    'unrealized':4,
    'unrelated':4,
    'unreliable':5,
    'unreported':4,
    'unrestricted':4,
    'unregulated':5,
    'unsaturated':5,
    'unscented':3,
    'unsettled':3,
    'unsolicited':5,
    'unsubstantiated':6,
    'unsupported':4,
    'untested':3,
    'unthreaded':3,
    'untimely':3,
    'untitled':3,
    'untranslated':4,
    'untreated':3,
    'untrue':2,
    'untrusted':3,
    'unusual':4,
    'unusually':5,
    'unwanted':3,
    'unwarranted':4,
    'unweighted':3,
    'univ':1,
    'updated':3,
    'upgraded':3,
    'useful':2,
    'usefully':3,
    'usefulness':3,
    'useless':2,
    'valerian':4,
    'vanadium':4,
    'varietal':4,
    'variety':4,
    'vario':3,
    'vaccinated':4,
    'vacuum':3,
    'vacuums':3,
    'vaguely':2,
    'vagueness':2,
    'valuable':4,
    'valuation':4,
    'value':2,
    'vale':1,
    'varia':3,
    'variability':6,
    'variable':4,
    'variation':4,
    'variational':5,
    'variance':3,
    'variant':3,
    'various':3,
    'variegated':4,
    'varying':3,
    'vaudeville':2,
    'vaulted':2,
    'vegetarian':5,
    'vegetarianism':6,
    'venue':2,
    'verifiable':5,
    'verifier':4,
    'verifying':4,
    'versatile':3,
    'vertices':3,
    'vested':2,
    'veterinarian':6,
    'via':2,
    'viability':5,
    'viable':3,
    'viaduct':3,
    'vial':2,
    'vicarious':4,
    'vide':2,
    'vier':2,
    'viola':3,
    'violated':4,
    'violating':4,
    'violate':3,
    'violence':3,
    'violent':3,
    'violet':3,
    'violin':3,
    'violinist':4,
    'violoncello':5,
    'viol':2,
    'viruses':3,
    'vitae':2,
    'vibrio':3,
    'victoria':4,
    'victorious':4,
    'viceroy':2,
    'video':3,
    'vigilante':4,
    'vile':1,
    'vindicated':4,
    'vineland':2,
    'vireo':3,
    'virtual':3,
    'virtually':4,
    'virtuoso':4,
    'virtuous':3,
    'virtue':2,
    'visual':3,
    'visualisation':6,
    'visualization':6,
    'visualizing':5,
    'visualize':4,
    'visualized':4,
    'visually':4,
    'vitreous':3,
    'voluptuous':4,
    'voyeur':2,
    'voyeurism':3,
    'voided':2,
    'volatile':3,
    'vortices':3,
    'voted':2,
    'voyager':3,
    'voyage':2,
    'vying':2,
    'watershed':3,
    'wale':1,
    'walleye':2,
    'warrior':3,
    'warehousing':3,
    'warehouse':2,
    'wasted':2,
    'wasteful':2,
    'wasteland':2,
    'waveform':2,
    'waveguide':2,
    'wavelength':2,
    'wavelet':2,
    'wealthier':3,
    'wealthiest':3,
    'wedded':2,
    'weenie':2,
    'weighted':2,
    'wellbeing':3,
    'werewolf':2,
    'whale':1,
    'whatsoever':4,
    'whereby':2,
    'wherefore':2,
    'while':1,
    'whitefish':2,
    'whiteness':2,
    'whitetail':2,
    'whoever':3,
    'whosoever':4,
    'whole':1,
    'wholeheartedly':4,
    'wholesaler':3,
    'wholesaling':3,
    'wholesale':2,
    'wholesome':2,
    'wicked':2,
    'widely':2,
    'widespread':2,
    'winded':2,
    'wireless':2,
    'wirelessly':3,
    'wiretap':2,
    'wiretapping':3,
    'wisteria':4,
    'wooded':2,
    'worsted':2,
    'worthwhile':2,
    'wounded':2,
    'wretched':2,
    'wrongdoing':3,
    'xenia':3,
    'xenophobia':5,
    'yippee':2,
    'yuan':2,
    'yule':1,
    'zaire':2,
    'zeolite':3,
    'zirconia':4,
    'zirconium':4,
    'zodiac':3,
    'zoological':5,
    'zoophilia':5,
    'zooplankton':4,
    'zoology':4,
    'zombie':2,
    
    'karaoke':4,
    'wanted':2,
    'café':2,
    'doppelgänger':4,
    'voilà':2,
    'jalapeño':4,
    'wishes':2,
    'dishes':2,
    'cliché':2,
    'piña colada': 5


    // Add more problematic words as needed
};

// Separating problematic phrases for clear handling
const problematicPhrases = {
    'déjà vu': 3,
    'piña colada': 5,
    'habeas corpus':5,
    'bon appétit':4,
    // Add other problematic phrases here
};

    // Function to count syllables in a word
    function countSyllables(word) {
        word = word.toLowerCase(); // Lowercase

        if (problematicWords.hasOwnProperty(word)) {
            return problematicWords[word];
        }

        // Splitting hyphenated and compound words
        if (word.includes('-')) {
            return word.split('-').reduce((acc, part) => acc + countSyllables(part), 0);
        }

        word = word.replace(/\W/g, ''); // Remove non-alphabetic characters
        if (word.length <= 3) { return 1; }

        word = word.replace(/'s$/, ''); // Possessive case

        // Improved regex for vowel groups
        const vowelGroups = word.match(/[aeiouy]+/g);

        if (!vowelGroups) return 0; // No vowels, no syllables

        let syllableCount = vowelGroups.length;

        // Handling silent 'e' and specific word endings
        if (word.endsWith('e') && syllableCount > 1 && !/le$/.test(word)) {
            syllableCount -= 1; // Silent 'e' at the end, except for 'le'
        }

        if ((word.endsWith('es') || word.endsWith('ed')) && syllableCount > 1) {
            const secondLastChar = word.charAt(word.length - 3);
            if (!'aeiouy'.includes(secondLastChar)) {
                syllableCount -= 1; // Subtract for silent 'es'/'ed'
            }
        }

        return syllableCount;
    }

    // Function to calculate the total syllables in userInput
    function calculateSyllables(userInput) {
    let totalSyllables = 0;

    // Check and handle problematic phrases first
    Object.keys(problematicPhrases).forEach(phrase => {
        const regex = new RegExp("\\b" + phrase + "\\b", "gi"); // Match the phrase case-insensitively
        const matches = userInput.match(regex);
        if (matches) {
            totalSyllables += problematicPhrases[phrase] * matches.length; // Add syllables for each occurrence
            userInput = userInput.replace(regex, ""); // Remove the phrase from the input text
        }
    });

    // Now process the remaining input text for individual words
    const words = userInput.trim().split(/\s+/);
    words.forEach(word => {
        if (word.length === 0) return; // Skip empty words
        totalSyllables += countSyllables(word);
    });

    return totalSyllables;
}


    textInput.addEventListener('input', updateCounts);

    copyButton.addEventListener('click', async () => {
        try {
            await navigator.clipboard.writeText(textInput.value);
            copyButton.textContent = 'Copied!';
            setTimeout(() => copyButton.textContent = 'Copy Text', 2000);
        } catch (err) {
            console.error('Failed to copy:', err);
        }
    });

    updateCounts(); // Initialize counts on page load
});













// Grab elements
const selectElement = (selector) => {
    const element = document.querySelector(selector);
    if(element) return element;
    throw new Error(`Something went wrong! Make sure that ${selector} exists/is typed correctly.`);  
};

//Nav styles on scroll
const scrollHeader = () =>{
    const navbarElement = selectElement('#header');
    if(this.scrollY >= 15) {
        navbarElement.classList.add('activated');
    } else {
        navbarElement.classList.remove('activated');
    }
}

window.addEventListener('scroll', scrollHeader);

// Open menu & search pop-up
const menuToggleIcon = selectElement('#menu-toggle-icon');
//const formOpenBtn = selectElement('#search-icon');
const formCloseBtn = selectElement('#form-close-btn');
const searchContainer = selectElement('#search-form-container');

const toggleMenu = () =>{
    const mobileMenu = selectElement('#menu');
    mobileMenu.classList.toggle('activated');
    menuToggleIcon.classList.toggle('activated');
}

menuToggleIcon.addEventListener('click', toggleMenu);

// Open/Close search form popup
//formOpenBtn.addEventListener('click', () => searchContainer.classList.add('activated'));
formCloseBtn.addEventListener('click', () => searchContainer.classList.remove('activated'));
// -- Close the search form popup on ESC keypress
window.addEventListener('keyup', (event) => {
    if(event.key === 'Escape') searchContainer.classList.remove('activated');
});













