document.addEventListener('DOMContentLoaded', function() {
    const textInput = document.getElementById('vc-textInput');
    const commaCountElement = document.getElementById('vc-vowelCount'); // Re-using for comma count
    const letterCountElement = document.getElementById('vc-letterCount');
    const wordCountElement = document.getElementById('vc-wordCount');
    const copyButton = document.getElementById('vc-copyButton');
    const maxCharacters = 1000000; // Maximum character limit set to a million

    function updateCounts() {
        const text = textInput.value;

        // Display warning and prevent further counting if character limit is exceeded
        if (text.length > maxCharacters) {
            const message = '1,000,000 character limit exceeded';
            commaCountElement.textContent = message;
            letterCountElement.textContent = message;
            wordCountElement.textContent = message;
            return; // Exit the function to stop further execution
        }

        const commaCount = (text.match(/,/g) || []).length;
        const words = text.match(/\S+/g) || [];
        const letters = text.match(/[a-z]/gi) || [];

        // Update the HTML with the counts
        commaCountElement.textContent = commaCount;
        letterCountElement.textContent = letters.length;
        wordCountElement.textContent = words.length;
    }

    textInput.addEventListener('input', updateCounts);

    copyButton.addEventListener('click', async () => {
        if (navigator.clipboard) {
            try {
                await navigator.clipboard.writeText(textInput.value);
                copyButton.textContent = 'Copied!';
                setTimeout(() => {
                    copyButton.textContent = 'Copy Text';
                }, 2000);
            } catch (err) {
                console.error('Failed to copy:', err);
            }
        } else {
            textInput.select();
            document.execCommand('copy');
            copyButton.textContent = 'Copied!';
            setTimeout(() => {
                copyButton.textContent = 'Copy Text';
            }, 2000);
        }
    });

    // Initialize counts on page load
    updateCounts();
});

// Grab elements
const selectElement = (selector) => {
    const element = document.querySelector(selector);
    if(element) return element;
    throw new Error(`Something went wrong! Make sure that ${selector} exists/is typed correctly.`);
};

// Nav styles on scroll
const scrollHeader = () => {
    const navbarElement = selectElement('#header');
    if (this.scrollY >= 15) {
        navbarElement.classList.add('activated');
    } else {
        navbarElement.classList.remove('activated');
    }
}

window.addEventListener('scroll', scrollHeader);

// Open menu & search pop-up
const menuToggleIcon = selectElement('#menu-toggle-icon');
const formCloseBtn = selectElement('#form-close-btn');
const searchContainer = selectElement('#search-form-container');

const toggleMenu = () => {
    const mobileMenu = selectElement('#menu');
    mobileMenu.classList.toggle('activated');
    menuToggleIcon.classList.toggle('activated');
}

menuToggleIcon.addEventListener('click', toggleMenu);

formCloseBtn.addEventListener('click', () => searchContainer.classList.remove('activated'));

// Close the search form popup on ESC keypress
window.addEventListener('keyup', (event) => {
    if (event.key === 'Escape') searchContainer.classList.remove('activated');
});
