// Filename: twittercharactercounter.js


    const chineseUnicode = /[\u3040-\u30ff\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\uff66-\uff9f]/g;

// Prints Character and Word length on textarea input
function callFunction(){
    
    let characters = getCharLength()
    
    
  
    //var countChinese = (getUserInput().match(chineseUnicode) || []).length;
    document.getElementById('typed').innerHTML = countChinese();

    
    document.getElementById("div5").innerHTML =  characters;
    //document.getElementById("typed").innerHTML = characters;
    
    document.getElementById("truncation").innerHTML =  getSpaceCount();
    document.getElementById("words").innerHTML =  wordEstimate();
    document.getElementById("about").innerHTML =  getLetterCount();
    document.getElementById("numbers").innerHTML =  getNumberCount();

    
}

function countChinese() {
    let countChinese = (getUserInput().match(chineseUnicode) || []).length;
    return countChinese;
}

function wordEstimate() {
    
    if (countChinese() <= 0) {
        return 0;
    }
    
    let words = Math.round(countChinese() * .7);

    return words;
}

// Get user input from textarea
function getUserInput(){
    
    // Assign user input to variable
    var userInput = document.getElementById("userWord").value;
    console.log("test" + userInput)
    return userInput;
}

// Get length of characters in textarea
function getCharLength() {
    /*
    if (getUserInput().length <= 3000){
        document.getElementById("typed").style.color = "black";
        document.getElementById("div5").style.color = "black";
        return getUserInput().length;
    }
    else {
        document.getElementById("typed").style.color = "red";
        document.getElementById("div5").style.color = "red";
        return getUserInput().length;
    }
    */
    return getUserInput().length;
}

  


// Get count of whitespace characters
function getSpaceCount() {
    if (!getUserInput().match(/\s/g)){
        return 0;
    }
    else {
        return getUserInput().match(/\s/g).length;
    }
}


// Get count of letters
function getLetterCount() {
    if (!getUserInput().match(/[a-z]/gi)){
        return 0;
    }
    else {
        return getUserInput().match(/[a-z]/gi).length;
    }
}

// Get count of numbers
function getNumberCount() {
    if (!getUserInput().match(/[0-9]/g)){
        return 0;
    }
    else { 
        return getUserInput().match(/[0-9]/g).length;
    }
}



// Copy text in textarea with button click
function copy() {
    

      if (getUserInput().length > 0){
    
          var copyText = document.getElementById("userWord");
          copyText.select();
          copyText.setSelectionRange(0, 99999)
          document.execCommand("copy");
          
          var x = document.getElementById("snackbar");
          x.className = "show";
          setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
      }
      else{
          var x = document.getElementById("snackbarFail");
          x.className = "show";
          setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);
      }
      
}
    
// Clear text in textarea with button click
function clearContent() {
    document.getElementById("userWord").value='';
    callFunction();
}











// Grab elements
const selectElement = (selector) => {
    const element = document.querySelector(selector);
    if(element) return element;
    throw new Error(`Something went wrong! Make sure that ${selector} exists/is typed correctly.`);  
};

//Nav styles on scroll
const scrollHeader = () =>{
    const navbarElement = selectElement('#header');
    if(this.scrollY >= 15) {
        navbarElement.classList.add('activated');
    } else {
        navbarElement.classList.remove('activated');
    }
}

window.addEventListener('scroll', scrollHeader);

// Open menu & search pop-up
const menuToggleIcon = selectElement('#menu-toggle-icon');
const formOpenBtn = selectElement('#search-icon');
const formCloseBtn = selectElement('#form-close-btn');
const searchContainer = selectElement('#search-form-container');

const toggleMenu = () =>{
    const mobileMenu = selectElement('#menu');
    mobileMenu.classList.toggle('activated');
    menuToggleIcon.classList.toggle('activated');
}

menuToggleIcon.addEventListener('click', toggleMenu);

// Open/Close search form popup
formOpenBtn.addEventListener('click', () => searchContainer.classList.add('activated'));
formCloseBtn.addEventListener('click', () => searchContainer.classList.remove('activated'));
// -- Close the search form popup on ESC keypress
window.addEventListener('keyup', (event) => {
    if(event.key === 'Escape') searchContainer.classList.remove('activated');
});

// Switch theme/add to local storage
const body = document.body;
const themeToggleBtn = selectElement('#theme-toggle-btn');
const currentTheme = localStorage.getItem('currentTheme');

// Check to see if there is a theme preference in local Storage, if so add the ligt theme to the body
if (currentTheme) {
    body.classList.add('light-theme');
}

themeToggleBtn.addEventListener('click', function () {
    // Add light theme on click
    body.classList.toggle('light-theme');

    // If the body has the class of light theme then add it to local Storage, if not remove it
    if (body.classList.contains('light-theme')) {
        localStorage.setItem('currentTheme', 'themeActive');
    } else {
        localStorage.removeItem('currentTheme');
    }
});
































