document.addEventListener('DOMContentLoaded', function() {
    const textInput = document.getElementById('vc-textInput');
    const adverbCountElement = document.getElementById('vc-adverbCount');
    const characterCountElement = document.getElementById('vc-characterCount');
    const adverbListElement = document.getElementById('vc-adverbList');
    const copyButton = document.getElementById('vc-copyButton');

    // Lists for adverb detection adjustments
    const falsePositives = ['family', 'sly', 'kelly', 'early', 'only', 'acromegaly', 
'actorly', 
'ally', 
'ally', 
'aly', 
'anatoly', 
'anencephaly', 
'anomaly', 
'apply', 
'armaly', 
'assembly', 
'assembly', 
'auntly', 
'badly', 
'baily', 
'bally', 
'barfly', 
'bayly', 
'bearly', 
'beastly', 
'beesly', 
'beggarly', 
'belly', 
'bely', 
'beverly', 
'bi-weekly', 
'bibliophily', 
'big-sisterly', 
'billy', 
'billy', 
'bimonthly', 
'biweekly', 
'blackfly', 
'blackguardly', 
'blakely', 
'blowfly', 
'bly', 
'bly', 
'bobbly', 
'bodily', 
'bolly', 
'booly', 
'botfly', 
'brachycephaly', 
'brambly', 
'brawly', 
'brierly', 
'bristly', 
'brolly', 
'brotherly', 
'bubbly', 
'bully', 
'burly', 
'business-friendly', 
'butterfly', 
'caerphilly', 
'caerphilly', 
'caramelly', 
'carly', 
'casserly', 
'cecily', 
'celly', 
'chantilly', 
'chantilly', 
'chilly', 
'chiropterophily', 
'churchly', 
'cicely', 
'cicely', 
'citizenly', 
'cleanly', 
'clerkly', 
'clovelly', 
'coaly', 
'cobbly', 
'coberly', 
'colly', 
'comely', 
'comply', 
'comradely', 
'connally', 
'connelly', 
'connolly', 
'contumely', 
'cooly', 
'costly', 
'coulibaly', 
'courtly', 
'cousinly', 
'cowardly', 
'crackly', 
'craftsmanly', 
'cranefly', 
'crawly', 
'creaturely', 
'creepy-crawly', 
'crilly', 
'crinkly', 
'crumbly', 
'crumply', 
'cuddly', 
'cully', 
'cully', 
'curly', 
'curmudgeonly', 
'dailly', 
'daily', 
'daily', 
'dally', 
'dally', 
'daly', 
'damselfly', 
'dancerly', 
'dangly', 
'dastardly', 
'daughterly', 
'dayly', 
'deadly', 
'dealy', 
'deathly', 
'designerly', 
'diddly', 
'dilly', 
'dilly-dally', 
'dimply', 
'disapply', 
'disassembly', 
'disorderly', 
'doily', 
'dolly', 
'dolly', 
'dolphin-friendly', 
'donnelly', 
'doolally', 
'dooly', 
'dovely', 
'dragonfly', 
'drawly', 
'dribbly', 
'drizzly', 
'drooly', 
'dudely', 
'duopoly', 
'ealy', 
'early', 
'early', 
'earthly', 
'easterly', 
'easterly', 
'eco-friendly', 
'elderly', 
'ely', 
'emily', 
'entomophily', 
'environment-friendly', 
'esterly', 
'everly', 
'exencephaly', 
'family', 
'family-friendly', 
'farrelly', 
'fatherly', 
'feely', 
'feely', 
'felly', 
'fiddly', 
'filly', 
'firebelly', 
'firefly', 
'fishbelly', 
'fleshly', 
'fly', 
'fly', 
'folly', 
'footmanly', 
'fortnightly', 
'freckly', 
'freely', 
'freight-only', 
'friendly', 
'frilly', 
'fruitfly', 
'gadfly', 
'gamely', 
'gangly', 
'gately', 
'gentlemanly', 
'gentlewomanly', 
'ghastly', 
'ghostly', 
'giggly', 
'gilly', 
'girl-friendly', 
'girlfriendly', 
'girly', 
'gnarly', 
'goatly', 
'gobbly', 
'godfatherly', 
'godly', 
'golightly', 
'golly', 
'goodly', 
'googly', 
'gospelly', 
'gradely', 
'grandfatherly', 
'grandmotherly', 
'grantly', 
'gravelly', 
'greenfly', 
'greenly', 
'grimly', 
'grisly', 
'gristly', 
'grizzly', 
'growly', 
'gruelly', 
'grumbly', 
'guestly', 
'gully', 
'gully', 
'gurgly', 
'half-hourly', 
'half-yearly', 
'hally', 
'hambly', 
'headly', 
'headmasterly', 
'healy', 
'heartly', 
'heavenly', 
'helly', 
'hepatomegaly', 
'hepatosplenomegaly', 
'heterosexually', 
'hevenly', 
'hillbilly', 
'hilly', 
'holly', 
'holly', 
'holy', 
'homely', 
'homily', 
'horsefly', 
'hourly', 
'housefly', 
'housewifely', 
'hover-fly', 
'hoverfly', 
'hurly', 
'hurly-burly', 
'husbandly', 
'hydrocephaly', 
'imply', 
'interactionally', 
'italy', 
'jangly', 
'jelly', 
'jiggly', 
'jilly', 
'jingly', 
'jolly', 
'jolly', 
'joly', 
'jowly', 
'jubbly', 
'july', 
'jungly', 
'kealy', 
'keely', 
'kelly', 
'kelly', 
'kenealy', 
'kennelly', 
'kiely', 
'kimberly', 
'kindly', 
'kingly', 
'kiraly', 
'knightly', 
'knobbly', 
'knubbly', 
'knuckly', 
'laggardly', 
'lally', 
'lally', 
'lawyerly', 
'leisurely', 
'likely', 
'lilly', 
'lily', 
'lily', 
'lively', 
'lively', 
'lolly', 
'lolly', 
'lonely', 
'lordly', 
'lovely', 
'lovely', 
'loverly', 
'lowly', 
'lully', 
'lurvely', 
'luvverly', 
'ly', 
'maidenly', 
'male-friendly', 
'maly', 
'manly', 
'manly', 
'mannerly', 
'marbly', 
'marly', 
'masterly', 
'matronly', 
'mattingly', 
'mayfly', 
'mccully', 
'mealy', 
'measly', 
'megalencephaly', 
'melancholy', 
'metally', 
'microcephaly', 
'milly', 
'misapply', 
'miserly', 
'moberly', 
'modelly', 
'molly', 
'molly', 
'moly', 
'monopoly', 
'monopoly', 
'monthly', 
'mosely', 
'motherly', 
'muddly', 
'mullally', 
'mullaly', 
'multiply', 
'muscly', 
'neely', 
'neighbourly', 
'nelly', 
'nelly', 
'niggardly', 
'niggly', 
'nightly', 
'no-fly', 
'non-daily', 
'nonfamily', 
'north-easterly', 
'north-westerly', 
'northeasterly', 
'northerly', 
'northwesterly', 
'nubbly', 
'nunnally', 
'offaly', 
'oily', 
'oligopoly', 
'olly', 
'oly', 
'only', 
'orderly', 
'orly', 
'ornithophily', 
'other-worldly', 
'otherworldly', 
'outfly', 
'overfly', 
'overfriendly', 
'oversupply', 
'ozone-friendly', 
'painterly', 
'pally', 
'paly', 
'panoply', 
'pauly', 
'pearly', 
'pebbly', 
'peely-wally', 
'pelly', 
'philately', 
'philly', 
'piccadilly', 
'piccadilly', 
'piddly', 
'pimply', 
'ply', 
'polly', 
'poly', 
'portly', 
'postmultiply', 
'pot-belly', 
'potbelly', 
'pre-emptively', 
'premultiply', 
'prickly', 
'priestly', 
'princely', 
'profamily', 
'protractedly', 
'psychobilly', 
'pully', 
'purply', 
'quarterly', 
'queenly', 
'radio-friendly', 
'rally', 
'rambly', 
'rascally', 
'rattly', 
'read-only', 
'readerly', 
'reapply', 
'reassembly', 
'reilly', 
'relly', 
'rely', 
'reply', 
'resupply', 
'rielly', 
'ripply', 
'rockabilly', 
'rolly', 
'roly-poly', 
'rubbly', 
'ruffianly', 
'rumbly', 
'rustly', 
'saintly', 
'sally', 
'sally', 
'samely', 
'sandfly', 
'savourly', 
'sawfly', 
'scally', 
'scally', 
'scaly', 
'scholarly', 
'schoolmasterly', 
'schoolmistressly', 
'sclerodactyly', 
'scrabbly', 
'scraggly', 
'scrambly', 
'scrawly', 
'scribbly', 
'scrolly', 
'scully', 
'sealy', 
'seely', 
'seemly', 
'self-assembly', 
'selly', 
'shaly', 
'shambly', 
'shapely', 
'shelly', 
'shelly', 
'shingly', 
'shively', 
'shoggly', 
'shoogly', 
'shuffly', 
'sicily', 
'sickly', 
'sightly', 
'silly', 
'singlehandedly', 
'sisterly', 
'skelly', 
'skelly', 
'skilly', 
'slatternly', 
'slovenly', 
'sluggardly', 
'sly', 
'sly', 
'smelly', 
'snavely', 
'snivelly', 
'snuffly', 
'snuggly', 
'softly-softly', 
'soldierly', 
'solly', 
'south-easterly', 
'south-westerly', 
'southeasterly', 
'southerly', 
'southwesterly', 
'spangly', 
'sparkly', 
'speckly', 
'spindly', 
'spinsterly', 
'splenomegaly', 
'sprightly', 
'spritely', 
'squally', 
'squiggly', 
'squirrely', 
'stanly', 
'stately', 
'statesmanly', 
'steely', 
'stepfamily', 
'stilly', 
'stokely', 
'straggly', 
'stubbly', 
'studly', 
'subassembly', 
'subfamily', 
'sully', 
'summerly', 
'superfamily', 
'superfly', 
'supply', 
'surly', 
'swirly', 
'swivelly', 
'tally', 
'tally', 
'tangly', 
'teacherly', 
'telly', 
'termly', 
'test-fly', 
'thessaly', 
'this-worldly', 
'three-ply', 
'tickly', 
'tiddly', 
'tilly', 
'tilly', 
'timely', 
'tingly', 
'tinkly', 
'tinselly', 
'towardly', 
'toxophily', 
'treacly', 
'trebly', 
'trembly', 
'trichinopoly', 
'trolly', 
'tully', 
'twice-weekly', 
'twice-yearly', 
'twiddly', 
'twilly', 
'twinkly', 
'twirly', 
'two-ply', 
'twombly', 
'ugly', 
'unbrotherly', 
'uncleanly', 
'uncomely', 
'uncourtly', 
'underbelly', 
'underly', 
'undersupply', 
'unearthly', 
'unfatherly', 
'unfriendly', 
'ungainly', 
'ungentlemanly', 
'ungodly', 
'unholy', 
'unkingly', 
'unlikely', 
'unlively', 
'unlovely', 
'unmanly', 
'unmannerly', 
'unmotherly', 
'unneighbourly', 
'unreflectively', 
'unruly', 
'unsaintly', 
'unscholarly', 
'unseemly', 
'unshapely', 
'unsightly', 
'unsisterly', 
'unsleepingly', 
'unsoldierly', 
'untimely', 
'unwieldly', 
'unwifely', 
'unwomanly', 
'unworldly', 
'user-friendly', 
'user-unfriendly', 
'vasily', 
'viewly', 
'waffly', 
'waggly', 
'wally', 
'wally', 
'waly', 
'waterlily', 
'waverly', 
'weakly', 
'weaselly', 
'weatherly', 
'weatherly', 
'weekly', 
'weevilly', 
'welly', 
'welly', 
'westerly', 
'wheely', 
'whirly', 
'whistly', 
'whitefly', 
'whitely', 
'whitely', 
'wibbly', 
'wibbly-wobbly', 
'widdly', 
'wifely', 
'wiggly', 
'willy', 
'willy', 
'wily', 
'winterly', 
'wizardly', 
'wobbly', 
'womanly', 
'woolly', 
'wooly', 
'wordly', 
'worldly', 
'wriggly', 
'wrinkly', 
'writerly', 
'wurly', 
'yearly', 
'zimmerly',  

 




];
    const adjectivesEndingInLy = ['friendly', 'lovely', 'lively', 'silly', 'ugly'];
    const compoundWords = ['motherly', 'manly', 'ghastly'];
    const irregularAdverbs = [ 'altogether', 'again', 'above', 'alike', 'afresh', 'asunder', 'away', 'ahead', 'alone', 'anyway', 'abeam', 'aback', 'anywhere', 'almost', 'also', 'across', 'all', 'about', 'aside', 'astray', 'any', 'already', 'aburst', 'abloom', 'along', 'anyhow', 'aloud', 'afterward', 'abroad', 'ago', 'always', 'apart', 'abreast', 'aboard', 'awhile', 'anymore', 'after', 'ashore', 'alright', 'boiling', 'backward', 'by', 'best', 'backstage', 'bareback', 'back', 'bright', 'bloody', 'blooming', 'bias', 'brag', 'brief', 'better', 'burning', 'below', 'besides', 'being', 'broadcast', 'bang', 'behind', 'before', 'beyond', 'beforehand', 'beneath', 'black', 'clockwise', 'cheap', 'chance', 'cold', 'crescendo', 'clear', 'certain', 'causeless', 'collect', 'downstream', 'downward', 'downstairs', 'deep', 'downright', 'direct', 'dead', 'deaththy', 'dirty', 'double', 'down', 'dear', 'downhill', 'doubtless', 'eastwards', 'eachwhere', 'either', 'ever', 'easy', 'each', 'elsewise', 'earthwards', 'else', 'enough', 'endwise', 'elsewhere', 'edgeways', 'even', 'eastward', 'everywhere', 'east', 'eft', 'earthward', 'evermore', 'endways', 'edgewise', 'forward', 'free', 'firsthand', 'first', 'flat', 'fast', 'fivefold', 'fine', 'friday', 'forth', 'furthest', 'fresh', 'fourfold', 'far', 'fretful', 'full', 'farther', 'fair', 'furthermore', 'further', 'forthwith', 'forever', 'farthest', 'frontwards', 'good', 'gatewise', 'great', 'henceforth', 'high', 'heavy', 'hard', 'halfway', 'hitherto', 'home', 'hereinto', 'half', 'hereon', 'howso', 'honest', 'herein', 'homewards', 'hellward', 'hereinafter', 'hereby', 'hence', 'hereablout', 'here', 'however', 'higher', 'harder', 'headlong', 'homeward', 'inward', 'in', 'indeed', 'inwards', 'indoors', 'inasmuch', 'instead', 'inside', 'jump', 'just', 'knitwise', 'kinda', 'longest', 'likewise', 'low', 'lengthwise', 'les', 'landwards', 'leastwise', 'lots', 'lifeless', 'little', 'left', 'late', 'lot', 'less', 'long', 'leastways', 'leftward', 'lasciviousluy', 'loud', 'live', 'like', 'louder', 'last', 'large', 'later', 'lower', 'ladylike', 'leeward', 'landward', 'longwise', 'most', 'manywise', 'midships', 'maybe', 'mighty', 'midweek', 'meanwhile', 'midway', 'meantime', 'meet', 'magnetizing', 'monstrous', 'more', 'midst', 'moreover', 'netherward', 'northwestwards', 'northward', 'northwards', 'not', 'nightwards', 'now', 'northwestward', 'northeastward', 'northeastwards', 'noway', 'never', 'nighttime', 'nohow', 'other', 'oversoon', 'once', 'overmore', 'ones', 'othergates', 'over', 'overside', 'overleaf', 'outcept', 'online', 'overseas', 'overboard', 'otherwise', 'overmuch', 'opposite', 'outside', 'overhead', 'outwards', 'otherwhere', 'outdoors', 'onwards', 'onto', 'onward', 'others', 'oftentimes', 'overall', 'outward', 'overtime', 'ofttimes', 'often', 'obiter', 'otherways', 'please', 'pickaback', 'polewards', 'past', 'pretty', 'perhaps', 'pellmell', 'quicker', 'questward', 'rearward', 'right', 'rightward', 'rearwards', 'regardless', 'romeward', 'sometimes', 'shipward', 'seldom', 'seawards', 'same', 'saddleback', 'schoolward', 'someday', 'still', 'sinkward', 'soon', 'towards', 'today', 'townward', 'then', 'there', 'thenadays', 'thereby', 'toward', 'tonight', 'tofore', 'together', 'townwards', 'tantivy', 'tandem', 'through', 'tomorrow', 'twice', 'too', 'though', 'upward', 'unbeware', 'unnear', 'upbeat', 'upright', 'upside-down', 'upwards', 'unseldom', 'unlike', 'villageward', 'valleywards', 'villagewards', 'valleyward', 'violetward', 'very', 'vanward', 'when', 'wherever', 'worrisome', 'westwards', 'westward', 'whatever', 'well', 'whereas', 'whatsoever', 'whereby', 'wrong', 'while', 'woundy', 'widewhere', 'whenever', 'where', 'windward', 'yestermonth', 'yeomanlike', 'yearlong', 'yesterweek', 'yearward', 'yesternight', 'yesterday', 'yestercentury', 'yestereven', 'youthward', 'youthwards', 'yestertime', 'year-long', 'yestermorrow', 'zenithwards', 'zenithward', 'zionwards'

];

    function updateCounts() {
        const text = textInput.value.toLowerCase();
        const characters = text.length; // Get character count
        let foundWords = text.match(/\b\w+\b/gi) || [];

        let adverbs = [
        ...foundWords.filter(word => irregularAdverbs.includes(word)),
        ...foundWords.filter(word => 
            word.endsWith('ly') && 
            !falsePositives.includes(word) && 
            !adjectivesEndingInLy.includes(word) && 
            !compoundWords.includes(word)
        )
    ];

console.log('Identified adverbs:', adverbs);
console.log('Irregular adverbs list:', irregularAdverbs);
console.log('Text being analyzed:', text);
console.log('Words found:', foundWords);

if (text.includes('often')) {
    console.log('"Often" is definitely in the text.');
} else {
    console.log('"Often" is not found in the text.');
}

        // Concatenate counts with labels for display
        adverbCountElement.textContent = adverbs.length; // Assuming you want to keep the label "Adverbs" static in HTML
        characterCountElement.textContent = `Characters: ${characters}`;

        // Update the adverb list box
        const placeholderText = "Your adverb list will be displayed here after you enter text in the text-box above.";
        adverbListElement.textContent = text.length === 0 ? placeholderText :
            adverbs.length > 0 ? adverbs.join(', ') : "No adverbs detected.";
    }

    textInput.addEventListener('input', updateCounts);

    copyButton.addEventListener('click', async () => {
        if (navigator.clipboard) {
            try {
                await navigator.clipboard.writeText(textInput.value);
                copyButton.textContent = 'Copied!';
                setTimeout(() => {
                    copyButton.textContent = 'Copy Text';
                }, 2000);
            } catch (err) {
                console.error('Failed to copy:', err);
            }
        } else {
            textInput.select();
            document.execCommand('copy');
            copyButton.textContent = 'Copied!';
            setTimeout(() => {
                copyButton.textContent = 'Copy Text';
            }, 2000);
        }
    });

    // Initialize counts on page load
    updateCounts();
});




// Grab elements
const selectElement = (selector) => {
    const element = document.querySelector(selector);
    if(element) return element;
    throw new Error(`Something went wrong! Make sure that ${selector} exists/is typed correctly.`);  
};

//Nav styles on scroll
const scrollHeader = () =>{
    const navbarElement = selectElement('#header');
    if(this.scrollY >= 15) {
        navbarElement.classList.add('activated');
    } else {
        navbarElement.classList.remove('activated');
    }
}

window.addEventListener('scroll', scrollHeader);

// Open menu & search pop-up
const menuToggleIcon = selectElement('#menu-toggle-icon');
//const formOpenBtn = selectElement('#search-icon');
const formCloseBtn = selectElement('#form-close-btn');
const searchContainer = selectElement('#search-form-container');

const toggleMenu = () =>{
    const mobileMenu = selectElement('#menu');
    mobileMenu.classList.toggle('activated');
    menuToggleIcon.classList.toggle('activated');
}

menuToggleIcon.addEventListener('click', toggleMenu);

// Open/Close search form popup
//formOpenBtn.addEventListener('click', () => searchContainer.classList.add('activated'));
formCloseBtn.addEventListener('click', () => searchContainer.classList.remove('activated'));
// -- Close the search form popup on ESC keypress
window.addEventListener('keyup', (event) => {
    if(event.key === 'Escape') searchContainer.classList.remove('activated');
});









