require '_h2ph_pre.ph';

unless(defined(&_VM_PAGE_H)) {
    eval 'sub _VM_PAGE_H () {1;}' unless defined(&_VM_PAGE_H);
    if(defined(&__cplusplus)) {
    }
    if(defined( &_KERNEL) || defined( &_KMEMUSER)) {
	eval("sub SE_NOSTAT () { 0; }") unless defined(&SE_NOSTAT);
	eval("sub SE_STAT () { 1; }") unless defined(&SE_STAT);
	eval("sub SE_SHARED () { 0; }") unless defined(&SE_SHARED);
	eval("sub SE_EXCL () { 1; }") unless defined(&SE_EXCL);
	eval("sub P_RECLAIM () { 0; }") unless defined(&P_RECLAIM);
	eval("sub P_NO_RECLAIM () { 1; }") unless defined(&P_NO_RECLAIM);
	if(defined( &_LOCKTEST) || defined( &_MPSTATS)) {
	    eval 'sub SE_DEFAULT () { &SE_STAT;}' unless defined(&SE_DEFAULT);
	} else {
	    eval 'sub SE_DEFAULT () { &SE_NOSTAT;}' unless defined(&SE_DEFAULT);
	}
    }
    if(defined(&DEBUG)) {
	eval 'sub VM_STATS () {1;}' unless defined(&VM_STATS);
    }
    if(defined(&VM_STATS)) {
	eval 'sub VM_STAT_ADD {
	    local($stat) = @_;
    	    eval q(($stat)++);
	}' unless defined(&VM_STAT_ADD);
    } else {
	eval 'sub VM_STAT_ADD {
	    local($stat) = @_;
    	    eval q();
	}' unless defined(&VM_STAT_ADD);
    }
    if(defined(&_KERNEL)) {
	eval 'sub page_struct_lock {
	    local($pp) = @_;
    	    eval q( &mutex_enter( &page_llock));
	}' unless defined(&page_struct_lock);
	eval 'sub page_struct_unlock {
	    local($pp) = @_;
    	    eval q( &mutex_exit( &page_llock));
	}' unless defined(&page_struct_unlock);
    }
    require 'sys/t_lock.ph';
    require 'vm/hat.ph';
    eval 'sub PAGE_HASHSZ () { &page_hashsz;}' unless defined(&PAGE_HASHSZ);
    eval 'sub PAGE_HASHAVELEN () {4;}' unless defined(&PAGE_HASHAVELEN);
    eval 'sub PAGE_HASHVPSHIFT () {6;}' unless defined(&PAGE_HASHVPSHIFT);
    eval 'sub PAGE_HASH_FUNC {
        local($vp, $off) = @_;
	    eval q(((( >>  &PAGESHIFT) + (($vp) >>  &PAGE_HASHVPSHIFT)) & ( &PAGE_HASHSZ - 1)));
    }' unless defined(&PAGE_HASH_FUNC);
    if(defined(&_KERNEL)) {
	eval 'sub PG_EXCL () {0x0001;}' unless defined(&PG_EXCL);
	eval 'sub PG_WAIT () {0x0002;}' unless defined(&PG_WAIT);
	eval 'sub PG_PHYSCONTIG () {0x0004;}' unless defined(&PG_PHYSCONTIG);
	eval 'sub PG_MATCH_COLOR () {0x0008;}' unless defined(&PG_MATCH_COLOR);
	eval 'sub se_trylock {
	    local($lock, $se) = @_;
    	    eval q((($se) ==  &SE_EXCL ? ((*$lock) == 0? ( &THREAD_KPRI_REQUEST(), ((*($lock)) = -1), 1) : 0) : ((*$lock) >= 0? ((*($lock))++, 1) : 0)));
	}' unless defined(&se_trylock);
	eval 'sub se_tryupgrade {
	    local($lock) = @_;
    	    eval q((*($lock) == 1? ((*($lock)) = -1, 1) : 0));
	}' unless defined(&se_tryupgrade);
	eval 'sub se_unlock {
	    local($lock) = @_;
    	    eval q((*($lock))--);
	}' unless defined(&se_unlock);
	eval 'sub se_nolock {
	    local($x) = @_;
    	    eval q((*($x) == 0));
	}' unless defined(&se_nolock);
	eval 'sub se_assert {
	    local($x) = @_;
    	    eval q((*($x) > 0|| *($x) == -1));
	}' unless defined(&se_assert);
	eval 'sub se_shared_assert {
	    local($x) = @_;
    	    eval q((*($x) > 0));
	}' unless defined(&se_shared_assert);
	eval 'sub se_excl_assert {
	    local($x) = @_;
    	    eval q((*($x) == -1));
	}' unless defined(&se_excl_assert);
	eval 'sub se_shared_lock {
	    local($x) = @_;
    	    eval q((*($x) > 0));
	}' unless defined(&se_shared_lock);
	eval 'sub PG_FREE_LIST () {1;}' unless defined(&PG_FREE_LIST);
	eval 'sub PG_CACHE_LIST () {2;}' unless defined(&PG_CACHE_LIST);
	eval 'sub PG_LIST_TAIL () {0;}' unless defined(&PG_LIST_TAIL);
	eval 'sub PG_LIST_HEAD () {1;}' unless defined(&PG_LIST_HEAD);
    }
    eval 'sub P_MOD () {0x1;}' unless defined(&P_MOD);
    eval 'sub P_REF () {0x2;}' unless defined(&P_REF);
    eval 'sub P_PNC () {0x4;}' unless defined(&P_PNC);
    eval 'sub P_TNC () {0x8;}' unless defined(&P_TNC);
    eval 'sub P_RO () {0x10;}' unless defined(&P_RO);
    eval 'sub PP_ISMOD {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &  &P_MOD));
    }' unless defined(&PP_ISMOD);
    eval 'sub PP_ISREF {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &  &P_REF));
    }' unless defined(&PP_ISREF);
    eval 'sub PP_ISNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm & ( &P_PNC| &P_TNC)));
    }' unless defined(&PP_ISNC);
    eval 'sub PP_ISPNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &  &P_PNC));
    }' unless defined(&PP_ISPNC);
    eval 'sub PP_ISTNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &  &P_TNC));
    }' unless defined(&PP_ISTNC);
    eval 'sub PP_ISRO {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &  &P_RO));
    }' unless defined(&PP_ISRO);
    eval 'sub PP_SETMOD {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm |=  &P_MOD));
    }' unless defined(&PP_SETMOD);
    eval 'sub PP_SETREF {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm |=  &P_REF));
    }' unless defined(&PP_SETREF);
    eval 'sub PP_SETREFMOD {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm |= ( &P_REF| &P_MOD)));
    }' unless defined(&PP_SETREFMOD);
    eval 'sub PP_SETPNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm |=  &P_PNC));
    }' unless defined(&PP_SETPNC);
    eval 'sub PP_SETTNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm |=  &P_TNC));
    }' unless defined(&PP_SETTNC);
    eval 'sub PP_SETRO {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm |=  &P_RO));
    }' unless defined(&PP_SETRO);
    eval 'sub PP_SETREFRO {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm |= ( &P_REF| &P_RO)));
    }' unless defined(&PP_SETREFRO);
    eval 'sub PP_SETREFMODRO {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm |= ( &P_REF| &P_MOD| &P_RO)));
    }' unless defined(&PP_SETREFMODRO);
    eval 'sub PP_CLRMOD {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &= ~ &P_MOD));
    }' unless defined(&PP_CLRMOD);
    eval 'sub PP_CLRREF {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &= ~ &P_REF));
    }' unless defined(&PP_CLRREF);
    eval 'sub PP_CLRREFMOD {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &= ~( &P_REF| &P_MOD)));
    }' unless defined(&PP_CLRREFMOD);
    eval 'sub PP_CLRPNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &= ~ &P_PNC));
    }' unless defined(&PP_CLRPNC);
    eval 'sub PP_CLRTNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &= ~ &P_TNC));
    }' unless defined(&PP_CLRTNC);
    eval 'sub PP_CLRRO {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &= ~ &P_RO));
    }' unless defined(&PP_CLRRO);
    if(defined(&__cplusplus)) {
    }
}
1;
