require '_h2ph_pre.ph';

unless(defined(&_VM_HAT_H)) {
    eval 'sub _VM_HAT_H () {1;}' unless defined(&_VM_HAT_H);
    require 'sys/types.ph';
    require 'sys/t_lock.ph';
    require 'vm/faultcode.ph';
    require 'vm/devpage.ph';
    require 'sys/kstat.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub HAT_PRIVSIZ () {4;}' unless defined(&HAT_PRIVSIZ);
    if(defined(&_KERNEL)) {
	if(defined(&notdef)) {
	} else {
	    eval 'sub hat_asload () {
	        eval q();
	    }' unless defined(&hat_asload);
	    eval 'sub hat_exec {
	        local($oas, $ostka, $stksz, $nas, $nstka, $flag) = @_;
    		eval q(0);
	    }' unless defined(&hat_exec);
	}
	eval 'sub HAT_LOAD () {0x00;}' unless defined(&HAT_LOAD);
	eval 'sub HAT_LOCK () {0x01;}' unless defined(&HAT_LOCK);
	eval 'sub HAT_UNLOCK () {0x02;}' unless defined(&HAT_UNLOCK);
	eval 'sub HAT_NOSYNCLOAD () {0x04;}' unless defined(&HAT_NOSYNCLOAD);
	eval 'sub HAT_ADVLOAD () {0x08;}' unless defined(&HAT_ADVLOAD);
	eval 'sub HAT_NOFAULT () {0x10;}' unless defined(&HAT_NOFAULT);
	eval 'sub HAT_FREEPP () {0x20;}' unless defined(&HAT_FREEPP);
	eval 'sub HAT_RELEPP () {0x40;}' unless defined(&HAT_RELEPP);
	eval 'sub HAT_NOCONSIST () {0x80;}' unless defined(&HAT_NOCONSIST);
	eval 'sub HAT_LOADSHARED () {0x100;}' unless defined(&HAT_LOADSHARED);
	eval 'sub HAT_KMEM () {0x10000;}' unless defined(&HAT_KMEM);
	eval 'sub HAT_DONTALLOC () {0;}' unless defined(&HAT_DONTALLOC);
	eval 'sub HAT_ALLOC () {1;}' unless defined(&HAT_ALLOC);
	eval 'sub HAT_UNLOAD () {0x0;}' unless defined(&HAT_UNLOAD);
	eval 'sub HAT_TMPUNLOAD () {0x1;}' unless defined(&HAT_TMPUNLOAD);
	eval 'sub HAT_NOSYNCUNLOAD () {0x2;}' unless defined(&HAT_NOSYNCUNLOAD);
	eval 'sub HAT_UNLOCKUNLOAD () {0x4;}' unless defined(&HAT_UNLOCKUNLOAD);
	eval 'sub HAT_UNMAP () {0x8;}' unless defined(&HAT_UNMAP);
	eval 'sub HAT_MAP () {0x0;}' unless defined(&HAT_MAP);
	eval 'sub HAT_DONTZERO () {0x0;}' unless defined(&HAT_DONTZERO);
	eval 'sub HAT_ZERORM () {0x1;}' unless defined(&HAT_ZERORM);
	eval 'sub HAT_STOPON_REF () {0x2;}' unless defined(&HAT_STOPON_REF);
	eval 'sub HAT_STOPON_MOD () {0x4;}' unless defined(&HAT_STOPON_MOD);
	eval 'sub HAT_STOPON_RM () {( &HAT_STOPON_REF |  &HAT_STOPON_MOD);}' unless defined(&HAT_STOPON_RM);
	eval 'sub HAT_DONE () {0x0;}' unless defined(&HAT_DONE);
	eval 'sub HAT_RESTART () {0x1;}' unless defined(&HAT_RESTART);
	eval 'sub HAT_VAC_DONE () {0x2;}' unless defined(&HAT_VAC_DONE);
	eval 'sub HAT_CACHE () {0x0;}' unless defined(&HAT_CACHE);
	eval 'sub HAT_UNCACHE () {0x1;}' unless defined(&HAT_UNCACHE);
	eval 'sub HAT_TMPNC () {0x2;}' unless defined(&HAT_TMPNC);
	eval 'sub HAT_STRICTORDER () {0x0000;}' unless defined(&HAT_STRICTORDER);
	eval 'sub HAT_UNORDERED_OK () {0x0100;}' unless defined(&HAT_UNORDERED_OK);
	eval 'sub HAT_MERGING_OK () {0x0200;}' unless defined(&HAT_MERGING_OK);
	eval 'sub HAT_LOADCACHING_OK () {0x0300;}' unless defined(&HAT_LOADCACHING_OK);
	eval 'sub HAT_STORECACHING_OK () {0x0400;}' unless defined(&HAT_STORECACHING_OK);
	eval 'sub HAT_ORDER_MASK () {0x0700;}' unless defined(&HAT_ORDER_MASK);
	eval 'sub HAT_NEVERSWAP () {0x0000;}' unless defined(&HAT_NEVERSWAP);
	eval 'sub HAT_STRUCTURE_BE () {0x0800;}' unless defined(&HAT_STRUCTURE_BE);
	eval 'sub HAT_STRUCTURE_LE () {0x1000;}' unless defined(&HAT_STRUCTURE_LE);
	eval 'sub HAT_ENDIAN_MASK () {0x1800;}' unless defined(&HAT_ENDIAN_MASK);
	eval 'sub HATOP_ALLOC {
	    local($hat, $as) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_alloc}))($hat, $as));
	}' unless defined(&HATOP_ALLOC);
	eval 'sub HATOP_SETUP {
	    local($as, $flag) = @_;
    	    eval q((*($as)-> ($a_hat->{hat_op}->{h_setup}))($as, $flag));
	}' unless defined(&HATOP_SETUP);
	eval 'sub HATOP_FREE {
	    local($hat, $as) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_free}))($hat, $as));
	}' unless defined(&HATOP_FREE);
	eval 'sub HATOP_DUP {
	    local($hat, $as, $newas) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_dup}))($hat, $as, $newas));
	}' unless defined(&HATOP_DUP);
	eval 'sub HATOP_SWAPIN {
	    local($hat, $as) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_swapin}))($hat, $as));
	}' unless defined(&HATOP_SWAPIN);
	eval 'sub HATOP_SWAPOUT {
	    local($hat, $as) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_swapout}))($hat, $as));
	}' unless defined(&HATOP_SWAPOUT);
	eval 'sub HATOP_MEMLOAD {
	    local($hat, $as, $addr, $pp, $prot, $flags) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_memload}))($hat, $as, $addr, $pp, $prot, $flags));
	}' unless defined(&HATOP_MEMLOAD);
	eval 'sub HATOP_DEVLOAD {
	    local($hat, $as, $addr, $dp, $pf, $prot, $flags) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_devload}))($hat, $as, $addr, $dp, $pf, $prot, $flags));
	}' unless defined(&HATOP_DEVLOAD);
	eval 'sub HATOP_CONTIG_MEMLOAD {
	    local($hat, $as, $addr, $pp, $prot, $flags, $len) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_contig_memload}))($hat, $as, $addr, $pp, $prot, $flags, $len));
	}' unless defined(&HATOP_CONTIG_MEMLOAD);
	eval 'sub HATOP_CONTIG_DEVLOAD {
	    local($hat, $as, $addr, $dp, $pf, $prot, $flags, $len) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_contig_devload}))($hat, $as, $addr, $dp, $pf, $prot, $flags, $len));
	}' unless defined(&HATOP_CONTIG_DEVLOAD);
	eval 'sub HATOP_UNLOCK {
	    local($hat, $as, $addr, $len) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_unlock}))($hat, $as, $addr, $len));
	}' unless defined(&HATOP_UNLOCK);
	eval 'sub HATOP_FAULT {
	    local($hat, $addr) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_fault}))($hat, $addr));
	}' unless defined(&HATOP_FAULT);
	eval 'sub HATOP_CHGPROT {
	    local($hat, $as, $addr, $len, $vprot) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_chgprot}))($as, $addr, $len, $vprot));
	}' unless defined(&HATOP_CHGPROT);
	eval 'sub HATOP_UNLOAD {
	    local($hat, $as, $addr, $len, $flags) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_unload}))($as, $addr, $len, $flags));
	}' unless defined(&HATOP_UNLOAD);
	eval 'sub HATOP_SYNC {
	    local($hat, $as, $addr, $len, $flags) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_sync}))($as, $addr, $len, $flags));
	}' unless defined(&HATOP_SYNC);
	eval 'sub HATOP_PAGEUNLOAD {
	    local($hat, $pp, $hme) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_pageunload}))($pp, $hme));
	}' unless defined(&HATOP_PAGEUNLOAD);
	eval 'sub HATOP_PAGESYNC {
	    local($hat, $pp, $hme, $flag) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_pagesync}))($hat, $pp, $hme, $flag));
	}' unless defined(&HATOP_PAGESYNC);
	eval 'sub HATOP_PAGECACHECTL {
	    local($hsw, $pp, $flag) = @_;
    	    eval q((*($hsw)-> ($hsw_ops->{h_pagecachectl}))($pp, $flag));
	}' unless defined(&HATOP_PAGECACHECTL);
	eval 'sub HATOP_GETKPFNUM {
	    local($hat, $addr) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_getkpfnum}))($addr));
	}' unless defined(&HATOP_GETKPFNUM);
	eval 'sub HATOP_GETPFNUM {
	    local($hat, $as, $addr) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_getpfnum}))($as, $addr));
	}' unless defined(&HATOP_GETPFNUM);
	eval 'sub HATOP_MAP {
	    local($hat, $as, $addr, $len, $flags) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_map}))($hat, $as, $addr, $len, $flags));
	}' unless defined(&HATOP_MAP);
	eval 'sub HATOP_PROBE {
	    local($hat, $as, $addr) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_probe}))($hat, $as, $addr));
	}' unless defined(&HATOP_PROBE);
	eval 'sub HATOP_SHARE {
	    local($hat, $das, $daddr, $sas, $saddr, $len) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_share}))($das, $daddr, $sas, $saddr, $len));
	}' unless defined(&HATOP_SHARE);
	eval 'sub HATOP_UNSHARE {
	    local($hat, $as, $addr, $len) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_unshare}))($as, $addr, $len));
	}' unless defined(&HATOP_UNSHARE);
	eval 'sub HATOP_UNMAP {
	    local($hat, $as, $addr, $len, $flags) = @_;
    	    eval q((*($hat)-> ($hat_op->{h_unmap}))($as, $addr, $len, $flags));
	}' unless defined(&HATOP_UNMAP);
    }
    eval 'sub HRM_SHIFT () {4;}' unless defined(&HRM_SHIFT);
    eval 'sub HRM_BYTES () {(1<<  &HRM_SHIFT);}' unless defined(&HRM_BYTES);
    eval 'sub HRM_PAGES () {(( &HRM_BYTES *  &NBBY) / 2);}' unless defined(&HRM_PAGES);
    eval 'sub HRM_PGPERBYTE () {( &NBBY/2);}' unless defined(&HRM_PGPERBYTE);
    eval 'sub HRM_PGBYTEMASK () {( &HRM_PGPERBYTE-1);}' unless defined(&HRM_PGBYTEMASK);
    eval 'sub HRM_PGOFFMASK () {(( &HRM_PGPERBYTE-1) <<  &MMU_PAGESHIFT);}' unless defined(&HRM_PGOFFMASK);
    eval 'sub HRM_BASEOFFSET () {((( &MMU_PAGESIZE *  &HRM_PAGES) - 1));}' unless defined(&HRM_BASEOFFSET);
    eval 'sub HRM_BASEMASK () {(~( &HRM_BASEOFFSET));}' unless defined(&HRM_BASEMASK);
    eval 'sub HRM_BASESHIFT () {( &MMU_PAGESHIFT + ( &HRM_SHIFT + 2));}' unless defined(&HRM_BASESHIFT);
    eval 'sub HRM_PAGEMASK () {( &MMU_PAGEMASK ^  &HRM_BASEMASK);}' unless defined(&HRM_PAGEMASK);
    eval 'sub HRM_HASHSIZE () {0x200;}' unless defined(&HRM_HASHSIZE);
    eval 'sub HRM_HASHMASK () {( &HRM_HASHSIZE - 1);}' unless defined(&HRM_HASHMASK);
    eval 'sub HRM_BLIST_INCR () {0x200;}' unless defined(&HRM_BLIST_INCR);
    eval 'sub HRM_SWSMONID () {1;}' unless defined(&HRM_SWSMONID);
    if(defined(&_KERNEL)) {
	eval 'sub HATLOCK_PAGE_ENTER {
	    local($pp) = @_;
    	    eval q((( ($hat_lockops->{hl_page_enter}))($pp)));
	}' unless defined(&HATLOCK_PAGE_ENTER);
	eval 'sub HATLOCK_PAGE_EXIT {
	    local($pp) = @_;
    	    eval q((( ($hat_lockops->{hl_page_exit}))($pp)));
	}' unless defined(&HATLOCK_PAGE_EXIT);
	eval 'sub HATLOCK_HAT_ENTER {
	    local($as) = @_;
    	    eval q((( ($hat_lockops->{hl_hat_enter}))($as)));
	}' unless defined(&HATLOCK_HAT_ENTER);
	eval 'sub HATLOCK_HAT_EXIT {
	    local($as) = @_;
    	    eval q((( ($hat_lockops->{hl_hat_exit}))($as)));
	}' unless defined(&HATLOCK_HAT_EXIT);
	eval 'sub HATLOCK_MLIST_ENTER {
	    local($pp) = @_;
    	    eval q((( ($hat_lockops->{hl_mlist_enter}))($pp)));
	}' unless defined(&HATLOCK_MLIST_ENTER);
	eval 'sub HATLOCK_MLIST_EXIT {
	    local($pp) = @_;
    	    eval q((( ($hat_lockops->{hl_mlist_exit}))($pp)));
	}' unless defined(&HATLOCK_MLIST_EXIT);
	eval 'sub HATLOCK_MLIST_HELD {
	    local($pp) = @_;
    	    eval q((( ($hat_lockops->{hl_mlist_held}))($pp)));
	}' unless defined(&HATLOCK_MLIST_HELD);
    }
    eval 'sub HATLOCK_CACHECTL_ENTER {
        local($pp) = @_;
	    eval q((( ($hat_lockops->{hl_cachectl_enter}))($pp)));
    }' unless defined(&HATLOCK_CACHECTL_ENTER);
    eval 'sub HATLOCK_CACHECTL_EXIT {
        local($pp) = @_;
	    eval q((( ($hat_lockops->{hl_cachectl_exit}))($pp)));
    }' unless defined(&HATLOCK_CACHECTL_EXIT);
    if(defined(&__cplusplus)) {
    }
}
1;
