require '_h2ph_pre.ph';

unless(defined(&_SYS_PRIVREGS_H)) {
    eval 'sub _SYS_PRIVREGS_H () {1;}' unless defined(&_SYS_PRIVREGS_H);
    if(defined(&__cplusplus)) {
    }
    require 'sys/fsr.ph';
    unless(defined(&_ASM)) {
	eval 'sub r_ps () { &r_tstate;}' unless defined(&r_ps);
	eval 'sub r_sp () { &r_o6;}' unless defined(&r_sp);
    }
    if(defined(&_KERNEL)) {
	eval 'sub lwptoregs {
	    local($lwp) = @_;
    	    eval q(((($lwp)-> &lwp_regs)));
	}' unless defined(&lwptoregs);
	eval 'sub lwptofpu {
	    local($lwp) = @_;
    	    eval q(((($lwp)-> &lwp_fpu)));
	}' unless defined(&lwptofpu);
	eval 'sub SAVE_GLOBALS {
	    local($RP) = @_;
    	    eval q( &stx % &g1, [$RP +  &G1*4];  &stx % &g2, [$RP +  &G2*4];  &stx % &g3, [$RP +  &G3*4];  &stx % &g4, [$RP +  &G4*4];  &stx % &g5, [$RP +  &G5*4];  &stx % &g6, [$RP +  &G6*4];  &stx % &g7, [$RP +  &G7*4];  &mov % &y, % &g1;  &st % &g1, [$RP +  &Y*4];);
	}' unless defined(&SAVE_GLOBALS);
	eval 'sub RESTORE_GLOBALS {
	    local($RP) = @_;
    	    eval q( &ld [$RP +  &Y*4], % &g1;  &mov % &g1, % &y;  &ldx [$RP +  &G1*4], % &g1;  &ldx [$RP +  &G2*4], % &g2;  &ldx [$RP +  &G3*4], % &g3;  &ldx [$RP +  &G4*4], % &g4;  &ldx [$RP +  &G5*4], % &g5;  &ldx [$RP +  &G6*4], % &g6;  &ldx [$RP +  &G7*4], % &g7;);
	}' unless defined(&RESTORE_GLOBALS);
	eval 'sub SAVE_OUTS {
	    local($RP) = @_;
    	    eval q( &stx % &i0, [$RP +  &O0*4];  &stx % &i1, [$RP +  &O1*4];  &stx % &i2, [$RP +  &O2*4];  &stx % &i3, [$RP +  &O3*4];  &stx % &i4, [$RP +  &O4*4];  &stx % &i5, [$RP +  &O5*4];  &stx % &i6, [$RP +  &O6*4];  &stx % &i7, [$RP +  &O7*4];);
	}' unless defined(&SAVE_OUTS);
	eval 'sub RESTORE_OUTS {
	    local($RP) = @_;
    	    eval q( &ldx [$RP +  &O0*4], % &i0;  &ldx [$RP +  &O1*4], % &i1;  &ldx [$RP +  &O2*4], % &i2;  &ldx [$RP +  &O3*4], % &i3;  &ldx [$RP +  &O4*4], % &i4;  &ldx [$RP +  &O5*4], % &i5;  &ldx [$RP +  &O6*4], % &i6;  &ldx [$RP +  &O7*4], % &i7;);
	}' unless defined(&RESTORE_OUTS);
	eval 'sub SAVE_V8WINDOW {
	    local($SBP) = @_;
    	    eval q( &st % &l0, [$SBP + (0*4)];  &st % &l1, [$SBP + (1*4)];  &st % &l2, [$SBP + (2*4)];  &st % &l3, [$SBP + (3*4)];  &st % &l4, [$SBP + (4*4)];  &st % &l5, [$SBP + (5*4)];  &st % &l6, [$SBP + (6*4)];  &st % &l7, [$SBP + (7*4)];  &st % &i0, [$SBP + (8*4)];  &st % &i1, [$SBP + (9*4)];  &st % &i2, [$SBP + (10*4)];  &st % &i3, [$SBP + (11*4)];  &st % &i4, [$SBP + (12*4)];  &st % &i5, [$SBP + (13*4)];  &st % &i6, [$SBP + (14*4)];  &st % &i7, [$SBP + (15*4)];);
	}' unless defined(&SAVE_V8WINDOW);
	eval 'sub RESTORE_V8WINDOW {
	    local($SBP) = @_;
    	    eval q( &ld [$SBP + (0*4)], % &l0;  &ld [$SBP + (1*4)], % &l1;  &ld [$SBP + (2*4)], % &l2;  &ld [$SBP + (3*4)], % &l3;  &ld [$SBP + (4*4)], % &l4;  &ld [$SBP + (5*4)], % &l5;  &ld [$SBP + (6*4)], % &l6;  &ld [$SBP + (7*4)], % &l7;  &ld [$SBP + (8*4)], % &i0;  &ld [$SBP + (9*4)], % &i1;  &ld [$SBP + (10*4)], % &i2;  &ld [$SBP + (11*4)], % &i3;  &ld [$SBP + (12*4)], % &i4;  &ld [$SBP + (13*4)], % &i5;  &ld [$SBP + (14*4)], % &i6;  &ld [$SBP + (15*4)], % &i7;);
	}' unless defined(&RESTORE_V8WINDOW);
	eval 'sub STORE_FPREGS {
	    local($FP) = @_;
    	    eval q( &std % &f0, [$FP];  &std % &f2, [$FP + 8];  &std % &f4, [$FP + 16];  &std % &f6, [$FP + 24];  &std % &f8, [$FP + 32];  &std % &f10, [$FP + 40];  &std % &f12, [$FP + 48];  &std % &f14, [$FP + 56];  &std % &f16, [$FP + 64];  &std % &f18, [$FP + 72];  &std % &f20, [$FP + 80];  &std % &f22, [$FP + 88];  &std % &f24, [$FP + 96];  &std % &f26, [$FP + 104];  &std % &f28, [$FP + 112];  &std % &f30, [$FP + 120];  &std % &d32, [$FP + 128];  &std % &d34, [$FP + 136];  &std % &d36, [$FP + 144];  &std % &d38, [$FP + 152];  &std % &d40, [$FP + 160];  &std % &d42, [$FP + 168];  &std % &d44, [$FP + 176];  &std % &d46, [$FP + 184];  &std % &d48, [$FP + 192];  &std % &d50, [$FP + 200];  &std % &d52, [$FP + 208];  &std % &d54, [$FP + 216];  &std % &d56, [$FP + 224];  &std % &d58, [$FP + 232];  &std % &d60, [$FP + 240];  &std % &d62, [$FP + 248];);
	}' unless defined(&STORE_FPREGS);
	eval 'sub LOAD_FPREGS {
	    local($FP) = @_;
    	    eval q( &ldd [$FP], % &f0;  &ldd [$FP + 8], % &f2;  &ldd [$FP + 16], % &f4;  &ldd [$FP + 24], % &f6;  &ldd [$FP + 32], % &f8;  &ldd [$FP + 40], % &f10;  &ldd [$FP + 48], % &f12;  &ldd [$FP + 56], % &f14;  &ldd [$FP + 64], % &f16;  &ldd [$FP + 72], % &f18;  &ldd [$FP + 80], % &f20;  &ldd [$FP + 88], % &f22;  &ldd [$FP + 96], % &f24;  &ldd [$FP + 104], % &f26;  &ldd [$FP + 112], % &f28;  &ldd [$FP + 120], % &f30;  &ldd [$FP + 128], % &d32;  &ldd [$FP + 136], % &d34;  &ldd [$FP + 144], % &d36;  &ldd [$FP + 152], % &d38;  &ldd [$FP + 160], % &d40;  &ldd [$FP + 168], % &d42;  &ldd [$FP + 176], % &d44;  &ldd [$FP + 184], % &d46;  &ldd [$FP + 192], % &d48;  &ldd [$FP + 200], % &d50;  &ldd [$FP + 208], % &d52;  &ldd [$FP + 216], % &d54;  &ldd [$FP + 224], % &d56;  &ldd [$FP + 232], % &d58;  &ldd [$FP + 240], % &d60;  &ldd [$FP + 248], % &d62;);
	}' unless defined(&LOAD_FPREGS);
	eval 'sub STORE_DL_FPREGS {
	    local($FP) = @_;
    	    eval q( &std % &f0, [$FP];  &std % &f2, [$FP + 8];  &std % &f4, [$FP + 16];  &std % &f6, [$FP + 24];  &std % &f8, [$FP + 32];  &std % &f10, [$FP + 40];  &std % &f12, [$FP + 48];  &std % &f14, [$FP + 56];  &std % &f16, [$FP + 64];  &std % &f18, [$FP + 72];  &std % &f20, [$FP + 80];  &std % &f22, [$FP + 88];  &std % &f24, [$FP + 96];  &std % &f26, [$FP + 104];  &std % &f28, [$FP + 112];  &std % &f30, [$FP + 120];);
	}' unless defined(&STORE_DL_FPREGS);
	eval 'sub STORE_DU_FPREGS {
	    local($FP) = @_;
    	    eval q( &std % &d32, [$FP + 128];  &std % &d34, [$FP + 136];  &std % &d36, [$FP + 144];  &std % &d38, [$FP + 152];  &std % &d40, [$FP + 160];  &std % &d42, [$FP + 168];  &std % &d44, [$FP + 176];  &std % &d46, [$FP + 184];  &std % &d48, [$FP + 192];  &std % &d50, [$FP + 200];  &std % &d52, [$FP + 208];  &std % &d54, [$FP + 216];  &std % &d56, [$FP + 224];  &std % &d58, [$FP + 232];  &std % &d60, [$FP + 240];  &std % &d62, [$FP + 248];);
	}' unless defined(&STORE_DU_FPREGS);
	eval 'sub LOAD_DL_FPREGS {
	    local($FP) = @_;
    	    eval q( &ldd [$FP], % &f0;  &ldd [$FP + 8], % &f2;  &ldd [$FP + 16], % &f4;  &ldd [$FP + 24], % &f6;  &ldd [$FP + 32], % &f8;  &ldd [$FP + 40], % &f10;  &ldd [$FP + 48], % &f12;  &ldd [$FP + 56], % &f14;  &ldd [$FP + 64], % &f16;  &ldd [$FP + 72], % &f18;  &ldd [$FP + 80], % &f20;  &ldd [$FP + 88], % &f22;  &ldd [$FP + 96], % &f24;  &ldd [$FP + 104], % &f26;  &ldd [$FP + 112], % &f28;  &ldd [$FP + 120], % &f30;);
	}' unless defined(&LOAD_DL_FPREGS);
	eval 'sub LOAD_DU_FPREGS {
	    local($FP) = @_;
    	    eval q( &ldd [$FP + 128], % &d32;  &ldd [$FP + 136], % &d34;  &ldd [$FP + 144], % &d36;  &ldd [$FP + 152], % &d38;  &ldd [$FP + 160], % &d40;  &ldd [$FP + 168], % &d42;  &ldd [$FP + 176], % &d44;  &ldd [$FP + 184], % &d46;  &ldd [$FP + 192], % &d48;  &ldd [$FP + 200], % &d50;  &ldd [$FP + 208], % &d52;  &ldd [$FP + 216], % &d54;  &ldd [$FP + 224], % &d56;  &ldd [$FP + 232], % &d58;  &ldd [$FP + 240], % &d60;  &ldd [$FP + 248], % &d62;);
	}' unless defined(&LOAD_DU_FPREGS);
    }
    eval 'sub CCR_IC () {0x01;}' unless defined(&CCR_IC);
    eval 'sub CCR_IV () {0x02;}' unless defined(&CCR_IV);
    eval 'sub CCR_IZ () {0x04;}' unless defined(&CCR_IZ);
    eval 'sub CCR_IN () {0x08;}' unless defined(&CCR_IN);
    eval 'sub CCR_XC () {0x10;}' unless defined(&CCR_XC);
    eval 'sub CCR_XV () {0x20;}' unless defined(&CCR_XV);
    eval 'sub CCR_XZ () {0x40;}' unless defined(&CCR_XZ);
    eval 'sub CCR_XN () {0x80;}' unless defined(&CCR_XN);
    eval 'sub CCR_ICC () {0x0f;}' unless defined(&CCR_ICC);
    eval 'sub CCR_XCC () {0xf0;}' unless defined(&CCR_XCC);
    eval 'sub PSTATE_AG () {0x001;}' unless defined(&PSTATE_AG);
    eval 'sub PSTATE_IE () {0x002;}' unless defined(&PSTATE_IE);
    eval 'sub PSTATE_PRIV () {0x004;}' unless defined(&PSTATE_PRIV);
    eval 'sub PSTATE_AM () {0x008;}' unless defined(&PSTATE_AM);
    eval 'sub PSTATE_PEF () {0x010;}' unless defined(&PSTATE_PEF);
    eval 'sub PSTATE_RED () {0x020;}' unless defined(&PSTATE_RED);
    eval 'sub PSTATE_MM () {0x0c0;}' unless defined(&PSTATE_MM);
    eval 'sub PSTATE_TLE () {0x100;}' unless defined(&PSTATE_TLE);
    eval 'sub PSTATE_CLE () {0x200;}' unless defined(&PSTATE_CLE);
    eval 'sub PSTATE_MG () {0x400;}' unless defined(&PSTATE_MG);
    eval 'sub PSTATE_IG () {0x800;}' unless defined(&PSTATE_IG);
    eval 'sub PSTATE_MM_TSO () {0x00;}' unless defined(&PSTATE_MM_TSO);
    eval 'sub PSTATE_MM_PSO () {0x40;}' unless defined(&PSTATE_MM_PSO);
    eval 'sub PSTATE_MM_RMO () {0x80;}' unless defined(&PSTATE_MM_RMO);
    eval 'sub TSTATE_CWP_MASK () {0x01f;}' unless defined(&TSTATE_CWP_MASK);
    eval 'sub TSTATE_CWP_SHIFT () {0;}' unless defined(&TSTATE_CWP_SHIFT);
    eval 'sub TSTATE_PSTATE_MASK () {0xfff;}' unless defined(&TSTATE_PSTATE_MASK);
    eval 'sub TSTATE_PSTATE_SHIFT () {8;}' unless defined(&TSTATE_PSTATE_SHIFT);
    eval 'sub TSTATE_ASI_MASK () {0x0ff;}' unless defined(&TSTATE_ASI_MASK);
    eval 'sub TSTATE_ASI_SHIFT () {24;}' unless defined(&TSTATE_ASI_SHIFT);
    eval 'sub TSTATE_CCR_MASK () {0x0ff;}' unless defined(&TSTATE_CCR_MASK);
    eval 'sub TSTATE_CCR_SHIFT () {32;}' unless defined(&TSTATE_CCR_SHIFT);
    eval 'sub TSTATE_AG () {( &PSTATE_AG <<  &TSTATE_PSTATE_SHIFT);}' unless defined(&TSTATE_AG);
    eval 'sub TSTATE_IE () {( &PSTATE_IE <<  &TSTATE_PSTATE_SHIFT);}' unless defined(&TSTATE_IE);
    eval 'sub TSTATE_PRIV () {( &PSTATE_PRIV <<  &TSTATE_PSTATE_SHIFT);}' unless defined(&TSTATE_PRIV);
    eval 'sub TSTATE_AM () {( &PSTATE_AM <<  &TSTATE_PSTATE_SHIFT);}' unless defined(&TSTATE_AM);
    eval 'sub TSTATE_PEF () {( &PSTATE_PEF <<  &TSTATE_PSTATE_SHIFT);}' unless defined(&TSTATE_PEF);
    eval 'sub TSTATE_MG () {( &PSTATE_MG <<  &TSTATE_PSTATE_SHIFT);}' unless defined(&TSTATE_MG);
    eval 'sub TSTATE_IG () {( &PSTATE_IG <<  &TSTATE_PSTATE_SHIFT);}' unless defined(&TSTATE_IG);
    eval 'sub TSTATE_CWP () { &TSTATE_CWP_MASK;}' unless defined(&TSTATE_CWP);
    unless(defined(&_ASM)) {
	eval 'sub TSTATE_ICC () {( &CCR_ICC <<  &TSTATE_CCR_SHIFT);}' unless defined(&TSTATE_ICC);
	eval 'sub TSTATE_IC () {( &CCR_IC <<  &TSTATE_CCR_SHIFT);}' unless defined(&TSTATE_IC);
    } else {
	eval 'sub TSTATE_ICC () {( &CCR_ICC <<  &TSTATE_CCR_SHIFT);}' unless defined(&TSTATE_ICC);
	eval 'sub TSTATE_IC () {( &CCR_IC <<  &TSTATE_CCR_SHIFT);}' unless defined(&TSTATE_IC);
    }
    eval 'sub TSTATE_V8_UBITS () {( &TSTATE_ICC |  &TSTATE_PEF);}' unless defined(&TSTATE_V8_UBITS);
    eval 'sub TSTATE_KERN () {(( &PSTATE_PRIV |  &PSTATE_AM |  &PSTATE_PEF |  &PSTATE_MM_TSO) <<  &TSTATE_PSTATE_SHIFT);}' unless defined(&TSTATE_KERN);
    eval 'sub TSTATE_USER () {((( &PSTATE_IE |  &PSTATE_AM |  &PSTATE_PEF |  &PSTATE_MM_TSO) <<  &TSTATE_PSTATE_SHIFT) | ( &ASI_PNF <<  &TSTATE_ASI_SHIFT));}' unless defined(&TSTATE_USER);
    eval 'sub PSTATE_KERN () {( &PSTATE_IE |  &PSTATE_PRIV |  &PSTATE_AM |  &PSTATE_PEF |  &PSTATE_MM_TSO);}' unless defined(&PSTATE_KERN);
    eval 'sub USERMODE {
        local($x) = @_;
	    eval q((!(($x) &  &TSTATE_PRIV)));
    }' unless defined(&USERMODE);
    eval 'sub WSTATE {
        local($o, $n) = @_;
	    eval q(((($o) << 3) | ($n)));
    }' unless defined(&WSTATE);
    eval 'sub WSTATE_USER () { &WSTATE(0, 1);}' unless defined(&WSTATE_USER);
    eval 'sub WSTATE_KERN () { &WSTATE(1, 5);}' unless defined(&WSTATE_KERN);
    eval 'sub WSTATE_MIXED () { &WSTATE(3, 7);}' unless defined(&WSTATE_MIXED);
    eval 'sub PIL_MAX () {0xf;}' unless defined(&PIL_MAX);
    eval 'sub VER_MANUF () {0xffff000000000000;}' unless defined(&VER_MANUF);
    eval 'sub VER_IMPL () {0x0000ffff00000000;}' unless defined(&VER_IMPL);
    eval 'sub VER_MASK () {0x00000000ff000000;}' unless defined(&VER_MASK);
    eval 'sub VER_MAXTL () {0x000000000000ff00;}' unless defined(&VER_MAXTL);
    eval 'sub VER_MAXWIN () {0x000000000000001f;}' unless defined(&VER_MAXWIN);
    if(defined(&__cplusplus)) {
    }
}
1;
