require '_h2ph_pre.ph';

unless(defined(&_SYS_VNODE_H)) {
    eval 'sub _SYS_VNODE_H () {1;}' unless defined(&_SYS_VNODE_H);
    require 'sys/types.ph';
    require 'sys/t_lock.ph';
    require 'sys/time.ph';
    require 'sys/cred.ph';
    require 'sys/uio.ph';
    require 'vm/seg_enum.ph';
    if(defined(&_KERNEL)) {
	require 'sys/buf.ph';
    }
    if(defined(&__cplusplus)) {
    }
    eval("sub VNON () { 0; }") unless defined(&VNON);
    eval("sub VREG () { 1; }") unless defined(&VREG);
    eval("sub VDIR () { 2; }") unless defined(&VDIR);
    eval("sub VBLK () { 3; }") unless defined(&VBLK);
    eval("sub VCHR () { 4; }") unless defined(&VCHR);
    eval("sub VLNK () { 5; }") unless defined(&VLNK);
    eval("sub VFIFO () { 6; }") unless defined(&VFIFO);
    eval("sub VDOOR () { 7; }") unless defined(&VDOOR);
    eval("sub VBAD () { 8; }") unless defined(&VBAD);
    eval 'sub VROOT () {0x01;}' unless defined(&VROOT);
    eval 'sub VNOCACHE () {0x02;}' unless defined(&VNOCACHE);
    eval 'sub VNOMAP () {0x04;}' unless defined(&VNOMAP);
    eval 'sub VDUP () {0x08;}' unless defined(&VDUP);
    eval 'sub VNOSWAP () {0x10;}' unless defined(&VNOSWAP);
    eval 'sub VNOMOUNT () {0x20;}' unless defined(&VNOMOUNT);
    eval 'sub VISSWAP () {0x40;}' unless defined(&VISSWAP);
    eval 'sub VSWAPLIKE () {0x80;}' unless defined(&VSWAPLIKE);
    eval 'sub IS_SWAPVP {
        local($vp) = @_;
	    eval q(((($vp)-> &v_flag & ( &VISSWAP |  &VSWAPLIKE)) != 0));
    }' unless defined(&IS_SWAPVP);
    eval 'sub VVFSLOCK () {0x100;}' unless defined(&VVFSLOCK);
    eval 'sub VVFSWAIT () {0x200;}' unless defined(&VVFSWAIT);
    eval 'sub VVMLOCK () {0x400;}' unless defined(&VVMLOCK);
    eval 'sub VVMEXEC () {0x1000;}' unless defined(&VVMEXEC);
    eval 'sub AT_TYPE () {0x0001;}' unless defined(&AT_TYPE);
    eval 'sub AT_MODE () {0x0002;}' unless defined(&AT_MODE);
    eval 'sub AT_UID () {0x0004;}' unless defined(&AT_UID);
    eval 'sub AT_GID () {0x0008;}' unless defined(&AT_GID);
    eval 'sub AT_FSID () {0x0010;}' unless defined(&AT_FSID);
    eval 'sub AT_NODEID () {0x0020;}' unless defined(&AT_NODEID);
    eval 'sub AT_NLINK () {0x0040;}' unless defined(&AT_NLINK);
    eval 'sub AT_SIZE () {0x0080;}' unless defined(&AT_SIZE);
    eval 'sub AT_ATIME () {0x0100;}' unless defined(&AT_ATIME);
    eval 'sub AT_MTIME () {0x0200;}' unless defined(&AT_MTIME);
    eval 'sub AT_CTIME () {0x0400;}' unless defined(&AT_CTIME);
    eval 'sub AT_RDEV () {0x0800;}' unless defined(&AT_RDEV);
    eval 'sub AT_BLKSIZE () {0x1000;}' unless defined(&AT_BLKSIZE);
    eval 'sub AT_NBLOCKS () {0x2000;}' unless defined(&AT_NBLOCKS);
    eval 'sub AT_VCODE () {0x4000;}' unless defined(&AT_VCODE);
    eval 'sub AT_ALL () {( &AT_TYPE| &AT_MODE| &AT_UID| &AT_GID| &AT_FSID| &AT_NODEID|  &AT_NLINK| &AT_SIZE| &AT_ATIME| &AT_MTIME| &AT_CTIME|  &AT_RDEV| &AT_BLKSIZE| &AT_NBLOCKS| &AT_VCODE);}' unless defined(&AT_ALL);
    eval 'sub AT_STAT () {( &AT_MODE| &AT_UID| &AT_GID| &AT_FSID| &AT_NODEID| &AT_NLINK|  &AT_SIZE| &AT_ATIME| &AT_MTIME| &AT_CTIME| &AT_RDEV);}' unless defined(&AT_STAT);
    eval 'sub AT_TIMES () {( &AT_ATIME| &AT_MTIME| &AT_CTIME);}' unless defined(&AT_TIMES);
    eval 'sub AT_NOSET () {( &AT_NLINK| &AT_RDEV| &AT_FSID| &AT_NODEID| &AT_TYPE|  &AT_BLKSIZE| &AT_NBLOCKS| &AT_VCODE);}' unless defined(&AT_NOSET);
    eval 'sub VSUID () {04000;}' unless defined(&VSUID);
    eval 'sub VSGID () {02000;}' unless defined(&VSGID);
    eval 'sub VSVTX () {01000;}' unless defined(&VSVTX);
    eval 'sub VREAD () {00400;}' unless defined(&VREAD);
    eval 'sub VWRITE () {00200;}' unless defined(&VWRITE);
    eval 'sub VEXEC () {00100;}' unless defined(&VEXEC);
    eval 'sub MODEMASK () {07777;}' unless defined(&MODEMASK);
    eval 'sub PERMMASK () {00777;}' unless defined(&PERMMASK);
    eval 'sub MANDMODE {
        local($mode) = @_;
	    eval q(((($mode) & ( &VSGID|( &VEXEC>>3))) ==  &VSGID));
    }' unless defined(&MANDMODE);
    eval 'sub MANDLOCK {
        local($vp, $mode) = @_;
	    eval q((($vp)-> &v_type ==  &VREG  &&  &MANDMODE($mode)));
    }' unless defined(&MANDLOCK);
    eval("sub RMFILE () { 0; }") unless defined(&RMFILE);
    eval("sub RMDIRECTORY () { 1; }") unless defined(&RMDIRECTORY);
    eval("sub NO_FOLLOW () { 0; }") unless defined(&NO_FOLLOW);
    eval("sub FOLLOW () { 1; }") unless defined(&FOLLOW);
    eval("sub NONEXCL () { 0; }") unless defined(&NONEXCL);
    eval("sub EXCL () { 1; }") unless defined(&EXCL);
    eval("sub CRCREAT () { 0; }") unless defined(&CRCREAT);
    eval("sub CRMKNOD () { 1; }") unless defined(&CRMKNOD);
    eval("sub CRMKDIR () { 2; }") unless defined(&CRMKDIR);
    eval("sub CRCORE () { 3; }") unless defined(&CRCORE);
    eval 'sub VSA_ACL () {0x0001;}' unless defined(&VSA_ACL);
    eval 'sub VSA_ACLCNT () {0x0002;}' unless defined(&VSA_ACLCNT);
    eval 'sub VSA_DFACL () {0x0004;}' unless defined(&VSA_DFACL);
    eval 'sub VSA_DFACLCNT () {0x0008;}' unless defined(&VSA_DFACLCNT);
    eval 'sub VOP_OPEN {
        local($vpp, $mode, $cr) = @_;
	    eval q((*(*($vpp))-> ($v_op->{vop_open}))($vpp, $mode, $cr));
    }' unless defined(&VOP_OPEN);
    eval 'sub VOP_CLOSE {
        local($vp, $f, $c, $o, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_close}))($vp, $f, $c, $o, $cr));
    }' unless defined(&VOP_CLOSE);
    eval 'sub VOP_READ {
        local($vp, $uiop, $iof, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_read}))($vp, $uiop, $iof, $cr));
    }' unless defined(&VOP_READ);
    eval 'sub VOP_WRITE {
        local($vp, $uiop, $iof, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_write}))($vp, $uiop, $iof, $cr));
    }' unless defined(&VOP_WRITE);
    eval 'sub VOP_IOCTL {
        local($vp, $cmd, $a, $f, $cr, $rvp) = @_;
	    eval q((*($vp)-> ($v_op->{vop_ioctl}))($vp, $cmd, $a, $f, $cr, $rvp));
    }' unless defined(&VOP_IOCTL);
    eval 'sub VOP_SETFL {
        local($vp, $f, $a, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_setfl}))($vp, $f, $a, $cr));
    }' unless defined(&VOP_SETFL);
    eval 'sub VOP_GETATTR {
        local($vp, $vap, $f, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_getattr}))($vp, $vap, $f, $cr));
    }' unless defined(&VOP_GETATTR);
    eval 'sub VOP_SETATTR {
        local($vp, $vap, $f, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_setattr}))($vp, $vap, $f, $cr));
    }' unless defined(&VOP_SETATTR);
    eval 'sub VOP_ACCESS {
        local($vp, $mode, $f, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_access}))($vp, $mode, $f, $cr));
    }' unless defined(&VOP_ACCESS);
    eval 'sub VOP_LOOKUP {
        local($vp, $cp, $vpp, $pnp, $f, $rdir, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_lookup}))($vp, $cp, $vpp, $pnp, $f, $rdir, $cr));
    }' unless defined(&VOP_LOOKUP);
    eval 'sub VOP_CREATE {
        local($dvp, $p, $vap, $ex, $mode, $vpp, $cr) = @_;
	    eval q((*($dvp)-> ($v_op->{vop_create}))($dvp, $p, $vap, $ex, $mode, $vpp, $cr));
    }' unless defined(&VOP_CREATE);
    eval 'sub VOP_REMOVE {
        local($dvp, $p, $cr) = @_;
	    eval q((*($dvp)-> ($v_op->{vop_remove}))($dvp, $p, $cr));
    }' unless defined(&VOP_REMOVE);
    eval 'sub VOP_LINK {
        local($tdvp, $fvp, $p, $cr) = @_;
	    eval q((*($tdvp)-> ($v_op->{vop_link}))($tdvp, $fvp, $p, $cr));
    }' unless defined(&VOP_LINK);
    eval 'sub VOP_RENAME {
        local($fvp, $fnm, $tdvp, $tnm, $cr) = @_;
	    eval q((*($fvp)-> ($v_op->{vop_rename}))($fvp, $fnm, $tdvp, $tnm, $cr));
    }' unless defined(&VOP_RENAME);
    eval 'sub VOP_MKDIR {
        local($dp, $p, $vap, $vpp, $cr) = @_;
	    eval q((*($dp)-> ($v_op->{vop_mkdir}))($dp, $p, $vap, $vpp, $cr));
    }' unless defined(&VOP_MKDIR);
    eval 'sub VOP_RMDIR {
        local($dp, $p, $cdir, $cr) = @_;
	    eval q((*($dp)-> ($v_op->{vop_rmdir}))($dp, $p, $cdir, $cr));
    }' unless defined(&VOP_RMDIR);
    eval 'sub VOP_READDIR {
        local($vp, $uiop, $cr, $eofp) = @_;
	    eval q((*($vp)-> ($v_op->{vop_readdir}))($vp, $uiop, $cr, $eofp));
    }' unless defined(&VOP_READDIR);
    eval 'sub VOP_SYMLINK {
        local($dvp, $lnm, $vap, $tnm, $cr) = @_;
	    eval q((*($dvp)-> ($v_op->{vop_symlink})) ($dvp, $lnm, $vap, $tnm, $cr));
    }' unless defined(&VOP_SYMLINK);
    eval 'sub VOP_READLINK {
        local($vp, $uiop, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_readlink}))($vp, $uiop, $cr));
    }' unless defined(&VOP_READLINK);
    eval 'sub VOP_FSYNC {
        local($vp, $syncflag, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_fsync}))($vp, $syncflag, $cr));
    }' unless defined(&VOP_FSYNC);
    eval 'sub VOP_INACTIVE {
        local($vp, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_inactive}))($vp, $cr));
    }' unless defined(&VOP_INACTIVE);
    eval 'sub VOP_FID {
        local($vp, $fidp) = @_;
	    eval q((*($vp)-> ($v_op->{vop_fid}))($vp, $fidp));
    }' unless defined(&VOP_FID);
    eval 'sub VOP_RWLOCK {
        local($vp, $w) = @_;
	    eval q((*($vp)-> ($v_op->{vop_rwlock}))($vp, $w));
    }' unless defined(&VOP_RWLOCK);
    eval 'sub VOP_RWUNLOCK {
        local($vp, $w) = @_;
	    eval q((*($vp)-> ($v_op->{vop_rwunlock}))($vp, $w));
    }' unless defined(&VOP_RWUNLOCK);
    eval 'sub VOP_SEEK {
        local($vp, $ooff, $noffp) = @_;
	    eval q((*($vp)-> ($v_op->{vop_seek}))($vp, $ooff, $noffp));
    }' unless defined(&VOP_SEEK);
    eval 'sub VOP_CMP {
        local($vp1, $vp2) = @_;
	    eval q((*($vp1)-> ($v_op->{vop_cmp}))($vp1, $vp2));
    }' unless defined(&VOP_CMP);
    eval 'sub VOP_FRLOCK {
        local($vp, $cmd, $a, $f, $o, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_frlock}))($vp, $cmd, $a, $f, $o, $cr));
    }' unless defined(&VOP_FRLOCK);
    eval 'sub VOP_SPACE {
        local($vp, $cmd, $a, $f, $o, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_space}))($vp, $cmd, $a, $f, $o, $cr));
    }' unless defined(&VOP_SPACE);
    eval 'sub VOP_REALVP {
        local($vp1, $vp2) = @_;
	    eval q((*($vp1)-> ($v_op->{vop_realvp}))($vp1, $vp2));
    }' unless defined(&VOP_REALVP);
    eval 'sub VOP_GETPAGE {
        local($vp, $of, $sz, $pr, $pl, $ps, $sg, $a, $rw, $cr) = @_;
	    eval q(((*($vp)-> ($v_op->{vop_getpage})) ($vp, $of, $sz, $pr, $pl, $ps, $sg, $a, $rw, $cr)));
    }' unless defined(&VOP_GETPAGE);
    eval 'sub VOP_PUTPAGE {
        local($vp, $of, $sz, $fl, $cr) = @_;
	    eval q(((*($vp)-> ($v_op->{vop_putpage}))($vp, $of, $sz, $fl, $cr)));
    }' unless defined(&VOP_PUTPAGE);
    eval 'sub VOP_MAP {
        local($vp, $of, $as, $a, $sz, $p, $mp, $fl, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_map})) ($vp, $of, $as, $a, $sz, $p, $mp, $fl, $cr));
    }' unless defined(&VOP_MAP);
    eval 'sub VOP_ADDMAP {
        local($vp, $of, $as, $a, $sz, $p, $mp, $fl, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_addmap})) ($vp, $of, $as, $a, $sz, $p, $mp, $fl, $cr));
    }' unless defined(&VOP_ADDMAP);
    eval 'sub VOP_DELMAP {
        local($vp, $of, $as, $a, $sz, $p, $mp, $fl, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_delmap})) ($vp, $of, $as, $a, $sz, $p, $mp, $fl, $cr));
    }' unless defined(&VOP_DELMAP);
    eval 'sub VOP_POLL {
        local($vp, $events, $anyyet, $reventsp, $phpp) = @_;
	    eval q((*($vp)-> ($v_op->{vop_poll}))($vp, $events, $anyyet, $reventsp, $phpp));
    }' unless defined(&VOP_POLL);
    eval 'sub VOP_DUMP {
        local($vp, $addr, $bn, $count) = @_;
	    eval q((*($vp)-> ($v_op->{vop_dump}))($vp, $addr, $bn, $count));
    }' unless defined(&VOP_DUMP);
    eval 'sub VOP_PATHCONF {
        local($vp, $cmd, $valp, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_pathconf}))($vp, $cmd, $valp, $cr));
    }' unless defined(&VOP_PATHCONF);
    eval 'sub VOP_PAGEIO {
        local($vp, $pp, $io_off, $io_len, $flags, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_pageio}))($vp, $pp, $io_off, $io_len, $flags, $cr));
    }' unless defined(&VOP_PAGEIO);
    eval 'sub VOP_DUMPCTL {
        local($vp, $flag) = @_;
	    eval q((*($vp)-> ($v_op->{vop_dumpctl}))($vp, $flag));
    }' unless defined(&VOP_DUMPCTL);
    eval 'sub VOP_DISPOSE {
        local($vp, $pp, $fl, $dn, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_dispose}))($vp, $pp, $fl, $dn, $cr));
    }' unless defined(&VOP_DISPOSE);
    eval 'sub VOP_GETSECATTR {
        local($vp, $vsap, $f, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_getsecattr})) ($vp, $vsap, $f, $cr));
    }' unless defined(&VOP_GETSECATTR);
    eval 'sub VOP_SETSECATTR {
        local($vp, $vsap, $f, $cr) = @_;
	    eval q((*($vp)-> ($v_op->{vop_setsecattr})) ($vp, $vsap, $f, $cr));
    }' unless defined(&VOP_SETSECATTR);
    eval 'sub LOOKUP_DIR () {0x01;}' unless defined(&LOOKUP_DIR);
    if(defined(&_KERNEL)) {
    }
    eval 'sub VN_HOLD {
        local($vp) = @_;
	    eval q({  &mutex_enter(($vp)-> &v_lock); ($vp)-> &v_count++;  &mutex_exit(($vp)-> &v_lock); });
    }' unless defined(&VN_HOLD);
    eval 'sub VN_RELE {
        local($vp) = @_;
	    eval q({  &vn_rele($vp); });
    }' unless defined(&VN_RELE);
    eval 'sub VN_INIT {
        local($vp, $vfsp, $type, $dev) = @_;
	    eval q({  &mutex_init(($vp)-> &v_lock, \\"vnode lock\\",  &MUTEX_DEFAULT,  &DEFAULT_WT); ($vp)-> &v_flag = 0; ($vp)-> &v_count = 1; ($vp)-> &v_vfsp = ($vfsp); ($vp)-> &v_type = ($type); ($vp)-> &v_rdev = ($dev); ($vp)-> &v_pages =  &NULL; ($vp)-> &v_stream =  &NULL; });
    }' unless defined(&VN_INIT);
    eval 'sub VN_CMP {
        local($VP1, $VP2) = @_;
	    eval q((($VP1) == ($VP2) ? 1: (($VP1)  && ($VP2)  && (($VP1)-> &v_op == ($VP2)-> &v_op) ?  &VOP_CMP($VP1, $VP2) : 0)));
    }' unless defined(&VN_CMP);
    eval 'sub ATTR_UTIME () {0x01;}' unless defined(&ATTR_UTIME);
    eval 'sub ATTR_EXEC () {0x02;}' unless defined(&ATTR_EXEC);
    eval 'sub ATTR_COMM () {0x04;}' unless defined(&ATTR_COMM);
    eval 'sub ATTR_HINT () {0x08;}' unless defined(&ATTR_HINT);
    eval 'sub VBSIZE {
        local($vp) = @_;
	    eval q((($vp)-> ($v_vfsp->{vfs_bsize})));
    }' unless defined(&VBSIZE);
    eval 'sub NULLVP () {(0);}' unless defined(&NULLVP);
    eval 'sub NULLVPP () {(0);}' unless defined(&NULLVPP);
    if(defined(&_KERNEL)) {
    }
    eval 'sub VN_DISPOSE {
        local($pp, $fl, $dn, $cr) = @_;
	    eval q({  &extern \'struct vnode\'  &kvp;  &if (($pp)-> &p_vnode !=  &NULL  && ($pp)-> &p_vnode !=  &kvp)  &VOP_DISPOSE(($pp)-> &p_vnode, ($pp), ($fl), ($dn), ($cr));  &else  &if (($fl) ==  &B_FREE)  &page_free(($pp), ($dn));  &else  &page_destroy(($pp), ($dn)); });
    }' unless defined(&VN_DISPOSE);
    if(defined(&__cplusplus)) {
    }
}
1;
