require '_h2ph_pre.ph';

unless(defined(&_SYS_SER_ASYNC_H)) {
    eval 'sub _SYS_SER_ASYNC_H () {1;}' unless defined(&_SYS_SER_ASYNC_H);
    require 'sys/ksynch.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub ZSTimeConst {
        local($InputClock, $BaudRate) = @_;
	    eval q(((($InputClock+($BaudRate*16)) / (2*($BaudRate*16))) - 2));
    }' unless defined(&ZSTimeConst);
    eval 'sub ZSDelayConst {
        local($Hertz, $FifoSize, $BitsByte, $BaudRate) = @_;
	    eval q((((**) / ($BaudRate)) + 1));
    }' unless defined(&ZSDelayConst);
    eval 'sub ZSPEED {
        local($n) = @_;
	    eval q( &ZSTimeConst( &PCLK, $n));
    }' unless defined(&ZSPEED);
    eval 'sub ZFIFOSZ () {3;}' unless defined(&ZFIFOSZ);
    eval 'sub ZDELAY {
        local($n) = @_;
	    eval q( &ZSDelayConst( &HZ,  &ZFIFOSZ,  &NBBY, $n));
    }' unless defined(&ZDELAY);
    eval 'sub ISPEED () { &B9600;}' unless defined(&ISPEED);
    eval 'sub ISPEED_SVID () { &B300;}' unless defined(&ISPEED_SVID);
    eval 'sub IFLAGS () {( &CS7| &CREAD| &PARENB);}' unless defined(&IFLAGS);
    eval 'sub IFLAGS_SVID () {( &CS8| &CREAD| &HUPCL);}' unless defined(&IFLAGS_SVID);
    eval 'sub I_IFLAGS () {0;}' unless defined(&I_IFLAGS);
    eval 'sub I_CFLAGS () {(( &ISPEED <<  &IBSHIFT) |  &ISPEED |  &CS8 |  &CREAD |  &HUPCL);}' unless defined(&I_CFLAGS);
    if(defined(&_KERNEL)) {
	unless(defined(&_ASM)) {
	    eval 'sub RINGBITS () {8;}' unless defined(&RINGBITS);
	    eval 'sub RINGSIZE () {(1<< &RINGBITS);}' unless defined(&RINGSIZE);
	    eval 'sub RINGMASK () {( &RINGSIZE-1);}' unless defined(&RINGMASK);
	    eval 'sub RINGFRAC () {2;}' unless defined(&RINGFRAC);
	    eval 'sub RING_INIT {
	        local($zap) = @_;
    		eval q((($zap)-> &za_rput = ($zap)-> &za_rget = 0));
	    }' unless defined(&RING_INIT);
	    eval 'sub RING_CNT {
	        local($zap) = @_;
    		eval q(((($zap)-> &za_rput - ($zap)-> &za_rget) &  &RINGMASK));
	    }' unless defined(&RING_CNT);
	    eval 'sub RING_FRAC {
	        local($zap) = @_;
    		eval q(( &RING_CNT >= ( &RINGSIZE/ &RINGFRAC)));
	    }' unless defined(&RING_FRAC);
	    eval 'sub RING_POK {
	        local($zap, $n) = @_;
    		eval q(( &RING_CNT < ( &RINGSIZE-($n))));
	    }' unless defined(&RING_POK);
	    eval 'sub RING_PUT {
	        local($zap, $c) = @_;
    		eval q((-> $za_ring[-> &za_rput++ &  &RINGMASK] = ($c)));
	    }' unless defined(&RING_PUT);
	    eval 'sub RING_UNPUT {
	        local($zap) = @_;
    		eval q((($zap)-> &za_rput--));
	    }' unless defined(&RING_UNPUT);
	    eval 'sub RING_GOK {
	        local($zap, $n) = @_;
    		eval q(( &RING_CNT >= ($n)));
	    }' unless defined(&RING_GOK);
	    eval 'sub RING_GET {
	        local($zap) = @_;
    		eval q((($zap)-> $za_ring[($zap)-> &za_rget++ &  &RINGMASK]));
	    }' unless defined(&RING_GET);
	    eval 'sub RING_EAT {
	        local($zap, $n) = @_;
    		eval q((($zap)-> &za_rget += ($n)));
	    }' unless defined(&RING_EAT);
	    eval 'sub SBITS () {8;}' unless defined(&SBITS);
	    eval 'sub S_UNMARK () {0x00ff;}' unless defined(&S_UNMARK);
	    eval 'sub S_PARERR () {(0x01<< &SBITS);}' unless defined(&S_PARERR);
	    eval 'sub S_BREAK () {(0x02<< &SBITS);}' unless defined(&S_BREAK);
	    eval 'sub RING_MARK {
	        local($zap, $c, $s) = @_;
    		eval q((-> $za_ring[-> &za_rput++ &  &RINGMASK] = (($c)|($s))));
	    }' unless defined(&RING_MARK);
	    eval 'sub RING_UNMARK {
	        local($zap) = @_;
    		eval q((($zap)-> $za_ring[(($zap)-> &za_rget) &  &RINGMASK] &=  &S_UNMARK));
	    }' unless defined(&RING_UNMARK);
	    eval 'sub RING_ERR {
	        local($zap, $c) = @_;
    		eval q((($zap)-> $za_ring[(($zap)-> &za_rget) &  &RINGMASK] & ($c)));
	    }' unless defined(&RING_ERR);
	    eval 'sub ZAS_WOPEN () {0x00000001;}' unless defined(&ZAS_WOPEN);
	    eval 'sub ZAS_ISOPEN () {0x00000002;}' unless defined(&ZAS_ISOPEN);
	    eval 'sub ZAS_OUT () {0x00000004;}' unless defined(&ZAS_OUT);
	    eval 'sub ZAS_CARR_ON () {0x00000008;}' unless defined(&ZAS_CARR_ON);
	    eval 'sub ZAS_STOPPED () {0x00000010;}' unless defined(&ZAS_STOPPED);
	    eval 'sub ZAS_DELAY () {0x00000020;}' unless defined(&ZAS_DELAY);
	    eval 'sub ZAS_BREAK () {0x00000040;}' unless defined(&ZAS_BREAK);
	    eval 'sub ZAS_BUSY () {0x00000080;}' unless defined(&ZAS_BUSY);
	    eval 'sub ZAS_DRAINING () {0x00000100;}' unless defined(&ZAS_DRAINING);
	    eval 'sub ZAS_SERVICEIMM () {0x00000200;}' unless defined(&ZAS_SERVICEIMM);
	    eval 'sub ZAS_SOFTC_ATTN () {0x00000400;}' unless defined(&ZAS_SOFTC_ATTN);
	    eval 'sub ZAS_PAUSED () {0x00000800;}' unless defined(&ZAS_PAUSED);
	    eval 'sub ZAS_LNEXT () {0x00001000;}' unless defined(&ZAS_LNEXT);
	    eval 'sub ZAS_XMIT_ACTIVE () {0x00002000;}' unless defined(&ZAS_XMIT_ACTIVE);
	    eval 'sub ZAS_DMA_DONE () {0x00004000;}' unless defined(&ZAS_DMA_DONE);
	    eval 'sub ZAS_ZSA_START () {0x00010000;}' unless defined(&ZAS_ZSA_START);
	    eval 'sub ZSA_MAX_RSTANDBY () {12;}' unless defined(&ZSA_MAX_RSTANDBY);
	    eval 'sub ZSA_RDONE_MAX () {60;}' unless defined(&ZSA_RDONE_MAX);
	    if(defined(&ZSA_DEBUG)) {
	    }
	    eval 'sub DO_STOPC () {(1<<8);}' unless defined(&DO_STOPC);
	    eval 'sub DO_ESC () {(1<<9);}' unless defined(&DO_ESC);
	    eval 'sub DO_SERVICEIMM () {(1<<10);}' unless defined(&DO_SERVICEIMM);
	    eval 'sub DO_TRANSMIT () {(1<<11);}' unless defined(&DO_TRANSMIT);
	    eval 'sub DO_RETRANSMIT () {(1<<12);}' unless defined(&DO_RETRANSMIT);
	    eval 'sub za_overrun () { ($za_uover->{uover_overrun});}' unless defined(&za_overrun);
	    eval 'sub za_hw_overrun () { ($za_uover->{_z}->{_hw});}' unless defined(&za_hw_overrun);
	    eval 'sub za_sw_overrun () { ($za_uover->{_z}->{_sw});}' unless defined(&za_sw_overrun);
	}
    }
    if(defined(&__cplusplus)) {
    }
}
1;
