require '_h2ph_pre.ph';

unless(defined(&_SYS_SCSI_ADAPTERS_NCRCTL_H)) {
    eval 'sub _SYS_SCSI_ADAPTERS_NCRCTL_H () {1;}' unless defined(&_SYS_SCSI_ADAPTERS_NCRCTL_H);
    if(defined(&__cplusplus)) {
    }
    eval 'sub msw () { $wa[0];}' unless defined(&msw);
    eval 'sub lsw () { $wa[1];}' unless defined(&lsw);
    eval 'sub lsb () { $ca[3];}' unless defined(&lsb);
    eval 'sub ivec2 () { ($bpr->{lsb});}' unless defined(&ivec2);
    eval 'sub NCR_CSR_DMA_ACTIVE () {0x8000;}' unless defined(&NCR_CSR_DMA_ACTIVE);
    eval 'sub NCR_CSR_DMA_CONFLICT () {0x4000;}' unless defined(&NCR_CSR_DMA_CONFLICT);
    eval 'sub NCR_CSR_DMA_BUS_ERR () {0x2000;}' unless defined(&NCR_CSR_DMA_BUS_ERR);
    eval 'sub NCR_CSR_ID () {0x1000;}' unless defined(&NCR_CSR_ID);
    eval 'sub NCR_CSR_FIFO_FULL () {0x0800;}' unless defined(&NCR_CSR_FIFO_FULL);
    eval 'sub NCR_CSR_FIFO_EMPTY () {0x0400;}' unless defined(&NCR_CSR_FIFO_EMPTY);
    eval 'sub NCR_CSR_NCR_IP () {0x0200;}' unless defined(&NCR_CSR_NCR_IP);
    eval 'sub NCR_CSR_DMA_IP () {0x0100;}' unless defined(&NCR_CSR_DMA_IP);
    eval 'sub NCR_CSR_LOB () {0x00c0;}' unless defined(&NCR_CSR_LOB);
    eval 'sub NCR_CSR_LOB_CNT {
        local($x) = @_;
	    eval q(((($x) &NCR_CSR_LOB) >> 6));
    }' unless defined(&NCR_CSR_LOB_CNT);
    eval 'sub NCR_CSR_BPCON () {0x0020;}' unless defined(&NCR_CSR_BPCON);
    eval 'sub NCR_CSR_DMA_EN () {0x0010;}' unless defined(&NCR_CSR_DMA_EN);
    eval 'sub NCR_CSR_SEND () {0x0008;}' unless defined(&NCR_CSR_SEND);
    eval 'sub NCR_CSR_INTR_EN () {0x0004;}' unless defined(&NCR_CSR_INTR_EN);
    eval 'sub NCR_CSR_FIFO_RES () {0x0002;}' unless defined(&NCR_CSR_FIFO_RES);
    eval 'sub NCR_CSR_SCSI_RES () {0x0001;}' unless defined(&NCR_CSR_SCSI_RES);
    eval 'sub CSR_BITS () {"\\20\\20DMA_ACT\\17DMA_CFLCT\\16DMA_BERR\\12NCR_IP\\11DMA_IP\\5DMA_EN\\4SND\\3ENA";}' unless defined(&CSR_BITS);
    eval 'sub GET_CSR {
        local($ncr) = @_;
	    eval q((($ncr)-> &n_type ==  &IS_COBRA)? ($ncr)-> ($n_ctl->{csr}->{la}) : ($ncr)-> ($n_ctl->{csr}->{lsw}));
    }' unless defined(&GET_CSR);
    eval 'sub SET_CSR {
        local($ncr, $val) = @_;
	    eval q((-> &n_type ==  &IS_COBRA)? (-> ($n_ctl->{csr}->{la}) = ) : (-> ($n_ctl->{csr}->{lsw}) = ($val)));
    }' unless defined(&SET_CSR);
    eval 'sub GET_BPR {
        local($ncr) = @_;
	    eval q((($ncr)-> &n_type ==  &IS_COBRA)? ($ncr)-> ($n_ctl->{bpr}->{la}) : (($ncr)-> ($n_ctl->{bpr}->{msw}) << 16) | ($ncr)-> ($n_ctl->{bpr}->{lsw}));
    }' unless defined(&GET_BPR);
    eval 'sub GET_DMA_ADDR {
        local($ncr) = @_;
	    eval q(((($ncr)-> &n_type ==  &IS_COBRA) ? (($ncr)-> ($n_dma->{addr}->{la})) : ((($ncr)-> ($n_dma->{addr}->{msw}) << 16) | ($ncr)-> ($n_dma->{addr}->{lsw}))));
    }' unless defined(&GET_DMA_ADDR);
    eval 'sub SET_DMA_ADDR {
        local($ncr, $val) = @_;
	    eval q((-> &n_type ==  &IS_COBRA) ? (-> ($n_dma->{addr}->{la}) = ) : (-> ($n_dma->{addr}->{msw}) = ($val >> 16), (-> ($n_dma->{addr}->{lsw}) = ($val))));
    }' unless defined(&SET_DMA_ADDR);
    eval 'sub GET_DMA_COUNT {
        local($ncr) = @_;
	    eval q((($ncr)-> &n_type ==  &IS_COBRA) ? ($ncr)-> ($n_dma->{count}->{la}) : ((($ncr)-> ($n_dma->{count}->{msw}) << 16) | ($ncr)-> ($n_dma->{count}->{lsw})));
    }' unless defined(&GET_DMA_COUNT);
    eval 'sub SET_DMA_COUNT {
        local($ncr, $val) = @_;
	    eval q((-> &n_type ==  &IS_COBRA) ? -> ($n_dma->{count}->{la}) = : (-> ($n_dma->{count}->{msw}) = ($val >> 16), (-> ($n_dma->{count}->{lsw}) = ($val))));
    }' unless defined(&SET_DMA_COUNT);
    eval 'sub GET_BCR {
        local($ncr) = @_;
	    eval q((((-> ($n_ctl->{bcrh})) << 16) | ( ($ncr)-> ($n_dma->{bcr}))));
    }' unless defined(&GET_BCR);
    eval 'sub SET_BCR {
        local($ncr, $val) = @_;
	    eval q(($ncr)-> ($n_ctl->{bcrh}) = (($val) >> 16), ($ncr)-> ($n_dma->{bcr}) = ($val) & 0xffff);
    }' unless defined(&SET_BCR);
    eval 'sub DISABLE_DMA {
        local($ncr) = @_;
	    eval q( &SET_CSR($ncr, (( &GET_CSR($ncr)) & ~ &NCR_CSR_DMA_EN)));
    }' unless defined(&DISABLE_DMA);
    eval 'sub DISABLE_INTR {
        local($ncr) = @_;
	    eval q( &SET_CSR($ncr, (( &GET_CSR($ncr)) & ~ &NCR_CSR_INTR_EN)));
    }' unless defined(&DISABLE_INTR);
    eval 'sub ENABLE_DMA {
        local($ncr) = @_;
	    eval q( &SET_CSR($ncr, (( &GET_CSR($ncr)) |  &NCR_CSR_DMA_EN)));
    }' unless defined(&ENABLE_DMA);
    eval 'sub ENABLE_INTR {
        local($ncr) = @_;
	    eval q( &SET_CSR($ncr, (( &GET_CSR($ncr)) |  &NCR_CSR_INTR_EN)));
    }' unless defined(&ENABLE_INTR);
    eval 'sub NCR_ARB_RETRIES () {20;}' unless defined(&NCR_ARB_RETRIES);
    eval 'sub NCR_SEL_RETRIES () {5;}' unless defined(&NCR_SEL_RETRIES);
    eval 'sub NCR_ARBITRATION_DELAY () {3;}' unless defined(&NCR_ARBITRATION_DELAY);
    eval 'sub NCR_BUS_CLEAR_DELAY () {1;}' unless defined(&NCR_BUS_CLEAR_DELAY);
    eval 'sub NCR_BUS_SETTLE_DELAY () {1;}' unless defined(&NCR_BUS_SETTLE_DELAY);
    eval 'sub NCR_UDC_WAIT () {1;}' unless defined(&NCR_UDC_WAIT);
    eval 'sub NCR_ARB_WAIT () {5;}' unless defined(&NCR_ARB_WAIT);
    eval 'sub NCR_RESET_DELAY () {4000000;}' unless defined(&NCR_RESET_DELAY);
    eval 'sub NCR_LONG_WAIT () {3000000;}' unless defined(&NCR_LONG_WAIT);
    eval 'sub NCR_WAIT_COUNT () {400000;}' unless defined(&NCR_WAIT_COUNT);
    eval 'sub NCR_SHORT_WAIT () {25000;}' unless defined(&NCR_SHORT_WAIT);
    eval 'sub NCR_PHASE_WAIT () {30;}' unless defined(&NCR_PHASE_WAIT);
    eval 'sub REQ_ASSERTED {
        local($ncr) = @_;
	    eval q(( &ncr_sbcwait( &CBSR,  &NCR_CBSR_REQ,  &NCR_WAIT_COUNT, 1) ==  &SUCCESS));
    }' unless defined(&REQ_ASSERTED);
    eval 'sub REQ_DROPPED {
        local($ncr) = @_;
	    eval q(( &ncr_sbcwait( &CBSR,  &NCR_CBSR_REQ,  &NCR_WAIT_COUNT, 0) ==  &SUCCESS));
    }' unless defined(&REQ_DROPPED);
    eval 'sub INTPENDING {
        local($ncr) = @_;
	    eval q((( &GET_CSR($ncr)) & ( &NCR_CSR_NCR_IP |  &NCR_CSR_DMA_IP |  &NCR_CSR_DMA_CONFLICT |  &NCR_CSR_DMA_BUS_ERR)));
    }' unless defined(&INTPENDING);
    eval 'sub RESELECTING {
        local($cbsr, $cdr, $id) = @_;
	    eval q(((($cbsr &  &NCR_CBSR_RESEL) ==  &NCR_CBSR_RESEL)  && ($cdr & $id)));
    }' unless defined(&RESELECTING);
    eval 'sub Hibyte {
        local($x) = @_;
	    eval q((((($x)) & 0xff00)>>8));
    }' unless defined(&Hibyte);
    eval 'sub Lobyte {
        local($x) = @_;
	    eval q(((($x)) & 0xff));
    }' unless defined(&Lobyte);
    eval 'sub VME_AM_DFLT () { &SP_VME_A24D16_SUPV_D;}' unless defined(&VME_AM_DFLT);
    eval 'sub NCRHWSIZE () {$sizeof{\'struct ncrsbc\'} + $sizeof{\'struct ncrdma\'} + $sizeof{\'struct ncrctl\'};}' unless defined(&NCRHWSIZE);
    eval 'sub COBRA_CSR_OFF () {$sizeof{\'struct ncrsbc\'} + (3* $sizeof{\'u_int\'});}' unless defined(&COBRA_CSR_OFF);
    eval 'sub CSR_OFF () {$sizeof{\'struct ncrsbc\'} + ((8- 1) * $sizeof{\'u_short\'});}' unless defined(&CSR_OFF);
    if(defined(&__cplusplus)) {
    }
}
1;
