require '_h2ph_pre.ph';

unless(defined(&_SYS_SCSI_ADAPTERS_GLMVAR_H)) {
    eval 'sub _SYS_SCSI_ADAPTERS_GLMVAR_H () {1;}' unless defined(&_SYS_SCSI_ADAPTERS_GLMVAR_H);
    if(defined(&__cplusplus)) {
    }
    if(defined(&DEBUG)) {
	eval 'sub GLM_DEBUG () {1;}' unless defined(&GLM_DEBUG);
    }
    eval 'sub N_GLM_UNITS () {( &NTARGETS_WIDE *  &NLUNS_PER_TARGET);}' unless defined(&N_GLM_UNITS);
    eval 'sub ALL_TARGETS () {0xffff;}' unless defined(&ALL_TARGETS);
    eval 'sub GLM_INITIAL_SOFT_SPACE () {4;}' unless defined(&GLM_INITIAL_SOFT_SPACE);
    eval 'sub GLM_XFER_WIDTH () {1;}' unless defined(&GLM_XFER_WIDTH);
    if(defined( &sparc)) {
	eval 'sub GLM_MAX_DMA_SEGS () {1;}' unless defined(&GLM_MAX_DMA_SEGS);
    } else {
	eval 'sub GLM_MAX_DMA_SEGS () {17;}' unless defined(&GLM_MAX_DMA_SEGS);
    }
    if(defined(&_LP64)) {
	eval 'sub PKT_PRIV_SIZE () {2;}' unless defined(&PKT_PRIV_SIZE);
	eval 'sub PKT_PRIV_LEN () {16;}' unless defined(&PKT_PRIV_LEN);
    } else {
	eval 'sub PKT_PRIV_SIZE () {1;}' unless defined(&PKT_PRIV_SIZE);
	eval 'sub PKT_PRIV_LEN () {8;}' unless defined(&PKT_PRIV_LEN);
    }
    eval 'sub PKT2CMD {
        local($pktp) = @_;
	    eval q(((($pktp)-> &pkt_ha_private)));
    }' unless defined(&PKT2CMD);
    eval 'sub CMD2PKT {
        local($cmdp) = @_;
	    eval q(((($cmdp)-> &cmd_pkt)));
    }' unless defined(&CMD2PKT);
    eval 'sub EXTCMDS_STATUS_SIZE () {($sizeof{\'struct scsi_arq_status\'});}' unless defined(&EXTCMDS_STATUS_SIZE);
    eval 'sub CFLAG_CMDDISC () {0x000001;}' unless defined(&CFLAG_CMDDISC);
    eval 'sub CFLAG_WATCH () {0x000002;}' unless defined(&CFLAG_WATCH);
    eval 'sub CFLAG_FINISHED () {0x000004;}' unless defined(&CFLAG_FINISHED);
    eval 'sub CFLAG_CHKSEG () {0x000008;}' unless defined(&CFLAG_CHKSEG);
    eval 'sub CFLAG_COMPLETED () {0x000010;}' unless defined(&CFLAG_COMPLETED);
    eval 'sub CFLAG_PREPARED () {0x000020;}' unless defined(&CFLAG_PREPARED);
    eval 'sub CFLAG_IN_TRANSPORT () {0x000040;}' unless defined(&CFLAG_IN_TRANSPORT);
    eval 'sub CFLAG_RESTORE_PTRS () {0x000080;}' unless defined(&CFLAG_RESTORE_PTRS);
    eval 'sub CFLAG_ARQ_IN_PROGRESS () {0x000100;}' unless defined(&CFLAG_ARQ_IN_PROGRESS);
    eval 'sub CFLAG_TRANFLAG () {0x0001ff;}' unless defined(&CFLAG_TRANFLAG);
    eval 'sub CFLAG_CMDPROXY () {0x000200;}' unless defined(&CFLAG_CMDPROXY);
    eval 'sub CFLAG_CMDARQ () {0x000400;}' unless defined(&CFLAG_CMDARQ);
    eval 'sub CFLAG_DMAVALID () {0x000800;}' unless defined(&CFLAG_DMAVALID);
    eval 'sub CFLAG_DMASEND () {0x001000;}' unless defined(&CFLAG_DMASEND);
    eval 'sub CFLAG_CMDIOPB () {0x002000;}' unless defined(&CFLAG_CMDIOPB);
    eval 'sub CFLAG_CDBEXTERN () {0x004000;}' unless defined(&CFLAG_CDBEXTERN);
    eval 'sub CFLAG_SCBEXTERN () {0x008000;}' unless defined(&CFLAG_SCBEXTERN);
    eval 'sub CFLAG_FREE () {0x010000;}' unless defined(&CFLAG_FREE);
    eval 'sub CFLAG_PRIVEXTERN () {0x020000;}' unless defined(&CFLAG_PRIVEXTERN);
    eval 'sub CFLAG_DMA_PARTIAL () {0x040000;}' unless defined(&CFLAG_DMA_PARTIAL);
    eval 'sub CFLAG_QFULL_STATUS () {0x080000;}' unless defined(&CFLAG_QFULL_STATUS);
    eval 'sub CFLAG_CMD_REMOVED () {0x100000;}' unless defined(&CFLAG_CMD_REMOVED);
    eval 'sub NPT_STATE_ACTIVE () {0x1;}' unless defined(&NPT_STATE_ACTIVE);
    eval 'sub NPT_STATE_QUEUED () {0x2;}' unless defined(&NPT_STATE_QUEUED);
    eval 'sub NRQ_NORMAL_CMD () {(0);}' unless defined(&NRQ_NORMAL_CMD);
    eval 'sub NRQ_ABORT () {(1);}' unless defined(&NRQ_ABORT);
    eval 'sub NRQ_ABORT_TAG () {(2);}' unless defined(&NRQ_ABORT_TAG);
    eval 'sub NRQ_DEV_RESET () {(3);}' unless defined(&NRQ_DEV_RESET);
    eval 'sub NTOFFSET {
        local($label) = @_;
	    eval q((((0)->$label)));
    }' unless defined(&NTOFFSET);
    eval 'sub HBAOFFSET {
        local($label) = @_;
	    eval q((((0)->$label)));
    }' unless defined(&HBAOFFSET);
    eval 'sub GLM_NT_SLOTS_SIZE_TQ () {($sizeof{\'struct nt_slots\'} + ($sizeof{\'struct glm_scsi_cmd\' } * ( &NTAGS -1)));}' unless defined(&GLM_NT_SLOTS_SIZE_TQ);
    eval 'sub GLM_NT_SLOT_SIZE () {($sizeof{\'struct nt_slots\'});}' unless defined(&GLM_NT_SLOT_SIZE);
    eval 'sub NSS_FUNCS () {9;}' unless defined(&NSS_FUNCS);
    eval 'sub NSTATE_IDLE () {(0);}' unless defined(&NSTATE_IDLE);
    eval 'sub NSTATE_ACTIVE () {(1);}' unless defined(&NSTATE_ACTIVE);
    eval 'sub NSTATE_WAIT_RESEL () {(2);}' unless defined(&NSTATE_WAIT_RESEL);
    eval 'sub NSYNCSTATE {
        local($glmp, $nptp) = @_;
	    eval q(($glmp)-> $g_syncstate[($nptp)-> &nt_target]);
    }' unless defined(&NSYNCSTATE);
    eval 'sub NSYNC_SDTR_NOTDONE () {(0);}' unless defined(&NSYNC_SDTR_NOTDONE);
    eval 'sub NSYNC_SDTR_SENT () {(1);}' unless defined(&NSYNC_SDTR_SENT);
    eval 'sub NSYNC_SDTR_RCVD () {(2);}' unless defined(&NSYNC_SDTR_RCVD);
    eval 'sub NSYNC_SDTR_ACK () {(3);}' unless defined(&NSYNC_SDTR_ACK);
    eval 'sub NSYNC_SDTR_REJECT () {(4);}' unless defined(&NSYNC_SDTR_REJECT);
    eval 'sub NSYNC_SDTR_DONE () {(5);}' unless defined(&NSYNC_SDTR_DONE);
    eval 'sub NACTION_DONE () {0x01;}' unless defined(&NACTION_DONE);
    eval 'sub NACTION_ERR () {0x02;}' unless defined(&NACTION_ERR);
    eval 'sub NACTION_GOT_BUS_RESET () {0x04;}' unless defined(&NACTION_GOT_BUS_RESET);
    eval 'sub NACTION_SAVE_BCNT () {0x08;}' unless defined(&NACTION_SAVE_BCNT);
    eval 'sub NACTION_SIOP_HALT () {0x10;}' unless defined(&NACTION_SIOP_HALT);
    eval 'sub NACTION_SIOP_REINIT () {0x20;}' unless defined(&NACTION_SIOP_REINIT);
    eval 'sub NACTION_SDTR () {0x40;}' unless defined(&NACTION_SDTR);
    eval 'sub NACTION_EXT_MSG_OUT () {0x80;}' unless defined(&NACTION_EXT_MSG_OUT);
    eval 'sub NACTION_ACK () {0x100;}' unless defined(&NACTION_ACK);
    eval 'sub NACTION_CHK_INTCODE () {0x200;}' unless defined(&NACTION_CHK_INTCODE);
    eval 'sub NACTION_INITIATOR_ERROR () {0x400;}' unless defined(&NACTION_INITIATOR_ERROR);
    eval 'sub NACTION_MSG_PARITY () {0x800;}' unless defined(&NACTION_MSG_PARITY);
    eval 'sub NACTION_MSG_REJECT () {0x1000;}' unless defined(&NACTION_MSG_REJECT);
    eval 'sub NACTION_BUS_FREE () {0x2000;}' unless defined(&NACTION_BUS_FREE);
    eval 'sub NACTION_ABORT () {0x4000;}' unless defined(&NACTION_ABORT);
    eval 'sub NACTION_DO_BUS_RESET () {0x8000;}' unless defined(&NACTION_DO_BUS_RESET);
    eval 'sub NACTION_CLEAR_CHIP () {0x10000;}' unless defined(&NACTION_CLEAR_CHIP);
    eval 'sub NACTION_ARQ () {0x20000;}' unless defined(&NACTION_ARQ);
    eval 'sub NACTION_EXT_MSG_IN () {0x40000;}' unless defined(&NACTION_EXT_MSG_IN);
    eval 'sub GLM_OPT_WIDE_BUS () {0x01;}' unless defined(&GLM_OPT_WIDE_BUS);
    eval 'sub GLM_OPT_ONBOARD_RAM () {0x02;}' unless defined(&GLM_OPT_ONBOARD_RAM);
    eval 'sub CONFIG_SPACE () {0;}' unless defined(&CONFIG_SPACE);
    eval 'sub IO_SPACE () {1;}' unless defined(&IO_SPACE);
    eval 'sub MEM_SPACE () {2;}' unless defined(&MEM_SPACE);
    eval 'sub BASE_REG2 () {3;}' unless defined(&BASE_REG2);
    eval 'sub FALSE () {0;}' unless defined(&FALSE);
    eval 'sub TRUE () {1;}' unless defined(&TRUE);
    eval 'sub UNDEFINED () {-1;}' unless defined(&UNDEFINED);
    eval 'sub MEG () {(1000* 1000);}' unless defined(&MEG);
    eval 'sub QFULL_RETRIES () {10;}' unless defined(&QFULL_RETRIES);
    eval 'sub QFULL_RETRY_INTERVAL () {100;}' unless defined(&QFULL_RETRY_INTERVAL);
    eval 'sub Tgt {
        local($sp) = @_;
	    eval q((($sp)-> ($cmd_pkt->{pkt_address}->{a_target})));
    }' unless defined(&Tgt);
    eval 'sub Lun {
        local($sp) = @_;
	    eval q((($sp)-> ($cmd_pkt->{pkt_address}->{a_lun})));
    }' unless defined(&Lun);
    eval 'sub GLM_POLL_TIME () {600000;}' unless defined(&GLM_POLL_TIME);
    eval 'sub EFF_ADDR {
        local($start, $offset) = @_;
	    eval q((($start) + ($offset)));
    }' unless defined(&EFF_ADDR);
    eval 'sub SDEV2ADDR {
        local($devp) = @_;
	    eval q(((($devp)-> &sd_address)));
    }' unless defined(&SDEV2ADDR);
    eval 'sub SDEV2TRAN {
        local($devp) = @_;
	    eval q((($devp)-> ($sd_address->{a_hba_tran})));
    }' unless defined(&SDEV2TRAN);
    eval 'sub PKT2TRAN {
        local($pktp) = @_;
	    eval q((($pktp)-> ($pkt_address->{a_hba_tran})));
    }' unless defined(&PKT2TRAN);
    eval 'sub ADDR2TRAN {
        local($ap) = @_;
	    eval q((($ap)-> &a_hba_tran));
    }' unless defined(&ADDR2TRAN);
    eval 'sub TRAN2GLM {
        local($hba) = @_;
	    eval q((($hba)-> &tran_hba_private));
    }' unless defined(&TRAN2GLM);
    eval 'sub SDEV2GLM {
        local($sd) = @_;
	    eval q(( &TRAN2GLM( &SDEV2TRAN($sd))));
    }' unless defined(&SDEV2GLM);
    eval 'sub PKT2GLM {
        local($pktp) = @_;
	    eval q(( &TRAN2GLM( &PKT2TRAN($pktp))));
    }' unless defined(&PKT2GLM);
    eval 'sub PKT2GLMUNITP {
        local($pktp) = @_;
	    eval q( &NTL2UNITP( &PKT2GLM($pktp), ($pktp)-> ($pkt_address->{a_target}), ($pktp)-> ($pkt_address->{a_lun})));
    }' unless defined(&PKT2GLMUNITP);
    eval 'sub ADDR2GLM {
        local($ap) = @_;
	    eval q(( &TRAN2GLM( &ADDR2TRAN($ap))));
    }' unless defined(&ADDR2GLM);
    eval 'sub ADDR2GLMUNITP {
        local($ap) = @_;
	    eval q( &NTL2UNITP( &ADDR2GLM($ap), ($ap)-> &a_target, ($ap)-> &a_lun));
    }' unless defined(&ADDR2GLMUNITP);
    eval 'sub NTL2UNITP {
        local($glm_blkp, $targ, $lun) = @_;
	    eval q((($glm_blkp)-> $g_units[ &TL2INDEX($targ, $lun)]));
    }' unless defined(&NTL2UNITP);
    eval 'sub POLL_TIMEOUT () {(2*  &SCSI_POLL_TIMEOUT * 1000000);}' unless defined(&POLL_TIMEOUT);
    eval 'sub SHORT_POLL_TIMEOUT () {(1000000);}' unless defined(&SHORT_POLL_TIMEOUT);
    eval 'sub TL2INDEX {
        local($target, $lun) = @_;
	    eval q((($target) *  &NLUNS_PER_TARGET + ($lun)));
    }' unless defined(&TL2INDEX);
    eval 'sub glm_put8 {
        local($handle, $addr, $value) = @_;
	    eval q( &ddi_putb($handle, , $value));
    }' unless defined(&glm_put8);
    eval 'sub glm_put16 {
        local($handle, $addr, $value) = @_;
	    eval q( &ddi_putw($handle, , $value));
    }' unless defined(&glm_put16);
    eval 'sub glm_put32 {
        local($handle, $addr, $value) = @_;
	    eval q( &ddi_putl($handle, , $value));
    }' unless defined(&glm_put32);
    eval 'sub glm_get8 {
        local($handle, $addr) = @_;
	    eval q( &ddi_getb($handle, ($addr)));
    }' unless defined(&glm_get8);
    eval 'sub glm_get16 {
        local($handle, $addr) = @_;
	    eval q( &ddi_getw($handle, ($addr)));
    }' unless defined(&glm_get16);
    eval 'sub glm_get32 {
        local($handle, $addr) = @_;
	    eval q( &ddi_getl($handle, ($addr)));
    }' unless defined(&glm_get32);
    eval 'sub glm_rep_put8 {
        local($handle, $host_addr, $dev_addr, $count, $flags) = @_;
	    eval q( &ddi_rep_putb($handle, $host_addr, $dev_addr, $count, $flags));
    }' unless defined(&glm_rep_put8);
    eval 'sub glm_rep_put32 {
        local($handle, $host_addr, $dev_addr, $count, $flags) = @_;
	    eval q( &ddi_rep_putl($handle, $host_addr, $dev_addr, $count, $flags));
    }' unless defined(&glm_rep_put32);
    eval 'sub GLM_RESET {
        local($P) = @_;
	    eval q( &glm53c87x_reset($P));
    }' unless defined(&GLM_RESET);
    eval 'sub GLM_INIT {
        local($P) = @_;
	    eval q( &glm53c87x_init($P));
    }' unless defined(&GLM_INIT);
    eval 'sub GLM_ENABLE_INTR {
        local($P) = @_;
	    eval q( &glm53c87x_enable($P));
    }' unless defined(&GLM_ENABLE_INTR);
    eval 'sub GLM_DISABLE_INTR {
        local($P) = @_;
	    eval q( &glm53c87x_disable($P));
    }' unless defined(&GLM_DISABLE_INTR);
    eval 'sub GLM_GET_ISTAT {
        local($P) = @_;
	    eval q(( &glm_get8( ($glm->{g_datap}), ( ($glm->{g_devaddr}) +  &NREG_ISTAT))));
    }' unless defined(&GLM_GET_ISTAT);
    eval 'sub GLM_HALT {
        local($P) = @_;
	    eval q( &glm53c87x_halt($P));
    }' unless defined(&GLM_HALT);
    eval 'sub GLM_SET_SIGP {
        local($P) = @_;
	    eval q( &ClrSetBits( ($glm->{g_devaddr}) +  &NREG_ISTAT, 0,  &NB_ISTAT_SIGP));
    }' unless defined(&GLM_SET_SIGP);
    eval 'sub GLM_RESET_SIGP {
        local($P) = @_;
	    eval q(  &glm_get8( ($glm->{g_datap}), ( ($glm->{g_devaddr}) +  &NREG_CTEST2)));
    }' unless defined(&GLM_RESET_SIGP);
    eval 'sub GLM_GET_INTCODE {
        local($P) = @_;
	    eval q(( &glm_get32( ($glm->{g_datap}), ( ($glm->{g_devaddr}) +  &NREG_DSPS))));
    }' unless defined(&GLM_GET_INTCODE);
    eval 'sub GLM_CHECK_ERROR {
        local($P, $nptp, $pktp) = @_;
	    eval q( &glm53c87x_check_error($nptp, $pktp));
    }' unless defined(&GLM_CHECK_ERROR);
    eval 'sub GLM_DMA_STATUS {
        local($P) = @_;
	    eval q( &glm53c87x_dma_status($P));
    }' unless defined(&GLM_DMA_STATUS);
    eval 'sub GLM_SCSI_STATUS {
        local($P) = @_;
	    eval q( &glm53c87x_scsi_status($P));
    }' unless defined(&GLM_SCSI_STATUS);
    eval 'sub GLM_SAVE_BYTE_COUNT {
        local($P, $nptp) = @_;
	    eval q( &glm53c87x_save_byte_count($P, $nptp));
    }' unless defined(&GLM_SAVE_BYTE_COUNT);
    eval 'sub GLM_GET_TARGET {
        local($P, $tp) = @_;
	    eval q( &glm53c87x_get_target($P, $tp));
    }' unless defined(&GLM_GET_TARGET);
    eval 'sub GLM_SETUP_SCRIPT {
        local($P, $nptp) = @_;
	    eval q( &glm53c87x_setup_script($P, $nptp));
    }' unless defined(&GLM_SETUP_SCRIPT);
    eval 'sub GLM_START_SCRIPT {
        local($P, $script) = @_;
	    eval q( &glm_put32( ($glm->{g_datap}), ( ($glm->{g_devaddr}) +  &NREG_DSP),  ($glm->{g_glm_scripts[$script]})));
    }' unless defined(&GLM_START_SCRIPT);
    eval 'sub GLM_SET_SYNCIO {
        local($P, $nptp) = @_;
	    eval q( &glm53c87x_set_syncio($P, $nptp));
    }' unless defined(&GLM_SET_SYNCIO);
    eval 'sub GLM_BUS_RESET {
        local($P) = @_;
	    eval q( &glm53c87x_bus_reset($P));
    }' unless defined(&GLM_BUS_RESET);
    eval 'sub INTPENDING {
        local($glm) = @_;
	    eval q(( &GLM_GET_ISTAT($glm) & ( &NB_ISTAT_DIP |  &NB_ISTAT_SIP)));
    }' unless defined(&INTPENDING);
    eval 'sub ClrSetBits {
        local($reg, $clr, $set) = @_;
	    eval q( &glm_put8( ($glm->{g_datap}), , (( &glm_get8( ($glm->{g_datap}), ($reg)) & ~($clr)) | ($set))));
    }' unless defined(&ClrSetBits);
    eval 'sub CLEAR_DMA {
        local($glm) = @_;
	    eval q( &glm_put8(-> &g_datap, (-> &g_devaddr +  &NREG_CTEST3),  &glm_get8(-> &g_datap, (($glm)-> &g_devaddr +  &NREG_CTEST3)) |  &NB_CTEST3_CLF));
    }' unless defined(&CLEAR_DMA);
    eval 'sub CLEAR_SCSI_FIFO {
        local($glm) = @_;
	    eval q( &glm_put8(-> &g_datap, (-> &g_devaddr +  &NREG_STEST3),  &glm_get8(-> &g_datap, (($glm)-> &g_devaddr +  &NREG_STEST3)) |  &NB_STEST3_CSF));
    }' unless defined(&CLEAR_SCSI_FIFO);
    eval 'sub RESET_SCSI_OFFSET {
        local($glm) = @_;
	    eval q( &glm_put8(-> &g_datap, (-> &g_devaddr +  &NREG_STEST2),  &glm_get8(-> &g_datap, (($glm)-> &g_devaddr +  &NREG_STEST2)) |  &NB_STEST2_ROF));
    }' unless defined(&RESET_SCSI_OFFSET);
    eval 'sub GLM_RMQ {
        local($glm, $unit) = @_;
	    eval q( &if (($unit =  ($glm->{g_forwp})) !=  &NULL) {  &if (( ($glm->{g_forwp}) =  ($unit->{nt_linkp})) ==  &NULL) {  ($glm->{g_backp}) =  &NULL; }  ($unit->{nt_linkp}) =  &NULL;  ($unit->{nt_state}) &= ~ &NPT_STATE_QUEUED; });
    }' unless defined(&GLM_RMQ);
    eval 'sub GLM_WAITQ_RM {
        local($unit, $cmdp) = @_;
	    eval q( &if (($cmdp =  ($unit->{nt_waitq})) !=  &NULL) {  &if (( ($unit->{nt_waitq}) =  ($cmdp->{cmd_linkp})) ==  &NULL)  ($unit->{nt_waitqtail}) =  ($unit->{nt_waitq});  ($cmdp->{cmd_linkp}) =  &NULL;  ($cmdp->{cmd_queued}) =  &FALSE; });
    }' unless defined(&GLM_WAITQ_RM);
    eval 'sub NB_ISTAT_CON () {0x08;}' unless defined(&NB_ISTAT_CON);
    eval 'sub NB_ISTAT_SIP () {0x02;}' unless defined(&NB_ISTAT_SIP);
    eval 'sub NB_ISTAT_DIP () {0x01;}' unless defined(&NB_ISTAT_DIP);
    eval 'sub NSS_STARTUP () {0;}' unless defined(&NSS_STARTUP);
    eval 'sub NSS_CONTINUE () {1;}' unless defined(&NSS_CONTINUE);
    eval 'sub NSS_WAIT4RESELECT () {2;}' unless defined(&NSS_WAIT4RESELECT);
    eval 'sub NSS_CLEAR_ACK () {3;}' unless defined(&NSS_CLEAR_ACK);
    eval 'sub NSS_EXT_MSG_OUT () {4;}' unless defined(&NSS_EXT_MSG_OUT);
    eval 'sub NSS_ERR_MSG () {5;}' unless defined(&NSS_ERR_MSG);
    eval 'sub NSS_BUS_DEV_RESET () {6;}' unless defined(&NSS_BUS_DEV_RESET);
    eval 'sub NSS_ABORT () {7;}' unless defined(&NSS_ABORT);
    eval 'sub NSS_EXT_MSG_IN () {8;}' unless defined(&NSS_EXT_MSG_IN);
    eval 'sub NSOP_MOVE_MASK () {0xf8;}' unless defined(&NSOP_MOVE_MASK);
    eval 'sub NSOP_MOVE () {0x18;}' unless defined(&NSOP_MOVE);
    eval 'sub NSOP_CHMOV () {0x08;}' unless defined(&NSOP_CHMOV);
    eval 'sub NSOP_PHASE () {0x0f;}' unless defined(&NSOP_PHASE);
    eval 'sub NSOP_DATAOUT () {0x00;}' unless defined(&NSOP_DATAOUT);
    eval 'sub NSOP_DATAIN () {0x01;}' unless defined(&NSOP_DATAIN);
    eval 'sub NSOP_COMMAND () {0x02;}' unless defined(&NSOP_COMMAND);
    eval 'sub NSOP_STATUS () {0x03;}' unless defined(&NSOP_STATUS);
    eval 'sub NSOP_MSGOUT () {0x06;}' unless defined(&NSOP_MSGOUT);
    eval 'sub NSOP_MSGIN () {0x07;}' unless defined(&NSOP_MSGIN);
    eval 'sub NINT_OK () {0xff00;}' unless defined(&NINT_OK);
    eval 'sub NINT_ILI_PHASE () {0xff01;}' unless defined(&NINT_ILI_PHASE);
    eval 'sub NINT_UNS_MSG () {0xff02;}' unless defined(&NINT_UNS_MSG);
    eval 'sub NINT_UNS_EXTMSG () {0xff03;}' unless defined(&NINT_UNS_EXTMSG);
    eval 'sub NINT_MSGIN () {0xff04;}' unless defined(&NINT_MSGIN);
    eval 'sub NINT_MSGREJ () {0xff05;}' unless defined(&NINT_MSGREJ);
    eval 'sub NINT_RESEL () {0xff06;}' unless defined(&NINT_RESEL);
    eval 'sub NINT_DISC () {0xff07;}' unless defined(&NINT_DISC);
    eval 'sub NINT_RESEL_ERR () {0xff08;}' unless defined(&NINT_RESEL_ERR);
    eval 'sub NINT_SDP_MSG () {0xff09;}' unless defined(&NINT_SDP_MSG);
    eval 'sub NINT_RP_MSG () {0xff0a;}' unless defined(&NINT_RP_MSG);
    eval 'sub NINT_SIGPROC () {0xff0b;}' unless defined(&NINT_SIGPROC);
    eval 'sub NINT_TOOMUCHDATA () {0xff0c;}' unless defined(&NINT_TOOMUCHDATA);
    eval 'sub NINT_SDTR () {0xff0d;}' unless defined(&NINT_SDTR);
    eval 'sub NINT_NEG_REJECT () {0xff0e;}' unless defined(&NINT_NEG_REJECT);
    eval 'sub NINT_REJECT () {0xff0f;}' unless defined(&NINT_REJECT);
    eval 'sub NINT_DEV_RESET () {0xff10;}' unless defined(&NINT_DEV_RESET);
    eval 'sub NINT_WDTR () {0xff11;}' unless defined(&NINT_WDTR);
    eval 'sub NINT_IWR () {0xff12;}' unless defined(&NINT_IWR);
    eval 'sub DEFAULT_SCSI_OPTIONS () { &SCSI_OPTIONS_DR;}' unless defined(&DEFAULT_SCSI_OPTIONS);
    eval 'sub DEFAULT_TAG_AGE_LIMIT () {2;}' unless defined(&DEFAULT_TAG_AGE_LIMIT);
    eval 'sub DEFAULT_RESET_DELAY () {3000;}' unless defined(&DEFAULT_RESET_DELAY);
    eval 'sub DEFAULT_WD_TICK () {10;}' unless defined(&DEFAULT_WD_TICK);
    eval 'sub GLM_PROXY_TYPE () { &CDB_GROUP0;}' unless defined(&GLM_PROXY_TYPE);
    eval 'sub GLM_PROXY_RESULT () { &GLM_PROXY_TYPE+1;}' unless defined(&GLM_PROXY_RESULT);
    eval 'sub GLM_PROXY_SNDMSG () {1;}' unless defined(&GLM_PROXY_SNDMSG);
    eval 'sub GLM_WATCH_RESET_DELAY_TICK () {50;}' unless defined(&GLM_WATCH_RESET_DELAY_TICK);
    eval 'sub MAX_THROTTLE () {254;}' unless defined(&MAX_THROTTLE);
    eval 'sub HOLD_THROTTLE () {0;}' unless defined(&HOLD_THROTTLE);
    eval 'sub DRAIN_THROTTLE () {-1;}' unless defined(&DRAIN_THROTTLE);
    eval 'sub QFULL_THROTTLE () {-2;}' unless defined(&QFULL_THROTTLE);
    eval 'sub NOTAG {
        local($tgt) = @_;
	    eval q(( ($glm->{g_notag}) & (1<<($tgt))));
    }' unless defined(&NOTAG);
    eval 'sub TAGGED {
        local($tgt) = @_;
	    eval q((( ($glm->{g_notag}) & (1<<($tgt))) == 0));
    }' unless defined(&TAGGED);
    if(defined( &GLM_DEBUG)) {
	eval 'sub GLM_DBGPR {
	    local($m, $args) = @_;
    	    eval q( &if ( &glm_debug_flags & ($m))  &glm_printf $args);
	}' unless defined(&GLM_DBGPR);
    } else {
	eval 'sub GLM_DBGPR {
	    local($m, $args) = @_;
    	    eval q();
	}' unless defined(&GLM_DBGPR);
    }
    eval 'sub NDBG0 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x01, $args));
    }' unless defined(&NDBG0);
    eval 'sub NDBG1 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x02, $args));
    }' unless defined(&NDBG1);
    eval 'sub NDBG2 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x04, $args));
    }' unless defined(&NDBG2);
    eval 'sub NDBG3 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x08, $args));
    }' unless defined(&NDBG3);
    eval 'sub NDBG4 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x10, $args));
    }' unless defined(&NDBG4);
    eval 'sub NDBG5 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x20, $args));
    }' unless defined(&NDBG5);
    eval 'sub NDBG6 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x40, $args));
    }' unless defined(&NDBG6);
    eval 'sub NDBG7 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x80, $args));
    }' unless defined(&NDBG7);
    eval 'sub NDBG8 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x0100, $args));
    }' unless defined(&NDBG8);
    eval 'sub NDBG9 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x0200, $args));
    }' unless defined(&NDBG9);
    eval 'sub NDBG10 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x0400, $args));
    }' unless defined(&NDBG10);
    eval 'sub NDBG11 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x0800, $args));
    }' unless defined(&NDBG11);
    eval 'sub NDBG12 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x1000, $args));
    }' unless defined(&NDBG12);
    eval 'sub NDBG13 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x2000, $args));
    }' unless defined(&NDBG13);
    eval 'sub NDBG14 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x4000, $args));
    }' unless defined(&NDBG14);
    eval 'sub NDBG15 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x8000, $args));
    }' unless defined(&NDBG15);
    eval 'sub NDBG16 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x010000, $args));
    }' unless defined(&NDBG16);
    eval 'sub NDBG17 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x020000, $args));
    }' unless defined(&NDBG17);
    eval 'sub NDBG18 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x040000, $args));
    }' unless defined(&NDBG18);
    eval 'sub NDBG19 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x080000, $args));
    }' unless defined(&NDBG19);
    eval 'sub NDBG20 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x100000, $args));
    }' unless defined(&NDBG20);
    eval 'sub NDBG21 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x200000, $args));
    }' unless defined(&NDBG21);
    eval 'sub NDBG22 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x400000, $args));
    }' unless defined(&NDBG22);
    eval 'sub NDBG23 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x800000, $args));
    }' unless defined(&NDBG23);
    eval 'sub NDBG24 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x1000000, $args));
    }' unless defined(&NDBG24);
    eval 'sub NDBG25 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x2000000, $args));
    }' unless defined(&NDBG25);
    eval 'sub NDBG26 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x4000000, $args));
    }' unless defined(&NDBG26);
    eval 'sub NDBG27 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x8000000, $args));
    }' unless defined(&NDBG27);
    eval 'sub NDBG28 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x10000000, $args));
    }' unless defined(&NDBG28);
    eval 'sub NDBG29 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x20000000, $args));
    }' unless defined(&NDBG29);
    eval 'sub NDBG30 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x40000000, $args));
    }' unless defined(&NDBG30);
    eval 'sub NDBG31 {
        local($args) = @_;
	    eval q( &GLM_DBGPR(0x80000000, $args));
    }' unless defined(&NDBG31);
    eval 'sub RQ_MAKECOM_COMMON {
        local($pktp, $flag, $cmd) = @_;
	    eval q(-> &pkt_flags = , (-> &pkt_cdbp)-> &scc_cmd = , (($pktp)-> &pkt_cdbp)-> &scc_lun = ($pktp)-> ($pkt_address->{a_lun}));
    }' unless defined(&RQ_MAKECOM_COMMON);
    eval 'sub RQ_MAKECOM_G0 {
        local($pktp, $flag, $cmd, $addr, $cnt) = @_;
	    eval q( &RQ_MAKECOM_COMMON(, , ),  &FORMG0ADDR((-> &pkt_cdbp), ),  &FORMG0COUNT((($pktp)-> &pkt_cdbp), ($cnt)));
    }' unless defined(&RQ_MAKECOM_G0);
    if(defined(&__cplusplus)) {
    }
}
1;
