require '_h2ph_pre.ph';

unless(defined(&_SYS_SCSI_ADAPTERS_FASREG_H)) {
    eval 'sub _SYS_SCSI_ADAPTERS_FASREG_H () {1;}' unless defined(&_SYS_SCSI_ADAPTERS_FASREG_H);
    require 'sys/note.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub fas_busid () { &fas_stat;}' unless defined(&fas_busid);
    eval 'sub fas_timeout () { &fas_intr;}' unless defined(&fas_timeout);
    eval 'sub fas_sync_period () { &fas_step;}' unless defined(&fas_sync_period);
    eval 'sub fas_sync_offset () { &fas_fifo_flag;}' unless defined(&fas_sync_offset);
    eval 'sub fas_stat2 () { &fas_clock_conv;}' unless defined(&fas_stat2);
    eval 'sub fas_conf4 () { &fas_test;}' unless defined(&fas_conf4);
    eval 'sub fas_id_code () { &fas_recmd_lo;}' unless defined(&fas_id_code);
    eval 'sub CMD_NOP () {0x0;}' unless defined(&CMD_NOP);
    eval 'sub CMD_FLUSH () {0x1;}' unless defined(&CMD_FLUSH);
    eval 'sub CMD_RESET_FAS () {0x2;}' unless defined(&CMD_RESET_FAS);
    eval 'sub CMD_RESET_SCSI () {0x3;}' unless defined(&CMD_RESET_SCSI);
    eval 'sub CMD_RESEL_SEQ () {0x40;}' unless defined(&CMD_RESEL_SEQ);
    eval 'sub CMD_SEL_NOATN () {0x41;}' unless defined(&CMD_SEL_NOATN);
    eval 'sub CMD_SEL_ATN () {0x42;}' unless defined(&CMD_SEL_ATN);
    eval 'sub CMD_SEL_STOP () {0x43;}' unless defined(&CMD_SEL_STOP);
    eval 'sub CMD_EN_RESEL () {0x44;}' unless defined(&CMD_EN_RESEL);
    eval 'sub CMD_DIS_RESEL () {0x45;}' unless defined(&CMD_DIS_RESEL);
    eval 'sub CMD_SEL_ATN3 () {0x46;}' unless defined(&CMD_SEL_ATN3);
    eval 'sub CMD_TRAN_INFO () {0x10;}' unless defined(&CMD_TRAN_INFO);
    eval 'sub CMD_COMP_SEQ () {0x11;}' unless defined(&CMD_COMP_SEQ);
    eval 'sub CMD_MSG_ACPT () {0x12;}' unless defined(&CMD_MSG_ACPT);
    eval 'sub CMD_TRAN_PAD () {0x18;}' unless defined(&CMD_TRAN_PAD);
    eval 'sub CMD_SET_ATN () {0x1a;}' unless defined(&CMD_SET_ATN);
    eval 'sub CMD_CLR_ATN () {0x1b;}' unless defined(&CMD_CLR_ATN);
    eval 'sub CMD_DISCONNECT () {0x27;}' unless defined(&CMD_DISCONNECT);
    eval 'sub CMD_DMA () {0x80;}' unless defined(&CMD_DMA);
    eval 'sub FIFOSIZE () {16;}' unless defined(&FIFOSIZE);
    eval 'sub MAX_FIFO_FLAG () {( &FIFOSIZE-1);}' unless defined(&MAX_FIFO_FLAG);
    eval 'sub FAS_FIFO_ONZ () {0x20;}' unless defined(&FAS_FIFO_ONZ);
    eval 'sub FIFO_CNT_MASK () {0x1f;}' unless defined(&FIFO_CNT_MASK);
    eval 'sub FAS_STAT_IPEND () {0x80;}' unless defined(&FAS_STAT_IPEND);
    eval 'sub FAS_STAT_GERR () {0x40;}' unless defined(&FAS_STAT_GERR);
    eval 'sub FAS_STAT_PERR () {0x20;}' unless defined(&FAS_STAT_PERR);
    eval 'sub FAS_STAT_XZERO () {0x10;}' unless defined(&FAS_STAT_XZERO);
    eval 'sub FAS_STAT_XCMP () {0x8;}' unless defined(&FAS_STAT_XCMP);
    eval 'sub FAS_STAT_MSG () {0x4;}' unless defined(&FAS_STAT_MSG);
    eval 'sub FAS_STAT_CD () {0x2;}' unless defined(&FAS_STAT_CD);
    eval 'sub FAS_STAT_IO () {0x1;}' unless defined(&FAS_STAT_IO);
    eval 'sub FAS_STAT_BITS () {"\\20\\10IPND\\07GERR\\06PERR\\05XZERO\\04XCMP\\03MSG\\02CD\\01IO";}' unless defined(&FAS_STAT_BITS);
    eval 'sub FAS_PHASE_MASK () {( &FAS_STAT_MSG |  &FAS_STAT_CD |  &FAS_STAT_IO);}' unless defined(&FAS_PHASE_MASK);
    eval 'sub FAS_PHASE_DATA_OUT () {0;}' unless defined(&FAS_PHASE_DATA_OUT);
    eval 'sub FAS_PHASE_DATA_IN () {( &FAS_STAT_IO);}' unless defined(&FAS_PHASE_DATA_IN);
    eval 'sub FAS_PHASE_COMMAND () {( &FAS_STAT_CD);}' unless defined(&FAS_PHASE_COMMAND);
    eval 'sub FAS_PHASE_STATUS () {( &FAS_STAT_CD |  &FAS_STAT_IO);}' unless defined(&FAS_PHASE_STATUS);
    eval 'sub FAS_PHASE_MSG_OUT () {( &FAS_STAT_MSG |  &FAS_STAT_CD);}' unless defined(&FAS_PHASE_MSG_OUT);
    eval 'sub FAS_PHASE_MSG_IN () {( &FAS_STAT_MSG |  &FAS_STAT_CD |  &FAS_STAT_IO);}' unless defined(&FAS_PHASE_MSG_IN);
    eval 'sub FAS_INT_RESET () {0x80;}' unless defined(&FAS_INT_RESET);
    eval 'sub FAS_INT_ILLEGAL () {0x40;}' unless defined(&FAS_INT_ILLEGAL);
    eval 'sub FAS_INT_DISCON () {0x20;}' unless defined(&FAS_INT_DISCON);
    eval 'sub FAS_INT_BUS () {0x10;}' unless defined(&FAS_INT_BUS);
    eval 'sub FAS_INT_FCMP () {0x8;}' unless defined(&FAS_INT_FCMP);
    eval 'sub FAS_INT_RESEL () {0x4;}' unless defined(&FAS_INT_RESEL);
    eval 'sub FAS_INT_SELATN () {0x2;}' unless defined(&FAS_INT_SELATN);
    eval 'sub FAS_INT_SEL () {0x1;}' unless defined(&FAS_INT_SEL);
    eval 'sub FAS_INT_BITS () {"\\20\\10RST\\07ILL\\06DISC\\05BUS\\04FCMP\\03RESEL\\02SATN\\01SEL";}' unless defined(&FAS_INT_BITS);
    eval 'sub FAS_STEP_MASK () {0x7;}' unless defined(&FAS_STEP_MASK);
    eval 'sub FAS_STEP_ARBSEL () {0;}' unless defined(&FAS_STEP_ARBSEL);
    eval 'sub FAS_STEP_SENTID () {1;}' unless defined(&FAS_STEP_SENTID);
    eval 'sub FAS_STEP_NOTCMD () {2;}' unless defined(&FAS_STEP_NOTCMD);
    eval 'sub FAS_STEP_PCMD () {3;}' unless defined(&FAS_STEP_PCMD);
    eval 'sub FAS_STEP_DONE () {4;}' unless defined(&FAS_STEP_DONE);
    eval 'sub FAS_CONF_SLOWMODE () {0x80;}' unless defined(&FAS_CONF_SLOWMODE);
    eval 'sub FAS_CONF_DISRINT () {0x40;}' unless defined(&FAS_CONF_DISRINT);
    eval 'sub FAS_CONF_PARTEST () {0x20;}' unless defined(&FAS_CONF_PARTEST);
    eval 'sub FAS_CONF_PAREN () {0x10;}' unless defined(&FAS_CONF_PAREN);
    eval 'sub FAS_CONF_CHIPTEST () {0x8;}' unless defined(&FAS_CONF_CHIPTEST);
    eval 'sub FAS_CONF_BUSID () {0x7;}' unless defined(&FAS_CONF_BUSID);
    eval 'sub DEFAULT_HOSTID () {7;}' unless defined(&DEFAULT_HOSTID);
    eval 'sub FAS_TEST_TGT () {0x1;}' unless defined(&FAS_TEST_TGT);
    eval 'sub FAS_TEST_INI () {0x2;}' unless defined(&FAS_TEST_INI);
    eval 'sub FAS_TEST_TRI () {0x4;}' unless defined(&FAS_TEST_TRI);
    eval 'sub FAS_CONF2_XL32 () {0x80;}' unless defined(&FAS_CONF2_XL32);
    eval 'sub FAS_CONF2_MKDONE () {0x40;}' unless defined(&FAS_CONF2_MKDONE);
    eval 'sub FAS_CONF2_PAUSE_INTR_DISABLE () {0x20;}' unless defined(&FAS_CONF2_PAUSE_INTR_DISABLE);
    eval 'sub FAS_CONF2_FENABLE () {0x10;}' unless defined(&FAS_CONF2_FENABLE);
    eval 'sub FAS_CONF2_SCSI2 () {0x8;}' unless defined(&FAS_CONF2_SCSI2);
    eval 'sub FAS_CONF2_TGT_BAD_PRTY_ABORT () {0x4;}' unless defined(&FAS_CONF2_TGT_BAD_PRTY_ABORT);
    eval 'sub FAS_CONF2_DMA_PRTY_ENABLE () {0x1;}' unless defined(&FAS_CONF2_DMA_PRTY_ENABLE);
    eval 'sub FAS_CONF3_ODDBYTE_AUTO () {0x80;}' unless defined(&FAS_CONF3_ODDBYTE_AUTO);
    eval 'sub FAS_CONF3_WIDE () {0x40;}' unless defined(&FAS_CONF3_WIDE);
    eval 'sub FAS_CONF3_IDBIT3 () {0x20;}' unless defined(&FAS_CONF3_IDBIT3);
    eval 'sub FAS_CONF3_IDRESCHK () {0x10;}' unless defined(&FAS_CONF3_IDRESCHK);
    eval 'sub FAS_CONF3_QUENB () {0x8;}' unless defined(&FAS_CONF3_QUENB);
    eval 'sub FAS_CONF3_CDB10 () {0x4;}' unless defined(&FAS_CONF3_CDB10);
    eval 'sub FAS_CONF3_FASTSCSI () {0x2;}' unless defined(&FAS_CONF3_FASTSCSI);
    eval 'sub FAS_CONF3_FASTCLK () {0x1;}' unless defined(&FAS_CONF3_FASTCLK);
    eval 'sub FAS_CONF4_PADMSGS () {0x20;}' unless defined(&FAS_CONF4_PADMSGS);
    eval 'sub FAS_REV_MASK () {0x7;}' unless defined(&FAS_REV_MASK);
    eval 'sub FAS_FCODE_MASK () {0xf8;}' unless defined(&FAS_FCODE_MASK);
    eval 'sub SET_FAS_COUNT {
        local($fasreg, $val) = @_;
	    eval q({  &fas_reg_write( &fas,  ($fasreg->{fas_xcnt_lo}), $val);  &fas_reg_write( &fas,  ($fasreg->{fas_xcnt_mid}), ($val >> 8));  &fas_reg_write( &fas,  ($fasreg->{fas_recmd_lo}), (($val >> 16)));  &fas_reg_write( &fas,  ($fasreg->{fas_recmd_hi}), 0); });
    }' unless defined(&SET_FAS_COUNT);
    eval 'sub GET_FAS_COUNT {
        local($fasreg, $val) = @_;
	    eval q({  &uint8_t  &lo,  &mid,  &r_lo;  &lo =  &fas_reg_read( &fas,  ($fasreg->{fas_xcnt_lo}));  &mid =  &fas_reg_read( &fas,  ($fasreg->{fas_xcnt_mid}));  &r_lo =  &fas_reg_read( &fas,  ($fasreg->{fas_recmd_lo})); = ( &lo | ( &mid << 8) | (( &r_lo) << 16)); });
    }' unless defined(&GET_FAS_COUNT);
    eval 'sub FAS_MAX_DMACOUNT () {(16*  &MEG);}' unless defined(&FAS_MAX_DMACOUNT);
    eval 'sub CLOCK_10MHZ () {2;}' unless defined(&CLOCK_10MHZ);
    eval 'sub CLOCK_15MHZ () {3;}' unless defined(&CLOCK_15MHZ);
    eval 'sub CLOCK_20MHZ () {4;}' unless defined(&CLOCK_20MHZ);
    eval 'sub CLOCK_25MHZ () {5;}' unless defined(&CLOCK_25MHZ);
    eval 'sub CLOCK_30MHZ () {6;}' unless defined(&CLOCK_30MHZ);
    eval 'sub CLOCK_35MHZ () {7;}' unless defined(&CLOCK_35MHZ);
    eval 'sub CLOCK_40MHZ () {8;}' unless defined(&CLOCK_40MHZ);
    eval 'sub CLOCK_MASK () {0x7;}' unless defined(&CLOCK_MASK);
    eval 'sub CLOCK_PERIOD {
        local($mhz) = @_;
	    eval q((1000*  &MEG) / ($mhz / 1000));
    }' unless defined(&CLOCK_PERIOD);
    eval 'sub CONVERT_PERIOD {
        local($time) = @_;
	    eval q((($time) + 3) >> 2);
    }' unless defined(&CONVERT_PERIOD);
    eval 'sub FAS_CLOCK_DELAY () {7682;}' unless defined(&FAS_CLOCK_DELAY);
    eval 'sub FAS_CLOCK_TICK {
        local($fas) = @_;
	    eval q(( &FAS_CLOCK_DELAY * -> &f_clock_conv * -> &f_clock_cycle) / 1000);
    }' unless defined(&FAS_CLOCK_TICK);
    eval 'sub FAS_SEL_TIMEOUT () {(250*  &MEG);}' unless defined(&FAS_SEL_TIMEOUT);
    eval 'sub FAS_CLOCK_TIMEOUT {
        local($tick,	$selection_timeout) = @_;
	    eval q(((($selection_timeout) *  &MEG) + ($tick) - 1) / ($tick));
    }' unless defined(&FAS_CLOCK_TIMEOUT);
    eval 'sub MIN_SYNC_FAST {
        local($fas) = @_;
	    eval q(4);
    }' unless defined(&MIN_SYNC_FAST);
    eval 'sub MIN_SYNC_SLOW {
        local($fas) = @_;
	    eval q(((($fas)-> &e_fasconf &  &FAS_CONF_SLOWMODE) ? 6: 5));
    }' unless defined(&MIN_SYNC_SLOW);
    eval 'sub MIN_SYNC {
        local($fas) = @_;
	    eval q(( &MIN_SYNC_FAST(($fas))));
    }' unless defined(&MIN_SYNC);
    eval 'sub MAX_SYNC {
        local($fas) = @_;
	    eval q(35);
    }' unless defined(&MAX_SYNC);
    eval 'sub SYNC_PERIOD_MASK () {0x1f;}' unless defined(&SYNC_PERIOD_MASK);
    eval 'sub MIN_SYNC_TIME {
        local($fas) = @_;
	    eval q(( &MIN_SYNC() * (-> &f_clock_cycle)) / 1000);
    }' unless defined(&MIN_SYNC_TIME);
    eval 'sub MAX_SYNC_TIME {
        local($fas) = @_;
	    eval q(( &MAX_SYNC() * (-> &f_clock_cycle)) / 1000);
    }' unless defined(&MAX_SYNC_TIME);
    eval 'sub MIN_SYNC_PERIOD {
        local($fas) = @_;
	    eval q(( &CONVERT_PERIOD( &MIN_SYNC_TIME(($fas)))));
    }' unless defined(&MIN_SYNC_PERIOD);
    eval 'sub MAX_SYNC_PERIOD {
        local($fas) = @_;
	    eval q(( &CONVERT_PERIOD( &MAX_SYNC_TIME(($fas)))));
    }' unless defined(&MAX_SYNC_PERIOD);
    eval 'sub DEFAULT_SYNC_PERIOD () {200;}' unless defined(&DEFAULT_SYNC_PERIOD);
    eval 'sub DEFAULT_FASTSYNC_PERIOD () {100;}' unless defined(&DEFAULT_FASTSYNC_PERIOD);
    eval 'sub FASTSCSI_THRESHOLD () {50;}' unless defined(&FASTSCSI_THRESHOLD);
    eval 'sub FAS_SYNC_KBPS {
        local($ns) = @_;
	    eval q(((((1000*  &MEG) / ($ns)) + 999) / 1000));
    }' unless defined(&FAS_SYNC_KBPS);
    eval 'sub DEFAULT_OFFSET () {15;}' unless defined(&DEFAULT_OFFSET);
    eval 'sub FAS366 () {0;}' unless defined(&FAS366);
    eval 'sub FAST () {5;}' unless defined(&FAST);
    eval 'sub FAS_STAT2_SEQCNT () {0x01;}' unless defined(&FAS_STAT2_SEQCNT);
    eval 'sub FAS_STAT2_FLATCHED () {0x02;}' unless defined(&FAS_STAT2_FLATCHED);
    eval 'sub FAS_STAT2_CLATCHED () {0x04;}' unless defined(&FAS_STAT2_CLATCHED);
    eval 'sub FAS_STAT2_CACTIVE () {0x08;}' unless defined(&FAS_STAT2_CACTIVE);
    eval 'sub FAS_STAT2_SCSI16 () {0x10;}' unless defined(&FAS_STAT2_SCSI16);
    eval 'sub FAS_STAT2_ISHUTTLE () {0x20;}' unless defined(&FAS_STAT2_ISHUTTLE);
    eval 'sub FAS_STAT2_OSHUTTLE () {0x40;}' unless defined(&FAS_STAT2_OSHUTTLE);
    eval 'sub FAS_STAT2_EMPTY () {0x80;}' unless defined(&FAS_STAT2_EMPTY);
    eval 'sub FAS_BUSID_ENCODID () {0x10;}' unless defined(&FAS_BUSID_ENCODID);
    eval 'sub FAS_BUSID_32BIT_COUNTER () {0x40;}' unless defined(&FAS_BUSID_32BIT_COUNTER);
    if(defined(&__cplusplus)) {
    }
}
1;
