require '_h2ph_pre.ph';

unless(defined(&_SYS_SCSI_ADAPTERS_ESPREG_H)) {
    eval 'sub _SYS_SCSI_ADAPTERS_ESPREG_H () {1;}' unless defined(&_SYS_SCSI_ADAPTERS_ESPREG_H);
    require 'sys/dmaga.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub esp_busid () { &esp_stat;}' unless defined(&esp_busid);
    eval 'sub esp_timeout () { &esp_intr;}' unless defined(&esp_timeout);
    eval 'sub esp_sync_period () { &esp_step;}' unless defined(&esp_sync_period);
    eval 'sub esp_sync_offset () { &esp_fifo_flag;}' unless defined(&esp_sync_offset);
    eval 'sub esp_id_code () { &esp_xcnt_hi;}' unless defined(&esp_id_code);
    eval 'sub CMD_NOP () {0x0;}' unless defined(&CMD_NOP);
    eval 'sub CMD_FLUSH () {0x1;}' unless defined(&CMD_FLUSH);
    eval 'sub CMD_RESET_ESP () {0x2;}' unless defined(&CMD_RESET_ESP);
    eval 'sub CMD_RESET_SCSI () {0x3;}' unless defined(&CMD_RESET_SCSI);
    eval 'sub CMD_RESEL_SEQ () {0x40;}' unless defined(&CMD_RESEL_SEQ);
    eval 'sub CMD_SEL_NOATN () {0x41;}' unless defined(&CMD_SEL_NOATN);
    eval 'sub CMD_SEL_ATN () {0x42;}' unless defined(&CMD_SEL_ATN);
    eval 'sub CMD_SEL_STOP () {0x43;}' unless defined(&CMD_SEL_STOP);
    eval 'sub CMD_EN_RESEL () {0x44;}' unless defined(&CMD_EN_RESEL);
    eval 'sub CMD_DIS_RESEL () {0x45;}' unless defined(&CMD_DIS_RESEL);
    eval 'sub CMD_SEL_ATN3 () {0x46;}' unless defined(&CMD_SEL_ATN3);
    eval 'sub CMD_TRAN_INFO () {0x10;}' unless defined(&CMD_TRAN_INFO);
    eval 'sub CMD_COMP_SEQ () {0x11;}' unless defined(&CMD_COMP_SEQ);
    eval 'sub CMD_MSG_ACPT () {0x12;}' unless defined(&CMD_MSG_ACPT);
    eval 'sub CMD_TRAN_PAD () {0x18;}' unless defined(&CMD_TRAN_PAD);
    eval 'sub CMD_SET_ATN () {0x1a;}' unless defined(&CMD_SET_ATN);
    eval 'sub CMD_CLR_ATN () {0x1b;}' unless defined(&CMD_CLR_ATN);
    eval 'sub CMD_DMA () {0x80;}' unless defined(&CMD_DMA);
    eval 'sub FIFOSIZE () {16;}' unless defined(&FIFOSIZE);
    eval 'sub MAX_FIFO_FLAG () {( &FIFOSIZE-1);}' unless defined(&MAX_FIFO_FLAG);
    eval 'sub ESP_FIFO_ONZ () {0x20;}' unless defined(&ESP_FIFO_ONZ);
    eval 'sub ESP_STAT_RES () {0x80;}' unless defined(&ESP_STAT_RES);
    eval 'sub ESP_STAT_IPEND () {0x80;}' unless defined(&ESP_STAT_IPEND);
    eval 'sub ESP_STAT_GERR () {0x40;}' unless defined(&ESP_STAT_GERR);
    eval 'sub ESP_STAT_PERR () {0x20;}' unless defined(&ESP_STAT_PERR);
    eval 'sub ESP_STAT_XZERO () {0x10;}' unless defined(&ESP_STAT_XZERO);
    eval 'sub ESP_STAT_XCMP () {0x8;}' unless defined(&ESP_STAT_XCMP);
    eval 'sub ESP_STAT_MSG () {0x4;}' unless defined(&ESP_STAT_MSG);
    eval 'sub ESP_STAT_CD () {0x2;}' unless defined(&ESP_STAT_CD);
    eval 'sub ESP_STAT_IO () {0x1;}' unless defined(&ESP_STAT_IO);
    eval 'sub ESP_STAT_BITS () {"\\20\\10IPND\\07GERR\\06PERR\\05XZERO\\04XCMP\\03MSG\\02CD\\01IO";}' unless defined(&ESP_STAT_BITS);
    eval 'sub ESP_PHASE_MASK () {( &ESP_STAT_MSG |  &ESP_STAT_CD |  &ESP_STAT_IO);}' unless defined(&ESP_PHASE_MASK);
    eval 'sub ESP_PHASE_DATA_OUT () {0;}' unless defined(&ESP_PHASE_DATA_OUT);
    eval 'sub ESP_PHASE_DATA_IN () {( &ESP_STAT_IO);}' unless defined(&ESP_PHASE_DATA_IN);
    eval 'sub ESP_PHASE_COMMAND () {( &ESP_STAT_CD);}' unless defined(&ESP_PHASE_COMMAND);
    eval 'sub ESP_PHASE_STATUS () {( &ESP_STAT_CD |  &ESP_STAT_IO);}' unless defined(&ESP_PHASE_STATUS);
    eval 'sub ESP_PHASE_MSG_OUT () {( &ESP_STAT_MSG |  &ESP_STAT_CD);}' unless defined(&ESP_PHASE_MSG_OUT);
    eval 'sub ESP_PHASE_MSG_IN () {( &ESP_STAT_MSG |  &ESP_STAT_CD |  &ESP_STAT_IO);}' unless defined(&ESP_PHASE_MSG_IN);
    eval 'sub ESP_INT_RESET () {0x80;}' unless defined(&ESP_INT_RESET);
    eval 'sub ESP_INT_ILLEGAL () {0x40;}' unless defined(&ESP_INT_ILLEGAL);
    eval 'sub ESP_INT_DISCON () {0x20;}' unless defined(&ESP_INT_DISCON);
    eval 'sub ESP_INT_BUS () {0x10;}' unless defined(&ESP_INT_BUS);
    eval 'sub ESP_INT_FCMP () {0x8;}' unless defined(&ESP_INT_FCMP);
    eval 'sub ESP_INT_RESEL () {0x4;}' unless defined(&ESP_INT_RESEL);
    eval 'sub ESP_INT_SELATN () {0x2;}' unless defined(&ESP_INT_SELATN);
    eval 'sub ESP_INT_SEL () {0x1;}' unless defined(&ESP_INT_SEL);
    eval 'sub ESP_INT_BITS () {"\\20\\10RST\\07ILL\\06DISC\\05BUS\\04FCMP\\03RESEL\\02SATN\\01SEL";}' unless defined(&ESP_INT_BITS);
    eval 'sub ESP_STEP_MASK () {0x7;}' unless defined(&ESP_STEP_MASK);
    eval 'sub ESP_STEP_ARBSEL () {0;}' unless defined(&ESP_STEP_ARBSEL);
    eval 'sub ESP_STEP_SENTID () {1;}' unless defined(&ESP_STEP_SENTID);
    eval 'sub ESP_STEP_NOTCMD () {2;}' unless defined(&ESP_STEP_NOTCMD);
    eval 'sub ESP_STEP_PCMD () {3;}' unless defined(&ESP_STEP_PCMD);
    eval 'sub ESP_STEP_DONE () {4;}' unless defined(&ESP_STEP_DONE);
    eval 'sub ESP_STEP_DONE5 () {5;}' unless defined(&ESP_STEP_DONE5);
    eval 'sub ESP_STEP_DONE6 () {6;}' unless defined(&ESP_STEP_DONE6);
    eval 'sub ESP_STEP_DONE7 () {7;}' unless defined(&ESP_STEP_DONE7);
    eval 'sub ESP_CONF_SLOWMODE () {0x80;}' unless defined(&ESP_CONF_SLOWMODE);
    eval 'sub ESP_CONF_DISRINT () {0x40;}' unless defined(&ESP_CONF_DISRINT);
    eval 'sub ESP_CONF_PARTEST () {0x20;}' unless defined(&ESP_CONF_PARTEST);
    eval 'sub ESP_CONF_PAREN () {0x10;}' unless defined(&ESP_CONF_PAREN);
    eval 'sub ESP_CONF_CHIPTEST () {0x8;}' unless defined(&ESP_CONF_CHIPTEST);
    eval 'sub ESP_CONF_BUSID () {0x7;}' unless defined(&ESP_CONF_BUSID);
    eval 'sub DEFAULT_HOSTID () {7;}' unless defined(&DEFAULT_HOSTID);
    eval 'sub ESP_TEST_TGT () {0x1;}' unless defined(&ESP_TEST_TGT);
    eval 'sub ESP_TEST_INI () {0x2;}' unless defined(&ESP_TEST_INI);
    eval 'sub ESP_TEST_TRI () {0x4;}' unless defined(&ESP_TEST_TRI);
    eval 'sub ESP_CONF2_RESETF () {0x80;}' unless defined(&ESP_CONF2_RESETF);
    eval 'sub ESP_CONF2_FENABLE () {0x40;}' unless defined(&ESP_CONF2_FENABLE);
    eval 'sub ESP_CONF2_STATPL () {0x40;}' unless defined(&ESP_CONF2_STATPL);
    eval 'sub ESP_CONF2_BYTECM () {0x20;}' unless defined(&ESP_CONF2_BYTECM);
    eval 'sub ESP_CONF2_TRIDMA () {0x10;}' unless defined(&ESP_CONF2_TRIDMA);
    eval 'sub ESP_CONF2_SCSI2 () {0x8;}' unless defined(&ESP_CONF2_SCSI2);
    eval 'sub ESP_CONF2_TBADPAR () {0x4;}' unless defined(&ESP_CONF2_TBADPAR);
    eval 'sub ESP_CONF2_REGPAR () {0x2;}' unless defined(&ESP_CONF2_REGPAR);
    eval 'sub ESP_CONF2_DMAPAR () {0x1;}' unless defined(&ESP_CONF2_DMAPAR);
    eval 'sub ESP_CONF3_236_IDRESCHK () {0x80;}' unless defined(&ESP_CONF3_236_IDRESCHK);
    eval 'sub ESP_CONF3_236_QUENB () {0x40;}' unless defined(&ESP_CONF3_236_QUENB);
    eval 'sub ESP_CONF3_236_CDB10 () {0x20;}' unless defined(&ESP_CONF3_236_CDB10);
    eval 'sub ESP_CONF3_236_FASTSCSI () {0x10;}' unless defined(&ESP_CONF3_236_FASTSCSI);
    eval 'sub ESP_CONF3_236_FASTCLK () {0x8;}' unless defined(&ESP_CONF3_236_FASTCLK);
    eval 'sub ESP_CONF3_236_SAVERESB () {0x4;}' unless defined(&ESP_CONF3_236_SAVERESB);
    eval 'sub ESP_CONF3_236_ALTDMA () {0x2;}' unless defined(&ESP_CONF3_236_ALTDMA);
    eval 'sub ESP_CONF3_236_THRESH8 () {0x1;}' unless defined(&ESP_CONF3_236_THRESH8);
    eval 'sub ESP_CONF3_100A_IDRESCHK () {0x10;}' unless defined(&ESP_CONF3_100A_IDRESCHK);
    eval 'sub ESP_CONF3_100A_QUENB () {0x8;}' unless defined(&ESP_CONF3_100A_QUENB);
    eval 'sub ESP_CONF3_100A_CDB10 () {0x4;}' unless defined(&ESP_CONF3_100A_CDB10);
    eval 'sub ESP_CONF3_100A_FASTSCSI () {0x2;}' unless defined(&ESP_CONF3_100A_FASTSCSI);
    eval 'sub ESP_CONF3_100A_FASTCLK () {0x1;}' unless defined(&ESP_CONF3_100A_FASTCLK);
    eval 'sub ESP_FAS100A () {0x0;}' unless defined(&ESP_FAS100A);
    eval 'sub ESP_FAS236 () {0x2;}' unless defined(&ESP_FAS236);
    eval 'sub ESP_REV_MASK () {0x7;}' unless defined(&ESP_REV_MASK);
    eval 'sub ESP_FCODE_MASK () {0xf8;}' unless defined(&ESP_FCODE_MASK);
    eval 'sub SET_ESP_COUNT_16 {
        local($ep, $val) = @_;
	    eval q(-> &esp_xcnt_lo = , -> &esp_xcnt_mid = (($val) >> 8));
    }' unless defined(&SET_ESP_COUNT_16);
    eval 'sub GET_ESP_COUNT_16 {
        local($ep, $val) = @_;
	    eval q( = -> &esp_xcnt_lo | (( ($ep)-> &esp_xcnt_mid) << 8));
    }' unless defined(&GET_ESP_COUNT_16);
    eval 'sub SET_ESP_COUNT_24 {
        local($ep, $val) = @_;
	    eval q(-> &esp_xcnt_lo = , -> &esp_xcnt_mid = ( >> 8), -> &esp_xcnt_hi = (($val) >> 16));
    }' unless defined(&SET_ESP_COUNT_24);
    eval 'sub GET_ESP_COUNT_24 {
        local($ep, $val) = @_;
	    eval q( = -> &esp_xcnt_lo | (( -> &esp_xcnt_mid) << 8) | (( ($ep)-> &esp_xcnt_hi) << 16));
    }' unless defined(&GET_ESP_COUNT_24);
    eval 'sub GET_ESP_COUNT {
        local($ep, $val) = @_;
	    eval q( &if ( ($esp->{e_espconf2}) &  &ESP_CONF2_FENABLE)  &GET_ESP_COUNT_24($ep, $val);  &else  &GET_ESP_COUNT_16($ep, $val););
    }' unless defined(&GET_ESP_COUNT);
    eval 'sub SET_ESP_COUNT {
        local($ep, $val) = @_;
	    eval q( &if ( ($esp->{e_espconf2}) &  &ESP_CONF2_FENABLE)  &SET_ESP_COUNT_24($ep, $val);  &else  &SET_ESP_COUNT_16($ep, $val););
    }' unless defined(&SET_ESP_COUNT);
    eval 'sub ESP_MAX_DMACOUNT () {(( ($esp->{e_espconf2}) &  &ESP_CONF2_FENABLE) ? 0x1000000 : 0x10000);}' unless defined(&ESP_MAX_DMACOUNT);
    eval 'sub CLOCK_10MHZ () {2;}' unless defined(&CLOCK_10MHZ);
    eval 'sub CLOCK_15MHZ () {3;}' unless defined(&CLOCK_15MHZ);
    eval 'sub CLOCK_20MHZ () {4;}' unless defined(&CLOCK_20MHZ);
    eval 'sub CLOCK_25MHZ () {5;}' unless defined(&CLOCK_25MHZ);
    eval 'sub CLOCK_30MHZ () {6;}' unless defined(&CLOCK_30MHZ);
    eval 'sub CLOCK_35MHZ () {7;}' unless defined(&CLOCK_35MHZ);
    eval 'sub CLOCK_40MHZ () {8;}' unless defined(&CLOCK_40MHZ);
    eval 'sub CLOCK_MASK () {0x7;}' unless defined(&CLOCK_MASK);
    eval 'sub CLOCK_PERIOD {
        local($mhz) = @_;
	    eval q((1000*  &MEG) /($mhz / 1000));
    }' unless defined(&CLOCK_PERIOD);
    eval 'sub CONVERT_PERIOD {
        local($time) = @_;
	    eval q((($time)+3) >>2);
    }' unless defined(&CONVERT_PERIOD);
    eval 'sub ESP_CLOCK_DELAY () {7682;}' unless defined(&ESP_CLOCK_DELAY);
    eval 'sub ESP_CLOCK_TICK {
        local($esp) = @_;
	    eval q((  &ESP_CLOCK_DELAY * -> &e_clock_conv * -> &e_clock_cycle) / 1000);
    }' unless defined(&ESP_CLOCK_TICK);
    eval 'sub ESP_SEL_TIMEOUT () {(250*  &MEG);}' unless defined(&ESP_SEL_TIMEOUT);
    eval 'sub ESP_CLOCK_TIMEOUT {
        local($tick, $selection_timeout) = @_;
	    eval q(((($selection_timeout) *  &MEG) + ($tick) - 1) / ($tick));
    }' unless defined(&ESP_CLOCK_TIMEOUT);
    eval 'sub MIN_SYNC_FAST {
        local($esp) = @_;
	    eval q(4);
    }' unless defined(&MIN_SYNC_FAST);
    eval 'sub MIN_SYNC_SLOW {
        local($esp) = @_;
	    eval q(((($esp)-> &e_espconf &  &ESP_CONF_SLOWMODE)? 6: 5));
    }' unless defined(&MIN_SYNC_SLOW);
    eval 'sub MIN_SYNC {
        local($esp) = @_;
	    eval q((((($esp)-> &e_type ==  &FAS236) || (($esp)-> &e_type ==  &FAS100A)) ? ( &MIN_SYNC_FAST(($esp))) : ( &MIN_SYNC_SLOW(($esp)))));
    }' unless defined(&MIN_SYNC);
    eval 'sub MAX_SYNC {
        local($esp) = @_;
	    eval q(35);
    }' unless defined(&MAX_SYNC);
    eval 'sub SYNC_PERIOD_MASK () {0x1f;}' unless defined(&SYNC_PERIOD_MASK);
    eval 'sub MIN_SYNC_TIME {
        local($esp) = @_;
	    eval q((  &MIN_SYNC() * (-> &e_clock_cycle)) / 1000);
    }' unless defined(&MIN_SYNC_TIME);
    eval 'sub MAX_SYNC_TIME {
        local($esp) = @_;
	    eval q((  &MAX_SYNC() * (-> &e_clock_cycle)) / 1000);
    }' unless defined(&MAX_SYNC_TIME);
    eval 'sub MIN_SYNC_PERIOD {
        local($esp) = @_;
	    eval q(( &CONVERT_PERIOD( &MIN_SYNC_TIME(($esp)))));
    }' unless defined(&MIN_SYNC_PERIOD);
    eval 'sub MAX_SYNC_PERIOD {
        local($esp) = @_;
	    eval q(( &CONVERT_PERIOD( &MAX_SYNC_TIME(($esp)))));
    }' unless defined(&MAX_SYNC_PERIOD);
    eval 'sub DEFAULT_SYNC_PERIOD () {200;}' unless defined(&DEFAULT_SYNC_PERIOD);
    eval 'sub DEFAULT_FASTSYNC_PERIOD () {100;}' unless defined(&DEFAULT_FASTSYNC_PERIOD);
    eval 'sub FASTSCSI_THRESHOLD () {50;}' unless defined(&FASTSCSI_THRESHOLD);
    eval 'sub ESP_SYNC_KBPS {
        local($ns) = @_;
	    eval q(((((1000* &MEG)/($ns))+999)/1000));
    }' unless defined(&ESP_SYNC_KBPS);
    eval 'sub DEFAULT_OFFSET () {15;}' unless defined(&DEFAULT_OFFSET);
    eval 'sub ESP100 () {0;}' unless defined(&ESP100);
    eval 'sub NCR53C90 () {0;}' unless defined(&NCR53C90);
    eval 'sub ESP100A () {1;}' unless defined(&ESP100A);
    eval 'sub NCR53C90A () {1;}' unless defined(&NCR53C90A);
    eval 'sub ESP236 () {2;}' unless defined(&ESP236);
    eval 'sub FAS100 () {3;}' unless defined(&FAS100);
    eval 'sub FAS100A () {3;}' unless defined(&FAS100A);
    eval 'sub FAS236 () {4;}' unless defined(&FAS236);
    eval 'sub FAST () {5;}' unless defined(&FAST);
    eval 'sub IS_53C90 {
        local($esp) = @_;
	    eval q((($esp)-> &e_type ==  &NCR53C90));
    }' unless defined(&IS_53C90);
    eval 'sub ESP_SIZE () {0x2000;}' unless defined(&ESP_SIZE);
    eval 'sub DMAGA_OFFSET () {0x1000;}' unless defined(&DMAGA_OFFSET);
    if(defined(&__cplusplus)) {
    }
}
1;
