require '_h2ph_pre.ph';

unless(defined(&_SYS_FLOCK_IMPL_H)) {
    eval 'sub _SYS_FLOCK_IMPL_H () {1;}' unless defined(&_SYS_FLOCK_IMPL_H);
    require 'sys/types.ph';
    require 'sys/fcntl.ph';
    require 'sys/file.ph';
    require 'sys/flock.ph';
    require 'sys/kmem.ph';
    require 'sys/user.ph';
    require 'sys/thread.ph';
    require 'sys/proc.ph';
    require 'sys/cred.ph';
    require 'sys/debug.ph';
    require 'sys/cmn_err.ph';
    require 'sys/errno.ph';
    require 'sys/systm.ph';
    require 'sys/vnode.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub ACTIVE_LOCK () {0x0001;}' unless defined(&ACTIVE_LOCK);
    eval 'sub SLEEPING_LOCK () {0x0002;}' unless defined(&SLEEPING_LOCK);
    eval 'sub IO_LOCK () {0x0004;}' unless defined(&IO_LOCK);
    eval 'sub REFERENCED_LOCK () {0x0008;}' unless defined(&REFERENCED_LOCK);
    eval 'sub QUERY_LOCK () {0x0010;}' unless defined(&QUERY_LOCK);
    eval 'sub WILLING_TO_SLEEP_LOCK () {0x0020;}' unless defined(&WILLING_TO_SLEEP_LOCK);
    eval 'sub RECOMPUTE_LOCK () {0x0040;}' unless defined(&RECOMPUTE_LOCK);
    eval 'sub RECOMPUTE_DONE () {0x0080;}' unless defined(&RECOMPUTE_DONE);
    eval 'sub BARRIER_LOCK () {0x0100;}' unless defined(&BARRIER_LOCK);
    eval 'sub GRANTED_LOCK () {0x0200;}' unless defined(&GRANTED_LOCK);
    eval 'sub CANCELLED_LOCK () {0x0400;}' unless defined(&CANCELLED_LOCK);
    eval 'sub DELETED_LOCK () {0x0800;}' unless defined(&DELETED_LOCK);
    eval 'sub INTERRUPTED_LOCK () {0x1000;}' unless defined(&INTERRUPTED_LOCK);
    eval 'sub LOCKMGR_LOCK () {0x2000;}' unless defined(&LOCKMGR_LOCK);
    eval 'sub HASH_SIZE () {32;}' unless defined(&HASH_SIZE);
    eval 'sub HASH_SHIFT () {( &HASH_SIZE - 1);}' unless defined(&HASH_SHIFT);
    eval 'sub HASH_INDEX {
        local($vp) = @_;
	    eval q((($vp >> 7) &  &HASH_SHIFT));
    }' unless defined(&HASH_INDEX);
    eval 'sub SAME_OWNER {
        local($lock1, $lock2) = @_;
	    eval q(((($lock1)-> ($l_flock->{l_pid}) == ($lock2)-> ($l_flock->{l_pid}))  && (($lock1)-> ($l_flock->{l_sysid}) == ($lock2)-> ($l_flock->{l_sysid}))));
    }' unless defined(&SAME_OWNER);
    eval 'sub NO_COLOR () {0;}' unless defined(&NO_COLOR);
    eval 'sub NO_CHECK_CYCLE () {0;}' unless defined(&NO_CHECK_CYCLE);
    eval 'sub CHECK_CYCLE () {1;}' unless defined(&CHECK_CYCLE);
    eval 'sub COLORED {
        local($vertex) = @_;
	    eval q((($vertex)-> &l_color == ($vertex)-> ($l_graph->{mark})));
    }' unless defined(&COLORED);
    eval 'sub COLOR {
        local($vertex) = @_;
	    eval q((($vertex)-> &l_color = ($vertex)-> ($l_graph->{mark})));
    }' unless defined(&COLOR);
    eval 'sub STACK_INIT {
        local($stack) = @_;
	    eval q((($stack) =  &NULL));
    }' unless defined(&STACK_INIT);
    eval 'sub STACK_PUSH {
        local($stack, $ptr, $stack_link) = @_;
	    eval q(($ptr)->$stack_link = ($stack), ($stack) = ($ptr));
    }' unless defined(&STACK_PUSH);
    eval 'sub STACK_POP {
        local($stack, $stack_link) = @_;
	    eval q(($stack) = ($stack)->$stack_link);
    }' unless defined(&STACK_POP);
    eval 'sub STACK_TOP {
        local($stack) = @_;
	    eval q(($stack));
    }' unless defined(&STACK_TOP);
    eval 'sub STACK_EMPTY {
        local($stack) = @_;
	    eval q((($stack) ==  &NULL));
    }' unless defined(&STACK_EMPTY);
    eval 'sub ACTIVE_HEAD {
        local($gp) = @_;
	    eval q((($gp)-> &active_locks));
    }' unless defined(&ACTIVE_HEAD);
    eval 'sub SLEEPING_HEAD {
        local($gp) = @_;
	    eval q((($gp)-> &sleeping_locks));
    }' unless defined(&SLEEPING_HEAD);
    eval 'sub SET_LOCK_TO_FIRST_ACTIVE_VP {
        local($gp, $lock, $vp) = @_;
	    eval q({ =  ($vp->{v_filocks}); });
    }' unless defined(&SET_LOCK_TO_FIRST_ACTIVE_VP);
    eval 'sub SET_LOCK_TO_FIRST_SLEEP_VP {
        local($gp, $lock, $vp) = @_;
	    eval q({  &for (($lock) =  &SLEEPING_HEAD(($gp))-> &l_next; (($lock) !=  &SLEEPING_HEAD(($gp))  && ($lock)-> &l_vnode != ($vp)); ($lock) = ($lock)-> &l_next) ; ($lock) = (($lock) ==  &SLEEPING_HEAD(($gp))) ?  &NULL : ($lock); });
    }' unless defined(&SET_LOCK_TO_FIRST_SLEEP_VP);
    eval 'sub OVERLAP {
        local($lock1, $lock2) = @_;
	    eval q(((($lock1)-> &l_start <= ($lock2)-> &l_start  && ($lock2)-> &l_start <= ($lock1)-> &l_end) || (($lock2)-> &l_start <= ($lock1)-> &l_start  && ($lock1)-> &l_start <= ($lock2)-> &l_end)));
    }' unless defined(&OVERLAP);
    eval 'sub IS_QUERY_LOCK {
        local($lock) = @_;
	    eval q((($lock)-> &l_state &  &QUERY_LOCK));
    }' unless defined(&IS_QUERY_LOCK);
    eval 'sub IS_RECOMPUTE {
        local($lock) = @_;
	    eval q((($lock)-> &l_state &  &RECOMPUTE_LOCK));
    }' unless defined(&IS_RECOMPUTE);
    eval 'sub IS_SLEEPING {
        local($lock) = @_;
	    eval q((($lock)-> &l_state &  &SLEEPING_LOCK));
    }' unless defined(&IS_SLEEPING);
    eval 'sub IS_BARRIER {
        local($lock) = @_;
	    eval q((($lock)-> &l_state &  &BARRIER_LOCK));
    }' unless defined(&IS_BARRIER);
    eval 'sub IS_GRANTED {
        local($lock) = @_;
	    eval q((($lock)-> &l_state &  &GRANTED_LOCK));
    }' unless defined(&IS_GRANTED);
    eval 'sub IS_CANCELLED {
        local($lock) = @_;
	    eval q((($lock)-> &l_state &  &CANCELLED_LOCK));
    }' unless defined(&IS_CANCELLED);
    eval 'sub IS_DELETED {
        local($lock) = @_;
	    eval q((($lock)-> &l_state &  &DELETED_LOCK));
    }' unless defined(&IS_DELETED);
    eval 'sub IS_REFERENCED {
        local($lock) = @_;
	    eval q((($lock)-> &l_state &  &REFERENCED_LOCK));
    }' unless defined(&IS_REFERENCED);
    eval 'sub IS_IO_LOCK {
        local($lock) = @_;
	    eval q((($lock)-> &l_state &  &IO_LOCK));
    }' unless defined(&IS_IO_LOCK);
    eval 'sub IS_WILLING_TO_SLEEP {
        local($lock) = @_;
	    eval q((($lock)-> &l_state &  &WILLING_TO_SLEEP_LOCK));
    }' unless defined(&IS_WILLING_TO_SLEEP);
    eval 'sub IS_ACTIVE {
        local($lock) = @_;
	    eval q((($lock)-> &l_state &  &ACTIVE_LOCK));
    }' unless defined(&IS_ACTIVE);
    eval 'sub IS_INTERRUPTED {
        local($lock) = @_;
	    eval q((($lock)-> &l_state &  &INTERRUPTED_LOCK));
    }' unless defined(&IS_INTERRUPTED);
    eval 'sub IS_LOCKMGR {
        local($lock) = @_;
	    eval q((($lock)-> &l_state &  &LOCKMGR_LOCK));
    }' unless defined(&IS_LOCKMGR);
    eval 'sub IS_LOCAL {
        local($lock) = @_;
	    eval q((($lock)-> ($l_flock->{l_sysid}) == 0));
    }' unless defined(&IS_LOCAL);
    eval 'sub IS_REMOTE {
        local($lock) = @_;
	    eval q((!  &IS_LOCAL($lock)));
    }' unless defined(&IS_REMOTE);
    eval 'sub BLOCKS {
        local($lock1, $lock2) = @_;
	    eval q((! &SAME_OWNER(($lock1), ($lock2))  && ((($lock1)-> &l_type ==  &F_WRLCK) || (($lock2)-> &l_type ==  &F_WRLCK))  &&  &OVERLAP(($lock1), ($lock2))));
    }' unless defined(&BLOCKS);
    eval 'sub COVERS {
        local($lock1, $lock2) = @_;
	    eval q(((($lock1)-> &l_start <= ($lock2)-> &l_start)  && (($lock1)-> &l_end >= ($lock2)-> &l_end)));
    }' unless defined(&COVERS);
    eval 'sub IN_LIST_REMOVE {
        local($ep) = @_;
	    eval q({ ($ep)-> ($edge_in_next->{edge_in_prev}) = ($ep)-> &edge_in_prev; ($ep)-> ($edge_in_prev->{edge_in_next}) = ($ep)-> &edge_in_next; });
    }' unless defined(&IN_LIST_REMOVE);
    eval 'sub ADJ_LIST_REMOVE {
        local($ep) = @_;
	    eval q({ ($ep)-> ($edge_adj_next->{edge_adj_prev}) = ($ep)-> &edge_adj_prev; ($ep)-> ($edge_adj_prev->{edge_adj_next}) = ($ep)-> &edge_adj_next; });
    }' unless defined(&ADJ_LIST_REMOVE);
    eval 'sub NOT_BLOCKED {
        local($lock) = @_;
	    eval q((($lock)-> ($l_edge->{edge_adj_next}) == ($lock)-> &l_edge  && ! &IS_GRANTED($lock)));
    }' unless defined(&NOT_BLOCKED);
    eval 'sub GRANT_WAKEUP {
        local($lock) = @_;
	    eval q({ ($lock)-> &l_state |=  &GRANTED_LOCK;  &cv_signal(($lock)-> &l_cv); });
    }' unless defined(&GRANT_WAKEUP);
    eval 'sub CANCEL_WAKEUP {
        local($lock) = @_;
	    eval q({ ($lock)-> &l_state |=  &CANCELLED_LOCK;  &cv_signal(($lock)-> &l_cv); });
    }' unless defined(&CANCEL_WAKEUP);
    eval 'sub INTERRUPT_WAKEUP {
        local($lock) = @_;
	    eval q({ ($lock)-> &l_state |=  &INTERRUPTED_LOCK;  &cv_signal(($lock)-> &l_cv); });
    }' unless defined(&INTERRUPT_WAKEUP);
    eval 'sub REMOVE_SLEEP_QUEUE {
        local($lock) = @_;
	    eval q({  &ASSERT; -> &l_state &= ~ &SLEEPING_LOCK; -> ($l_next->{l_prev}) = -> &l_prev; -> ($l_prev->{l_next}) = -> &l_next; -> &l_next = -> &l_prev =  &NULL; });
    }' unless defined(&REMOVE_SLEEP_QUEUE);
    eval 'sub NO_DEPENDENTS {
        local($lock) = @_;
	    eval q((($lock)-> ($l_edge->{edge_in_next}) == ($lock)-> &l_edge));
    }' unless defined(&NO_DEPENDENTS);
    eval 'sub GRANT {
        local($lock) = @_;
	    eval q((($lock)-> &l_state |=  &GRANTED_LOCK));
    }' unless defined(&GRANT);
    eval 'sub FIRST_IN {
        local($lock) = @_;
	    eval q((($lock)-> ($l_edge->{edge_in_next})));
    }' unless defined(&FIRST_IN);
    eval 'sub FIRST_ADJ {
        local($lock) = @_;
	    eval q((($lock)-> ($l_edge->{edge_adj_next})));
    }' unless defined(&FIRST_ADJ);
    eval 'sub HEAD {
        local($lock) = @_;
	    eval q((($lock)-> &l_edge));
    }' unless defined(&HEAD);
    eval 'sub NEXT_ADJ {
        local($ep) = @_;
	    eval q((($ep)-> &edge_adj_next));
    }' unless defined(&NEXT_ADJ);
    eval 'sub NEXT_IN {
        local($ep) = @_;
	    eval q((($ep)-> &edge_in_next));
    }' unless defined(&NEXT_IN);
    eval 'sub IN_ADJ_INIT {
        local($lock) = @_;
	    eval q({ ($lock)-> ($l_edge->{edge_adj_next}) = ($lock)-> ($l_edge->{edge_adj_prev}) = ($lock)-> &l_edge; ($lock)-> ($l_edge->{edge_in_next}) = ($lock)-> ($l_edge->{edge_in_prev}) = ($lock)-> &l_edge; });
    }' unless defined(&IN_ADJ_INIT);
    eval 'sub COPY {
        local($lock1, $lock2) = @_;
	    eval q({ ($lock1)-> &l_graph = ($lock2)-> &l_graph; ($lock1)-> &l_vnode = ($lock2)-> &l_vnode; ($lock1)-> &l_type = ($lock2)-> &l_type; ($lock1)-> &l_start = ($lock2)-> &l_start; ($lock1)-> &l_end = ($lock2)-> &l_end; ($lock1)-> &l_flock = ($lock2)-> &l_flock; ($lock1)-> &pvertex = ($lock2)-> &pvertex; });
    }' unless defined(&COPY);
    eval 'sub UNLOCK () {0x1;}' unless defined(&UNLOCK);
    eval 'sub DOWNGRADE () {0x2;}' unless defined(&DOWNGRADE);
    eval 'sub UPGRADE () {0x3;}' unless defined(&UPGRADE);
    eval 'sub STAY_SAME () {0x4;}' unless defined(&STAY_SAME);
    eval 'sub PROC_CHUNK () {100;}' unless defined(&PROC_CHUNK);
    eval 'sub PROC_SAME_OWNER {
        local($lock, $pvertex) = @_;
	    eval q(((($lock)-> ($l_flock->{l_pid}) == ($pvertex)-> &pid)  && (($lock)-> ($l_flock->{l_sysid}) == ($pvertex)-> &sysid)));
    }' unless defined(&PROC_SAME_OWNER);
    eval 'sub PROC_ARRIVE {
        local($pvertex) = @_;
	    eval q((($pvertex)-> &atime =  ($pgraph->{mark})));
    }' unless defined(&PROC_ARRIVE);
    eval 'sub PROC_DEPART {
        local($pvertex) = @_;
	    eval q((($pvertex)-> &dtime =  ($pgraph->{mark})));
    }' unless defined(&PROC_DEPART);
    eval 'sub PROC_ARRIVED {
        local($pvertex) = @_;
	    eval q((($pvertex)-> &atime ==  ($pgraph->{mark})));
    }' unless defined(&PROC_ARRIVED);
    eval 'sub PROC_DEPARTED {
        local($pvertex) = @_;
	    eval q((($pvertex)-> &dtime ==  ($pgraph->{mark})));
    }' unless defined(&PROC_DEPARTED);
    if(defined(&__cplusplus)) {
    }
}
1;
