require '_h2ph_pre.ph';

unless(defined(&_SYS_AUDIO_4231_H)) {
    eval 'sub _SYS_AUDIO_4231_H () {1;}' unless defined(&_SYS_AUDIO_4231_H);
    require 'sys/audio_4231_dma.ph';
    if(defined(&__cplusplus)) {
    }
    if(defined(&_KERNEL)) {
	eval 'sub CS_UNITMASK () {(0x0f);}' unless defined(&CS_UNITMASK);
	eval 'sub CS_UNIT {
	    local($dev) = @_;
    	    eval q((( &geteminor($dev)) &  &CS_UNITMASK));
	}' unless defined(&CS_UNIT);
	eval 'sub CS_ISCTL {
	    local($dev) = @_;
    	    eval q(((( &geteminor($dev)) &  &CS_MINOR_CTL) != 0));
	}' unless defined(&CS_ISCTL);
	eval 'sub CS_CLONE_BIT () {(0x10);}' unless defined(&CS_CLONE_BIT);
	eval 'sub CS_MINOR_RW () {(0x20);}' unless defined(&CS_MINOR_RW);
	eval 'sub CS_MINOR_RO () {(0x40);}' unless defined(&CS_MINOR_RO);
	eval 'sub CS_MINOR_CTL () {(0x80);}' unless defined(&CS_MINOR_CTL);
	eval 'sub AUD_CS4231_PRECISION () {(8);}' unless defined(&AUD_CS4231_PRECISION);
	eval 'sub AUD_CS4231_CHANNELS () {(1);}' unless defined(&AUD_CS4231_CHANNELS);
	eval 'sub AUD_CS4231_SAMPLERATE () {(8000);}' unless defined(&AUD_CS4231_SAMPLERATE);
	eval 'sub AUD_CS4231_SAMPR16000 () {(16000);}' unless defined(&AUD_CS4231_SAMPR16000);
	eval 'sub AUD_CS4231_SAMPR11025 () {(11025);}' unless defined(&AUD_CS4231_SAMPR11025);
	eval 'sub AUD_CS4231_SAMPR18900 () {(18900);}' unless defined(&AUD_CS4231_SAMPR18900);
	eval 'sub AUD_CS4231_SAMPR22050 () {(22050);}' unless defined(&AUD_CS4231_SAMPR22050);
	eval 'sub AUD_CS4231_SAMPR32000 () {(32000);}' unless defined(&AUD_CS4231_SAMPR32000);
	eval 'sub AUD_CS4231_SAMPR37800 () {(37800);}' unless defined(&AUD_CS4231_SAMPR37800);
	eval 'sub AUD_CS4231_SAMPR44100 () {(44100);}' unless defined(&AUD_CS4231_SAMPR44100);
	eval 'sub AUD_CS4231_SAMPR48000 () {(48000);}' unless defined(&AUD_CS4231_SAMPR48000);
	eval 'sub AUD_CS4231_SAMPR9600 () {(9600);}' unless defined(&AUD_CS4231_SAMPR9600);
	eval 'sub AUD_CS4231_SAMPR8000 () { &AUD_CS4231_SAMPLERATE;}' unless defined(&AUD_CS4231_SAMPR8000);
	if(defined(&MULTI_DEBUG)) {
	    eval 'sub AUD_CS4231_BSIZE () {(1024* 3);}' unless defined(&AUD_CS4231_BSIZE);
	} else {
	    eval 'sub AUD_CS4231_BSIZE () {(8180);}' unless defined(&AUD_CS4231_BSIZE);
	}
	eval 'sub AUD_CS4231_MAX_BSIZE () {(65536);}' unless defined(&AUD_CS4231_MAX_BSIZE);
	eval 'sub AUD_CS4231_CMDPOOL () {(100);}' unless defined(&AUD_CS4231_CMDPOOL);
	eval 'sub AUD_CS4231_RECBUFS () {(50);}' unless defined(&AUD_CS4231_RECBUFS);
	eval 'sub AUD_CS4231_PLAYBUFS () {( &AUD_CS4231_CMDPOOL -  &AUD_CS4231_RECBUFS);}' unless defined(&AUD_CS4231_PLAYBUFS);
	eval 'sub AUD_CS4231_IDNUM () {(0x6175);}' unless defined(&AUD_CS4231_IDNUM);
	eval 'sub AUD_CS4231_NAME () {"audiocs";}' unless defined(&AUD_CS4231_NAME);
	eval 'sub AUD_CS4231_MINPACKET () {(0);}' unless defined(&AUD_CS4231_MINPACKET);
	if(defined(&MULTI_DEBUG)) {
	    eval 'sub AUD_CS4231_MAXPACKET () {(1024* 3);}' unless defined(&AUD_CS4231_MAXPACKET);
	} else {
	    eval 'sub AUD_CS4231_MAXPACKET () {(8180);}' unless defined(&AUD_CS4231_MAXPACKET);
	}
	eval 'sub AUD_CS4231_HIWATER () {(57000);}' unless defined(&AUD_CS4231_HIWATER);
	eval 'sub AUD_CS4231_LOWATER () {(32000);}' unless defined(&AUD_CS4231_LOWATER);
	eval 'sub AUD_CS4231_DEFAULT_PLAYGAIN () {(132);}' unless defined(&AUD_CS4231_DEFAULT_PLAYGAIN);
	eval 'sub AUD_CS4231_DEFAULT_RECGAIN () {(126);}' unless defined(&AUD_CS4231_DEFAULT_RECGAIN);
	eval 'sub AUD_CS4231_MIN_ATEN () {(0);}' unless defined(&AUD_CS4231_MIN_ATEN);
	eval 'sub AUD_CS4231_MAX_ATEN () {(31);}' unless defined(&AUD_CS4231_MAX_ATEN);
	eval 'sub AUD_CS4231_MAX_DEV_ATEN () {(63);}' unless defined(&AUD_CS4231_MAX_DEV_ATEN);
	eval 'sub AUD_CS4231_MIN_GAIN () {(0);}' unless defined(&AUD_CS4231_MIN_GAIN);
	eval 'sub AUD_CS4231_MAX_GAIN () {(15);}' unless defined(&AUD_CS4231_MAX_GAIN);
	eval 'sub AUD_CS4231_MON_MIN_ATEN () {(0);}' unless defined(&AUD_CS4231_MON_MIN_ATEN);
	eval 'sub AUD_CS4231_MON_MAX_ATEN () {(63);}' unless defined(&AUD_CS4231_MON_MAX_ATEN);
	eval 'sub CS_DEV_NAME () {"SUNW,CS4231";}' unless defined(&CS_DEV_NAME);
	eval 'sub CS_DEV_VERSION () {"a";}' unless defined(&CS_DEV_VERSION);
	eval 'sub CS_DEV_VERSION_B () {"b";}' unless defined(&CS_DEV_VERSION_B);
	eval 'sub CS_DEV_VERSION_C () {"c";}' unless defined(&CS_DEV_VERSION_C);
	eval 'sub CS_DEV_VERSION_D () {"d";}' unless defined(&CS_DEV_VERSION_D);
	eval 'sub CS_DEV_VERSION_E () {"e";}' unless defined(&CS_DEV_VERSION_E);
	eval 'sub CS_DEV_CONFIG_ONBRD1 () {"onboard1";}' unless defined(&CS_DEV_CONFIG_ONBRD1);
	if(defined( &sparc) || defined( &__sparc)) {
	}
 elsif(defined( &i386) || defined( &__ppc)) {
	} else {
	    die("One\ of\ sparc\,\ i86\ or\ ppc\ must\ be\ defined\.");
	}
	eval 'sub DMA_LIST_SIZE () {8;}' unless defined(&DMA_LIST_SIZE);
	eval 'sub APC_DMA () {0x01;}' unless defined(&APC_DMA);
	eval 'sub EB2_DMA () {0x02;}' unless defined(&EB2_DMA);
	eval 'sub i8237_DMA () {0x03;}' unless defined(&i8237_DMA);
	eval 'sub DMA_PB_HANDLE () {( ($unitp->{play_dma_handle}));}' unless defined(&DMA_PB_HANDLE);
	eval 'sub DMA_RC_HANDLE () {( ($unitp->{cap_dma_handle}));}' unless defined(&DMA_RC_HANDLE);
	eval 'sub ACC_PB_HANDLE () {( ($unitp->{play_acc_handle}));}' unless defined(&ACC_PB_HANDLE);
	eval 'sub ACC_RC_HANDLE () {( ($unitp->{cap_acc_handle}));}' unless defined(&ACC_RC_HANDLE);
	eval 'sub DMA_PB_COOKIE () {( ($unitp->{play_dma_cookie}));}' unless defined(&DMA_PB_COOKIE);
	eval 'sub DMA_RC_COOKIE () {( ($unitp->{cap_dma_cookie}));}' unless defined(&DMA_RC_COOKIE);
	eval 'sub DMA_PB_NCOOKIES () {( ($unitp->{play_dma_cookie_count}));}' unless defined(&DMA_PB_NCOOKIES);
	eval 'sub DMA_RC_NCOOKIES () {( ($unitp->{cap_dma_cookie_count}));}' unless defined(&DMA_RC_NCOOKIES);
	eval 'sub XCTL0_OFF () {0x01;}' unless defined(&XCTL0_OFF);
	eval 'sub XCTL0_ON () {0x02;}' unless defined(&XCTL0_ON);
	eval 'sub REG_83E () {0x03;}' unless defined(&REG_83E);
	eval 'sub REG_83E_MASK () {0x10;}' unless defined(&REG_83E_MASK);
    }
    eval 'sub UNITP {
        local($as) = @_;
	    eval q(((($as)-> ($distate->{ddstate}))));
    }' unless defined(&UNITP);
    eval 'sub CSR {
        local($as) = @_;
	    eval q(( &UNITP($as)-> &chip));
    }' unless defined(&CSR);
    eval 'sub ASTOCS {
        local($as) = @_;
	    eval q((($as)));
    }' unless defined(&ASTOCS);
    eval 'sub CSTOAS {
        local($cs) = @_;
	    eval q((($cs)));
    }' unless defined(&CSTOAS);
    eval 'sub CS4231_IAR () { ($chip->{pioregs}->{iar});}' unless defined(&CS4231_IAR);
    eval 'sub CS4231_IDR () { ($chip->{pioregs}->{idr});}' unless defined(&CS4231_IDR);
    eval 'sub CS4231_STATUS () { ($chip->{pioregs}->{statr});}' unless defined(&CS4231_STATUS);
    eval 'sub CS4231_PIOR () { ($chip->{pioregs}->{piodr});}' unless defined(&CS4231_PIOR);
    eval 'sub CS4231_HANDLE () {( ($unitp->{cnf_handle}));}' unless defined(&CS4231_HANDLE);
    eval 'sub REG_SELECT {
        local($r) = @_;
	    eval q( &ddi_putb( &handle,  ($chip->{pioregs}->{iar}), ($r)););
    }' unless defined(&REG_SELECT);
    eval 'sub LOCK_UNITP {
        local($unitp) = @_;
	    eval q( &mutex_enter(($unitp)-> &lock));
    }' unless defined(&LOCK_UNITP);
    eval 'sub UNLOCK_UNITP {
        local($unitp) = @_;
	    eval q( &mutex_exit(($unitp)-> &lock));
    }' unless defined(&UNLOCK_UNITP);
    eval 'sub ASSERT_UNITLOCKED {
        local($unitp) = @_;
	    eval q( &ASSERT( &MUTEX_HELD(($unitp)-> &lock)));
    }' unless defined(&ASSERT_UNITLOCKED);
    eval 'sub OR_SET_BYTE_R {
        local($handle, $addr, $val) = @_;
	    eval q({  &register  &uchar_t  &tmpval;  &tmpval =  &ddi_getb($handle, $addr);  &tmpval |= $val;  &ddi_putb($handle, $addr,  &tmpval); });
    }' unless defined(&OR_SET_BYTE_R);
    eval 'sub OR_SET_LONG_R {
        local($handle, $addr, $val) = @_;
	    eval q({  &register \'ulong_t tmpval\';  &tmpval =  &ddi_getl($handle, $addr);  &tmpval |= $val;  &ddi_putl($handle, $addr,  &tmpval); });
    }' unless defined(&OR_SET_LONG_R);
    eval 'sub NOR_SET_LONG_R {
        local($handle, $addr, $val, $mask) = @_;
	    eval q({  &register \'ulong_t tmpval\';  &tmpval =  &ddi_getl($handle, $addr);  &tmpval &= ~($mask);  &tmpval |= $val;  &ddi_putl($handle, $addr,  &tmpval); });
    }' unless defined(&NOR_SET_LONG_R);
    eval 'sub AND_SET_BYTE_R {
        local($handle, $addr, $val) = @_;
	    eval q({  &register  &uchar_t  &tmpval;  &tmpval =  &ddi_getb($handle, $addr);  &tmpval &= $val;  &ddi_putb($handle, $addr,  &tmpval); });
    }' unless defined(&AND_SET_BYTE_R);
    eval 'sub AND_SET_LONG_R {
        local($handle, $addr, $val) = @_;
	    eval q({  &register \'ulong_t tmpval\';  &tmpval =  &ddi_getl($handle, $addr);  &tmpval &= $val;  &ddi_putl($handle, $addr,  &tmpval); });
    }' unless defined(&AND_SET_LONG_R);
    eval 'sub GET_INT_PROP {
        local($devi, $pname, $pval, $plen) = @_;
	    eval q(( &ddi_prop_op( &DDI_DEV_T_ANY, ,  &PROP_LEN_AND_VAL_BUF,  &DDI_PROP_DONTPASS, , ($pval), ($plen))));
    }' unless defined(&GET_INT_PROP);
    eval 'sub GAIN_SET {
        local($var, $gain) = @_;
	    eval q((($var & ~(0x3f)) | $gain));
    }' unless defined(&GAIN_SET);
    if(defined( &sparc) || defined( &__sparc)) {
	eval 'sub RECGAIN_SET {
	    local($var, $gain) = @_;
    	    eval q((($var & ~(0x1f)) | $gain));
	}' unless defined(&RECGAIN_SET);
    }
 elsif(defined( &i386) || defined( &__ppc)) {
	eval 'sub RECGAIN_SET {
	    local($var, $gain) = @_;
    	    eval q((($var & ~(0x3f)) | $gain));
	}' unless defined(&RECGAIN_SET);
    } else {
	die("One\ of\ sparc\,\ i386\ or\ ppc\ must\ be\ defined\.");
    }
    eval 'sub CHANGE_MUTE {
        local($var, $val) = @_;
	    eval q((($var & ~(0x80)) | $val));
    }' unless defined(&CHANGE_MUTE);
    eval 'sub MUTE_ON {
        local($var) = @_;
	    eval q(($var | 0x80));
    }' unless defined(&MUTE_ON);
    eval 'sub MUTE_OFF {
        local($var) = @_;
	    eval q(($var & 0x7f));
    }' unless defined(&MUTE_OFF);
    eval 'sub LINEMUTE_ON () {0x80;}' unless defined(&LINEMUTE_ON);
    eval 'sub LINEMUTE_OFF () {(~0x80);}' unless defined(&LINEMUTE_OFF);
    eval 'sub CS4231_MAX_DEV_ATEN_SLOT () {(0);}' unless defined(&CS4231_MAX_DEV_ATEN_SLOT);
    eval 'sub IAR_AUTOCAL_BEGIN () {0x40;}' unless defined(&IAR_AUTOCAL_BEGIN);
    eval 'sub IAR_AUTOCAL_END () {~(0x40);}' unless defined(&IAR_AUTOCAL_END);
    eval 'sub IAR_MCE () {0x40;}' unless defined(&IAR_MCE);
    eval 'sub IAR_MCD () { &IAR_AUTOCAL_END;}' unless defined(&IAR_MCD);
    eval 'sub IAR_NOTREADY () {0x80;}' unless defined(&IAR_NOTREADY);
    eval 'sub INT_ACTIVE () {0x01;}' unless defined(&INT_ACTIVE);
    eval 'sub PB_READY () {0x02;}' unless defined(&PB_READY);
    eval 'sub SAMPLE_ERR () {0x10;}' unless defined(&SAMPLE_ERR);
    eval 'sub RC_READY () {0x20;}' unless defined(&RC_READY);
    eval 'sub CHANGE_INPUT {
        local($var, $val) = @_;
	    eval q((($var & ~(0x0f)) | $val));
    }' unless defined(&CHANGE_INPUT);
    eval 'sub L_INPUT_CR () {0x0;}' unless defined(&L_INPUT_CR);
    eval 'sub L_INPUTCR_AUX1 () {0x40;}' unless defined(&L_INPUTCR_AUX1);
    eval 'sub MIC_ENABLE {
        local($var) = @_;
	    eval q((($var & 0x2f) | 0x80));
    }' unless defined(&MIC_ENABLE);
    eval 'sub LINE_ENABLE {
        local($var) = @_;
	    eval q(($var & 0x2f));
    }' unless defined(&LINE_ENABLE);
    eval 'sub CDROM_ENABLE {
        local($var) = @_;
	    eval q((($var & 0x2f) | 0x40));
    }' unless defined(&CDROM_ENABLE);
    eval 'sub OUTPUTLOOP_ENABLE {
        local($var) = @_;
	    eval q((($var & 0x2f) | 0xc0));
    }' unless defined(&OUTPUTLOOP_ENABLE);
    eval 'sub NO_INTERNAL_CD () {0x0;}' unless defined(&NO_INTERNAL_CD);
    eval 'sub INTERNAL_CD_ON_AUX1 () {0x1;}' unless defined(&INTERNAL_CD_ON_AUX1);
    eval 'sub INTERNAL_CD_ON_AUX2 () {0x2;}' unless defined(&INTERNAL_CD_ON_AUX2);
    eval 'sub AUX_INIT_VALUE () {0x88;}' unless defined(&AUX_INIT_VALUE);
    if(defined( &sparc) || defined( &__sparc)) {
	eval 'sub AUX1_LOOPBACK_TEST () {0x80;}' unless defined(&AUX1_LOOPBACK_TEST);
    }
    eval 'sub R_INPUT_CR () {0x1;}' unless defined(&R_INPUT_CR);
    eval 'sub R_INPUTCR_AUX1 () { &L_INPUTCR_AUX1;}' unless defined(&R_INPUTCR_AUX1);
    eval 'sub L_AUX1_INPUT_CR () {0x2;}' unless defined(&L_AUX1_INPUT_CR);
    eval 'sub R_AUX1_INPUT_CR () {0x3;}' unless defined(&R_AUX1_INPUT_CR);
    eval 'sub L_AUX2_INPUT_CR () {0x4;}' unless defined(&L_AUX2_INPUT_CR);
    eval 'sub R_AUX2_INPUT_CR () {0x5;}' unless defined(&R_AUX2_INPUT_CR);
    eval 'sub L_OUTPUT_CR () {0x6;}' unless defined(&L_OUTPUT_CR);
    eval 'sub OUTCR_MUTE () {0x80;}' unless defined(&OUTCR_MUTE);
    eval 'sub OUTCR_UNMUTE () {~0x80;}' unless defined(&OUTCR_UNMUTE);
    eval 'sub R_OUTPUT_CR () {0x7;}' unless defined(&R_OUTPUT_CR);
    eval 'sub PLAY_DATA_FR () {0x08;}' unless defined(&PLAY_DATA_FR);
    eval 'sub CHANGE_DFR {
        local($var, $val) = @_;
	    eval q((($var & ~(0xf)) | $val));
    }' unless defined(&CHANGE_DFR);
    eval 'sub CHANGE_ENCODING {
        local($var, $val) = @_;
	    eval q((($var & ~(0xe0)) | $val));
    }' unless defined(&CHANGE_ENCODING);
    eval 'sub DEFAULT_DATA_FMAT () {0x20;}' unless defined(&DEFAULT_DATA_FMAT);
    eval 'sub CS4231_DFR_8000 () {0x00;}' unless defined(&CS4231_DFR_8000);
    eval 'sub CS4231_DFR_9600 () {0x0e;}' unless defined(&CS4231_DFR_9600);
    eval 'sub CS4231_DFR_11025 () {0x03;}' unless defined(&CS4231_DFR_11025);
    eval 'sub CS4231_DFR_16000 () {0x02;}' unless defined(&CS4231_DFR_16000);
    eval 'sub CS4231_DFR_18900 () {0x05;}' unless defined(&CS4231_DFR_18900);
    eval 'sub CS4231_DFR_22050 () {0x07;}' unless defined(&CS4231_DFR_22050);
    eval 'sub CS4231_DFR_32000 () {0x06;}' unless defined(&CS4231_DFR_32000);
    eval 'sub CS4231_DFR_37800 () {0x09;}' unless defined(&CS4231_DFR_37800);
    eval 'sub CS4231_DFR_44100 () {0x0b;}' unless defined(&CS4231_DFR_44100);
    eval 'sub CS4231_DFR_48000 () {0x0c;}' unless defined(&CS4231_DFR_48000);
    eval 'sub CS4231_DFR_LINEAR8 () {0x00;}' unless defined(&CS4231_DFR_LINEAR8);
    eval 'sub CS4231_DFR_ULAW () {0x20;}' unless defined(&CS4231_DFR_ULAW);
    eval 'sub CS4231_DFR_ALAW () {0x60;}' unless defined(&CS4231_DFR_ALAW);
    eval 'sub CS4231_DFR_ADPCM () {0xa0;}' unless defined(&CS4231_DFR_ADPCM);
    if(defined(&MULTI_DEBUG)) {
	eval 'sub CS4231_DFR_LINEARBE () {0x40;}' unless defined(&CS4231_DFR_LINEARBE);
    } else {
	eval 'sub CS4231_DFR_LINEARBE () {0xc0;}' unless defined(&CS4231_DFR_LINEARBE);
    }
    eval 'sub CS4231_DFR_LINEARLE () {0x40;}' unless defined(&CS4231_DFR_LINEARLE);
    eval 'sub CS4231_STEREO_ON {
        local($val) = @_;
	    eval q(($val | 0x10));
    }' unless defined(&CS4231_STEREO_ON);
    eval 'sub CS4231_MONO_ON {
        local($val) = @_;
	    eval q(($val & ~0x10));
    }' unless defined(&CS4231_MONO_ON);
    eval 'sub INTERFACE_CR () {0x09;}' unless defined(&INTERFACE_CR);
    eval 'sub CHIP_INACTIVE () {0x08;}' unless defined(&CHIP_INACTIVE);
    eval 'sub PEN_ENABLE () {(0x01);}' unless defined(&PEN_ENABLE);
    eval 'sub PEN_DISABLE () {(~0x01);}' unless defined(&PEN_DISABLE);
    eval 'sub CEN_ENABLE () {(0x02);}' unless defined(&CEN_ENABLE);
    eval 'sub CEN_DISABLE () {(~0x02);}' unless defined(&CEN_DISABLE);
    eval 'sub ACAL_DISABLE () {(~0x08);}' unless defined(&ACAL_DISABLE);
    eval 'sub NO_CALIBRATION () {(0x00);}' unless defined(&NO_CALIBRATION);
    eval 'sub CONV_CALIBRATION () {(0x08);}' unless defined(&CONV_CALIBRATION);
    eval 'sub DAC_CALIBRATION () {(0x10);}' unless defined(&DAC_CALIBRATION);
    eval 'sub FULL_CALIBRATION () {(0x18);}' unless defined(&FULL_CALIBRATION);
    eval 'sub ICR_AUTOCAL_INIT () {0x01;}' unless defined(&ICR_AUTOCAL_INIT);
    eval 'sub PIN_CR () {0x0a;}' unless defined(&PIN_CR);
    eval 'sub XCTL0 () {0x40;}' unless defined(&XCTL0);
    eval 'sub XCTL1 () {0x80;}' unless defined(&XCTL1);
    if(defined( &sparc) || defined( &__sparc)) {
	eval 'sub INTR_ON () {0x82;}' unless defined(&INTR_ON);
	eval 'sub INTR_OFF () {0x80;}' unless defined(&INTR_OFF);
	eval 'sub PINCR_LINE_MUTE () {0x40;}' unless defined(&PINCR_LINE_MUTE);
	eval 'sub PINCR_HDPH_MUTE () {0x80;}' unless defined(&PINCR_HDPH_MUTE);
    }
 elsif(defined( &i386) || defined( &__ppc)) {
	eval 'sub INTR_ON () {0x02;}' unless defined(&INTR_ON);
	eval 'sub INTR_OFF () {0x00;}' unless defined(&INTR_OFF);
    } else {
	die("One\ of\ sparc\,\ i386\ or\ ppc\ must\ be\ defined\.");
    }
    eval 'sub TEST_IR () {0x0b;}' unless defined(&TEST_IR);
    eval 'sub DRQ_STAT () {0x10;}' unless defined(&DRQ_STAT);
    eval 'sub AUTOCAL_INPROGRESS () {0x20;}' unless defined(&AUTOCAL_INPROGRESS);
    eval 'sub MISC_IR () {0x0c;}' unless defined(&MISC_IR);
    eval 'sub MISC_IR_MODE2 () {0x40;}' unless defined(&MISC_IR_MODE2);
    eval 'sub TIAD65 () {0x20;}' unless defined(&TIAD65);
    eval 'sub CODEC_ID_MASK () {0x0f;}' unless defined(&CODEC_ID_MASK);
    eval 'sub CODEC_SIGNATURE () {0x0a;}' unless defined(&CODEC_SIGNATURE);
    eval 'sub LOOPB_CR () {0x0d;}' unless defined(&LOOPB_CR);
    eval 'sub LOOPB_ON () {0x01;}' unless defined(&LOOPB_ON);
    eval 'sub LOOPB_OFF () {0x00;}' unless defined(&LOOPB_OFF);
    eval 'sub PLAYB_UBR () {0x0e;}' unless defined(&PLAYB_UBR);
    eval 'sub PLAYB_LBR () {0x0f;}' unless defined(&PLAYB_LBR);
    eval 'sub ALT_FEA_EN1R () {0x10;}' unless defined(&ALT_FEA_EN1R);
    eval 'sub OLB_ENABLE () {0x80;}' unless defined(&OLB_ENABLE);
    eval 'sub TIMER_ENABLE () {0x40;}' unless defined(&TIMER_ENABLE);
    eval 'sub DACZ_ON () {0x01;}' unless defined(&DACZ_ON);
    eval 'sub ALT_FEA_EN2R () {0x11;}' unless defined(&ALT_FEA_EN2R);
    eval 'sub HPF_ON () {0x01;}' unless defined(&HPF_ON);
    eval 'sub XTALE_ON () {0x20;}' unless defined(&XTALE_ON);
    eval 'sub L_LINE_INGAIN_R () {0x12;}' unless defined(&L_LINE_INGAIN_R);
    eval 'sub L_LINE_MUTE () {0x80;}' unless defined(&L_LINE_MUTE);
    eval 'sub R_LINE_INGAIN_R () {0x13;}' unless defined(&R_LINE_INGAIN_R);
    eval 'sub R_LINE_MUTE () {0x80;}' unless defined(&R_LINE_MUTE);
    eval 'sub TIMER_HIB_R () {0x14;}' unless defined(&TIMER_HIB_R);
    eval 'sub TIMER_LOB_R () {0x15;}' unless defined(&TIMER_LOB_R);
    eval 'sub ALT_FEAT_STATR () {0x18;}' unless defined(&ALT_FEAT_STATR);
    eval 'sub CS_PU () {0x01;}' unless defined(&CS_PU);
    eval 'sub CS_PO () {0x02;}' unless defined(&CS_PO);
    eval 'sub CS_CO () {0x04;}' unless defined(&CS_CO);
    eval 'sub CS_CU () {0x08;}' unless defined(&CS_CU);
    eval 'sub CS_PI () {0x10;}' unless defined(&CS_PI);
    eval 'sub CS_CI () {0x20;}' unless defined(&CS_CI);
    eval 'sub CS_TI () {0x40;}' unless defined(&CS_TI);
    eval 'sub ALL_INTRS_MASK () { &CS_PI |  &CS_CI |  &CS_TI;}' unless defined(&ALL_INTRS_MASK);
    eval 'sub RESET_STATUS () {0x00;}' unless defined(&RESET_STATUS);
    eval 'sub VERSION_R () {0x19;}' unless defined(&VERSION_R);
    eval 'sub CS4231A () {0x20;}' unless defined(&CS4231A);
    eval 'sub CS4231CDE () {0x80;}' unless defined(&CS4231CDE);
    eval 'sub MONO_IOCR () {0x1a;}' unless defined(&MONO_IOCR);
    eval 'sub CHANGE_MONO_GAIN {
        local($val) = @_;
	    eval q((($val & ~(0xff)) | $val));
    }' unless defined(&CHANGE_MONO_GAIN);
    eval 'sub MONO_SPKR_MUTE () {0x40;}' unless defined(&MONO_SPKR_MUTE);
    eval 'sub MONO_INPUT_MUTE () {0x80;}' unless defined(&MONO_INPUT_MUTE);
    eval 'sub CAPTURE_DFR () {0x1c;}' unless defined(&CAPTURE_DFR);
    eval 'sub CAPTURE_UBR () {0x1e;}' unless defined(&CAPTURE_UBR);
    eval 'sub CAPTURE_LBR () {0x1f;}' unless defined(&CAPTURE_LBR);
    eval 'sub RECORD () {0x1;}' unless defined(&RECORD);
    eval 'sub PLAYBACK () {0x0;}' unless defined(&PLAYBACK);
    eval 'sub CS_TIMEOUT () {9000000;}' unless defined(&CS_TIMEOUT);
    eval 'sub CS_POLL_TIMEOUT () {100000;}' unless defined(&CS_POLL_TIMEOUT);
    eval 'sub AUD_DMA_RESET {
        local($P, $h) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_dma_reset}))($P, $h));
    }' unless defined(&AUD_DMA_RESET);
    eval 'sub AUD_DMA_MAP_REGS {
        local($d, $P) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_map_regs}))($d, $P));
    }' unless defined(&AUD_DMA_MAP_REGS);
    eval 'sub AUD_DMA_UNMAP_REGS {
        local($P) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_unmap_regs}))($P));
    }' unless defined(&AUD_DMA_UNMAP_REGS);
    eval 'sub AUD_DMA_ADD_INTR {
        local($d, $P) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_add_intr}))($d, $P));
    }' unless defined(&AUD_DMA_ADD_INTR);
    eval 'sub AUD_DMA_VERSION {
        local($P, $sp) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_version}))($P, $sp));
    }' unless defined(&AUD_DMA_VERSION);
    eval 'sub AUD_DMA_START_INPUT {
        local($P) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_start_input}))($P));
    }' unless defined(&AUD_DMA_START_INPUT);
    eval 'sub AUD_DMA_START_OUTPUT {
        local($P) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_start_output}))($P));
    }' unless defined(&AUD_DMA_START_OUTPUT);
    eval 'sub AUD_DMA_STOP_INPUT {
        local($P) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_stop_input}))($P));
    }' unless defined(&AUD_DMA_STOP_INPUT);
    eval 'sub AUD_DMA_STOP_OUTPUT {
        local($P) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_stop_output}))($P));
    }' unless defined(&AUD_DMA_STOP_OUTPUT);
    eval 'sub AUD_DMA_GET_COUNT {
        local($P, $pc, $cc) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_get_count}))($P, $pc, $cc));
    }' unless defined(&AUD_DMA_GET_COUNT);
    eval 'sub AUD_DMA_GET_NCOUNT {
        local($P, $d, $nc) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_get_ncount}))($P, $d, $nc));
    }' unless defined(&AUD_DMA_GET_NCOUNT);
    eval 'sub AUD_DMA_GET_ACCHANDLE {
        local($P, $e, $d) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_get_acchandle}))($P, $e, $d));
    }' unless defined(&AUD_DMA_GET_ACCHANDLE);
    eval 'sub AUD_DMA_SETUP {
        local($P, $d, $c, $l) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_dma_setup}))($P, $d, $c, $l));
    }' unless defined(&AUD_DMA_SETUP);
    eval 'sub AUD_DMA_PLAY_LAST {
        local($P, $h, $e) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_play_last}))($P, $h, $e));
    }' unless defined(&AUD_DMA_PLAY_LAST);
    eval 'sub AUD_DMA_PLAY_CLEANUP {
        local($P, $h, $e) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_play_cleanup}))($P, $h, $e));
    }' unless defined(&AUD_DMA_PLAY_CLEANUP);
    eval 'sub AUD_DMA_PLAY_NEXT {
        local($P, $h) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_play_next}))($P, $h));
    }' unless defined(&AUD_DMA_PLAY_NEXT);
    eval 'sub AUD_DMA_REC_NEXT {
        local($P) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_rec_next}))($P));
    }' unless defined(&AUD_DMA_REC_NEXT);
    eval 'sub AUD_DMA_REC_CLEANUP {
        local($P) = @_;
	    eval q((($P)-> ($opsp->{audio_4231_rec_cleanup}))($P));
    }' unless defined(&AUD_DMA_REC_CLEANUP);
    if(defined(&__cplusplus)) {
    }
}
1;
