require '_h2ph_pre.ph';

unless(defined(&_NFS_NFS_H)) {
    eval 'sub _NFS_NFS_H () {1;}' unless defined(&_NFS_NFS_H);
    require 'sys/isa_defs.ph';
    require 'sys/vfs.ph';
    require 'sys/stream.ph';
    require 'rpc/types.ph';
    if(defined(&_KERNEL)) {
	require 'rpc/xdr.ph';
    }
    if(defined(&_KERNEL)) {
	require 'sys/fcntl.ph';
	require 'sys/kstat.ph';
    }
    require 'vm/page.ph';
    require 'rpc/rpc_sztypes.ph';
    require 'sys/sysmacros.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub NFS_PROGRAM () {(100003);}' unless defined(&NFS_PROGRAM);
    eval 'sub NFS_VERSMIN () {(2);}' unless defined(&NFS_VERSMIN);
    eval 'sub NFS_VERSMAX () {(3);}' unless defined(&NFS_VERSMAX);
    eval 'sub NFS_VERSION () {(2);}' unless defined(&NFS_VERSION);
    eval 'sub NFS_PORT () {2049;}' unless defined(&NFS_PORT);
    eval 'sub NFS_MAXDATA () {8192;}' unless defined(&NFS_MAXDATA);
    eval 'sub NFS_MAXNAMLEN () {255;}' unless defined(&NFS_MAXNAMLEN);
    eval 'sub NFS_MAXPATHLEN () {1024;}' unless defined(&NFS_MAXPATHLEN);
    eval 'sub NFS_TIMEO () {11;}' unless defined(&NFS_TIMEO);
    eval 'sub NFS_COTS_TIMEO () {100;}' unless defined(&NFS_COTS_TIMEO);
    eval 'sub NFS_RETRIES () {5;}' unless defined(&NFS_RETRIES);
    eval 'sub NFS_UID_NOBODY () {-2;}' unless defined(&NFS_UID_NOBODY);
    eval 'sub NFS_GID_NOBODY () {-2;}' unless defined(&NFS_GID_NOBODY);
    eval 'sub ECTSIZE () {2048;}' unless defined(&ECTSIZE);
    eval 'sub IETSIZE () {8192;}' unless defined(&IETSIZE);
    eval("sub NFS_OK () { 0; }") unless defined(&NFS_OK);
    eval("sub NFSERR_PERM () { 1; }") unless defined(&NFSERR_PERM);
    eval("sub NFSERR_NOENT () { 2; }") unless defined(&NFSERR_NOENT);
    eval("sub NFSERR_IO () { 5; }") unless defined(&NFSERR_IO);
    eval("sub NFSERR_NXIO () { 6; }") unless defined(&NFSERR_NXIO);
    eval("sub NFSERR_ACCES () { 13; }") unless defined(&NFSERR_ACCES);
    eval("sub NFSERR_EXIST () { 17; }") unless defined(&NFSERR_EXIST);
    eval("sub NFSERR_XDEV () { 18; }") unless defined(&NFSERR_XDEV);
    eval("sub NFSERR_NODEV () { 19; }") unless defined(&NFSERR_NODEV);
    eval("sub NFSERR_NOTDIR () { 20; }") unless defined(&NFSERR_NOTDIR);
    eval("sub NFSERR_ISDIR () { 21; }") unless defined(&NFSERR_ISDIR);
    eval("sub NFSERR_INVAL () { 22; }") unless defined(&NFSERR_INVAL);
    eval("sub NFSERR_FBIG () { 27; }") unless defined(&NFSERR_FBIG);
    eval("sub NFSERR_NOSPC () { 28; }") unless defined(&NFSERR_NOSPC);
    eval("sub NFSERR_ROFS () { 30; }") unless defined(&NFSERR_ROFS);
    eval("sub NFSERR_OPNOTSUPP () { 45; }") unless defined(&NFSERR_OPNOTSUPP);
    eval("sub NFSERR_NAMETOOLONG () { 63; }") unless defined(&NFSERR_NAMETOOLONG);
    eval("sub NFSERR_NOTEMPTY () { 66; }") unless defined(&NFSERR_NOTEMPTY);
    eval("sub NFSERR_DQUOT () { 69; }") unless defined(&NFSERR_DQUOT);
    eval("sub NFSERR_STALE () { 70; }") unless defined(&NFSERR_STALE);
    eval("sub NFSERR_REMOTE () { 71; }") unless defined(&NFSERR_REMOTE);
    eval("sub NFSERR_WFLUSH () { 72; }") unless defined(&NFSERR_WFLUSH);
    eval("sub NFNON () { 0; }") unless defined(&NFNON);
    eval("sub NFREG () { 1; }") unless defined(&NFREG);
    eval("sub NFDIR () { 2; }") unless defined(&NFDIR);
    eval("sub NFBLK () { 3; }") unless defined(&NFBLK);
    eval("sub NFCHR () { 4; }") unless defined(&NFCHR);
    eval("sub NFLNK () { 5; }") unless defined(&NFLNK);
    eval("sub NFSOC () { 6; }") unless defined(&NFSOC);
    eval 'sub SO4_BITSMAJOR () {8;}' unless defined(&SO4_BITSMAJOR);
    eval 'sub SO4_BITSMINOR () {8;}' unless defined(&SO4_BITSMINOR);
    eval 'sub SO4_MAXMAJ () {0xff;}' unless defined(&SO4_MAXMAJ);
    eval 'sub SO4_MAXMIN () {0xff;}' unless defined(&SO4_MAXMIN);
    eval 'sub nfsv2_cmpdev {
        local($x) = @_;
	    eval q((((($x)>> &L_BITSMINOR) >  &SO4_MAXMAJ || (($x) &L_MAXMIN) >  &SO4_MAXMIN) ?  &NODEV : (((($x)>> &L_BITSMINOR)<< &SO4_BITSMINOR)|(($x) &SO4_MAXMIN))));
    }' unless defined(&nfsv2_cmpdev);
    eval 'sub nfsv2_expdev {
        local($x) = @_;
	    eval q(((((($x)>> &SO4_BITSMINOR) &SO4_MAXMAJ)<< &L_BITSMINOR) | (($x) &SO4_MAXMIN)));
    }' unless defined(&nfsv2_expdev);
    eval 'sub NFS_FIFO_TYPE () { &NFCHR;}' unless defined(&NFS_FIFO_TYPE);
    eval 'sub NFS_FIFO_MODE () { &S_IFCHR;}' unless defined(&NFS_FIFO_MODE);
    eval 'sub NFS_FIFO_DEV () {(-1);}' unless defined(&NFS_FIFO_DEV);
    eval 'sub NA_ISFIFO {
        local($NA) = @_;
	    eval q(((($NA)-> &na_type ==  &NFS_FIFO_TYPE)  && (($NA)-> &na_rdev ==  &NFS_FIFO_DEV)));
    }' unless defined(&NA_ISFIFO);
    eval 'sub NA_SETFIFO {
        local($NA) = @_;
	    eval q({ ($NA)-> &na_type =  &NFS_FIFO_TYPE; ($NA)-> &na_rdev =  &NFS_FIFO_DEV; ($NA)-> &na_mode = (($NA)-> &na_mode&~ &S_IFMT)| &NFS_FIFO_MODE; });
    }' unless defined(&NA_SETFIFO);
    eval 'sub NFS_FHSIZE () {32;}' unless defined(&NFS_FHSIZE);
    eval 'sub NFS_FHMAXDATA () {(( &NFS_FHSIZE - $sizeof{\'struct fhsize\'} + 8) / 2);}' unless defined(&NFS_FHMAXDATA);
    eval 'sub wa_fhandle () { ($wa_args->{otw_wa_fhandle});}' unless defined(&wa_fhandle);
    eval 'sub wa_begoff () { ($wa_args->{otw_wa_begoff});}' unless defined(&wa_begoff);
    eval 'sub wa_offset () { ($wa_args->{otw_wa_offset});}' unless defined(&wa_offset);
    eval 'sub wa_totcount () { ($wa_args->{otw_wa_totcount});}' unless defined(&wa_totcount);
    eval 'sub n2v_type {
        local($x) = @_;
	    eval q(( &NA_ISFIFO ?  &VFIFO : (($x)-> &na_type)));
    }' unless defined(&n2v_type);
    eval 'sub n2v_rdev {
        local($x) = @_;
	    eval q(( &NA_ISFIFO($x) ? 0: ($x)-> &na_rdev));
    }' unless defined(&n2v_rdev);
    eval 'sub rr_ok () { ($rr_u->{rr_ok_u});}' unless defined(&rr_ok);
    eval 'sub rr_attr () { ($rr_u->{rr_ok_u}->{rrok_attr});}' unless defined(&rr_attr);
    eval 'sub rr_count () { ($rr_u->{rr_ok_u}->{rrok_count});}' unless defined(&rr_count);
    eval 'sub rr_bufsize () { ($rr_u->{rr_ok_u}->{rrok_bufsize});}' unless defined(&rr_bufsize);
    eval 'sub rr_data () { ($rr_u->{rr_ok_u}->{rrok_data});}' unless defined(&rr_data);
    eval 'sub rr_mp () { ($rr_u->{rr_ok_u}->{rrok_mp});}' unless defined(&rr_mp);
    eval 'sub ns_attr () { ($ns_u->{ns_attr_u});}' unless defined(&ns_attr);
    eval 'sub rl_srok () { ($rl_u->{rl_srok_u});}' unless defined(&rl_srok);
    eval 'sub rl_count () { ($rl_u->{rl_srok_u}->{srok_count});}' unless defined(&rl_count);
    eval 'sub rl_data () { ($rl_u->{rl_srok_u}->{srok_data});}' unless defined(&rl_data);
    eval 'sub rd_rdok () { ($rd_u->{rd_rdok_u});}' unless defined(&rd_rdok);
    eval 'sub rd_offset () { ($rd_u->{rd_rdok_u}->{rdok_offset});}' unless defined(&rd_offset);
    eval 'sub rd_size () { ($rd_u->{rd_rdok_u}->{rdok_size});}' unless defined(&rd_size);
    eval 'sub rd_eof () { ($rd_u->{rd_rdok_u}->{rdok_eof});}' unless defined(&rd_eof);
    eval 'sub rd_entries () { ($rd_u->{rd_rdok_u}->{rdok_entries});}' unless defined(&rd_entries);
    eval 'sub DA_FREENAME () {1;}' unless defined(&DA_FREENAME);
    eval 'sub dr_drok () { ($dr_u->{dr_drok_u});}' unless defined(&dr_drok);
    eval 'sub dr_fhandle () { ($dr_u->{dr_drok_u}->{drok_fhandle});}' unless defined(&dr_fhandle);
    eval 'sub dr_attr () { ($dr_u->{dr_drok_u}->{drok_attr});}' unless defined(&dr_attr);
    eval 'sub SLA_FREETNM () {1;}' unless defined(&SLA_FREETNM);
    eval 'sub fs_fsok () { ($fs_u->{fs_fsok_u});}' unless defined(&fs_fsok);
    eval 'sub fs_tsize () { ($fs_u->{fs_fsok_u}->{fsok_tsize});}' unless defined(&fs_tsize);
    eval 'sub fs_bsize () { ($fs_u->{fs_fsok_u}->{fsok_bsize});}' unless defined(&fs_bsize);
    eval 'sub fs_blocks () { ($fs_u->{fs_fsok_u}->{fsok_blocks});}' unless defined(&fs_blocks);
    eval 'sub fs_bfree () { ($fs_u->{fs_fsok_u}->{fsok_bfree});}' unless defined(&fs_bfree);
    eval 'sub fs_bavail () { ($fs_u->{fs_fsok_u}->{fsok_bavail});}' unless defined(&fs_bavail);
    if(defined(&_KERNEL)) {
	if(defined(&_LITTLE_ENDIAN)) {
	}
	if(defined(&_LITTLE_ENDIAN)) {
	}
	if(defined(&_LITTLE_ENDIAN)) {
	}
	if(defined(&_LITTLE_ENDIAN)) {
	}
	if(defined(&_LITTLE_ENDIAN)) {
	}
	if(defined(&_LITTLE_ENDIAN)) {
	}
    }
    eval 'sub RFS_NULL () {0;}' unless defined(&RFS_NULL);
    eval 'sub RFS_GETATTR () {1;}' unless defined(&RFS_GETATTR);
    eval 'sub RFS_SETATTR () {2;}' unless defined(&RFS_SETATTR);
    eval 'sub RFS_ROOT () {3;}' unless defined(&RFS_ROOT);
    eval 'sub RFS_LOOKUP () {4;}' unless defined(&RFS_LOOKUP);
    eval 'sub RFS_READLINK () {5;}' unless defined(&RFS_READLINK);
    eval 'sub RFS_READ () {6;}' unless defined(&RFS_READ);
    eval 'sub RFS_WRITECACHE () {7;}' unless defined(&RFS_WRITECACHE);
    eval 'sub RFS_WRITE () {8;}' unless defined(&RFS_WRITE);
    eval 'sub RFS_CREATE () {9;}' unless defined(&RFS_CREATE);
    eval 'sub RFS_REMOVE () {10;}' unless defined(&RFS_REMOVE);
    eval 'sub RFS_RENAME () {11;}' unless defined(&RFS_RENAME);
    eval 'sub RFS_LINK () {12;}' unless defined(&RFS_LINK);
    eval 'sub RFS_SYMLINK () {13;}' unless defined(&RFS_SYMLINK);
    eval 'sub RFS_MKDIR () {14;}' unless defined(&RFS_MKDIR);
    eval 'sub RFS_RMDIR () {15;}' unless defined(&RFS_RMDIR);
    eval 'sub RFS_READDIR () {16;}' unless defined(&RFS_READDIR);
    eval 'sub RFS_STATFS () {17;}' unless defined(&RFS_STATFS);
    eval 'sub RFS_NPROC () {18;}' unless defined(&RFS_NPROC);
    if(defined(&_KERNEL)) {
    }
    if(defined(&_KERNEL)) {
	eval("sub NFS_CALLS () { 0; }") unless defined(&NFS_CALLS);
	eval("sub NFS_BADCALLS () { 1; }") unless defined(&NFS_BADCALLS);
    }
    eval 'sub NFS3_FHSIZE () {64;}' unless defined(&NFS3_FHSIZE);
    eval 'sub NFS3_COOKIEVERFSIZE () {8;}' unless defined(&NFS3_COOKIEVERFSIZE);
    eval 'sub NFS3_CREATEVERFSIZE () {8;}' unless defined(&NFS3_CREATEVERFSIZE);
    eval 'sub NFS3_WRITEVERFSIZE () {8;}' unless defined(&NFS3_WRITEVERFSIZE);
    eval 'sub nfs3nametoolong () {(-1);}' unless defined(&nfs3nametoolong);
    eval 'sub fh3_fsid () { ($fh3_u->{nfs_fh3_i}->{fh3_i}->{fh_fsid});}' unless defined(&fh3_fsid);
    eval 'sub fh3_len () { ($fh3_u->{nfs_fh3_i}->{fh3_i}->{fh_len});}' unless defined(&fh3_len);
    eval 'sub fh3_data () { ($fh3_u->{nfs_fh3_i}->{fh3_i}->{fh_data});}' unless defined(&fh3_data);
    eval 'sub fh3_xlen () { ($fh3_u->{nfs_fh3_i}->{fh3_i}->{fh_xlen});}' unless defined(&fh3_xlen);
    eval 'sub fh3_xdata () { ($fh3_u->{nfs_fh3_i}->{fh3_i}->{fh_xdata});}' unless defined(&fh3_xdata);
    eval("sub NFS3_OK () { 0; }") unless defined(&NFS3_OK);
    eval("sub NFS3ERR_PERM () { 1; }") unless defined(&NFS3ERR_PERM);
    eval("sub NFS3ERR_NOENT () { 2; }") unless defined(&NFS3ERR_NOENT);
    eval("sub NFS3ERR_IO () { 5; }") unless defined(&NFS3ERR_IO);
    eval("sub NFS3ERR_NXIO () { 6; }") unless defined(&NFS3ERR_NXIO);
    eval("sub NFS3ERR_ACCES () { 13; }") unless defined(&NFS3ERR_ACCES);
    eval("sub NFS3ERR_EXIST () { 17; }") unless defined(&NFS3ERR_EXIST);
    eval("sub NFS3ERR_XDEV () { 18; }") unless defined(&NFS3ERR_XDEV);
    eval("sub NFS3ERR_NODEV () { 19; }") unless defined(&NFS3ERR_NODEV);
    eval("sub NFS3ERR_NOTDIR () { 20; }") unless defined(&NFS3ERR_NOTDIR);
    eval("sub NFS3ERR_ISDIR () { 21; }") unless defined(&NFS3ERR_ISDIR);
    eval("sub NFS3ERR_INVAL () { 22; }") unless defined(&NFS3ERR_INVAL);
    eval("sub NFS3ERR_FBIG () { 27; }") unless defined(&NFS3ERR_FBIG);
    eval("sub NFS3ERR_NOSPC () { 28; }") unless defined(&NFS3ERR_NOSPC);
    eval("sub NFS3ERR_ROFS () { 30; }") unless defined(&NFS3ERR_ROFS);
    eval("sub NFS3ERR_MLINK () { 31; }") unless defined(&NFS3ERR_MLINK);
    eval("sub NFS3ERR_NAMETOOLONG () { 63; }") unless defined(&NFS3ERR_NAMETOOLONG);
    eval("sub NFS3ERR_NOTEMPTY () { 66; }") unless defined(&NFS3ERR_NOTEMPTY);
    eval("sub NFS3ERR_DQUOT () { 69; }") unless defined(&NFS3ERR_DQUOT);
    eval("sub NFS3ERR_STALE () { 70; }") unless defined(&NFS3ERR_STALE);
    eval("sub NFS3ERR_REMOTE () { 71; }") unless defined(&NFS3ERR_REMOTE);
    eval("sub NFS3ERR_BADHANDLE () { 10001; }") unless defined(&NFS3ERR_BADHANDLE);
    eval("sub NFS3ERR_NOT_SYNC () { 10002; }") unless defined(&NFS3ERR_NOT_SYNC);
    eval("sub NFS3ERR_BAD_COOKIE () { 10003; }") unless defined(&NFS3ERR_BAD_COOKIE);
    eval("sub NFS3ERR_NOTSUPP () { 10004; }") unless defined(&NFS3ERR_NOTSUPP);
    eval("sub NFS3ERR_TOOSMALL () { 10005; }") unless defined(&NFS3ERR_TOOSMALL);
    eval("sub NFS3ERR_SERVERFAULT () { 10006; }") unless defined(&NFS3ERR_SERVERFAULT);
    eval("sub NFS3ERR_BADTYPE () { 10007; }") unless defined(&NFS3ERR_BADTYPE);
    eval("sub NFS3ERR_JUKEBOX () { 10008; }") unless defined(&NFS3ERR_JUKEBOX);
    eval("sub NF3REG () { 1; }") unless defined(&NF3REG);
    eval("sub NF3DIR () { 2; }") unless defined(&NF3DIR);
    eval("sub NF3BLK () { 3; }") unless defined(&NF3BLK);
    eval("sub NF3CHR () { 4; }") unless defined(&NF3CHR);
    eval("sub NF3LNK () { 5; }") unless defined(&NF3LNK);
    eval("sub NF3SOCK () { 6; }") unless defined(&NF3SOCK);
    eval("sub NF3FIFO () { 7; }") unless defined(&NF3FIFO);
    eval("sub DONT_CHANGE () { 0; }") unless defined(&DONT_CHANGE);
    eval("sub SET_TO_SERVER_TIME () { 1; }") unless defined(&SET_TO_SERVER_TIME);
    eval("sub SET_TO_CLIENT_TIME () { 2; }") unless defined(&SET_TO_CLIENT_TIME);
    eval 'sub resok () { ($res_u->{ok});}' unless defined(&resok);
    eval 'sub resfail () { ($res_u->{fail});}' unless defined(&resfail);
    eval 'sub ACCESS3_READ () {0x1;}' unless defined(&ACCESS3_READ);
    eval 'sub ACCESS3_LOOKUP () {0x2;}' unless defined(&ACCESS3_LOOKUP);
    eval 'sub ACCESS3_MODIFY () {0x4;}' unless defined(&ACCESS3_MODIFY);
    eval 'sub ACCESS3_EXTEND () {0x8;}' unless defined(&ACCESS3_EXTEND);
    eval 'sub ACCESS3_DELETE () {0x10;}' unless defined(&ACCESS3_DELETE);
    eval 'sub ACCESS3_EXECUTE () {0x20;}' unless defined(&ACCESS3_EXECUTE);
    eval("sub UNSTABLE () { 0; }") unless defined(&UNSTABLE);
    eval("sub DATA_SYNC () { 1; }") unless defined(&DATA_SYNC);
    eval("sub FILE_SYNC () { 2; }") unless defined(&FILE_SYNC);
    eval("sub UNCHECKED () { 0; }") unless defined(&UNCHECKED);
    eval("sub GUARDED () { 1; }") unless defined(&GUARDED);
    eval("sub EXCLUSIVE () { 2; }") unless defined(&EXCLUSIVE);
    eval 'sub FSF3_LINK () {0x1;}' unless defined(&FSF3_LINK);
    eval 'sub FSF3_SYMLINK () {0x2;}' unless defined(&FSF3_SYMLINK);
    eval 'sub FSF3_HOMOGENEOUS () {0x8;}' unless defined(&FSF3_HOMOGENEOUS);
    eval 'sub FSF3_CANSETTIME () {0x10;}' unless defined(&FSF3_CANSETTIME);
    eval 'sub NFS3_PROGRAM () {(100003);}' unless defined(&NFS3_PROGRAM);
    eval 'sub NFS_V3 () {(3);}' unless defined(&NFS_V3);
    eval 'sub NFSPROC3_NULL () {(0);}' unless defined(&NFSPROC3_NULL);
    eval 'sub NFSPROC3_GETATTR () {(1);}' unless defined(&NFSPROC3_GETATTR);
    eval 'sub NFSPROC3_SETATTR () {(2);}' unless defined(&NFSPROC3_SETATTR);
    eval 'sub NFSPROC3_LOOKUP () {(3);}' unless defined(&NFSPROC3_LOOKUP);
    eval 'sub NFSPROC3_ACCESS () {(4);}' unless defined(&NFSPROC3_ACCESS);
    eval 'sub NFSPROC3_READLINK () {(5);}' unless defined(&NFSPROC3_READLINK);
    eval 'sub NFSPROC3_READ () {(6);}' unless defined(&NFSPROC3_READ);
    eval 'sub NFSPROC3_WRITE () {(7);}' unless defined(&NFSPROC3_WRITE);
    eval 'sub NFSPROC3_CREATE () {(8);}' unless defined(&NFSPROC3_CREATE);
    eval 'sub NFSPROC3_MKDIR () {(9);}' unless defined(&NFSPROC3_MKDIR);
    eval 'sub NFSPROC3_SYMLINK () {(10);}' unless defined(&NFSPROC3_SYMLINK);
    eval 'sub NFSPROC3_MKNOD () {(11);}' unless defined(&NFSPROC3_MKNOD);
    eval 'sub NFSPROC3_REMOVE () {(12);}' unless defined(&NFSPROC3_REMOVE);
    eval 'sub NFSPROC3_RMDIR () {(13);}' unless defined(&NFSPROC3_RMDIR);
    eval 'sub NFSPROC3_RENAME () {(14);}' unless defined(&NFSPROC3_RENAME);
    eval 'sub NFSPROC3_LINK () {(15);}' unless defined(&NFSPROC3_LINK);
    eval 'sub NFSPROC3_READDIR () {(16);}' unless defined(&NFSPROC3_READDIR);
    eval 'sub NFSPROC3_READDIRPLUS () {(17);}' unless defined(&NFSPROC3_READDIRPLUS);
    eval 'sub NFSPROC3_FSSTAT () {(18);}' unless defined(&NFSPROC3_FSSTAT);
    eval 'sub NFSPROC3_FSINFO () {(19);}' unless defined(&NFSPROC3_FSINFO);
    eval 'sub NFSPROC3_PATHCONF () {(20);}' unless defined(&NFSPROC3_PATHCONF);
    eval 'sub NFSPROC3_COMMIT () {(21);}' unless defined(&NFSPROC3_COMMIT);
    if(defined(&_KERNEL)) {
    }
    if(defined(&_KERNEL)) {
    }
    if(defined(&_KERNEL)) {
	if(defined(&DEBUG)) {
	}
    }
    if(defined(&__cplusplus)) {
    }
}
1;
