require '_h2ph_pre.ph';

unless(defined(&_VM_PAGE_H)) {
    eval 'sub _VM_PAGE_H () {1;}' unless defined(&_VM_PAGE_H);
    if(defined(&__cplusplus)) {
    }
    if(defined( &_KERNEL) || defined( &_KMEMUSER)) {
	eval("sub SE_NOSTAT () { 0; }") unless defined(&SE_NOSTAT);
	eval("sub SE_STAT () { 1; }") unless defined(&SE_STAT);
	eval("sub SE_SHARED () { 0; }") unless defined(&SE_SHARED);
	eval("sub SE_EXCL () { 1; }") unless defined(&SE_EXCL);
	eval("sub P_RECLAIM () { 0; }") unless defined(&P_RECLAIM);
	eval("sub P_NO_RECLAIM () { 1; }") unless defined(&P_NO_RECLAIM);
	if(defined( &_LOCKTEST) || defined( &_MPSTATS)) {
	    eval 'sub SE_DEFAULT () { &SE_STAT;}' unless defined(&SE_DEFAULT);
	} else {
	    eval 'sub SE_DEFAULT () { &SE_NOSTAT;}' unless defined(&SE_DEFAULT);
	}
    }
    if(defined(&DEBUG)) {
	eval 'sub VM_STATS () {1;}' unless defined(&VM_STATS);
    }
    if(defined(&VM_STATS)) {
	eval 'sub VM_STAT_ADD {
	    local($stat) = @_;
    	    eval q(($stat)++);
	}' unless defined(&VM_STAT_ADD);
    } else {
	eval 'sub VM_STAT_ADD {
	    local($stat) = @_;
    	    eval q();
	}' unless defined(&VM_STAT_ADD);
    }
    if(defined(&_KERNEL)) {
	eval 'sub page_freelock_enter () {
	    eval q( &mutex_enter( &page_freelock));
	}' unless defined(&page_freelock_enter);
	eval 'sub page_freelock_exit () {
	    eval q( &mutex_exit( &page_freelock));
	}' unless defined(&page_freelock_exit);
	eval 'sub page_struct_lock {
	    local($pp) = @_;
    	    eval q( &mutex_enter( &page_llock));
	}' unless defined(&page_struct_lock);
	eval 'sub page_struct_unlock {
	    local($pp) = @_;
    	    eval q( &mutex_exit( &page_llock));
	}' unless defined(&page_struct_unlock);
    }
    require 'sys/t_lock.ph';
    require 'vm/hat.ph';
    if(defined(&_KERNEL)) {
	eval 'sub PG_EXCL () {0x0001;}' unless defined(&PG_EXCL);
	eval 'sub PG_WAIT () {0x0002;}' unless defined(&PG_WAIT);
	eval 'sub PG_PHYSCONTIG () {0x0004;}' unless defined(&PG_PHYSCONTIG);
	eval 'sub se_nolock {
	    local($x) = @_;
    	    eval q((*($x) == 0));
	}' unless defined(&se_nolock);
	eval 'sub se_assert {
	    local($x) = @_;
    	    eval q((*($x) > 0|| *($x) == -1));
	}' unless defined(&se_assert);
	eval 'sub se_shared_assert {
	    local($x) = @_;
    	    eval q((*($x) > 0));
	}' unless defined(&se_shared_assert);
	eval 'sub se_excl_assert {
	    local($x) = @_;
    	    eval q((*($x) == -1));
	}' unless defined(&se_excl_assert);
	eval 'sub se_shared_lock {
	    local($x) = @_;
    	    eval q((*($x) > 0));
	}' unless defined(&se_shared_lock);
	eval 'sub page_hash_assert {
	    local($x) = @_;
    	    eval q(( &MUTEX_HELD(($x)) ? 1: 0));
	}' unless defined(&page_hash_assert);
    }
    eval 'sub PAGE_HASHSZ () { &page_hashsz;}' unless defined(&PAGE_HASHSZ);
    eval 'sub PAGE_HASHAVELEN () {4;}' unless defined(&PAGE_HASHAVELEN);
    eval 'sub PAGE_HASHVPSHIFT () {6;}' unless defined(&PAGE_HASHVPSHIFT);
    eval 'sub PAGE_HASH_FUNC {
        local($vp, $off) = @_;
	    eval q(((( >>  &PAGESHIFT) + (($vp) >>  &PAGE_HASHVPSHIFT)) & ( &PAGE_HASHSZ - 1)));
    }' unless defined(&PAGE_HASH_FUNC);
    if((defined(&NCPU) ? &NCPU : 0) < 4) {
	eval 'sub PH_TABLE_SIZE () {16;}' unless defined(&PH_TABLE_SIZE);
    } else {
	eval 'sub PH_TABLE_SIZE () {128;}' unless defined(&PH_TABLE_SIZE);
    }
    eval 'sub PAGE_HASH_MUTEX {
        local($index) = @_;
	    eval q( $ph_mutex[($index) >>  &ph_mutex_shift]);
    }' unless defined(&PAGE_HASH_MUTEX);
    eval 'sub PSE_SHIFT () {6;}' unless defined(&PSE_SHIFT);
    eval 'sub PSE_TABLE_SIZE () {32;}' unless defined(&PSE_TABLE_SIZE);
    eval 'sub PAGE_SE_MUTEX {
        local($pp) = @_;
	    eval q( $pse_mutex[(($pp) >>  &PSE_SHIFT) & ( &PSE_TABLE_SIZE - 1)]);
    }' unless defined(&PAGE_SE_MUTEX);
    if((defined(&NCPU) ? &NCPU : 0) < 4) {
	eval 'sub VP_SHIFT () {7;}' unless defined(&VP_SHIFT);
    } else {
	eval 'sub VP_SHIFT () {11;}' unless defined(&VP_SHIFT);
    }
    eval 'sub VPH_TABLE_SIZE () {(2<<  &VP_SHIFT);}' unless defined(&VPH_TABLE_SIZE);
    eval 'sub VP_HASH_FUNC {
        local($vp) = @_;
	    eval q(((( >> 6) + ( >> 10) + ( >> 10) + (($vp) >> 12)) & ( &VPH_TABLE_SIZE - 1)));
    }' unless defined(&VP_HASH_FUNC);
    eval 'sub PAGE_VNODE_MUTEX {
        local($vp) = @_;
	    eval q((($vp) ==  &kvp ?  $vph_mutex[ &VPH_TABLE_SIZE + 0] :  $vph_mutex[ &VP_HASH_FUNC($vp)]));
    }' unless defined(&PAGE_VNODE_MUTEX);
    eval 'sub P_MOD () {0x1;}' unless defined(&P_MOD);
    eval 'sub P_REF () {0x2;}' unless defined(&P_REF);
    eval 'sub P_PNC () {0x4;}' unless defined(&P_PNC);
    eval 'sub P_TNC () {0x8;}' unless defined(&P_TNC);
    eval 'sub PP_ISMOD {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &  &P_MOD));
    }' unless defined(&PP_ISMOD);
    eval 'sub PP_ISREF {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &  &P_REF));
    }' unless defined(&PP_ISREF);
    eval 'sub PP_ISNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm & ( &P_PNC| &P_TNC)));
    }' unless defined(&PP_ISNC);
    eval 'sub PP_ISPNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &  &P_PNC));
    }' unless defined(&PP_ISPNC);
    eval 'sub PP_ISTNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &  &P_TNC));
    }' unless defined(&PP_ISTNC);
    eval 'sub PP_SETMOD {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm |=  &P_MOD));
    }' unless defined(&PP_SETMOD);
    eval 'sub PP_SETREF {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm |=  &P_REF));
    }' unless defined(&PP_SETREF);
    eval 'sub PP_SETREFMOD {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm |= ( &P_REF| &P_MOD)));
    }' unless defined(&PP_SETREFMOD);
    eval 'sub PP_SETPNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm |=  &P_PNC));
    }' unless defined(&PP_SETPNC);
    eval 'sub PP_SETTNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm |=  &P_TNC));
    }' unless defined(&PP_SETTNC);
    eval 'sub PP_CLRMOD {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &= ~ &P_MOD));
    }' unless defined(&PP_CLRMOD);
    eval 'sub PP_CLRREF {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &= ~ &P_REF));
    }' unless defined(&PP_CLRREF);
    eval 'sub PP_CLRREFMOD {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &= ~( &P_REF| &P_MOD)));
    }' unless defined(&PP_CLRREFMOD);
    eval 'sub PP_CLRPNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &= ~ &P_PNC));
    }' unless defined(&PP_CLRPNC);
    eval 'sub PP_CLRTNC {
        local($pp) = @_;
	    eval q((($pp)-> &p_nrm &= ~ &P_TNC));
    }' unless defined(&PP_CLRTNC);
    if(defined(&__cplusplus)) {
    }
}
1;
