require '_h2ph_pre.ph';

unless(defined(&_SYS_FS_UFS_FS_H)) {
    eval 'sub _SYS_FS_UFS_FS_H () {1;}' unless defined(&_SYS_FS_UFS_FS_H);
    require 'sys/isa_defs.ph';
    require 'sys/t_lock.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub BBSIZE () {8192;}' unless defined(&BBSIZE);
    eval 'sub SBSIZE () {8192;}' unless defined(&SBSIZE);
    eval 'sub BBOFF () {((0));}' unless defined(&BBOFF);
    eval 'sub SBOFF () {(( &BBOFF +  &BBSIZE));}' unless defined(&SBOFF);
    eval 'sub BBLOCK () {((0));}' unless defined(&BBLOCK);
    eval 'sub SBLOCK () {(( &BBLOCK +  &BBSIZE /  &DEV_BSIZE));}' unless defined(&SBLOCK);
    eval 'sub UFSROOTINO () {(2);}' unless defined(&UFSROOTINO);
    eval 'sub LOSTFOUNDINO () {( &UFSROOTINO + 1);}' unless defined(&LOSTFOUNDINO);
    eval 'sub MINBSIZE () {4096;}' unless defined(&MINBSIZE);
    eval 'sub MAXMNTLEN () {512;}' unless defined(&MAXMNTLEN);
    eval 'sub MAXCSBUFS () {32;}' unless defined(&MAXCSBUFS);
    eval 'sub FS_MAGIC () {0x011954;}' unless defined(&FS_MAGIC);
    eval 'sub FSOKAY () {(0x7c269d38);}' unless defined(&FSOKAY);
    eval 'sub FSACTIVE () {(0);}' unless defined(&FSACTIVE);
    eval 'sub FSCLEAN () {(0x1);}' unless defined(&FSCLEAN);
    eval 'sub FSSTABLE () {(0x2);}' unless defined(&FSSTABLE);
    eval 'sub FSBAD () {(0xff);}' unless defined(&FSBAD);
    eval 'sub FSSUSPEND () {(0xfe);}' unless defined(&FSSUSPEND);
    eval 'sub FSLOG () {(0xfd);}' unless defined(&FSLOG);
    if(defined(&_LITTLE_ENDIAN)) {
    } else {
    }
    eval 'sub fs_reclaim () { $fs_sparecon[53];}' unless defined(&fs_reclaim);
    if(defined(&_LITTLE_ENDIAN)) {
    } else {
    }
    eval 'sub FS_RECLAIM () {(0x00000001);}' unless defined(&FS_RECLAIM);
    eval 'sub FS_RECLAIMING () {(0x00000002);}' unless defined(&FS_RECLAIMING);
    eval 'sub FS_CHECKCLEAN () {(0x00000004);}' unless defined(&FS_CHECKCLEAN);
    eval 'sub FS_CHECKRECLAIM () {(0x00000008);}' unless defined(&FS_CHECKRECLAIM);
    eval 'sub FS_OPTTIME () {0;}' unless defined(&FS_OPTTIME);
    eval 'sub FS_OPTSPACE () {1;}' unless defined(&FS_OPTSPACE);
    eval 'sub FS_42POSTBLFMT () {-1;}' unless defined(&FS_42POSTBLFMT);
    eval 'sub FS_DYNAMICPOSTBLFMT () {1;}' unless defined(&FS_DYNAMICPOSTBLFMT);
    if(defined(&_KERNEL)) {
	eval 'sub fs_postbl {
	    local($ufsvfsp, $cylno) = @_;
    	    eval q(((-> ($vfs_fs->{fs_postblformat}) !=  &FS_DYNAMICPOSTBLFMT) ? (-> ($vfs_fs->{fs_opostbl[$cylno]})) : ((($ufsvfsp)-> &vfs_fs + ($ufsvfsp)-> ($vfs_fs->{fs_postbloff})) + ($cylno) * ($ufsvfsp)-> &vfs_nrpos)));
	}' unless defined(&fs_postbl);
    } else {
	eval 'sub fs_postbl {
	    local($fs, $cylno) = @_;
    	    eval q(((-> &fs_postblformat !=  &FS_DYNAMICPOSTBLFMT) ? (-> $fs_opostbl[$cylno]) : ((($fs) + ($fs)-> &fs_postbloff) + ($cylno) * ($fs)-> &fs_nrpos)));
	}' unless defined(&fs_postbl);
    }
    eval 'sub fs_rotbl {
        local($fs) = @_;
	    eval q(((-> &fs_postblformat !=  &FS_DYNAMICPOSTBLFMT) ? (-> &fs_space) : ((($fs) + ($fs)-> &fs_rotbloff))));
    }' unless defined(&fs_rotbl);
    eval 'sub fs_cs {
        local($fs, $indx) = @_;
	    eval q( $fs_csp[($indx) >> ($fs)-> &fs_csshift][($indx) & ~($fs)-> &fs_csmask]);
    }' unless defined(&fs_cs);
    eval 'sub CG_MAGIC () {0x090255;}' unless defined(&CG_MAGIC);
    eval 'sub cg_blktot {
        local($cgp) = @_;
	    eval q(((-> &cg_magic !=  &CG_MAGIC) ? (()-> &cg_btot) : ((($cgp) + ($cgp)-> &cg_btotoff))));
    }' unless defined(&cg_blktot);
    if(defined(&_KERNEL)) {
	eval 'sub cg_blks {
	    local($ufsvfsp, $cgp, $cylno) = @_;
    	    eval q(((-> &cg_magic !=  &CG_MAGIC) ? (()-> $cg_b[$cylno]) : ((($cgp) + ($cgp)-> &cg_boff) + ($cylno) * ($ufsvfsp)-> &vfs_nrpos)));
	}' unless defined(&cg_blks);
    } else {
	eval 'sub cg_blks {
	    local($fs, $cgp, $cylno) = @_;
    	    eval q(((-> &cg_magic !=  &CG_MAGIC) ? (()-> $cg_b[$cylno]) : ((($cgp) + ($cgp)-> &cg_boff) + ($cylno) * ($fs)-> &fs_nrpos)));
	}' unless defined(&cg_blks);
    }
    eval 'sub cg_inosused {
        local($cgp) = @_;
	    eval q(((-> &cg_magic !=  &CG_MAGIC) ? (()-> &cg_iused) : ((($cgp) + ($cgp)-> &cg_iusedoff))));
    }' unless defined(&cg_inosused);
    eval 'sub cg_blksfree {
        local($cgp) = @_;
	    eval q(((-> &cg_magic !=  &CG_MAGIC) ? (()-> &cg_free) : ((($cgp) + ($cgp)-> &cg_freeoff))));
    }' unless defined(&cg_blksfree);
    eval 'sub cg_chkmagic {
        local($cgp) = @_;
	    eval q((-> &cg_magic ==  &CG_MAGIC || (($cgp))-> &cg_magic ==  &CG_MAGIC));
    }' unless defined(&cg_chkmagic);
    eval 'sub fsbtodb {
        local($fs, $b) = @_;
	    eval q((($b) << ($fs)-> &fs_fsbtodb));
    }' unless defined(&fsbtodb);
    eval 'sub dbtofsb {
        local($fs, $b) = @_;
	    eval q((($b) >> ($fs)-> &fs_fsbtodb));
    }' unless defined(&dbtofsb);
    eval 'sub cgbase {
        local($fs, $c) = @_;
	    eval q(((($fs)-> &fs_fpg * ($c))));
    }' unless defined(&cgbase);
    eval 'sub cgstart {
        local($fs, $c) = @_;
	    eval q(( &cgbase($fs, $c) + ($fs)-> &fs_cgoffset * (($c) & ~(($fs)-> &fs_cgmask))));
    }' unless defined(&cgstart);
    eval 'sub cgsblock {
        local($fs, $c) = @_;
	    eval q(( &cgstart($fs, $c) + ($fs)-> &fs_sblkno));
    }' unless defined(&cgsblock);
    eval 'sub cgtod {
        local($fs, $c) = @_;
	    eval q(( &cgstart($fs, $c) + ($fs)-> &fs_cblkno));
    }' unless defined(&cgtod);
    eval 'sub cgimin {
        local($fs, $c) = @_;
	    eval q(( &cgstart($fs, $c) + ($fs)-> &fs_iblkno));
    }' unless defined(&cgimin);
    eval 'sub cgdmin {
        local($fs, $c) = @_;
	    eval q(( &cgstart($fs, $c) + ($fs)-> &fs_dblkno));
    }' unless defined(&cgdmin);
    eval 'sub itoo {
        local($fs, $x) = @_;
	    eval q(( %  &INOPB($fs)));
    }' unless defined(&itoo);
    eval 'sub itog {
        local($fs, $x) = @_;
	    eval q(( / ($fs)-> &fs_ipg));
    }' unless defined(&itog);
    eval 'sub itod {
        local($fs, $x) = @_;
	    eval q((( &cgimin($fs,  &itog($fs, $x)) + ( &blkstofrags(, ((%-> &fs_ipg)/ &INOPB($fs)))))));
    }' unless defined(&itod);
    eval 'sub dtog {
        local($fs, $d) = @_;
	    eval q((($d) / ($fs)-> &fs_fpg));
    }' unless defined(&dtog);
    eval 'sub dtogd {
        local($fs, $d) = @_;
	    eval q((($d) % ($fs)-> &fs_fpg));
    }' unless defined(&dtogd);
    eval 'sub blkmap {
        local($fs, $map, $loc) = @_;
	    eval q(((($map)[($loc) /  &NBBY] >> (($loc) %  &NBBY)) & (0xff >> ( &NBBY - ($fs)-> &fs_frag))));
    }' unless defined(&blkmap);
    eval 'sub cbtocylno {
        local($fs, $bno) = @_;
	    eval q((($bno) *  &NSPF($fs) / ($fs)-> &fs_spc));
    }' unless defined(&cbtocylno);
    if(defined(&_KERNEL)) {
	eval 'sub cbtorpos {
	    local($ufsvfsp, $bno) = @_;
    	    eval q(((((($bno) *  &NSPF(($ufsvfsp)-> &vfs_fs) % ($ufsvfsp)-> ($vfs_fs->{fs_spc})) % ($ufsvfsp)-> ($vfs_fs->{fs_nsect})) % ($ufsvfsp)-> ($vfs_fs->{fs_nsect})) * ($ufsvfsp)-> &vfs_nrpos) / ($ufsvfsp)-> ($vfs_fs->{fs_nsect}));
	}' unless defined(&cbtorpos);
    } else {
	eval 'sub cbtorpos {
	    local($fs, $bno) = @_;
    	    eval q(((((($bno) *  &NSPF($fs) % ($fs)-> &fs_spc) % ($fs)-> &fs_nsect) % ($fs)-> &fs_nsect) * ($fs)-> &fs_nrpos) / ($fs)-> &fs_nsect);
	}' unless defined(&cbtorpos);
    }
    eval 'sub blkoff {
        local($fs, $loc) = @_;
	    eval q((($loc) & ~($fs)-> &fs_bmask));
    }' unless defined(&blkoff);
    eval 'sub fragoff {
        local($fs, $loc) = @_;
	    eval q((($loc) & ~($fs)-> &fs_fmask));
    }' unless defined(&fragoff);
    eval 'sub lblkno {
        local($fs, $loc) = @_;
	    eval q((($loc) >> ($fs)-> &fs_bshift));
    }' unless defined(&lblkno);
    eval 'sub numfrags {
        local($fs, $loc) = @_;
	    eval q((($loc) >> ($fs)-> &fs_fshift));
    }' unless defined(&numfrags);
    eval 'sub blkroundup {
        local($fs, $size) = @_;
	    eval q(((($size) + ($fs)-> &fs_bsize - 1) & ($fs)-> &fs_bmask));
    }' unless defined(&blkroundup);
    eval 'sub fragroundup {
        local($fs, $size) = @_;
	    eval q(((($size) + ($fs)-> &fs_fsize - 1) & ($fs)-> &fs_fmask));
    }' unless defined(&fragroundup);
    eval 'sub fragstoblks {
        local($fs, $frags) = @_;
	    eval q((($frags) >> ($fs)-> &fs_fragshift));
    }' unless defined(&fragstoblks);
    eval 'sub blkstofrags {
        local($fs, $blks) = @_;
	    eval q((($blks) << ($fs)-> &fs_fragshift));
    }' unless defined(&blkstofrags);
    eval 'sub fragnum {
        local($fs, $fsb) = @_;
	    eval q((($fsb) & (($fs)-> &fs_frag - 1)));
    }' unless defined(&fragnum);
    eval 'sub blknum {
        local($fs, $fsb) = @_;
	    eval q((($fsb) &~ (($fs)-> &fs_frag - 1)));
    }' unless defined(&blknum);
    eval 'sub freespace {
        local($fs, $percentreserved) = @_;
	    eval q(( &blkstofrags(($fs), ($fs)-> ($fs_cstotal->{cs_nbfree})) + ($fs)-> ($fs_cstotal->{cs_nffree}) - (($fs)-> &fs_dsize / 100* ($percentreserved))));
    }' unless defined(&freespace);
    eval 'sub blksize {
        local($fs, $ip, $lbn) = @_;
	    eval q(((($lbn) >=  &NDADDR || ($ip)-> &i_size >= (($lbn) + 1) << ($fs)-> &fs_bshift) ? ($fs)-> &fs_bsize : ( &fragroundup($fs,  &blkoff($fs, ($ip)-> &i_size)))));
    }' unless defined(&blksize);
    eval 'sub dblksize {
        local($fs, $dip, $lbn) = @_;
	    eval q(((($lbn) >=  &NDADDR || ($dip)-> &di_size >= (($lbn) + 1) << ($fs)-> &fs_bshift) ? ($fs)-> &fs_bsize : ( &fragroundup($fs,  &blkoff($fs, ($dip)-> &di_size)))));
    }' unless defined(&dblksize);
    eval 'sub NSPB {
        local($fs) = @_;
	    eval q((($fs)-> &fs_nspf << ($fs)-> &fs_fragshift));
    }' unless defined(&NSPB);
    eval 'sub NSPF {
        local($fs) = @_;
	    eval q((($fs)-> &fs_nspf));
    }' unless defined(&NSPF);
    eval 'sub INOPB {
        local($fs) = @_;
	    eval q((($fs)-> &fs_inopb));
    }' unless defined(&INOPB);
    eval 'sub INOPF {
        local($fs) = @_;
	    eval q((($fs)-> &fs_inopb >> ($fs)-> &fs_fragshift));
    }' unless defined(&INOPF);
    eval 'sub NINDIR {
        local($fs) = @_;
	    eval q((($fs)-> &fs_nindir));
    }' unless defined(&NINDIR);
    eval 'sub bitloc {
        local($a, $i) = @_;
	    eval q((($a)[($i)/ &NBBY]));
    }' unless defined(&bitloc);
    eval 'sub setbit {
        local($a, $i) = @_;
	    eval q((($a)[($i)/ &NBBY] |= 1<<(($i)% &NBBY)));
    }' unless defined(&setbit);
    eval 'sub clrbit {
        local($a, $i) = @_;
	    eval q((($a)[($i)/ &NBBY] &= ~(1<<(($i)% &NBBY))));
    }' unless defined(&clrbit);
    eval 'sub isset {
        local($a, $i) = @_;
	    eval q((($a)[($i)/ &NBBY] & (1<<(($i)% &NBBY))));
    }' unless defined(&isset);
    eval 'sub isclr {
        local($a, $i) = @_;
	    eval q(((($a)[($i)/ &NBBY] & (1<<(($i)% &NBBY))) == 0));
    }' unless defined(&isclr);
    eval 'sub getfs {
        local($vfsp) = @_;
	    eval q((( ($vfsp->{vfs_data}))-> ($vfs_bufp->{b_un}->{b_addr})));
    }' unless defined(&getfs);
    if(defined(&__cplusplus)) {
    }
}
1;
